;****
; PATCH to fix clear screen write over RAMTOP

PATCHL	=	$C000

	ORG	PATCHL

PCLRSCR
	LDY	ADRESS		;Y get current bias w/i memory page
	LDA	#0
	STA	ADRESS		;make low byte of indirect ptr = 0
	RTS

;****
; PATCH  to eliminate WSYNC from click routine

PCLICK
	LDX	#2*63		;2 times trip count
	PHA			;will need to use A
PCLIC1
	STX	CONSOL		;turn loudspeaker on

	LDA	VCOUNT		;loop til VCOUNT changes
PCLIC2
	CMP	VCOUNT		;ea VCOUNT = 2 WSYNCs
	BEQ	PCLIC2

	DEX
	DEX
	BPL	PCLIC1		;loop til count = 0

	PLA			;restore A
	RTS

;****
; PATCH  for CASETTE handler so that it supports both PAL and NTSC

CHPAT1
	LDX	PALNTS
	LDY	RLEADL,X
	LDA	RLEADH,X
	TAX
	JMP	CHP1.RT


;****
; PATCH  for CASETTE handler so that it supports both PAL and NTSC

CHPAT2
	LDX	PALNTS
	LDY	WLEADL,X
	LDA	WLEADH,X
	TAX
	JMP	CHP2.RT


;****
; PATCH #1 for DISPLAY handler
; entered w/ X = DINDEX to identify mode 9,10,11,and 15
;	IF (9,10,11)	jump to DHP1RT
;	ELSE IF 15	jump to C0C6
;	ELSE		jump to NOT8

DHPAT1
	CPX	#8
	BCC	DHP1.2

	CPX	#15
	BNE	DHP1.1
	JMP	COC6

DHP1.1
	CPX	#12
	BCS	DHP1.2
	JMP	DHP1RT

DHP1.2
	JMP	NOT8

;****
; PATCH #2 for DISPLAY handler
; IF >= 12	jump C0C10
; ELSE CMP #9	jump DHP2RT

DHPAT2
	LDA	DINDEX
	CMP	#12
	BCS	DHP2.1

	CMP	#9
	JMP	DHP2RT
DHP2.1
	JMP	COC10


;****
; PATCH #3 for DISPLAY handler
; to identify mode 9,10,11,and 15
;	IF (9,10,11,15)	jump to DHP3RT
;	ELSE		jump to DOPEN5
; entry w/ A = DINDEX

DHPAT3
	CMP	#8
	BCC	DHP3.2

	CMP	#15
	BEQ	DHP3.1

	CMP	#12
	BCS	DHP3.2
DHP3.1
	JMP	DHP3RT

DHP3.2
	JMP	DOPEN5


;****
; TABLE from XL OS with 1 less per an entry

TLSC
	DB	2,1,1,0,0,1,1,2,2,2,2,2,2,2,1,2



