      LIST      X
; THIS IS THE ORIGINAL JUNE 1979 ATARI 400/800 COMPUTER OPERATING
; SYSTEM LISTING, MODIFIED TO ASSEMBLE ON THE MICROTEC CROSS
; ASSEMBLER.  IN ACTUALITY, A COUPLE OF FILLER (ZERO) BYTES
; SHOWN IN THIS LISTING WERE NOT ZERO IN RELEASED ROMS.
; ALSO, RESET VECTORS, COLD START VECTOR, ROM CHECKSUM OF THE
; RELEASED CODE ARE NOT REPRESENTED HERE--THIS CODE ASSEMBLES
; INTO THE VERSION USED TO LOAD INTO ATARI'S RAM-BASED
; COMPUTER DEVELOPMENT SYSTEMS.
;
; THE FOLLOWING SOURCE CHANGES WERE MADE TO CONVERT TO THE
; MICROTEC ASSEMBLER:
;   1.  " CHANGED TO ' ; ALSO, CLOSING ' ADDED WHERE NECESSARY
;   2.  SOME SOURCE SPACING CORRECTIONS MADE (EG., .PAGE
;          NOT IN COLUMN 1)
;   3.  ( ) IN COMPLEX EXPRESSIONS ADDED FOR CORRECT EVALUATION
;   4.  ILLEGAL OPCODE (PAGE 3 OF INTERRUPT HANDLER) MADE
;          INTO A COMMENT TO REFLECT THAT IT DID NOT
;          ASSEMBLE IN THE ORIGINAL ASSEMBLER
;   5.  FORWARD REFERENCES IN EQUATES NOT ALLOWED IN MICROTEC.
;          SYMBOLS MOVED:
;              IN SIO:  JTADRH,JTADRL  FROM P.3 TO PP.14,15
;              IN MON:  TBLLEN         FROM P.3 TO P.3
;   6.  SOME DUPLICATE LABELS CAUSED PROBLEMS.  SUBSTITUTE LABELS
;          CREATED:
;              IN SIO:  CASET  PP. 2,4,15,16
;              IN DSK:  FOMAT  PP. 1,2,2
;          DUPLICATE LABELS WHICH CAUSED NO PROBLEMS TO THE
;          RESULTING OBJECT ARE UNCHANGED (EITHER DUP VALUE
;          SAME OR LABEL NOT REFERENCED).
 .PAGE
;
;
;       COLLEEN OPERATING SYSTEM EQUATE FILE
;
;
;
;       MODULE ORIGIN TABLE
;
CHRORG  =       $E000       CHARACTER SET
VECTBL  =       $E400       VECTOR TABLE
VCTABL  =       $E480       RAM VECTOR INITIAL VALUE TABLE
CIOORG  =       $E4A6       CENTRAL I/O HANDLER
INTORG  =       $E6D5       INTERRUPT HANDLER
SIOORG  =       $E944       SERIAL I/O DRIVER
DSKORG  =       $EDEA       DISK HANDLER
PRNORG  =       $EE78       PRINTER HANDLER
CASORG  =       $EF41       CASSETTE HANDLER
MONORG  =       $F0E3       MOINTOR/POWER UP MODULE
KBDORG  =       $F3E4       KEYBOARD/DISPLAY HANDLER
;
;
;
;
;     VECTOR TABLE
;
;HANDLER ENTRY POINTS ARE CALLED OUT IN THE FOLLOWING VECTOR
;TABLE. THESE ARE THE ADDRESSES MINUS ONE.
;
;
;EXAMPLE FOR EDITOR
;
;    E400       OPEN
;       2       CLOSE
;       4       GET
;       6       PUT
;       8       STATUS
;       A       SPECIAL
;       C       JUMP TO POWER ON INITIALIZATION ROUTINE
;       F       NOT USED
;
;
EDITRV  =       $E400       EDITOR
SCRENV  =       $E410       TELEVISION SCREEN
KEYBDV  =       $E420       KEYBOARD
PRINTV  =       $E430       PRINTER
CASETV  =       $E440       CASSETTE
;
;       JUMP VECTOR TABLE
;
;THE FOLLOWING IS A TABLE OF JUMP INSTRUCTIONS
;TO VARIOUS ENTRY POINTS IN THE OPERATING SYSTEM.
;
DISKIV  =       $E450       DISK INITIALIZATION
DSKINV  =       $E453       DISK INTERFACE
CIOV    =       $E456       CENTRAL INPUT OUTPUT ROUTINE
SIOV    =       $E459       SERIAL INPUT OUTPUT ROUTINE
SETVBV  =       $E45C       SET SYSTEM TIMERS ROUTINE
SYSVBV  =       $E45F       SYSTEM VERTICAL BLANK CALCULATIONS
XITVBV  =       $E462       EXIT VERTICAL BLANK CALCULATIONS
SIOINV  =       $E465       SERIAL INPUT OUTPUT INITIALIZATION
SENDEV  =       $E468       SEND ENABLE ROUTINE
INTINV  =       $E46B       INTERRUPT HANDLER INITIALIZATION
CIOINV  =       $E46E       CENTRAL INPUT OUTPUT INITIALIZATION
BLKBDV  =       $E471       BLACKBOARD MODE
WARMSV  =       $E474       WARM START ENTRY POINT
COLDSV  =       $E477       COLD START ENTRY POINT
RBLOKV  =       $E47A       CASSETTE READ BLOCK ENTRY POINT VECTOR
CSOPIV  =       $E47D       CASSETTE OPEN FOR INPUT VECTOR
;VCTABL = $E480
;
;
; OPERATING SYSTEM EQUATES
;
; COMMAND CODES FOR IOCB
OPEN    =       3             OPEN FOR INPUT/OUTPUT
GETREC  =       5             GET RECORD (TEXT)
GETCHR  =       7             GET CHARACTER(S)
PUTREC  =       9             PUT RECORD (TEXT)
PUTCHR  =       $B            PUT CHARACTER(S)
CLOSE   =       $C            CLOSE DEVICE
STATIS  =       $D            STATUS REQUEST
SPECIL  =       $E            BEGINNING OF SPECIAL ENTRY COMMANDS
;
; SPECIAL ENTRY COMMANDS
DRAWLN  =       $11           DRAW LINE
FILLIN  =       $12           DRAW LINE WITH RIGHT FILL
RENAME  =       $20           RENAME DISK FILE
DELETE  =       $21           DELETE DISK FILE
FORMAT  =       $22           FORMAT
LOCKFL  =       $23           LOCK FILE TO READ ONLY
UNLOCK  =       $24           UNLOCK LOCKED FILE
POINT   =       $25           POINT SECTOR
NOTE    =       $26           NOTE SECTOR
IOCFRE  =       $FF           IOCB "FREE"
;
; AUX1 EQUATES
; () INDICATES WHICH DEVICES USE BIT
APPEND  =       $1            OPEN FOR WRITE APPEND (D), OR SCREEN READ 
DIRECT  =       $2            OPEN FOR DIRECTORY ACCESS (D)
OPNIN   =       $4            OPEN FOR INPUT (ALL DEVICES)
OPNOT   =       $8            OPEN FOR OUTPUT (ALL DEVICES)
OPNINO  =       OPNIN+OPNOT   OPEN FOR INPUT AND OUTPUT (ALL DEVICES)
MXDMOD  =       $10           OPEN FOR MIXED MODE (E,S)
INSCLR  =       $20           OPEN WITHOUT CLEARING SCREEN (E,S)
;
; DEVICE NAMES
SCREDT  =       'E            SCREEN EDITOR (R/W)
KBD     =       'K            KEYBOARD (R ONLY)
DISPLY  =       'S            SCREEN DISPLY (R/W)
PRINTR  =       'P            PRINTER (W ONLY)
CASSET  =       'C            CASSETTE
MODEM   =       'M            MODEM
DISK    =       'D            DISK (R/W)
;
; SYSTEM EOL (CARRIAGE RETURN)
CR      =       $9B
;
;
;       OPERATING SYSTEM STATUS CODES
;
SUCCES  =       $01           SUCCESSFUL OPERATION
;
BRKABT  =       $80           BREAK KEY ABORT
PRVOPN  =       $81           IOCB ALREADY OPEN
NONDEV  =       $82           NON-EXISTANT DEVICE
WRONLY  =       $83           IOCB OPENED FOR WRITE ONLY
NVALID  =       $84           INVALID COMMAND
NOTOPN  =       $85           DEVICE OR FILE NOT OPEN
BADIOC  =       $86           INVALID IOCB NUMBER
RDONLY  =       $87           IOCB OPENED FOR READ ONLY
EOFERR  =       $88           END OF FILE
TRNRCD  =       $89           TRUNCATED RECORD
TIMOUT  =       $8A           PERIPHERAL DEVICE TIME OUT
DNACK   =       $8B           DEVICE DOES NOT ACKNOWLEDGE COMMAND
FRMERR  =       $8C           SERIAL BUS FRAMING ERROR
CRSROR  =       $8D           CURSOR OVERRANGE
OVRRUN  =       $8E           SERIAL BUS DATA OVERRUN
CHKERR  =       $8F           SERIAL BUS CHECKSUM ERROR
;
DERROR  =       $90           PERIPHERAL DEVICE ERROR (OPERATION NOT COM
BADMOD  =       $91           BAD SCREEN MODE NUMBER
FNCNOT  =       $92           FUNCTION NOT IMPLEMENTED IN HANDLER
SCRMEM  =       $93           INSUFICIENT MEMORY FOR SCREEN MODE
;
;
;
;
;
;
;       PAGE ZERO RAM ASSIGNMENTS
;
        *=$0000
LINZBS  *=*+2   LINBUG       RAM (WILL BE REPLACED BY MONITOR RAM)
;
; THESE LOCATIONS ARE NOT CLEARED
CASINI  *=*+2   CASSETTE    INIT LOCATION
RAMLO   *=*+2   RAM         POINTER FOR MEMORY TEST
TRAMSZ  *=*+1   TEMPORARY   REGISTER FOR RAM SIZE
TSTDAT  *=*+1   RAM         TEST DATA REGISTER
;
; CLEARED ON COLDSTART ONLY
WARMST  *=*+1   WARM        START FLAG
BOOT?   *=*+1   SUCCESSFUL  BOOT FLAG
DOSVEC  *=*+2   DISK        SOFTWARE START VECTOR
DOSINI  *=*+2   DISK        SOFTWARE INIT ADDRESS
APPMHI  *=*+2   APPLICATIONS MEMORY HI LIMIT
;
; CLEARED ON COLD OR WARM START
INTZBS  =*      INTERRUPT   HANDLER
POKMSK  *=*+1   SYSTEM      MASK FOR POKEY IRQ ENABLE
BRKKEY  *=*+1   BREAK       KEY FLAG
RTCLOK  *=*+3   REAL        TIME CLOCK (IN 16 MSEC UNITS)
;
BUFADR  *=*+2   INDIRECT    BUFFER ADDRESS REGISTER
;
ICCOMT  *=*+1   COMMAND     FOR VECTOR
;
DSKFMS  *=*+2   DISK        FILE MANAGER POINTER
DSKUTL  *=*+2   DISK        UTILITIES POINTER
;
PTIMOT  *=*+1   PRINTER     TIME OUT REGISTER
PBPNT   *=*+1   PRINT       BUFFER POINTER
PBUFSZ  *=*+1   PRINT       BUFFER SIZE
PTEMP   *=*+1   TEMPORARY   REGISTER
;
ZIOCB   =*      ZERO        PAGE I/O CONTROL BLOCK
IOCBSZ  =       16             NUMBER OF BYTES PER IOCB
MAXIOC  =       8*IOCBSZ      LENGTH OF THE IOCB AREA
IOCBAS  =*
ICHIDZ  *=*+1   HANDLER     INDEX NUMBER (FF = IOCB FREE)
ICDNOZ  *=*+1   DEVICE      NUMBER (DRIVE NUMBER)
ICCOMZ  *=*+1   COMMAND     CODE
ICSTAZ  *=*+1   STATUS      OF LAST IOCB ACTION
ICBALZ  *=*+1   BUFFER      ADDRESS LOW BYTE
ICBAHZ  *=*+1
ICPTLZ  *=*+1   PUT         BYTE ROUTINE ADDRESS - 1
ICPTHZ  *=*+1
ICBLLZ  *=*+1   BUFFER      LENGTH LOW BYTE
ICBLHZ  *=*+1
ICAX1Z  *=*+1   AUXILIARY   INFORMATION FIRST BYTE
ICAX2Z  *=*+1
ICSPRZ  *=*+4   TWO         SPARE BYTES (CIO LOCAL USE)
ICIDNO  =       ICSPRZ+2     IOCB NUMBER X 16
CIOCHR  =       ICSPRZ+3     CHARACTER BYTE FOR CURRENT OPERATION
;
STATUS  *=*+1   INTERNAL    STATUS STORAGE
CHKSUM  *=*+1   CHECKSUM    (SINGLE BYTE SUM WITH CARRY)
BUFRLO  *=*+1   POINTER     TO DATA BUFFER (LO BYTE)
BUFRHI  *=*+1   POINTER     TO DATA BUFFER (HI BYTE)
BFENLO  *=*+1   NEXT        BYTE PAST END OF THE DATA BUFFER (LO BYTE)
BFENHI  *=*+1   NEXT        BYTE PAST END OF THE DATA BUFFER (HI BYTE)
CRETRY  *=*+1   NUMBER      OF COMMAND FRAME RETRIES
DRETRY  *=*+1   NUMBER      OF DEVICE RETRIES
BUFRFL  *=*+1   DATA        BUFFER FULL FLAG
RECVDN  *=*+1   RECEIVE     DONE FLAG
XMTDON  *=*+1   TRANSMISSION DONE FLAG
CHKSNT  *=*+1   CHECKSUM    SENT FLAG
NOCKSM  *=*+1   NO          CHECKSUM FOLLOWS DATA FLAG
;
;
BPTR    *=*+1
FTYPE   *=*+1
FEOF    *=*+1
FREQ    *=*+1
SOUNDR  *=*+1   NOISY       I/O FLAG.  (ZERO IS QUIET)
CRITIC  *=*+1   DEFINES     CRITICAL SECTION (CRITICAL IF NON-ZERO)
;
FMSZPG  *=*+7   DISK        FILE MANAGER SYSTEM ZERO PAGE
;
;
CKEY    *=*+1   FLAG        SET WHEN GAME START PRESSED
CASSBT  *=*+1   CASSETTE    BOOT FLAG
DSTAT   *=*+1   DISPLAY     STATUS
;
ATRACT  *=*+1   ATRACT      FLAG
DRKMSK  *=*+1   DARK        ATRACT MASK
COLRSH  *=*+1   ATRACT      COLOR SHIFTER (EOR'ED WITH PLAYFIELD COLORS)
;
LEDGE   =       2               LMARGN'S VALUE AT COLD START
REDGE   =       39             RMARGN'S VALUE AT COLD START
TMPCHR  *=*+1
HOLD1   *=*+1
LMARGN  *=*+1   LEFT        MARGIN (SET TO 1 AT POWER ON)
RMARGN  *=*+1   RIGHT       MARGIN (SET TO 38 AT POWER ON)
ROWCRS  *=*+1   CURSOR      COUNTERS
COLCRS  *=*+2
DINDEX  *=*+1
SAVMSC  *=*+2
OLDROW  *=*+1
OLDCOL  *=*+2
OLDCHR  *=*+1   DATA        UNDER CURSOR
OLDADR  *=*+2
NEWROW  *=*+1   POINT       DRAW GOES TO
NEWCOL  *=*+2
LOGCOL  *=*+1   POINTS      AT COLUMN IN LOGICAL LINE
ADRESS  *=*+2
MLTTMP  *=*+2
OPNTMP  =       MLTTMP        FIRST BYTE IS USED IN OPEN AS TEMP
SAVADR  *=*+2
RAMTOP  *=*+1   RAM         SIZE DEFINED BY POWER ON LOGIC
BUFCNT  *=*+1   BUFFER      COUNT
BUFSTR  *=*+2   EDITOR      GETCH POINTER
BITMSK  *=*+1   BIT         MASK
SHFAMT  *=*+1
ROWAC   *=*+2
COLAC   *=*+2
ENDPT   *=*+2
DELTAR  *=*+1
DELTAC  *=*+2
ROWINC  *=*+1
COLINC  *=*+1
SWPFLG  *=*+1   NON-0       IF TXT AND REGULAR RAM IS SWAPPED
HOLDCH  *=*+1   CH          IS MOVED HERE IN KGETCH BEFORE CNTL & SHIFT 
INSDAT  *=*+1
COUNTR  *=*+2
;
;
;
;
;       80 - FF ARE RESERVED FOR USER APPLICATIONS
;
;
;
;       NOTE : SEE FLOATING POINT SUBROUTINE AREA FOR ZERO PAGE CELLS
;
;
;
;
;       PAGE 1   -   STACK
;
;
;
;
;       PAGE TWO RAM ASSIGNMENTS
;
        *=$0200
INTABS  =*      INTERRUPT   RAM
VDSLST  *=*+2   DISPLAY     LIST NMI VECTOR
VPRCED  *=*+2   PROCEED     LINE IRQ VECTOR
VINTER  *=*+2   INTERRUPT   LINE IRQ VECTOR
VBREAK  *=*+2   SOFTWARE    BREAK (00) INSTRUCTION IRQ VECTOR
VKEYBD  *=*+2   POKEY       KEYBOARD IRQ VECTOR
VSERIN  *=*+2   POKEY       SERIAL INPUT READY IRQ
VSEROR  *=*+2   POKEY       SERIAL OUTPUT READY IRQ
VSEROC  *=*+2   POKEY       SERIAL OUTPUT COMPLETE IRQ
VTIMR1  *=*+2   POKEY       TIMER 1 IRQ
VTIMR2  *=*+2   POKEY       TIMER 2 IRQ
VTIMR4  *=*+2   POKEY       TIMER 4 IRQ
VIMIRQ  *=*+2   IMMEDIATE   IRQ VECTOR
CDTMV1  *=*+2   COUNT       DOWN TIMER 1
CDTMV2  *=*+2   COUNT       DOWN TIMER2
CDTMV3  *=*+2   COUNT       DOWN TIMER 3
CDTMV4  *=*+2   COUNT       DOWN TIMER 4
CDTMV5  *=*+2   COUNT       DOWN TIMER 5
VVBLKI  *=*+2   IMMEDIATE   VERTICAL BLANK NMI VECTOR
VVBLKD  *=*+2   DEFERRED    VERTICAL BLANK NMI VECTOR
CDTMA1  *=*+2   COUNT       DOWN TIMER 1 JSR ADDRESS
CDTMA2  *=*+2   COUNT       DOWN TIMER 2 JSR ADDRESS
CDTMF3  *=*+1   COUNT       DOWN TIMER 3 FLAG
SRTIMR  *=*+1   SOFTWARE    REPEAT TIMER
CDTMF4  *=*+1   COUNT       DOWN TIMER 4 FLAG
INTEMP  *=*+1   IAN'S       TEMP (RENAMED FROM T1 BY POPULAR DEMAND)
CDTMF5  *=*+1   COUNT       DOWN TIMER FLAG 5
SDMCTL  *=*+1   SAVE        DMACTL REGISTER
SDLSTL  *=*+1   SAVE        DISPLAY LIST LOW BYTE
SDLSTH  *=*+1   SAVE        DISPLAY LIST HI BYTE
SSKCTL  *=*+1   SKCTL       REGISTER RAM
        *=*+1
;
LPENH   *=*+1   LIGHT       PEN HORIZONTAL VALUE
LPENV   *=*+1   LIGHT       PEN VERTICAL VALUE
        *=*+2   SPARE       BYTES
;
        *=*+2   SPARE
;
CDEVIC  *=*+1   COMMAND     FRAME BUFFER - DEVICE
CCOMND  *=*+1                          COMMAND
CAUX1   *=*+1                           COMMAND AUX BYTE 1
CAUX2   *=*+1                           COMMAND AUX BYTE 2
;               NOTE: MAY NOT BE THE LAST WORD ON A PAGE
TEMP    *=*+1   TEMPORARY   RAM CELL
;               NOTE: MAY NOT BE THE LAST WORD ON A PAGE
ERRFLG  *=*+1   ERROR       FLAG - ANY DEVICE ERROR EXCEPT TIME OUT
;
DFLAGS  *=*+1   DISK        FLAGS FROM SECTOR ONE
DBSECT  *=*+1   NUMBER      OF DISK BOOT SECTORS
BOOTAD  *=*+2   ADDRESS     WHERE DISK BOOT LOADER WILL BE PUT
COLDST  *=*+1   COLDSTART   FLAG (1=IN MIDDLE OF COLDSTART)
;
        *=*+1   SPARE
;
DSKTIM  *=*+1   DISK        TIME OUT REGISTER
;
LINBUF  *=*+40  CHAR        LINE BUFFER
;
GPRIOR  *=*+1   GLOBAL      PRIORITY CELL
;
PADDL0  *=*+1   POTENTIOMETER 0 RAM CELL
PADDL1  *=*+1
PADDL2  *=*+1
PAODL3  *=*+1
PADDL4  *=*+1
PADDL5  *=*+1
PADDL6  *=*+1
PADDL7  *=*+1
STICK0  *=*+1   JOYSTICK    0 RAM CELL
STICK1  *=*+1
STICK2  *=*+1
STICK3  *=*+1
PTRIG0  *=*+1   PADDLE      TRIGGER 0
PTRIG1  *=*+1
PTRIG2  *=*+1
PTRIG3  *=*+1
PTRIG4  *=*+1
PTRIG5  *=*+1
PTRIG6  *=*+1
PTRIG7  *=*+1
STRIG0  *=*+1   JOYSTICK    TRIGGER 0
STRIG1  *=*+1
STRIG2  *=*+1
STRIG3  *=*+1
;
CSTAT   *=*+1
WMODE   *=*+1
BLIM    *=*+1
;
        *=*+5   SPARE
;
;
;
;
TXTROW  *=*+1   TEXT        ROWCRS
TXTCOL  *=*+2   TEXT        COLCRS
TINDEX  *=*+1   TEXT        INDEX
TXTMSC  *=*+2   FOOLS       CONVRT INTO NEW MSC
TXTOLD  *=*+6   OLDROW      & OLDCOL FOR TEXT (AND THEN SOME)
TMPX1   *=*+1
HOLD3   *=*+1
SUBTMP  *=*+1
HOLD2   *=*+1
DMASK   *=*+1
TMPLBT  *=*+1
ESCFLG  *=*+1   ESCAPE      FLAG
TABMAP  *=*+15
LOGMAP  *=*+4   LOGICAL     LINE START BIT MAP
INVFLG  *=*+1   INVERSE     VIDEO FLAG (TOGGLED BY ATARI KEY)
FILFLG  *=*+1   RIGHT       FILL FLAG FOR DRAW
TMPROW  *=*+1
TMPCOL  *=*+2
SCRFLG  *=*+1   SET         IF SCROLL OCCURS
HOLD4   *=*+1   TEMP        CELL USED IN DRAW ONLY
HOLD5   *=*+1   DITTO
SHFLOK  *=*+1
BOTSCR  *=*+1   BOTTOM      OF SCREEN : 24 NORM  4 SPLIT
;
;
PCOLR0  *=*+1   P0          COLOR
PCOLR1  *=*+1   P1          COLOR
PCOLR2  *=*+1   P2          COLOR
PCOLR3  *=*+1   P3          COLOR
COLOR0  *=*+1   COLOR       0
COLOR1  *=*+1
COLOR2  *=*+1
COLOR3  *=*+1
COLOR4  *=*+1


        *=*+23  SPARE



GLBABS  =*      GLOBAL      VARIABLES
;
        *=*+4   SPARE
;
RAMSIZ  *=*+1   RAM         SIZE (HI BYTE ONLY)
MEMTOP  *=*+2   TOP         OF AVAILABLE USER MEMORY
MEMLO   *=*+2   BOTTOM      OF AVAILABLE USER MEMORY
        *=*+1   SPARE
DVSTAT  *=*+4   STATUS      BUFFER
CBAUDL  *=*+1   CASSETTE    BAUD RATE LOW BYTE
CBAUDH  *=*+1
;
CRSINH  *=*+1   CURSOR      INHIBIT (00 = CURSOR ON)
KEYDEL  *=*+1   KEY         DELAY
CH1     *=*+1
;
CHACT   *=*+1   CHACTL      REGISTER RAM
CHBAS   *=*+1   CHBAS       REGISTER RAM
;
        *=*+5   SPARE       BYTES
;
CHAR    *=*+1
ATACHR  *=*+1   ATASCII     CHARACTER
CH      *=*+1   GLOBAL      VARIABLE FOR KEYBOARD
FILDAT  *=*+1   RIGHT       FILL DATA (DRAW)
DSPFLG  *=*+1   DISPLAY     FLAG : DISPLAY CNTLS IF NON-ZERO
SSFLAG  *=*+1   START/STOP  FLAG FOR PAGING (CNTL 1). CLEARED BY BREAK
;
;
;
;
;
;
;
;       PAGE THREE RAM ASSIGNMENTS
;
DCB     =*      DEVICE      CONTROL BLOCK
DDEVIC  *=*+1   PERIPHERAL  UNIT 1 BUS I.D. NUMBER
DUNIT   *=*+1   UNIT        NUMBER
DCOMND  *=*+1   BUS         COMMAND
DSTATS  *=*+1   COMMAND     TYPE/STATUS RETURN
DBUFLO  *=*+1   DATA        BUFFER POINTER LOW BYTE
DBUFHI  *=*+1
DTIMLO  *=*+1   DEVICE      TIME OUT IN 1 SECOND UNITS
DUNUSE  *=*+1   UNUSED      BYTE
DBYTLO  *=*+1   NUMBER      OF BYTES TO BE TRANSFERRED LOW BYTE
DBYTHI  *=*+1
DAUX1   *=*+1   COMMAND     AUXILIARY BYTE 1
DAUX2   *=*+1
;
TIMER1  *=*+2   INITIAL     TIMER VALUE
ADDCOR  *=*+1   ADDITION    CORRECTION
CASFLG  *=*+1   CASSETTE    MODE WHEN SET
TIMER2  *=*+2   FINAL       TIMER VALUE. THESE TWO TIMER VALUES
;               ARE USED TO COMPUTE INTERVAL FOR BAUD RATE
TEMP1   *=*+2   TEMPORARY   STORAGE REGISTER
TEMP2   *=*+1   TEMPORARY   STORAGE REGISTER
TEMP3   *=*+1   TEMPORARY   STORAGE REGISTER
SAVIO   *=*+1   SAVE        SERIAL IN DATA PORT
TIMFLG  *=*+1   TIME        OUT FLAG FOR BAUD RATE CORRECTION
STACKP  *=*+1   SIO         STACK POINTER SAVE CELL
TSTAT   *=*+1   TEMPORARY   STATUS HOLDER
;
;
;
HATABS  *=*+38  HANDLER     ADDRESS TABLE
MAXDEV  =       *-HATABS-5    MAXIMUM HANDLER ADDRESS INDEX
;
;     NOTE : THE ENTIRE IOCB DEFINITIONS HAVE BEEN MODIFIED
;
IOCB    *=      *              I/O CONTROL BLOCKS
ICHID   *=*+1   HANDLER     INDEX NUMBER (FF = IOCB FREE)
ICDNO   *=*+1   DEVICE      NUMBER (DRIVE NUMBER)
ICCOM   *=*+1   COMMAND     CODE
ICSTA   *=*+1   STATUS      OF LAST IOCB ACTION
ICBAL   *=*+1   BUFFER      ADDRESS LOW BYTE
ICBAH   *=*+1
ICPTL   *=*+1   PUT         BYTE ROUTINE ADDRESS - 1
ICPTH   *=*+1
ICBLL   *=*+1   BUFFER      LENGTH LOW BYTE
ICBLH   *=*+1
ICAX1   *=*+1   AUXILIARY   INFORMATION FIRST BYTE
ICAX2   *=*+1
ICSPR   *=*+4   FOUR        SPARE BYTES
        *=*+MAXIOC-IOCBSZ
;
PRNBUF  *=*+40  PRINTER     BUFFER
;
        *=*+21  SPARE       BYTES
;
;
;
;
;
;
;
;       PAGE FOUR RAM ASSIGNMENTS
;
CASBUF  *=*+131 CASSETTE    BUFFER
;
; USER AREA STARTS HERE AND GOES TO END OF PAGE FIVE
USAREA  *=*+128 SPARE
;
;
;
;
;
;
;
;       PAGE FIVE RAM ASSIGNMENTS
;
;       PAGE FIVE IS RESERVED AS A USER WORK SPACE
;
;       NOTE: SEE FLOATING POINT SUBROUTINE AREA FOR PAGE FIVE CELLS
;
;
;       PAGE SIX RAM ASSIGNMENTS
;
;       PAGE SIX IS RESERVED AS A USER'S USER WORK SPACE
;
;
;
;
;                               FLOATING POINT SUBROUTINES
;
FPREC   =       6               ;FLOATING PT PRECISION (# OF BYTES)
;                               IF CARRY USED THEN CARRY CLEAR => NO ERR
AFP     =       $D800           ;ASCII->FLOATING POINT (FP)
;                               INBUFF+CIX -> FR0, CIX, CARRY
FASC    =       $D8E6           ;FP -> ASCII      FR0-> LBUFF  (INBUFF)
IFP     =       $D9AA           ;INTEGER -> FP
;                               0-$FFFF (LSB,MSB) IN FR0,FR0+1->FR0
FPI     =       $D9D2           ;FP -> INTEGER    FR0 -> FR0,FR0+1, CARR
FSUB    =       $DA60           ;FR0 <- FR0 - FR1  ,CARRY
FADD    =       $DA66           ;FR0 <- FR0 + FR1  ,CARRY
FMUL    =       $DADB           ;FR0 <- FR0 * FR1  ,CARRY
FDIV    =       $DB28           ;FR0 <- FR0 / FR1  ,CARRY
FLD0R   =       $DD89           ;FLOATING LOAD REG0    FR0 <- (X,Y)
FLD0P   =       $DD8D           ;    "     "    "      FR0 <- (FLPTR)
FLD1R   =       $DD98           ;    "     "   REG1    FR1 <- (X,Y)
FLD1P   =       $DD9C           ;    "     "    "      FR1 <- (FLPTR)
FST0R   =       $DDA7           ;FLOATING STORE REG0 (X,Y) <- FR0
FST0P   =       $DDAB           ;    "     "    "   (FLPTR)<- FR0
FMOVE   =       $DDB6           ;FR1 <- FR0
PLYEVL  =       $DD40           ;FR0 <- P(Z) = SUM(I=N TO 0) (A(I)*Z**I)
;                               INPUT: (X,Y) = A(N),A(N-1)...A(0)  -> PL
;                                      ACC   = # OF COEFFICIENTS = DEGRE
;                                      FR0   = Z
EXP     =       $DDC0           ;FR0 <- E**FR0 = EXP10(FR0 * LOG10(E))  
EXP10   =       $DDCC           ;FR0 <- 10**FR0  CARRY
LOG     =       $DECD           ;FR0 <- LN(FR0) = LOG10(FR0)/LOG10(E)   
LOG10   =       $DED1           ;FR0 <- LOG10 (FR0)    CARRY
;                               THE FOLLOWING ARE IN BASIC CARTRIDGE:
SIN     =       $BD81           ;FR0 <- SIN(FR0)  DEGFLG=0 =>RADS,  6=>D
COS     =       $BD73           ;FR0 <- COS(FR0)    CARRY
ATAN    =       $BE43           ;FR0 <- ATAN(FR0)   CARRY
SQR     =       $BEB1           ;FR0 <- SQUAREROOT(FR0)   CARRY
;FLOATING POINT ROUTINES ZERO PAGE (NEEDED ONLY IF F.P. ROUTINES ARE CAL
        *=$D4
FR0     *=*+FPREC                 ;FP REG0
FRE     *=*+FPREC
FR1     *=*+FPREC                 ;FP REG1
FR2     *=*+FPREC
FRX     *=*+1           ;FP SPARE
EEXP    *=*+1           ;VALUE OF E
NSIGN   *=*+1           ;SIGN OF #
ESIGN   *=*+1           ;SIGN OF EXPONENT
FCHRFLG *=*+1           ;1ST CHAR FLAG
DIGRT   *=*+1           ;# OF DIGITS RIGHT OF DECIMAL
CIX     *=*+1           ;CURRENT INPUT INDEX
INBUFF  *=*+2           ;POINTS TO USER'S LINE INPUT BUFFER
ZTEMP1  *=*+2
ZIEMP4  *=*+2
ZTEMP3  *=*+2
DEGFLG
RADFLG  *=*+1           ;0=RADIANS, 6=DEGREES
RADON   =       0                 ;INDICATES RADIANS
DEGON   =       6                 ;INDICATES DEGREES
FLPTR   *=*+2           ;POINTS TO USER'S FLOATING PT NUMBER
FPTR2   *=*+2
;FLOATING PT ROUTINES' NON-ZERO PAGE RAM (NEEDED ONLY IF F.P. ROUTINES C
        *=$57E
LBPR1   *=*+1           ;LBUFF PREFIX 1
LBPR2   *=*+1           ;LBUFF PREFIX 2
LBUFF   *=*+128         ;LINE BUFFER
PLYARG  =       LBUFF+$60       ;POLYNOMIAL ARGUMENTS
FPSCR   =       PLYARG+FPREC
FPSCR1  =       FPSCR+FPREC
FSCR    =       FPSCR
FSCR1   =       FPSCR1
LBFEND  =       *-1             ;END OF LBUFF
;
;
;
;
;
;
;
;
;
;       COLLEEN MNEMONICS
;
POKEY   =       $D200           VBLANK ACTION:          DESCRIPTION:
POT0    =       POKEY+0         POT0-->PADDL0           0-227 IN RAM CEL
POT1    =       POKEY+1         POT1-->PADDL1           0-227 IN RAM CEL
POT2    =       POKEY+2         POT2-->PADDL2           0-227 IN RAM CEL
POT3    =       POKEY+3         POT3-->PADDL3           0-227 IN RAM CEL
POT4    =       POKEY+4         POT4-->PADDL4           0-227 IN RAM CEL
POT5    =       POKEY+5         POT5-->PADDL5           0-227 IN RAM CEL
POT6    =       POKEY+6         POT6-->PADDL6           0-227 IN RAM CEL
POT7    =       POKEY+7         POT7-->PADDL7           0-227 IN RAM CEL
ALLPOT  =       POKEY+8         ???
KBCODE  =       POKEY+9
RANDOM  =       POKEY+10
POTGO   =       POKEY+11        STROBED
SERIN   =       POKEY+13
IRQST   =       POKEY+14
SKSTAT  =       POKEY+15
AUDF1   =       POKEY+0
AUDC1   =       POKEY+1
AUDF2   =       POKEY+2
AUDC2   =       POKEY+3
AUDF3   =       POKEY+4
AUDC3   =       POKEY+5
AUDF4   =       POKEY+6
AUDC4   =       POKEY+7
AUDCTL  =       POKEY+8         NONE                    AUDCTL<--[SIO]
STIMER  =       POKEY+9
SKRES   =       POKEY+10        NONE                    SKRES<--[SIO]
SEROUT  =       POKEY+13        NONE                    SEROUT<--[SIO]
IRQEN   =       POKEY+14        POKMSK-->IRQEN  (AFFECTED BY OPEN S: OR 
SKCTL   =       POKEY+15        SSKCTL-->SKCTL          SSKCTL<--[SIO]
;
CTIA    =       $D000           VBLANK ACTION:          DESCRIPTION:
HPOSP0  =       CTIA+0
HPOSP1  =       CTIA+1
HPOSP2  =       CTIA+2
HPOSP3  =       CTIA+3
HPOSM0  =       CTIA+4
HPOSM1  =       CTIA+5
HPOSM2  =       CTIA+6
HPOSM3  =       CTIA+7
SIZEP0  =       CTIA+8
SIZEP1  =       CTIA+9
SIZEP2  =       CTIA+10
SIZEP3  =       CTIA+11
SIZEM   =       CTIA+12
GRAFP0  =       CTIA+13
GRAFP1  =       CTIA+14
GRAFP2  =       CTIA+15
GRAFP3  =       CTIA+16
GRAFM   =       CTIA+17
COLPM0  =       CTIA+18         PCOLR0-->COLPM0         WITH ATTRACT MOD
COLPM1  =       CTIA+19         PCOLR1-->COLPM1         WITH ATTRACT MOD
COLPM2  =       CTIA+20         PCOLR2-->COLPM2         WITH ATTRACT MOD
COLPM3  =       CTIA+21         PCOLR3-->COLPM3         WITH ATTRACT MOD
COLPF0  =       CTIA+22         COLOR0-->COLPF0         WITH ATTRACT MOD
COLPF1  =       CTIA+23         COLOR1-->COLPF1         WITH ATTRACT MOD
COLPF2  =       CTIA+24         COLOR2-->COLPF2         WITH ATTRACT MOD
COLPF3  =       CTIA+25         COLOR3-->COLPF3         WITH ATTRACT MOD
COLBK   =       CTIA+26         COLOR4-->COLBK          WITH ATTRACT MOD
PRIOR   =       CTIA+27         (ON OPEN S: OR E:)      GPRIOR-->PRIOR
VDELAY  =       CTIA+28
GRACTL  =       CTIA+29
HITCLR  =       CTIA+30
CONSOL  =       CTIA+31         $08-->CONSOL            TURN OFF SPEAKER
M0PF    =       CTIA+0
M1PF    =       CTIA+1
M2PF    =       CTIA+2
M3PF    =       CTIA+3
P0PF    =       CTIA+4
P1PF    =       CTIA+5
P2PF    =       CTIA+8
P3PF    =       CTIA+7
M0PL    =       CTIA+8
M1PL    =       CTIA+9
M2PL    =       CTIA+10
M3PL    =       CTIA+11
P0PL    =       CTIA+12
P1PL    =       CTIA+13
P2PL    =       CTIA+14
P3PL    =       CTIA+15
TRIG0   =       CTIA+16         TRIG0-->STRIG0
TRIG1   =       CTIA+17         TRIG1-->STRIG1
TRIG2   =       CTIA+18         TRIG2-->STRIG2
TRIG3   =       CTIA+19         TRIG3-->STRIG3
;
ANTIC   =       $D400           VBLANK ACTION           DESCRIPTION
DMACTL  =       ANTIC+0         DMACTL<--SDMCTL         ON OPEN S: OR E:
CHACTL  =       ANTIC+1         CHACTL<--CHACT          ON OPEN S: OR E:
DLISTL  =       ANTIC+2         DLISTL<--SDLSTL         ON OPEN S: OR E:
DLISTH  =       ANTIC+3         DLISTH<--SDLSTH         ON OPEN S: OR E:
HSCROL  =       ANTIC+4
VSCROL  =       ANTIC+5
PMBASE  =       ANTIC+7
CHBASE  =       ANTIC+9         CHBASE<--CHBAS          ON OPEN S: OR E:
WSYNC   =       ANTIC+10
VCOUNT  =       ANTIC+11
PENH    =       ANTIC+12
PENV    =       ANTIC+13
NMIEN   =       ANTIC+14        NMIEN<--40               POWER ON AND [S
NMIRES  =       ANTIC+15        STROBED
NMIST   =       ANTIC+15
PIA     =       $D300           VBLANK ACTION           DESCRIPTION
PORTA   =       PIA+0           PORTA-->STICK0,1        X-Y CONTROLLERS
PORTB   =       PIA+1           PORTB-->STICK2,3        X-Y CONTROLLERS
PACTL   =       PIA+2           NONE                    PACTL<--3C [INIT
PBCTL   =       PIA+3           NONE                    PBCTL<--3C [INIT
;
;
;
; .PAGE
