	.INCLUDE	"camac.inc"
	TITLE	'OS - Operating System'
	SUBTTL	' '
	LIST	-F,-M

;	SPACE	4,10
;***	Copyright 1984 ATARI.  Unauthorized reproduction, adaptation,
;*	distribution, performance or display of this computer program
;*	or the associated audiovisual work is strictly prohibited.
;	SPACE	4,10
;***	OS - Operating System
;*
;*	NOTES
;*		This source is currently being refined.  Areas which
;*		need work are indicated by question marks ("???").
;*
;*	MODS
;*		Revision A (400/800)
;*		D. Crane/A. Miller/L. Kaplan/R. Whitehead???	??/??/??
;*
;*		Revision B (400/800)
;*		Fix several problems.
;*		M. Mahar/R. S. Scheiman???	??/??/??
;*
;*		Revision 10 (1200XL)
;*		Support 1200XL, add new features.
;*		H. Stewart/L. Winner???
;*		R. S. Scheiman/Y. M. Chen/M. W. Colburn	10/26/82
;*
;*		Revision 11 (1200XL)
;*		Fix several problems.
;*		R. S. Scheiman	12/23/82
;*
;*		Revision 1 (600XL/800XL)
;*		Support PBI and on-board BASIC.
;*		R. S. Scheiman/R. K. Nordin/Y. M. Chen	03/11/83
;*
;*		Revision 2 (600XL/800XL)
;*		Fix several problems.
;*		R. S. Scheiman	05/10/83
;*		Bring closer to Coding Standard (object unchanged).
;*		R. K. Nordin	11/01/83
;*
;*		Revision 3 (600XL/800XL/1450XLD)
;*		Fix MAXDEV, problems resulting from CRASS65 version,
;*		initial address for RAM sizing, "Boot Error" message,
;*		initial address for cartridge equivalence checksum,
;*		mishandling of SIO NAK, initializing of CHKSUM, and
;*		initialization of PORTB.
;*		R. K. Nordin	03/27/84
;*
;*		Revision 3, Version 2 (600XL/800XL/1450XLD)
;*				
;*               Dedicate PDVI ($D1FF) to external parallel device IRQ status
;*		Dedicate IPDVI ($D1CF) to internal parallel device IRQ status
;*		Using PDIMSK ($0249) for external parallel device IRQ selection mask
;*		Using IPDIMK ($0254) for internal parallel device IRQ selection mask
;*		After masking (PDVI, PDIMSK) & (IPDVI, IPDIMK), OR the result
;*		together, piror to processing parallel device IRQ
;*
;*		On cold start, initialize PDVI = 0, to avoid potential
;*		checksum error.
;*		Y. T. JANG, V. WU	02/22/84
;*
;*		Revision 3, Version 3  (600XL/800XL/1450XLD)
;*
;*		Dedicate the 11 bytes at ACMVAR ($3ED-$3F7) for use as
;*		a RESET routine area.  On warmstart, the OS will JSR
;*		to ACMVAR immediately after initializing hardware.
;*		MIKE BARALL		06/08/84
;*
;*		Revision 3, Version 4  (600XL/800XL/1450XLD)
;*
;*		Make CIO accept device number 0 (like Rev B did).
;*		MIKE BARALL		06/21/84
;*
;*		Revision 4, Version 0 (600XL/800XL/1450XLD)
;*
;*		Add support for SIO fast mode (38400 baud).
;*		Add resident Help Text Viewer.
;*		Remove Peripheral Handler Loading Facility.
;*		MIKE BARALL		07/16/84
;*
;*		Revision 5, Version 0 (800XL/800XLF/900XLF/900XLFK)
;*
;*		Revert to Rev. B device handlers (E:, C:, P:, S:, K:),
;*		(with bug fixes) to eliminate need for Translator.
;*		Remove parallel I/O support.
;*		Fix keyboard display in self-test.
;*		MIKE BARALL & VINCENT WU	09/04/84


;	SPACE	4,10
;***	History
;*
;*	??? Insert here a history similar to the portion in Scheiman's
;*	Usage Guidelines.
;	SPACE	4,10
;**	Program Structure
;*
;*	The sections of the OS appear in the following order with
;*	corresponding subtitles:
;*
;*	Equates and Definitions
;*
;*		System Symbol Equates
;*		System Address Equates
;*		Miscellaneous Address Equates
;*		Macro Definitions
;*
;*	Code and Data
;*
;*		First 8K ROM Identification and Checksum
;*
;*		Interrupt Handler
;*		Initialization
;*		Disk Input/Ouput
;*		Self-test, Part 1
;*		Parallel Input/Output
;*		Self-test, Part 2
;*		Help Text Viewer, Part 1
;*
;*		International Character Set
;*
;*		Self-test, Part 3
;*		Floating Point Package
;*
;*		Domestic Character Set
;*
;*		Device Handler Vector Tables
;*		Jump Vectors
;*		Generic Parallel Device Handler Vector Table
;*		Additional Jump Vectors
;*
;*		$E4C0 Patch
;*		Central Input/Output
;*		Help Text Viewer, Part 2
;*		$E912 Patch
;*		$E959 Patch
;*		Serial Input/Output
;*		Keyboard, Editor and Screen Handler, Part 1
;*		Peripheral Handler Entry Routine
;*		$EF6B Patch
;*		Keyboard, Editor and Screen Handler, Part 2
;*		$F223 Patch
;*		Keyboard, Editor and Screen Handler, Part 3
;*		$FCD8 Patch
;*		Cassette Handler
;*		Printer Handler
;*		Self-test, Part 4
;*
;*		Second 8K ROM Identification and Checksum
;*		6502 Machine Vectors
;	SUBTTL	'System Symbol Equates'
;	SPACE	4,10
;**	Assembly Option Equates


FALSE	EQU	0
TRUE	EQU	not FALSE

.define	VGC	TRUE	;virtual game controllers
.define	RAMSYS	FALSE	;not RAM based system
.define	LNBUG	FALSE	;no LNBUG interface
;	SPACE	4,10
;**	Identification Equates


IDREV	EQU	$04	;identification revision number
IDDAY	EQU	$06	;identification day
IDMON	EQU	$09	;identification month
IDYEAR	EQU	$84	;identification year
IDCPU	EQU	$02	;identification CPU series
IDPN1	EQU	'C'	;identification part number field 1
IDPN2	EQU	'C'	;identification part number field 2
IDPN3	EQU	$00	;identification part number field 3
IDPN4	EQU	$00	;identification part number field 4
IDPN5	EQU	$01	;identification part number field 5
;	SPACE	4,10
;**	Configuration Equates


MAXDEV	EQU	33	;offset to last possible entry of HATABS
IOCBSZ	EQU	16	;length of IOCB

SEIOCB	EQU	0*IOCBSZ	;screen editor IOCB index
MAXIOC	EQU	8*IOCBSZ	;first invalid IOCB index

DSCTSZ	EQU	128	;disk sector size

LEDGE	EQU	2	;left edge
REDGE	EQU	39	;right edge

INIML	EQU	$0700	;initial MEMLO

ICSORG	EQU	$CC00	;international character set origin
DCSORG	EQU	$E000	;domestic character set origin

PRNORG	EQU	$EE78	;printer handler origin
CASORG	EQU	$EF41	;cassette handler origin
KBDORG	EQU	$F3E4	;keyboard/screen/display handler origin
;	SPACE	4,10
;**	IOCB Command Code Equates


OPEN	EQU	$03	;open
GETREC	EQU	$05	;get record
GETCHR	EQU	$07	;get character(s)
PUTREC	EQU	$09	;put record
PUTCHR	EQU	$0B	;put character(s)
CLOSE	EQU	$0C	;close
STATIS	EQU	$0D	;status
SPECIL	EQU	$0E	;special
;	SPACE	4,10
;**	Special Entry Command Equates


;	Screen Commands

DRAWLN	EQU	$11	;draw line
FILLIN	EQU	$12	;draw line with right fill
;	SPACE	4,10
;**	ICAX1 Auxiliary Byte 1 Equates


APPEND	EQU	$01	;open write append (D:) or screen read (E:)
DIRECT	EQU	$02	;open for directory access (D:)
OPNIN	EQU	$04	;open for input (all devices)
OPNOT	EQU	$08	;open for output (all devices)
MXDMOD	EQU	$10	;open for mixed mode (E:, S:)
INSCLR	EQU	$20	;open for input without clearing screen (E:, S:)
;	SPACE	4,10
;**	Device Code Equates


CASSET	EQU	'C'	;cassette
DISK	EQU	'D'	;disk
SCREDT	EQU	'E'	;screen editor
KBD	EQU	'K'	;keyboard
PRINTR	EQU	'P'	;printer
DISPLY	EQU	'S'	;screen display
;	SPACE	4,10
;**	Character and Key Code Equates


CLS	EQU	$7D	;clear screen
EOL	EQU	$9B	;end of line (RETURN)

HELP	EQU	$11	;key code for HELP
CNTLF1	EQU	$83	;key code for CTRL-F1
CNTLF2	EQU	$84	;key code for CTRL-F2
CNTLF3	EQU	$93	;key code for CTRL-F3
CNTLF4	EQU	$94	;key code for CTRL-F4
CNTL1	EQU	$9F	;key code for CTRL-1
;	SPACE	4,10
;**	Status Code Equates


SUCCES	EQU	1	;successful operation

BRKABT	EQU	128	;BREAK key abort
PRVOPN	EQU	129	;IOCB already open error
NONDEV	EQU	130	;nonexistent device error
WRONLY	EQU	131	;IOCB opened for write only error
NVALID	EQU	132	;invalid command error
NOTOPN	EQU	133	;device/file not open error
BADIOC	EQU	134	;invalid IOCB index error
RDONLY	EQU	135	;IOCB opened for read only error
EOFERR	EQU	136	;end of file error
TRNRCD	EQU	137	;truncated record error
TIMOUT	EQU	138	;peripheral device timeout error
DNACK	EQU	139	;device does not acknowledge command error
FRMERR	EQU	140	;serial bus framing error
CRSROR	EQU	141	;cursor overrange error
OVRRUN	EQU	142	;serial bus data overrun error
CHKERR	EQU	143	;serial bus checksum error
DERROR	EQU	144	;device done (operation incomplete) error
BADMOD	EQU	145	;bad screen mode number error
FNCNOT	EQU	146	;function not implemented in handler error
SCRMEM	EQU	147	;insufficient memory for screen mode error
BADHFT	EQU	148	;incorrect help text file type code
HELPKD	EQU	149	;help key pressed

;**	DCB Device Bus ID Equates


DISKID	EQU	$31	;disk bus ID
PDEVN	EQU	$40	;printer bus ID
CASET	EQU	$60	;cassette bus ID
;	SPACE	4,10
;**	Bus Command Equates


FOMAT	EQU	'!'	;format command
PUTSEC	EQU	'P'	;put sector command
READ	EQU	'R'	;read command
STATC	EQU	'S'	;status command
WRITE	EQU	'W'	;write command
;	SPACE	4,10
;**	Command Auxiliary Byte Equates


DOUBLE	EQU	'D'	;print 20 characters double width
NORMAL	EQU	'N'	;print 40 characters normally
PLOT	EQU	'P'	;plot
SIDWAY	EQU	'S'	;print 16 characters sideways
;	SPACE	4,10
;**	Bus Response Equates


ACK	EQU	'A'	;device acknowledged
COMPLT	EQU	'C'	;device successfully completed operation
ERROR	EQU	'E'	;device incurred error in attempted operation
HSACK	EQU	'H'	;device acks and requests 38400 baud
NACK	EQU	'N'	;device did not understand
;	SPACE	4,10
;**	Floating Point Package Miscellaneous Equates


FPREC	EQU	6	;precision

FMPREC	EQU	FPREC-1	;length of mantissa
;	SPACE	4,10
;**	Cassette Record Type Equates


HDR	EQU	$FB	;header
DTA	EQU	$FC	;data record
DT1	EQU	$FA	;last data record
EOT	EQU	$FE	;end of tape (file)

TONE1	EQU	2	;record
TONE2	EQU	1	;playback
;	SPACE	4,10
;**	Cassette Timing Equates


WLEADN	EQU	1152	;NTSC 19.2 second WRITE file leader
RLEADN	EQU	576	;NTSC 9.6 second READ file leader
WIRGLN	EQU	180	;NTSC 3.0 second WRITE IRG
RIRGLN	EQU	120	;NTSC 2.0 second READ IRG
WSIRGN	EQU	15	;NTSC 0.25 second WRITE short IRG
RSIRGN	EQU	10	;NTSC 0.16 second READ short IRG
BEEPNN	EQU	30	;NTSC 0.5 second beep duration
BEEPFN	EQU	10	;NTSC 0.16 second beep separation

WLEADP	EQU	960	;PAL 19.2 second WRITE file leader
RLEADP	EQU	480	;PAL 9.6 second READ file leader
WIRGLP	EQU	150	;PAL 3.0 second WRITE IRG
RIRGLP	EQU	100	;PAL 2.0 second READ IRG
WSIRGP	EQU	13	;PAL 0.25 second WRITE short IRG
RSIRGP	EQU	8	;PAL 0.16 second READ short IRG
BEEPNP	EQU	25	;PAL 0.5 second beep duration
BEEPFP	EQU	8	;PAL 0.16 second beep separation

WIRGHI	EQU	0	;high WRITE IRG
RIRGHI	EQU	0	;high READ IRG
;	SPACE	4,10
;**	Power-up Validation Byte Value Equates


PUPVL1	EQU	$5C	;power-up validation value 1
PUPVL2	EQU	$93	;power-up validation value 2
PUPVL3	EQU	$25	;power-up validation value 3
;	SPACE	4,10
;**	Miscellaneous Equates


IOCFRE	EQU	$FF	;IOCB free indicator

B38400	EQU	$0010	;38400 baud POKEY counter value
B19200	EQU	$0028	;19200 baud POKEY counter value
B00600	EQU	$05CC	;600 baud POKEY counter value

HITONE	EQU	$05	;FSK high freq. POKEY counter value (5326 Hz)
LOTONE	EQU	$07	;FSK low freq. POKEY counter value (3995 Hz)

NCOMLO	EQU	$34	;PIA lower NOT COMMAND line command
NCOMHI	EQU	$3C	;PIA raise NOT COMMAND line command

MOTRGO	EQU	$34	;PIA cassette motor ON command
MOTRST	EQU	$3C	;PIA cassette motor OFF command

NODAT	EQU	$00	;SIO immediate operation
GETDAT	EQU	$40	;SIO read data frame
PUTDAT	EQU	$80	;SIO write data frame

CRETRI	EQU	13	;number of command frame retries
DRETRI	EQU	1	;number of device retries
CTIM	EQU	2	;command frame ACK timeout

NBUFSZ	EQU	40	;print normal buffer size
DBUFSZ	EQU	20	;print double buffer size
SBUFSZ	EQU	29	;print sideways buffer size

SPACE	EQU	$20	;ASCII space
WRITEC	EQU	$57	;DCB write command
N	EQU	$4E	;ASCII 'N'
D	EQU	$44	;ASCII 'D'
S	EQU	$53	;ASCII 'S'
CR	EQU	EOL	;Carriage return
;	SUBTTL	'System Address Equates'
;	SPACE	4,10
;**	Page Zero Address Equates


LNFLG	EQU	$0000	;1-byte LNBUG flag (0 = not LNBUG)
NGFLAG	EQU	$0001	;1-byte memory status (0 = failure)

;	Not Cleared

CASINI	EQU	$0002	;2-byte cassette program initialization address
RAMLO	EQU	$0004	;2-byte RAM address for memory test
TRAMSZ	EQU	$0006	;1-byte RAM size temporary
CMCMD	EQU	$0007	;1-byte command communications

;	Cleared upon Coldstart Only

WARMST	EQU	$0008	;1-byte warmstart flag (0 = coldstart)
BOOTq	EQU	$0009	;1-byte successful boot flags
DOSVEC	EQU	$000A	;2-byte disk program start vector
DOSINI	EQU	$000C	;2-byte disk program initialization address
APPMHI	EQU	$000E	;2-byte applications memory high limit

;	Cleared upon Coldstart or Warmstart

INTZBS	EQU	$0010	;first page zero location to clear

POKMSK	EQU	$0010	;1-byte IRQEN shadow
BRKKEY	EQU	$0011	;1-byte BREAK key flag (0 = no BREAK)
RTCLOK	EQU	$0012	;3-byte real time clock (16 millisecond units)
BUFADR	EQU	$0015	;2-byte disk interface buffer address
ICCOMT	EQU	$0017	;1-byte CIO command table index
DSKFMS	EQU	$0018	;2-byte DOS File Management System pointer
DSKUTL	EQU	$001A	;2-byte DOS utility pointer
PTIMOT	EQU	$001C	;1-byte printer timeout
PBPNT	EQU	$001D	;1-byte printer buffer pointer
PBUFSZ	EQU	$001E	;1-byte printer buffer size
PTEMP	EQU	$001F	;1-byte printer temporary

ZIOCB	EQU	$0020	;address of page zero IOCB
IOCBAS	EQU	$0020	;16-byte page zero IOCB
ICHIDZ	EQU	$0020	;1-byte handler ID ($FF = IOCB free)
ICDNOZ	EQU	$0021	;1-byte device number
ICCOMZ	EQU	$0022	;1-byte command code
ICSTAZ	EQU	$0023	;1-byte status of last action
ICBALZ	EQU	$0024	;1-byte low buffer address
ICBAHZ	EQU	$0025	;1-byte high buffer address
ICPTLZ	EQU	$0026	;1-byte low PUT-BYTE routine address-1
ICPTHZ	EQU	$0027	;1-byte high PUT-BYTE routine address-1
ICBLLZ	EQU	$0028	;1-byte low buffer length
ICBLHZ	EQU	$0029	;1-byte high buffer length
ICAX1Z	EQU	$002A	;1-byte first auxiliary information
ICAX2Z	EQU	$002B	;1-byte second auxiliary information
ICSPRZ	EQU	$002C	;4-byte spares

ENTVEC	EQU	$002C	;2-byte (not used)
ICIDNO	EQU	$002E	;1-byte IOCB index (IOCB number times IOCBSZ)
CIOCHR	EQU	$002F	;1-byte character for current CIO operation

STATUS	EQU	$0030	;1-byte SIO operation status
CHKSUM	EQU	$0031	;1-byte checksum (single byte sum with carry)
BUFRLO	EQU	$0032	;1-byte low data buffer address
BUFRHI	EQU	$0033	;1-byte high data buffer address
BFENLO	EQU	$0034	;1-byte low data buffer end address
BFENHI	EQU	$0035	;1-byte high data buffer end address
CRETRY	EQU	$0036	;1-byte number of command frame retries
DRETRY	EQU	$0037	;1-byte number of device retries
BUFRFL	EQU	$0038	;1-byte data buffer full flag (0 = not full)
RECVDN	EQU	$0039	;1-byte receive-frame done flag (0 = not done)
XMTDON	EQU	$003A	;1-byte transmit-frame done flag (0 = not done)
CHKSNT	EQU	$003B	;1-byte checksum sent flag (0 = not sent)
NOCKSM	EQU	$003C	;1-byte no checksum follows data flag (0 = does)
BPTR	EQU	$003D	;1-byte cassette buffer pointer
FTYPE	EQU	$003E	;1-byte cassette IRG type (neg. = continuous)
FEOF	EQU	$003F	;1-byte cassette EOF flag (0 = no EOF)
FREQ	EQU	$0040	;1-byte cassette beep counter
SOUNDR	EQU	$0041	;1-byte noisy I/O flag (0 = quiet)

CRITIC	EQU	$0042	;1-byte critical section flag (0 = not critical)

FMSZPG	EQU	$0043	;7-byte reserved for DOS File Management System

CKEY	EQU	$004A	;1-byte cassette boot request flag (0 = not)
CASSBT	EQU	$004B	;1-byte cassette boot flag (0 = not)
DSTAT	EQU	$004C	;1-byte display status
ATRACT	EQU	$004D	;1-byte attract-mode timer and flag
DRKMSK	EQU	$004E	;1-byte attract-mode dark (luminance) mask
COLRSH	EQU	$004F	;1-byte attract-mode color shift
TMPCHR	EQU	$0050	;1-byte	temporary character
HOLD1	EQU	$0051	;1-byte	temporary
LMARGN	EQU	$0052	;1-byte text column left margin
RMARGN	EQU	$0053	;1-byte text column right margin
ROWCRS	EQU	$0054	;1-byte cursor row
COLCRS	EQU	$0055	;2-byte cursor column
DINDEX	EQU	$0057	;1-byte display mode
SAVMSC	EQU	$0058	;2-byte saved memory scan counter
OLDROW	EQU	$005A	;1-byte prior row
OLDCOL	EQU	$005B	;2-byte prior column
OLDCHR	EQU	$005D	;1-byte saved character under cursor
OLDADR	EQU	$005E	;2-byte saved cursor memory address
NEWROW	EQU	$0060	;1-byte draw destination row
NEWCOL	EQU	$0061	;2-byte draw destination column
LOGCOL	EQU	$0063	;1-byte logical line cursor column
ADRESS	EQU	$0064	;2-byte temporary address

MLTTMP	EQU	$0066	;1-byte temporary
OPNTMP	EQU	$0066	;1-byte open temporary
TOADR	EQU	$0066	;2-byte destination address

SAVADR	EQU	$0068	;2-byte saved address
FRMADR	EQU	$0068	;2-byte source address

RAMTOP	EQU	$006A	;1-byte RAM size
BUFCNT	EQU	$006B	;1-byte buffer count (logical line size)
BUFSTR	EQU	$006C	;2-byte buffer start pointer
BITMSK	EQU	$006E	;1-byte bit mask for bit map operation
SHFAMT	EQU	$006F	;1-byte shift amount for pixel justification
ROWAC	EQU	$0070	;2-byte draw working row
COLAC	EQU	$0072	;2-byte draw working column
ENDPT	EQU	$0074	;2-byte end point
DELTAR	EQU	$0076	;1-byte row difference
DELTAC	EQU	$0077	;2-byte column difference
ROWINC	EQU	$0079	;1-byte draw row increment
COLINC	EQU	$007A	;1-byte draw column increment
SWPFLG	EQU	$007B	;1-byte split screen swap flag (0 = not swapped)
HOLDCH	EQU	$007C	;1-byte temporary character
INSDAT	EQU	$007D	;1-byte temporary
COUNTR	EQU	$007E	;2-byte draw iteration count

;	Reserved for Application and Floating Point Package

;	EQU	$0080	;128 bytes reserved for application and FPP
;	SPACE	4,10
;**	Floating Point Package Page Zero Address Equates


FR0	EQU	$00D4	;6-byte register 0
FR0M	EQU	$00D5	;5-byte register 0 mantissa
QTEMP	EQU	$00D9	;1-byte temporary

FRE	EQU	$00DA	;6-byte (internal) register E

FR1	EQU	$00E0	;6-byte register 1
FR1M	EQU	$00E1	;5-byte register 1 mantissa

FR2	EQU	$00E6	;6-byte (internal) register 2

FRX	EQU	$00EC	;1-byte temporary

EEXP	EQU	$00ED	;1-byte value of exponent

FRSIGN	EQU	$00EE	;1-byte floating point sign
NSIGN	EQU	$00EE	;1-byte sign of number

PLYCNT	EQU	$00EF	;1-byte polynomial degree
ESIGN	EQU	$00EF	;1-byte sign of exponent

SGNFLG	EQU	$00F0	;1-byte sign flag
FCHFLG	EQU	$00F0	;1-byte first character flag

XFMFLG	EQU	$00F1	;1-byte transform flag
DIGRT	EQU	$00F1	;1-byte number of digits after decimal point

CIX	EQU	$00F2	;1-byte current input index
INBUFF	EQU	$00F3	;2-byte line input buffer

ZTEMP1	EQU	$00F5	;2-byte temporary
ZTEMP4	EQU	$00F7	;2-byte temporary
ZTEMP3	EQU	$00F9	;2-byte temporary

FLPTR	EQU	$00FC	;2-byte floating point number pointer
FPTR2	EQU	$00FE	;2-byte floating point number pointer
;	SPACE	4,10
;**	Page One (Stack) Address Equates


;	EQU	$0100	;256-byte stack
;	SPACE	4,10
;**	Page Two Address Equates


INTABS	EQU	$0200	;42-byte interrupt handler table

VDSLST	EQU	$0200	;2-byte display list NMI vector
VPRCED	EQU	$0202	;2-byte serial I/O proceed line IRQ vector
VINTER	EQU	$0204	;2-byte serial I/O interrupt line IRQ vector
VBREAK	EQU	$0206	;2-byte BRK instruction IRQ vector
VKEYBD	EQU	$0208	;2-byte keyboard IRQ vector
VSERIN	EQU	$020A	;2-byte serial input ready IRQ vector
VSEROR	EQU	$020C	;2-byte serial output ready IRQ vector
VSEROC	EQU	$020E	;2-byte serial output complete IRQ vector
VTIMR1	EQU	$0210	;2-byte POKEY timer 1 IRQ vector
VTIMR2	EQU	$0212	;2-byte POKEY timer 2 IRQ vector
VTIMR4	EQU	$0214	;2-byte POKEY timer 4 IRQ vector
VIMIRQ	EQU	$0216	;2-byte immediate IRQ vector
CDTMV1	EQU	$0218	;2-byte countdown timer 1 value
CDTMV2	EQU	$021A	;2-byte countdown timer 2 value
CDTMV3	EQU	$021C	;2-byte countdown timer 3 value
CDTMV4	EQU	$021E	;2-byte countdown timer 4 value
CDTMV5	EQU	$0220	;2-byte countdown timer 5 value
VVBLKI	EQU	$0222	;2-byte immediate VBLANK NMI vector
VVBLKD	EQU	$0224	;2-byte deferred VBLANK NMI vector
CDTMA1	EQU	$0226	;2-byte countdown timer 1 vector
CDTMA2	EQU	$0228	;2-byte countdown timer 2 vector

CDTMF3	EQU	$022A	;1-byte countdown timer 3 flag (0 = expired)
SRTIMR	EQU	$022B	;1-byte software key repeat timer
CDTMF4	EQU	$022C	;1-byte countdown timer 4 flag (0 = expired)
INTEMP	EQU	$022D	;1-byte temporary
CDTMF5	EQU	$022E	;1-byte countdown timer 5 flag (0 = expired)
SDMCTL	EQU	$022F	;1-byte DMACTL shadow
SDLSTL	EQU	$0230	;1-byte DLISTL shadow
SDLSTH	EQU	$0231	;1-byte DLISTH shadow
SSKCTL	EQU	$0232	;1-byte SKCTL shadow
LCOUNT	EQU	$0233	;1-byte Help Viewer context entry point
LPENH	EQU	$0234	;1-byte light pen horizontal value
LPENV	EQU	$0235	;1-byte light pen vertical value
BRKKY	EQU	$0236	;2-byte BREAK key vector
;	EQU	$0238	;2-byte not used
CDEVIC	EQU	$023A	;1-byte command frame device ID
CCOMND	EQU	$023B	;1-byte command frame command
CAUX1	EQU	$023C	;1-byte command auxiliary 1
CAUX2	EQU	$023D	;1-byte command auxiliary 2

TEMP	EQU	$023E	;1-byte temporary

	ASSERT	(low TEMP)<>$FF	;may not be the last word on a page

ERRFLG	EQU	$023F	;1-byte I/O error flag (0 = no error)

	ASSERT	(low ERRFLG)<>$FF ;may not be the last word on a page

DFLAGS	EQU	$0240	;1-byte disk flags from sector 1
DBSECT	EQU	$0241	;1-byte disk boot sector count
BOOTAD	EQU	$0242	;2-byte disk boot memory address
COLDST	EQU	$0244	;1-byte coldstart flag (0 = complete)
RECLEN	EQU	$0245	;1-byte help viewer screen erased flag (0=not)
DSKTIM	EQU	$0246	;1-byte disk format timeout

LINBUF	EQU	$0247	;40-byte character line buffer

GPRIOR	EQU	$026F	;1-byte PRIOR shadow

PADDL0	EQU	$0270	;1-byte potentiometer 0
PADDL1	EQU	$0271	;1-byte potentiometer 1
PADDL2	EQU	$0272	;1-byte potentiometer 2
PADDL3	EQU	$0273	;1-byte potentiometer 3
PADDL4	EQU	$0274	;1-byte potentiometer 4
PADDL5	EQU	$0275	;1-byte potentiometer 5
PADDL6	EQU	$0276	;1-byte potentiometer 6
PADDL7	EQU	$0277	;1-byte potentiometer 7

STICK0	EQU	$0278	;1-byte joystick 0
STICK1	EQU	$0279	;1-byte joystick 1
STICK2	EQU	$027A	;1-byte joystick 2
STICK3	EQU	$027B	;1-byte joystick 3

PTRIG0	EQU	$027C	;1-byte paddle trigger 0
PTRIG1	EQU	$027D	;1-byte paddle trigger 1
PTRIG2	EQU	$027E	;1-byte paddle trigger 2
PTRIG3	EQU	$027F	;1-byte paddle trigger 3
PTRIG4	EQU	$0280	;1-byte paddle trigger 4
PTRIG5	EQU	$0281	;1-byte paddle trigger 5
PTRIG6	EQU	$0282	;1-byte paddle trigger 6
PTRIG7	EQU	$0283	;1-byte paddle trigger 7

STRIG0	EQU	$0284	;1-byte joystick trigger 0
STRIG1	EQU	$0285	;1-byte joystick trigger 1
STRIG2	EQU	$0286	;1-byte joystick trigger 2
STRIG3	EQU	$0287	;1-byte joystick trigger 3

CSTAT	EQU	$0288	;1-byte casette status
WMODE	EQU	$0289	;1-byte cassette WRITE mode ($80 = writing)
BLIM	EQU	$028A	;1-byte cassette buffer limit
IMASK	EQU	$028B	;1-byte (not used)
JVECK	EQU	$028C	;2-byte jump vector or temporary
NEWADR	EQU	$028E	;2-byte not used
TXTROW	EQU	$0290	;1-byte split screen text cursor row
TXTCOL	EQU	$0291	;2-byte split screen text cursor column
TINDEX	EQU	$0293	;1-byte split scree text mode
TXTMSC	EQU	$0294	;2-byte split screen memory scan counter
TXTOLD	EQU	$0296	;6-byte OLDROW, OLDCOL, OLDCHR, OLDADR for text
TMPX1	EQU	$029C	;1-byte temporary
HOLD3	EQU	$029D	;1-byte temporary
SUBTMP	EQU	$029E	;1-byte temporary
HOLD2	EQU	$029F	;1-byte (not used)
DMASK	EQU	$02A0	;1-byte display (pixel location) mask
TMPLBT	EQU	$02A1	;1-byte (not used)
ESCFLG	EQU	$02A2	;1-byte escape flag ($80 = ESC detected)
TABMAP	EQU	$02A3	;15-byte (120-bit) tab stop bit map
LOGMAP	EQU	$02B2	;8-byte (32-bit) logical line bit map
INVFLG	EQU	$02B6	;1-byte inverse video flag ($80 = inverse)
FILFLG	EQU	$02B7	;1-byte right fill flag (0 = no fill)
TMPROW	EQU	$02B8	;1-byte temporary row
TMPCOL	EQU	$02B9	;2-byte temporary column
SCRFLG	EQU	$02BB	;1-byte scroll occurence flag (0 = not occurred)
HOLD4	EQU	$02BC	;1-byte temporary for line draw
HOLD5	EQU	$02BD	;1-byte temporary for line draw
SHFLOK	EQU	$02BE	;1-byte shift/control lock flags
BOTSCR	EQU	$02BF	;1-byte screen bottom (24 = normal, 4 = split)

PCOLR0	EQU	$02C0	;1-byte player-missle 0 color/luminance
PCOLR1	EQU	$02C1	;1-byte player-missle 1 color/luminance
PCOLR2	EQU	$02C2	;1-byte player-missle 2 color/luminance
PCOLR3	EQU	$02C3	;1-byte player-missle 3 color/luminance

COLOR0	EQU	$02C4	;1-byte playfield 0 color/luminance
COLOR1	EQU	$02C5	;1-byte playfield 1 color/luminance
COLOR2	EQU	$02C6	;1-byte playfield 2 color/luminance
COLOR3	EQU	$02C7	;1-byte playfield 3 color/luminance

COLOR4	EQU	$02C8	;1-byte background color/luminance

PARMBL	EQU	$02C9	;10-byte help text viewer parameter block
HFTYPE	EQU	$02C9	;2-byte file type code
HPTYPE	EQU	$02C9	;1-byte page type
HCHAR	EQU	$02C9	;1-byte character being transmitted
HNEXT	EQU	$02C9	;3-byte point data for next screen
HROW	EQU	$02CA	;1-byte row index
HCOL	EQU	$02CB	;1-byte column index
HFILL	EQU	$02CB	;1-byte file header fill
HFIRST	EQU	$02CC	;3-byte point data for first screen
HIMAGE	EQU	$02CF	;3-byte point data for saved screen image
HCOUNT	EQU	$02D2	;1-byte counter

;	EQU	$02D3	;2-byte not used

DSCTLN	EQU	$02D5	;2-byte disk sector length
RELADR	EQU	$02D7	;2-byte help text viewer filespec address
KRPDEL	EQU	$02D9	;1-byte auto-repeat delay
KEYREP	EQU	$02DA	;1-byte auto-repeat rate
NOCLIK	EQU	$02DB	;1-byte key click disable
HELPFG	EQU	$02DC	;1-byte HELP key flag (0 = no HELP)
PALNTS	EQU	$02DD	;1-byte PAL/NTSC indicator (0 = NTSC, PAL = 1)
HIBYTE	EQU	$02DE	;1-byte Help Viewer dividing line character
PUPBT1	EQU	$02DF	;1-byte power-up validation byte 1

;	EQU	$02E0	;4-byte reserved for DOS

RAMSIZ	EQU	$02E4	;1-byte high RAM size
MEMTOP	EQU	$02E5	;2-byte top of available user memory
MEMLO	EQU	$02E7	;2-byte bottom of available user memory
HNDLOD	EQU	$02E9	;1-byte OK to return help key error code flag
DVSTAT	EQU	$02EA	;4-byte device status buffer
CBAUDL	EQU	$02EE	;1-byte low cassette baud rate
CBAUDH	EQU	$02EF	;1-byte high cassette baud rate
CRSINH	EQU	$02F0	;1-byte cursor inhibit (0 = cursor on)
KEYDEL	EQU	$02F1	;1-byte key debounce delay timer
CH1	EQU	$02F2	;1-byte prior keyboard character
CHACT	EQU	$02F3	;1-byte CHACTL shadow
CHBAS	EQU	$02F4	;1-byte CHBASE shadow

;	EQU	$02F5	;5-byte not used

CHAR	EQU	$02FA	;1-byte internal character
ATACHR	EQU	$02FB	;1-byte ATASCII character or plot point
CH	EQU	$02FC	;1-byte keyboard code (buffer)
FILDAT	EQU	$02FD	;1-byte right fill data
DSPFLG	EQU	$02FE	;1-byte control character display flag (0 = no)
SSFLAG	EQU	$02FF	;1-byte start/stop flag (0 = not stopped)
;	SPACE	4,10
;**	Page Three Address Equates


DCB	EQU	$0300	;12-byte device control block
DDEVIC	EQU	$0300	;1-byte unit 1 bus ID
DUNIT	EQU	$0301	;1-byte unit number
DCOMND	EQU	$0302	;1-byte bus command
DSTATS	EQU	$0303	;1-byte command type/status return
DBUFLO	EQU	$0304	;1-byte low data buffer address
DBUFHI	EQU	$0305	;1-byte high data buffer address
DTIMLO	EQU	$0306	;1-byte timeout (seconds)
DUNUSE	EQU	$0307	;1-byte (not used)
DBYTLO	EQU	$0308	;1-byte low number of bytes to transfer
DBYTHI	EQU	$0309	;1-byte high number of bytes to transfer
DAUX1	EQU	$030A	;1-byte first command auxiliary
DAUX2	EQU	$030B	;1-byte second command auxiliary

TIMER1	EQU	$030C	;2-byte initial baud rate timer value
ADDCOR	EQU	$030E	;1-byte addition correction
CASFLG	EQU	$030F	;1-byte cassette I/O flag (0 = not cassette I/O)
TIMER2	EQU	$0310	;2-byte final baud rate timer value
TEMP1	EQU	$0312	;2-byte temporary
TEMP2	EQU	$0314	;1-byte temporary
TEMP3	EQU	$0315	;1-byte temporary
SAVIO	EQU	$0316	;1-byte saved serial data input indicator
TIMFLG	EQU	$0317	;1-byte timeout flag (0 = timeout)
STACKP	EQU	$0318	;1-byte SIO saved stack pointer
TSTAT	EQU	$0319	;1-byte temporary status

HATABS	EQU	$031A	;36-byte handler address table

PUPBT2	EQU	$033E	;1-byte power-up validation byte 2
PUPBT3	EQU	$033F	;1-byte power-up validation byte 3

IOCB	EQU	$0340	;128-byte I/O control blocks area
ICHID	EQU	$0340	;1-byte handler ID ($FF = free)
ICDNO	EQU	$0341	;1-byte device number
ICCOM	EQU	$0342	;1-byte command code
ICSTA	EQU	$0343	;1-byte status of last action
ICBAL	EQU	$0344	;1-byte low buffer address
ICBAH	EQU	$0345	;1-byte high buffer address
ICPTL	EQU	$0346	;1-byte low PUT-BYTE routine address-1
ICPTH	EQU	$0347	;1-byte high PUT-BYTE routine address-1
ICBLL	EQU	$0348	;1-byte low buffer length
ICBLH	EQU	$0349	;1-byte high buffer length
ICAX1	EQU	$034A	;1-byte first auxiliary information
ICAX2	EQU	$034B	;1-byte second auxiliary information
ICSPR	EQU	$034C	;4-byte work area

PRNBUF	EQU	$03C0	;40-byte printer buffer
;	EQU	$03E8	;3-byte not used
CARTCK	EQU	$03EB	;1-byte cartridge equivalence checksum
DERRF	EQU	$03EC	;1-byte screen OPEN error flag (0 = not)

;	Remainder of Page Three Not Cleared upon Reset

ACMVAR	EQU	$03ED	;11-byte user SYSTEM RESET routine
BASICF	EQU	$03F8	;1-byte BASIC switch flag (0 = BASIC enabled)
;	EQU	$03F9	;1-byte not used
GINTLK	EQU	$03FA	;1-byte cartridge interlock
;	EQU	$03FB	;2-byte not used
CASBUF	EQU	$03FD	;3-byte first 3 bytes of cassette buffer
;	SPACE	4,10
;**	Page Four Address Equates


;	EQU	$0400	;128-byte remainder of cassette buffer

;	Reserved for Application

USAREA	EQU	$0480	;128 bytes reserved for application
;	SPACE	4,10
;**	Page Five Address Equates


;	Reserved for Application and Floating Point Package

;	EQU	$0500	;256 bytes reserved for application and FPP
;	SPACE	4,10
;**	Floating Point Package Address Equates


LBPR1	EQU	$057E	;1-byte LBUFF preamble
LBPR2	EQU	$057F	;1-byte LBUFF preamble
LBUFF	EQU	$0580	;128-byte line buffer

PLYARG	EQU	$05E0	;6-byte floating point polynomial argument
FPSCR	EQU	$05E6	;6-byte floating point temporary
FPSCR1	EQU	$05EC	;6-byte floating point temporary
;	SPACE	4,10
;**	Page Six Address Equates


;	Reserved for Application

;	EQU	$0600	;256 bytes reserved for application
;	SPACE	4,10
;**	LNBUG Address Equates


	IF	LNBUG
LNORG	EQU	$6000	;LNBUG origin
LNIRQ	EQU	$6033	;LNBUG IRQ entry
LNNMI	EQU	$8351	;LNBUG NMI vector
	ENDIF	;LNBUG
;	SPACE	4,10
;**	Cartridge Address Equates


CARTCS	EQU	$BFFA	;2-byte cartridge coldstart address
CART	EQU	$BFFC	;1-byte cartridge present indicator
CARTFG	EQU	$BFFD	;1-byte cartridge flags
CARTAD	EQU	$BFFE	;2-byte cartridge start vector
;	SPACE	4,10
;**	CTIA/GTIA Address Equates


CTIA	EQU	$D000	;CTIA/GTIA area

;	Read/Write Addresses

CONSOL	EQU	$D01F	;console switches and speaker control

;	Read Addresses

M0PF	EQU	$D000	;missle 0 and playfield collision
M1PF	EQU	$D001	;missle 1 and playfield collision
M2PF	EQU	$D002	;missle 2 and playfield collision
M3PF	EQU	$D003	;missle 3 and playfield collision

P0PF	EQU	$D004	;player 0 and playfield collision
P1PF	EQU	$D005	;player 1 and playfield collision
P2PF	EQU	$D006	;player 2 and playfield collision
P3PF	EQU	$D007	;player 3 and playfield collision

M0PL	EQU	$D008	;missle 0 and player collision
M1PL	EQU	$D009	;missle 1 and player collision
M2PL	EQU	$D00A	;missle 2 and player collision
M3PL	EQU	$D00B	;missle 3 and player collision

P0PL	EQU	$D00C	;player 0 and player collision
P1PL	EQU	$D00D	;player 1 and player collision
P2PL	EQU	$D00E	;player 2 and player collision
P3PL	EQU	$D00F	;player 3 and player collision

TRIG0	EQU	$D010	;joystick trigger 0
TRIG1	EQU	$D011	;joystick trigger 1

TRIG2	EQU	$D012	;cartridge interlock
TRIG3	EQU	$D013	;ACMI module interlock

PAL	EQU	$D014	;PAL/NTSC indicator

;	Write Addresses

HPOSP0	EQU	$D000	;player 0 horizontal position
HPOSP1	EQU	$D001	;player 1 horizontal position
HPOSP2	EQU	$D002	;player 2 horizontal position
HPOSP3	EQU	$D003	;player 3 horizontal position

HPOSM0	EQU	$D004	;missle 0 horizontal position
HPOSM1	EQU	$D005	;missle 1 horizontal position
HPOSM2	EQU	$D006	;missle 2 horizontal position
HPOSM3	EQU	$D007	;missle 3 horizontal position

SIZEP0	EQU	$D008	;player 0 size
SIZEP1	EQU	$D009	;player 1 size
SIZEP2	EQU	$D00A	;player 2 size
SIZEP3	EQU	$D00B	;player 3 size

SIZEM	EQU	$D00C	;missle sizes

GRAFP0	EQU	$D00D	;player 0 graphics
GRAFP1	EQU	$D00E	;player 1 graphics
GRAFP2	EQU	$D00F	;player 2 graphics
GRAFP3	EQU	$D010	;player 3 graphics

GRAFM	EQU	$D011	;missle graphics

COLPM0	EQU	$D012	;player-missle 0 color/luminance
COLPM1	EQU	$D013	;player-missle 1 color/luminance
COLPM2	EQU	$D014	;player-missle 2 color/luminance
COLPM3	EQU	$D015	;player-missle 3 color/luminance

COLPF0	EQU	$D016	;playfield 0 color/luminance
COLPF1	EQU	$D017	;playfield 1 color/luminance
COLPF2	EQU	$D018	;playfield 2 color/luminance
COLPF3	EQU	$D019	;playfield 3 color/luminance

COLBK	EQU	$D01A	;background color/luminance

PRIOR	EQU	$D01B	;priority select
VDELAY	EQU	$D01C	;vertical delay
GRACTL	EQU	$D01D	;graphic control
HITCLR	EQU	$D01E	;collision clear
;	SPACE	4,10
;**	POKEY Address Equates


POKEY	EQU	$D200	;POKEY area

;	Read Addresses

POT0	EQU	$D200	;potentiometer 0
POT1	EQU	$D201	;potentiometer 1
POT2	EQU	$D202	;potentiometer 2
POT3	EQU	$D203	;potentiometer 3
POT4	EQU	$D204	;potentiometer 4
POT5	EQU	$D205	;potentiometer 5
POT6	EQU	$D206	;potentiometer 6
POT7	EQU	$D207	;potentiometer 7

ALLPOT	EQU	$D208	;potentiometer port state
KBCODE	EQU	$D209	;keyboard code
RANDOM	EQU	$D20A	;random number generator
SERIN	EQU	$D20D	;serial port input
IRQST	EQU	$D20E	;IRQ interrupt status
SKSTAT	EQU	$D20F	;serial port and keyboard status

;	Write Addresses

AUDF1	EQU	$D200	;channel 1 audio frequency
AUDC1	EQU	$D201	;channel 1 audio control

AUDF2	EQU	$D202	;channel 2 audio frequency
AUDC2	EQU	$D203	;channel 2 audio control

AUDF3	EQU	$D204	;channel 3 audio frequency
AUDC3	EQU	$D205	;channel 3 audio control

AUDF4	EQU	$D206	;channel 4 audio frequency
AUDC4	EQU	$D207	;channel 4 audio control

AUDCTL	EQU	$D208	;audio control
STIMER	EQU	$D209	;start timers
SKRES	EQU	$D20A	;reset SKSTAT status
POTGO	EQU	$D20B	;start potentiometer scan sequence
SEROUT	EQU	$D20D	;serial port output
IRQEN	EQU	$D20E	;IRQ interrupt enable
SKCTL	EQU	$D20F	;serial port and keyboard control
;	SPACE	4,10
;**	PIA Address Equates


PIA	EQU	$D300	;PIA area

;	Read/Write Addresses

PORTA	EQU	$D300	;port A direction register or jacks 0 and 1
PORTB	EQU	$D301	;port B direction register or memory control

PACTL	EQU	$D302	;port A control
PBCTL	EQU	$D303	;port B control
;	SPACE	4,10
;**	ANTIC Address Equates


ANTIC	EQU	$D400	;ANTIC area

;	Read Addresses

VCOUNT	EQU	$D40B	;vertical line counter
PENH	EQU	$D40C	;light pen horizontal position
PENV	EQU	$D40D	;light pen vertical position
NMIST	EQU	$D40F	;NMI interrupt status

;	Write Addresses

DMACTL	EQU	$D400	;DMA control
CHACTL	EQU	$D401	;character control
DLISTL	EQU	$D402	;low display list address
DLISTH	EQU	$D403	;high disply list address
HSCROL	EQU	$D404	;horizontal scroll
VSCROL	EQU	$D405	;vertical scroll
PMBASE	EQU	$D407	;player-missle base address
CHBASE	EQU	$D409	;character base address
WSYNC	EQU	$D40A	;wait for HBLANK synchronization
NMIEN	EQU	$D40E	;NMI enable
NMIRES	EQU	$D40F	;NMI interrupt status reset
;	SPACE	4,10
;**	Floating Point Package Address Equates


AFP	EQU	$D800	;convert ASCII to floating point
FASC	EQU	$D8E6	;convert floating point to ASCII
IFP	EQU	$D9AA	;convert integer to floating point
FPI	EQU	$D9D2	;convert floating point to integer
ZFR0	EQU	$DA44	;zero FR0
ZF1	EQU	$DA46	;zero floating point number
FSUB	EQU	$DA60	;subtract floating point numbers
FADD	EQU	$DA66	;add floating point numbers
FMUL	EQU	$DADB	;multiply floating point numbers
FDIV	EQU	$DB28	;divide floating point numbers
PLYEVL	EQU	$DD40	;evaluate floating point polynomial
FLD0R	EQU	$DD89	;load floating point number
FLD0P	EQU	$DD8D	;load floating point number
FLD1R	EQU	$DD98	;load floating point number
FLD1P	EQU	$DD9C	;load floating point number
FST0R	EQU	$DDA7	;store floating point number
FST0P	EQU	$DDAB	;store floating point number
FMOVE	EQU	$DDB6	;move floating point number
LOG	EQU	$DECD	;calculate floating point logarithm
LOG10	EQU	$DED1	;calculate floating point base 10 logarithm
EXP	EQU	$DDC0	;calculate floating point exponentiation
EXP10	EQU	$DDCC	;calculate floating point base 10 exponentiation
;	SPACE	4,10
;**	Device Handler Vector Table Address Equates


EDITRV	EQU	$E400	;editor handler vector table
SCRENV	EQU	$E410	;screen handler vector table
KEYBDV	EQU	$E420	;keyboard handler vector table
PRINTV	EQU	$E430	;printer handler vector table
CASETV	EQU	$E440	;cassette handler vector table
;	SPACE	4,10
;**	Jump Vector Address Equates


DINITV	EQU	$E450	;vector to initialize DIO
DSKINV	EQU	$E453	;vector to DIO
CIOV	EQU	$E456	;vector to CIO
SIOV	EQU	$E459	;vector to SIO
SETVBV	EQU	$E45C	;vector to set VBLANK parameters
SYSVBV	EQU	$E45F	;vector to process immediate VBLANK NMI
XITVBV	EQU	$E462	;vector to process deferred VBLANK NMI
SIOINV	EQU	$E465	;vector to initialize SIO
SENDEV	EQU	$E468	;vector to enable SEND
INTINV	EQU	$E46B	;vector to initialize interrupt handler
CIOINV	EQU	$E46E	;vector to initialize CIO
BLKBDV	EQU	$E471	;vector to power-up display (formerly memo pad)
WARMSV	EQU	$E474	;vector to warmstart
COLDSV	EQU	$E477	;vector to coldstart
RBLOKV	EQU	$E47A	;vector to read cassette block
CSOPIV	EQU	$E47D	;vector to open cassette for input
PUPDIV	EQU	$E480	;vector to power-up display
SLFTSV	EQU	$E483	;vector to self-test
PHENTV	EQU	$E486	;vector to enter peripheral handler in HATABS
PHUNLV	EQU	$E489	;vector to unlink peripheral handler (null)
PHINIV	EQU	$E48C	;vector to initialize peripheral handler (null)
;	SPACE	4,10
;**	Generic Parallel Device Handler Vector Table Address Equates


GPDVV	EQU	$E48F	;generic parallel device handler vector table
;	SPACE 4,10
;**	Additional Jump Vector Address Equates


HTXTVV	EQU	$E49F	;vector to enter help text viewer
;	SUBTTL	'Miscellaneous Address Equates'
;	SPACE	4,10
;**	Self-test Page Zero Address Equates


STTIME	EQU	$0080	;2-byte main screen timeout timer
STAUT	EQU	$0082	;1-byte auto-mode flag
STJMP	EQU	$0083	;3-byte ANTIC jump instruction
STSEL	EQU	$0086	;1-byte selection
STPASS	EQU	$0087	;1-byte pass
STSPP	EQU	$0088	;1-byte SELECT previously pressed flag
;	EQU	$0089	;1-byte (not used)
STKST	EQU	$008A	;1-byte keyboard self-test flag (0 = not)
STCHK	EQU	$008B	;2-byte checksum
STSMM	EQU	$008D	;1-byte screen memory mask
STSMP	EQU	$008E	;1-byte screen memory pointer
ST1K	EQU	$008F	;1-byte current 1K of memory to test
STPAG	EQU	$0090	;2-byte current page to test
STPC	EQU	$0092	;1-byte page count
STMVAL	EQU	$0093	;1-byte correct value for memory test
STSKP	EQU	$0094	;1-byte simulated keypress index
STTMP1	EQU	$0095	;2-byte temporary
STVOC	EQU	$0097	;1-byte current voice indicator
STNOT	EQU	$0098	;1-byte current note counter
STCDI	EQU	$0099	;1-byte cleft display pointer
STCDA	EQU	$009A	;1-byte cleft data pointer
STTMP2	EQU	$009B	;2-byte temporary
STTMP3	EQU	$009D	;1-byte temporary
STADR1	EQU	$009E	;2-byte temporary address
STADR2	EQU	$00A0	;2-byte temporary address
STBL	EQU	$00A2	;1-byte blink counter
STTMP4	EQU	$00A3	;1-byte temporary
STLM	EQU	$00A4	;1-byte LED mask
STTMP5	EQU	$00A5	;1-byte temporary
;	SPACE	4,10
;**	Self-test Address Equates


ST3000	EQU	$3000	;screen memory
ST3002	EQU	$3002	;cleft display
ST3004	EQU	$3004	;"VOICE #" text display
ST300B	EQU	$300B	;voice number display
ST301C	EQU	$301C	;START key display
ST301E	EQU	$301E	;SELECT key display
ST3020	EQU	$3020	;OPTION key display, first 8K ROM display
ST3021	EQU	$3021	;keyboard character display
ST3022	EQU	$3022	;keyboard text display
ST3024	EQU	$3024	;second 8K ROM display
ST3028	EQU	$3028	;"RAM" text display
ST3038	EQU	$3038	;RAM display
ST303C	EQU	$303C	;fifth note display
ST304C	EQU	$304C	;"B S" text display
ST3052	EQU	$3052	;tab key display
ST3062	EQU	$3062	;cleft display
ST306D	EQU	$306D	;return key display
ST3072	EQU	$3072	;control key display
ST3092	EQU	$3092	;"SH" text display
ST309E	EQU	$309E	;sixth note display
ST30AB	EQU	$30AB	;"SH" text display
ST30B7	EQU	$30B7	;"S P A C E   B A R" text display
ST30C1	EQU	$30C1	;cleft display
ST30C2	EQU	$30C2	;cleft display
ST30C7	EQU	$30C7	;third note display
ST30CA	EQU	$30CA	;fourth note display
ST30F8	EQU	$30F8	;third note display
ST3100	EQU	$3100	;screen memory
ST3121	EQU	$3121	;cleft display
ST3122	EQU	$3122	;cleft display
ST313C	EQU	$313C	;fifth note display
ST3150	EQU	$3150	;first line of staff display
ST3154	EQU	$3154	;first note display
ST3181	EQU	$3181	;cleft display
ST3182	EQU	$3182	;cleft display
ST3186	EQU	$3186	;second note display
ST318C	EQU	$318C	;fifth note display
ST31B0	EQU	$31B0	;second line of staff display
ST31C2	EQU	$31C2	;cleft display
ST31CA	EQU	$31CA	;fourth note display
ST31EE	EQU	$31EE	;sixth note display
ST31F1	EQU	$31F1	;cleft display
ST3210	EQU	$3210	;third line of staff display
ST321A	EQU	$321A	;fourth note display
ST3248	EQU	$3248	;third note display
ST3270	EQU	$3270	;fourth line of staff display
ST32D0	EQU	$32D0	;fifth line of staff display
;	SUBTTL	'Macro Definitions'
;	SPACE	4,10
;**	FIX - Fix Address
;*
;*	FIX sets the origin counter to the value specified as an
;*	argument.  If the current origin counter is less than the
;*	argument, FIX fills the intervening bytes with zero and
;*	issues a message to document the location and number of
;*	bytes that are zero filled.
;*
;*	ENTRY	FIX	address
;*
;*
;*	EXIT
;*		Origin counter set to specified address.
;*		Message issued if zero fill required.
;*
;*	CHANGES
;*		-none-
;*
;*	CALLS
;*		-none-
;*
;*	NOTES
;*		Due to ECHO limitiation of 255 iterations, FIX is
;*		recursive.
;*		If the current origin counter value is beyond the
;*		argument, FIX generates an error.
;*
;*	MODS
;*		R. K. Nordin	11/01/83


.macro	FIX	address
	.if	* > address
	.error	.sprintf("$%04x precedes current origin value of $%04x", address, *)
	.elseif * < address
	.out	.sprintf("$%04x free bytes from $%04x to $%04x", address-*, *, address-1)
	.res	address-*, $00
	.endif
.endmacro
;	SUBTTL	'First 8K ROM Identification and Checksum'
;	SPACE	4,10
	ORG	$C000
;	SPACE	4,10
;**	First 8K ROM Identification and Checksum


	DW	$0000				;reserved for checksum
	DB	IDDAY,IDMON,IDYEAR		;date (day, month, year)
	DB	IDCPU				;CPU series
	DB	IDPN1,IDPN2,IDPN3,IDPN4,IDPN5	;part number
	DB	IDREV				;revision number
;	SUBTTL	'Interrupt Handler'
;	SPACE	4,10
;**	IIH - Initialize Interrupt Handler
;*
;*	ENTRY	JSR	IIH
;*		TRIG2 = cartridge interlock
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IIH	=	*	;entry

	LDA	#$40
	STA	NMIEN	;disable DLI and enable VBLANK NMI

	LDA	TRIG3	;cartridge interlock
	STA	GINTLK	;cartridge interlock status

	RTS		;return
;	SPACE	4,10
;**	NMI - Process NMI
;*
;*	ENTRY	JMP	NMI
;*		??
;*
;*	EXIT
;*		Exits via appropriate vector to process NMI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


NMI	=	*	;entry

	ASSERT	$C0=high NMI	;for compatibility with LNBUG

;	Check for display list NMI.

	BIT	NMIST
	BPL	NMI1		;if not display list NMI

	JMP	(VDSLST)	;process display list NMI, return

;	Initialize.

NMI1	CLD

;	Save registers.

	PHA		;save A
	TXA
	PHA		;save X
	TYA
	PHA		;save Y

;	Reset NMI status.

	STA	NMIRES		;reset NMI status

;	Process NMI.

	IF	LNBUG
	LDA	LNFLG		;LNBUG flag
	BNE	NMI2		;if LNBUG

	JMP	(VVBLKI)	;process immediate VBLANK NMI, return

NMI2	JMP	(LNNMI)		;invoke LNBUG NMI routine, return
	ELSE	;LNBUG
	JMP	(VVBLKI)	;process immediate VBLANK NMI, return
	ENDIF	;LNBUG
;	SPACE	4,10
;**	IRQ - Process IRQ
;*
;*	ENTRY	JMP	IRQ
;*		??
;*
;*	EXIT
;*		Exits via VIMIRQ vector
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IRQ	=	*		;entry

;	Initialize.

	CLD

;	Process IRQ.

	IF	LNBUG
	BIT	LNFLG
	BMI	IRQ1		;if LNBUG on

	JMP	(VIMIRQ)	;process immediate IRQ, return

IRQ1	JMP	LNIRQ		;invoke LNBUG IRQ routine, return
	ELSE	;LNBUG
	JMP	(VIMIRQ)	;process immediate IRQ, return
	ENDIF	;LNBUG
;	SPACE	4,10
;**	IIR - Process Immediate IRQ
;*
;*	ENTRY	JMP	IIR
;*		??
;*
;*	EXIT
;*		Exits via appropriate vector to process IRQ
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Y.T. Jang    05/15/84
;*		3. Remove parallel bus & ACMI interrupt processing.
;*		   Mike Barall	09/06/84


IIR	=	*	;entry

;	Initialize.

	PHA		;save A

;	Check for serial input ready IRQ.

	LDA	IRQST	;IRQ status
	AND	#$20	;serial input ready
	BNE	IIR1	;if not serial input ready

;	Process serial input IRQ.

	LDA	#not $20	;all other interrupts
	STA	IRQEN		;enable all other interrupts
	LDA	POKMSK
	STA	IRQEN
	JMP	(VSERIN)	;process serial input ready IRQ, return
IIR1

;	Initialize further.

	TXA
	PHA		;save X

;	Check other types of IRQ.

IIR2	LDX	#TIRQL-1-1	;offset to next to last entry

IIR3	LDA	TIRQ,X		;IRQ type
	CPX	#5		;offset to serial out complete
	BNE	IIR4		;if not serial out complete

	AND	POKMSK		;and with POKEY IRQ enable
	BEQ	IIR5		;if serial out complete not enabled

IIR4	BIT	IRQST		;IRQ interrupt status
	BEQ	IIR6		;if interrupt found

IIR5	DEX
	BPL	IIR3		;if not done

;	Coninue IRQ processing.

	JMP	CIR		;continue IRQ processing, return

;	Enable other interrupts.

IIR6	EOR	#$FF		;complement mask
	STA	IRQEN		;enable all others
	LDA	POKMSK		;POKEY IRQ mask
	STA	IRQEN		;enable indicated IRQ's

;	Process IRQ.

IIR7	LDA	TOIH,X		;offset to interrupt handler
	TAX
	LDA	INTABS,X	;interrupt handler address
	STA	JVECK
	LDA	INTABS+1,X
	STA	JVECK+1
	PLA
	TAX			;restore X
	JMP	(JVECK)		;process interrupt, return
;	SPACE	4,10
;**	BIR - Process BREAK Key IRQ
;*
;*	ENTRY	JMP	BIR
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


BIR	=	*	;entry

;	Process BREAK.

	LDA	#0
	STA	BRKKEY	;clear BREAK key flag
	STA	SSFLAG	;clear start/stop flag
	STA	CRSINH	;enable cursor
	STA	ATRACT	;turn off attract-mode

;	Exit.

BIR1	PLA		;restore A
	RTI		;return
;	SPACE	4,10
;**	CIR - Continue IRQ Processing
;*
;*	ENTRY	JMP	CIR
;*		??
;*
;*	EXIT
;*		Exits via appropriate vector to process IRQ or to XIR
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


CIR	=	*		;entry

;	Initialize.

	PLA			;saved ???
	TAX

;	Check for port A interrupt.

	BIT	PACTL		;port A control
	BPL	CIR1		;if not port A interrupt

;	Process proceed line IRQ.

	LDA	PORTA		;clear interrupt status bit
	JMP	(VPRCED)	;process proceed line IRQ, return

;	Check for port B interrupt.

CIR1	BIT	PBCTL		;port B control
	BPL	CIR2		;if not port B interrupt

;	Process interrupt line IRQ.

	LDA	PORTB		;clear interrupt status bit
	JMP	(VINTER)	;process interrupt line IRQ, return

;	Check for BRK instruction IRQ.

CIR2	PLA
	STA	JVECK		;save ???

	PLA			;saved P
	PHA			;resave P
	AND	#$10		;B bit of P register
	BEQ	CIR3		;if not BRK instruction IRQ

;	Process BRK instruction IRQ.

	LDA	JVECK		;saved ???
	PHA
	JMP	(VBREAK)	;process BRK instruction IRQ, return

;	Exit IRQ processing.

CIR3	LDA	JVECK		;saved ???
	PHA
;	JMP	XIR		;exit IRQ processing, return
;	SPACE	4,10
;**	XIR - Exit IRQ Processing
;*
;*	ENTRY	JMP	XIR
;*		??
;*
;*	EXIT
;*		Exits to RIR
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


XIR	=	*	;entry
	PLA		;restore A
;	JMP	RIR	;return from interrupt
;	SPACE	4,10
;**	RIR - Return from Interrupt
;*
;*	ENTRY	JMP	RIR
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


RIR	=	*	;entry
	RTI		;return
;	SPACE	4,10
;**	TIRQ - Table of IRQ Types
;*
;*	Entry n is the interrupt indicator of priority n (0 is lowest).
;*
;*	NOTES
;*		Problem: entry 7 (serial input ready) not used.
;*
;*		Correction: entry 7 IS required! (Mike Barall 09/06/84)


TIRQ	DB	$80	;0 - BREAK key IRQ
	DB	$40	;1 - keyboard IRQ
	DB	$04	;2 - timer 4 IRQ
	DB	$02	;3 - timer 2 IRQ
	DB	$01	;4 - timer 1 IRQ
	DB	$08	;5 - serial output complete IRQ
	DB	$10	;6 - serial output ready IRQ
	DB	$20	;7 - serial input ready IRQ

TIRQL	=	*-TIRQ	;length
;	SPACE	4,10
;**	TOIH - Table of Offsets to Interrupt Handlers
;*
;*	Entry n is the offset to the interrupt handler vector
;*	corresponding to entry n of TIRQ.
;*
;*	NOTES
;*		Problem: entry 7 (serial input ready) not used.
;*
;*		Correction: entry 7 IS required! (Mike Barall 09/06/84)


TOIH	DB	BRKKY-INTABS	;0 - BREAK key IRQ
	DB	VKEYBD-INTABS	;1 - keyboard IRQ
	DB	VTIMR4-INTABS	;2 - timer 4 IRQ
	DB	VTIMR2-INTABS	;3 - timer 2 IRQ
	DB	VTIMR1-INTABS	;4 - timer 1 IRQ
	DB	VSEROC-INTABS	;5 - serial output complete IRQ
	DB	VSEROR-INTABS	;6 - serial output ready IRQ
	DB	VSERIN-INTABS	;7 - serial input ready IRQ
;	SPACE	4,10
;**	WFR - Wait for RESET
;*
;*	WFR loops forever.
;*
;*	ENTRY	JMP	WFR
;*
;*	EXIT
;*		Does not exit
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


WFR	=	*	;entry

;	Loop forever, waiting for RESET.

WFR1	JMP	WFR1	;loop
;	SPACE	4,10
;**	IVNM - Process Immediate VBLANK NMI
;*
;*	ENTRY	JSR	IVNM
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. a. Remove COLPF1 updating from immediate VBI.
;*		   b. Remove fine scrolling support.
;*		   c. Remove ACMI support.
;*		   d. Remove support for CTRL-FUNCTION keys.
;*		   Mike Barall	09/06/84


IVNM	=	*		;entry

;	Increment frame counter and attract-mode counter.

	INC	RTCLOK+2	;increment low frame counter
	BNE	IVN1		;if low counter not zero

	INC	ATRACT		;increment attract-mode counter/flag
	INC	RTCLOK+1	;increment middle frame counter
	BNE	IVN1		;if middle counter not zero

	INC	RTCLOK		;increment high frame counter

;	Set attract-mode effects.

IVN1	LDA	#$FE		;select no luminance change
	LDX	#0		;select no color shift
	LDY	ATRACT		;attract-mode timer/flag
	BPL	IVN2		;if not attract-mode

	STA	ATRACT		;ensure continued attract-mode
	LDX	RTCLOK+1	;select color shift
	LDA	#$F6		;select lower luminance

IVN2	STA	DRKMSK		;attract-mode luminance
	STX	COLRSH		;attract-mode color shift

;	Process countdown timer 1.

	LDX	#0		;indicate countdown timer 1
	JSR	DCT		;decrement countdown timer
	BNE	IVN3		;if timer not expired

	JSR	PTO		;process countdown timer 1 expiration

;	Check for critical sction.

IVN3	LDA	CRITIC
	BNE	IVN4		;if critical section

;	Check for IRQ enabled.

	TSX			;stack pointer
	LDA	$0104,X		;stacked P
	AND	#$04		;I (IRQ disable) bit
	BEQ	IVN5		;if IRQ enabled

;	Exit.

IVN4	JMP	DVNM		;process deferred VBLANK NMI, return

;	Process IRQ enabled non-critical section.

IVN5

;	Check for cartridge change.

	LDA	TRIG3		;cartridge interlock
	CMP	GINTLK		;previous cartridge interlock status
	BNE	WFR		;if cartridge change, wait for RESET

;	Set hardware registers from shadows.

	LDA	PENV
	STA	LPENV		;light pen vertical position
	LDA	PENH
	STA	LPENH		;light pen vertical position
	LDA	SDLSTH
	STA	DLISTH		;high display list address
	LDA	SDLSTL
	STA	DLISTL		;low display list address
	LDA	SDMCTL
	STA	DMACTL		;DMA control
	LDA	GPRIOR
	STA	PRIOR		;prioritty select

;	Turn off speaker.

IVN6	LDX	#$08		;speaker off
	STX	CONSOL		;set speaker control

;	Set color registers from shadows.

;	LDX	#8		;offset to background color

IVN7	CLI
	LDA	PCOLR0,X	;color register shadow
	EOR	COLRSH		;modify with attract-mode color shift
	AND	DRKMSK		;modify with attract-mode luminance
	STA	COLPM0,X	;set color register
	DEX
	BPL	IVN7		;if not done

;	Set character set control.

	LDA	CHBAS
	STA	CHBASE
	LDA	CHACT
	STA	CHACTL

;	Process countdown timer 2.

	LDX	#2		;indicate countdown timer 2
	JSR	DCT		;decrement countdown timer
	BNE	IVN8		;if timer not expired

	JSR	PTT		;process countdown timer 2 expiration

;	Process timers 3, 4 and 5.

IVN8	LDX	#2		;preset offset to timer 2

IVN9	INX
	INX			;offset to countdown timer
	LDA	CDTMV3-4,X	;countdown timer
	ORA	CDTMV3+1-4,X
	BEQ	IVN10		;if countdown timer already expired

	JSR	DCT		;decrement countdown timer
	STA	CDTMF3-4,X	;indicate timer expiration status

IVN10	CPX	#8		;offset to timer 5
	BNE	IVN9		;if all timers not done

;	Check debounce counter.

	LDA	SKSTAT		;keyboard status
	AND	#$04		;key down indicator
	BEQ	IVN11		;if key down

;	Process key up.

	LDA	KEYDEL		;key delay counter
	BEQ	IVN11		;if counted down already

	DEC	KEYDEL		;decrement key delay counter

;	Check software key repeat timer.

IVN11	LDA	SRTIMR		;key repeat timer
	BEQ	IVN13		;if key repeat timer expired

	LDA	SKSTAT		;keyboard status
	AND	#$04		;key down indicator
	BNE	IVN12		;if key no longer down

	DEC	SRTIMR		;decrement key repeat timer
	BNE	IVN13		;if key repeat timer not expired

;	Process key repeat timer expiration.

	LDA	KEYREP		;initial timer value
	STA	SRTIMR		;reset key repeat timer
	LDA	KBCODE		;key code

;	Check for hidden codes.

	CMP	#CNTL1
	BEQ	IVN13		;if CTRL-1

	AND	#$3F
	CMP	#HELP
	BEQ	IVN13		;if HELP

;	Set key code.

	LDA	KBCODE		;key code
	STA	CH		;set key code
	JMP	IVN13		;continue

;	Zero key repeat timer.

IVN12	LDA	#0
	STA	SRTIMR		;zero key repeat timer

;	Read joysticks.

IVN13	LDA	PORTA		;joystick readings
	LSR	A
	LSR	A
	LSR	A
	LSR	A		;joystick 1 reading
	STA	STICK1		;set joystick 1 reading
	IF	VGC
	STA	STICK3		;simulate joystick 3 reading
	ENDIF	;VGC
	LDA	PORTA		;joystick readings
	AND	#$0F		;joystick 0 reading
	STA	STICK0		;set joystick 0 reading
	IF	VGC
	STA	STICK2		;simulate joystick 2 reading
	ENDIF	;VGC

;	Read joystick triggers.

	LDA	TRIG0		;trigger 0 indicator
	STA	STRIG0		;set trigger 0 indicator
	IF	VGC
	STA	STRIG2		;simulate trigger 2 indicator
	ENDIF	;VGC
	LDA	TRIG1		;trigger 1 indicator
	STA	STRIG1		;set trigger 1 indicator
	IF	VGC
	STA	STRIG3		;simulate trigger 3 indicator
	ENDIF	;VGC

;	Read potentiometers.

	LDX	#3		;offset to last potentiometer

IVN14	LDA	POT0,X		;potentiometer reading
	STA	PADDL0,X	;set potentiometer reading
	IF	VGC
	STA	PADDL4,X	;simulate potentiometer reading
	ENDIF	;VGC
	DEX
	BPL	IVN14		;if not done

;	Start potentiometers for next time.

	STA	POTGO		;start potentiometers

;	Read paddle triggers.

	LDX	#2		;offset to paddle trigger reading
	LDY	#1		;offset to joystick reading

IVN15	LDA	STICK0,Y	;joystick reading
	LSR	A
	LSR	A
	LSR	A		;paddle trigger reading
	STA	PTRIG1,X	;set paddle trigger reading
	IF	VGC
	STA	PTRIG5,X	;simulate paddle trigger reading
	ENDIF	;VGC

	LDA	#0
	ROL	A		;paddle trigger reading
	STA	PTRIG0,X	;set paddle trigger reading
	IF	VGC
	STA	PTRIG4,X	;simulate paddle trigger reading
	ENDIF	;VGC
	DEX
	DEX
	DEY
	BPL	IVN15		;if not done

;	Process deferred VBLANK NMI.

	JMP	(VVBLKD)	;process deferred VBLANK NMI, return
;	SPACE	4,10
;**	PTO - Process Countdown Timer One Expiration
;*
;*	ENTRY	JSR	PTO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PTO	=	*		;entry
	JMP	(CDTMA1)	;process countdown timer 1 expiration
;	SPACE	4,10
;**	PTT - Process Countdown Timer Two Expiration
;*
;*	ENTRY	JSR	PTT
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PTT	=	*		;entry
	JMP	(CDTMA2)	;process countdown timer 2 expiration
;	SPACE	4,10
;**	DCT - Decrement Countdown Timer
;*
;*	ENTRY	JSR	DCT
;*		X = offset to timer value
;*
;*	EXIT
;*		A = 0, if timer expired
;*		  = $FF, if timer did not expire
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DCT	=	*		;entry
	LDY	CDTMV1,X	;low timer value
	BNE	DCT1		;if low timer value not zero

	LDY	CDTMV1+1,X	;high timer value
	BEQ	DCT2		;if timer value zero, exit

	DEC	CDTMV1+1,X	;decrement high timer value

DCT1	DEC	CDTMV1,X	;decrement low timer value
	BNE	DCT2		;if low timer value not zero

	LDY	CDTMV1+1,X	;high timer value
	BNE	DCT2		;if high timer value not zero

	LDA	#0		;indicate timer expired
	RTS			;return

DCT2	LDA	#$FF		;indicate timer did not expire
	RTS			;return
;	SPACE	4,10
;**	SVP - Set Vertical Blank Parameters
;*
;*	SVP sets countdown timers and VBLANK vectors.
;*
;*	ENTRY	JSR	SVP
;*		X = high initial timer value or high vector address
;*		Y = low initial timer value or low vector address
;*		A = 1, if timer 1 value
;*		    2, if timer 2 value
;*		    3, if timer 3 value
;*		    4, if timer 4 value
;*		    5, if timer 5 value
;*		    6, if immediate VBLANK vector
;*		    7, if deferred VBLANK vector
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SVP	=	*		;entry

;	Initialize.

	ASL	A		;compute offset+2 to value or vector
	STA	INTEMP		;offset+2 to value or vector
	TXA			;high timer value or high vector address

;	Ensure no VBLANK in progress by delaying after HBLANK.

	LDX	#5		;20 CPU cycles
	STA	WSYNC		;wait for HBLANK synchronization

SVP1	DEX
	BNE	SVP1		;if not done delaying

;	Set timer value or vector address.

	LDX	INTEMP		;offset+2 to value or vector
	STA	CDTMV1-2+1,X	;high timer value or high vector address
	TYA
	STA	CDTMV1-2,X	;low timer value or low vector address
	RTS			;return
;	SPACE	4,10
;**	DVNM - Process Deferred VBLANK NMI
;*
;*	ENTRY	???JSR	DVNM
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DVNM	=	*	;entry
	PLA
	TAY		;restore Y
	PLA
	TAX		;restore X
	PLA		;restore A
	RTI		;return
;	SUBTTL	'Initialization'
;	SPACE	4,10
;**	PWS - Perform Warmstart
;*
;*	ENTRY	JMP	PWS
;*		??
;*
;*	EXIT
;*		Exits to PCS or PRS
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Initialize PDVS to zero.
;*		   Y. T. JANG & V. WU	02/22/84
;*		3. Move PDVS initialization to IHW.
;*		   Mike Barall	06/08/84


PWS	=	*	;entry

;	Initialize.

	SEI

;	Check for cartridge change.

	LDA	TRIG3	;cartridge interlock
	CMP	GINTLK	;previous cartridge interlock status
	BNE	PCS	;if cartridge changed, perform coldstart

;	Check for cartridge.

	ROR	A
	BCC	PWS1	;if no cartridge

;	Verify no change in cartridge.

	JSR	CCE	;check cartridge equivalence
	BNE	PCS	;if different cartridge, coldstart

;	Check coldstart status.

PWS1	LDA	COLDST	;coldstart status
	BNE	PCS	;if coldstart was in progress, perform coldstart

;	Perform warmstart.

	LDA	#$FF	;indicate warmstart
	BNE	PRS	;preset memory, return
;	SPACE	4,10
;**	RES - Process RESET
;*
;*	ENTRY	JMP	RES
;*		??
;*
;*	EXIT
;*		Exits to PCS, if coldstart, or PWS, if warmstart
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


RES	=	*	;entry

;	Initialize.

	SEI

;	Delay 0.1 second for RESET bounce.

	LDX	#140	;0.1 second delay

RES1	DEY
	BNE	RES1	;if inner loop not done

	DEX
	BNE	RES1	;if outer loop not done

;	Check power-up validation bytes.

	LDA	PUPBT1
	CMP	#PUPVL1
	BNE	PCS	;if validation byte 1 differs, coldstart

	LDA	PUPBT2
	CMP	#PUPVL2
	BNE	PCS	;if validation byte 2 differs, coldstart

	LDA	PUPBT3
	CMP	#PUPVL3
	BEQ	PWS	;if all bytes validated, perform warmstart

;	JMP	PCS	;perform coldstart, return
;	SPACE	4,10
;**	PCS - Perform Coldstart
;*
;*	ENTRY	JMP	PCS
;*		??
;*
;*	EXIT
;*		Exits to PRS
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PCS	=	*	;entry
	LDA	#0	;indicate coldstart
;	JMP	PRS	;preset memory, return
;	SPACE	4,10
;**	PRS - Preset Memory
;*
;*	ENTRY	JMP	PRS
;*		??
;*
;*	EXIT
;*		Exits to EMS, if memory bad
;*		Exits via CARTCS vector or DOSVEC vector
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Remove ACMI support.
;*		   Mike Barall 09/06/84


PRS	=	*		;entry

;	Update warmstart flag.

	STA	WARMST		;update warmstart flag

;	Set initial conditions.

	SEI
	CLD
	LDX	#$FF	
	TXS			;set stack pointer

;	Initialize LNBUG flag, if necessary.

	IF	LNBUG
	LDY	#0		;assume no LNBUG
	LDA	LNORG		;first byte of LNBUG
	CMP	#$4C		;JMP instruction
	BNE	PRS2		;if JMP not present, indicate no LNBUG

	INC	LNORG		;try to increment test byte
	CMP	LNORG		;original contents of test byte
	BEQ	PRS1		;if no change, LNBUG present

	DEC	LNORG		;restore test byte
	BNE	PRS2		;indicate no LNBUG

PRS1	DEY			;LNBUG present indicator

PRS2	STY	LNFLG		;LNBUG flag
	ENDIF	;LNBUG

;	Perform miscellaneous initialization.

	JSR	PMI		;perform miscellaneous initialization

;	Initialize memory status.

	LDA	#1		;no failure indicator
	STA	NGFLAG		;memory status flag

;	Check type.

	LDA	WARMST		;warmstart flag
	BNE	PRS8		;if warmstart

;	Zero all RAM (except beginning of page zero).

	LDA	#0
	LDY	#WARMST		;initial offset into page zero
	STA	RAMLO
	STA	RAMLO+1		;initialize RAM pointer

PRS3	LDA	#$FF
	STA	(RAMLO),Y	;attempt to store $FF
	CMP	(RAMLO),Y
	BEQ	PRS4		;if $FF stored successfully

	LSR	NGFLAG		;indicate memory failure

PRS4	LDA	#$00
	STA	(RAMLO),Y	;attempt to store $00
	CMP	(RAMLO),Y
	BEQ	PRS5		;if $00 stored successfully

	LSR	NGFLAG		;indicate memory failure

PRS5	INY
	BNE	PRS3		;if not end of page

;	Advance to next page and check for completion.

	INC	RAMLO+1		;advance RAM pointer to next page
	LDX	RAMLO+1
	CPX	TRAMSZ		;RAM size
	BNE	PRS3		;if not at end of RAM

;	Initialize RESET vector

	LDA	#$60		;$60 is the opcode for RTS
	STA	ACMVAR

;	Initialize DOSVEC.

	LDA	#low PPD	;power-up display routine address
	STA	DOSVEC		;initialize DOS vector
	LDA	#high PPD
	STA	DOSVEC+1

;	Verify ROM checksums.

	LDA	PORTB
	AND	#$7F		;select self-test ROM
	STA	PORTB		;port B memory control

	JSR	VFR		;verify first 8K ROM
	BCS	PRS6		;if first 8K ROM bad

	JSR	VSR		;verify second 8K ROM
	BCC	PRS7		;if seond 8K ROM good

PRS6	LSR	NGFLAG		;indicate memory bad

PRS7	LDA	PORTB
	ORA	#$80		;disable self-test ROM
	STA	PORTB		;update port B memory control

;	Indicate coldstart in progress.

	LDA	#$FF
	STA	COLDST		;indicate coldstart in progress
	BNE	PRS12		;continue with coldstart procedures

;	Perform warmstart procedures.

PRS8	LDX	#0

	LDA	DERRF		;screen OPEN error flag
	BEQ	PRS9		;if in screen OPEN

;	Clean up APPMHI.

	STX	APPMHI
	STX	APPMHI+1
	TXA

;	Clear page 2 and part of page 3.

PRS9	STA	$0200,X		;clear byte of page 2

	CPX	#low ACMVAR	;start of page 3 locations not to clear
	BCS	PRS10		;if not to clear this page 3 location

	STA	$0300,X		;clear byte of page 3

PRS10	DEX
	BNE	PRS9		;if not done

;	Clear part of page 0.

	LDX	#INTZBS		;offset to first page 0 byte to clear

PRS11	STA	$0000,X		;clear byte of page 0
	INX
	BPL	PRS11		;if not done

;	Record BASIC status.

PRS12	LDX	#0		;initially assume BASIC enabled
	LDA	PORTB		;port B memory control
	AND	#$02		;BASIC enabled indicator
	BEQ	PRS13		;if BASIC enabled

	INX			;indicate BASIC disabled

PRS13	STX	BASICF		;BASIC flag

;	Establish power-up validation bytes.

	LDA	#PUPVL1
	STA	PUPBT1		;validation byte 1
	LDA	#PUPVL2
	STA	PUPBT2		;validation byte 2
	LDA	#PUPVL3
	STA	PUPBT3		;validation byte 3

;	Establish screen margins.

	LDA	#LEDGE
	STA	LMARGN		;left margin
	LDA	#REDGE
	STA	RMARGN		;right margin

;	Establish parameters for NTSC or PAL.

	LDA	PAL		;GTIA flag bits
	AND	#$0E		;PAL/NTSC indicator
	BNE	PRS14		;if NTSC

	LDA	#5		;PAL key repeat delay
	LDX	#1		;PAL indicator
	LDY	#40		;PAL key repeat initial delay
	BNE	PRS15		;set parameters

PRS14	LDA	#6		;NTSC key repeat delay
	LDX	#0		;NTSC indicator
	LDY	#48		;NTSC key repeat initial delay

PRS15	STA	KEYREP		;set key repeat rate
	STX	PALNTS		;set PAL/NTSC status
	STY	KRPDEL		;set key repeat initial delay

;	Initialize missing controller ports, if not simulated.

	IF	not VGC
	LDA	#$0F		;joystick centered
	STA	STICK2
	STA	STICK3
	LDA	#$01		;trigger not pressed
	STA	STRIG2
	STA	STRIG3

	LDX	#3		;offset to last controller

PRS16	LDA	#$E4		;paddle fully counter-clockwise
	STA	PADDL4,X
	LDA	#$01		;trigger not pressed
	STA	PTRIG4,X
	DEX
	BPL	PRS16		;if not done
	ENDIF	;VGC

;	Copy interrupt vector table from ROM to RAM.

	LDX	#TIHVL-1	;offset to last byte of table

PRS17	LDA	TIHV,X		;byte of table of interrupt vectors
	STA	INTABS,X	;byte of RAM table
	DEX
	BPL	PRS17		;if not done

;	Copy handler vector table from ROM to RAM.

	LDX	#THAVL-1	;offset to last byte of table

PRS18	LDA	THAV,X		;byte of handler vector table
	STA	HATABS,X	;byte of RAM table
	DEX
	BPL	PRS18		;if not done

;	Initialize software.

	JSR	ISW		;initialize software

;	Enable IRQ interrupts.

	CLI

;	Check for memory problems.

	LDA	NGFLAG		;memory status
	BNE	PRS21		;if memory good

;	Perform memory self-test on bad memory.

	LDA	PORTB
	AND	#$7F		;enable self-test ROM
	STA	PORTB		;update port B memory control
	LDA	#2
	STA	CHACT		;CHACTL (character control) shadow
	LDA	#high DCSORG	;high domestic character set origin
	STA	CHBAS		;CHBASE (character base) shadow
	JMP	EMS		;execute memory self-test

;	Check for cartridge.

PRS21	LDX	#0
	STX	TRAMSZ		;clear cartridge flag

	LDX	RAMSIZ		;RAM size
	CPX	#high $B000	;start of cartridge area
	BCS	PRS22		;if RAM in cartridge area

	LDX	CART
	BNE	PRS22		;if no cartridge

	INC	TRAMSZ		;set cartridge flag
	JSR	CCE		;check cartridge equivalence
	JSR	ICS		;initialize cartridge software

;	Open screen editor.

PRS22	LDA	#OPEN
	LDX	#SEIOCB		;screen editor IOCB index
	STA	ICCOM,X		;command
	LDA	#low SEDS	;screen editor device specification
	STA	ICBAL,X		;buffer address
	LDA	#high SEDS
	STA	ICBAH,X
	LDA	#OPNIN+OPNOT	;open for input/output
	STA	ICAX1,X		;auxiliary informatin 1
	JSR	CIOV		;vector to CIO
	BPL	PRS23		;if no error

;	Process error (which should never happen).

	JMP	RES		;retry power-up

;	Delay, ensuring VBLANK.

PRS23	INX
	BNE	PRS23		;if inner loop not done

	INY
	BPL	PRS23		;if outer loop not done

;	Attempt cassette boot.

	JSR	ACB		;attempt cassette boot

;	Check cartridge for disk boot.

	LDA	TRAMSZ
	BEQ	PRS24		;if no cartridge

	LDA	CARTFG		;cartridge mode flags
	ROR	A
	BCC	PRS25		;if disk boot not desired

;	Attempt disk boot.

PRS24	JSR	ADB		;attempt disk boot

;	Indicate coldstart complete.

PRS25	LDA	#0
	STA	COLDST		;indicate coldstart complete

;	Check cartridge for execution.

	LDA	TRAMSZ
	BEQ	PRS26		;if no cartridge

	LDA	CARTFG		;cartridge mode flags
	AND	#$04
	BEQ	PRS26		;if execution not desired

;	Execute cartridge.

	JMP	(CARTCS)	;execute cartridge

;	Exit to power-up display or booted program.

PRS26	JMP	(DOSVEC)	;vector to booted program
;	SPACE	4,10
;**	ICS - Initialize Cartridge Software
;*
;*	ENTRY	JSR	ICS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ICS	=	*	;entry
	JMP	(CARTAD)	;initialize cartridge software
;	SPACE	4,10
;**	THAV - Table of Handler Vectors
;*
;*	NOTES
;*		THAV is moved to RAM table HATABS.


THAV	DB	PRINTR	;printer device code
	DW	PRINTV	;printer handler vector table

	DB	CASSET	;cassette device code
	DW	CASETV	;cassette handler vector table

	DB	SCREDT	;editor device code
	DW	EDITRV	;editor handler vector table

	DB	DISPLY	;screen device code
	DW	SCRENV	;screen handler vector table

	DB	KBD	;keyboard device code
	DW	KEYBDV	;keyboard handler vector table

THAVL	=	*-THAV	;length
;	SPACE	4,10
;**	BMSG - Boot Error Message
;*
;*	NOTES
;*		Problem: should use lower case in message.


BMSG	DB	'Boot Error',EOL
;	SPACE	4,10
;**	Screen Editor Device Specification


SEDS	DB	'E:',EOL
;	SPACE	4,10
;**	TIHV - Table of Interrupt Handler Vectors
;*
;*	NOTES
;*		TIHV is moved to RAM table INTABS.


TIHV	DW	RIR	;VDSLST - display list NMI vector
	DW	XIR	;VPRCED - proceed line IRQ vector
	DW	XIR	;VINTER - interrupt line IRQ vector
	DW	XIR	;VBREAK - BRK instruction IRQ vector
	DW	KIR	;VKEYBD - keyboard IRQ vector
	DW	IRIR	;VSERIN - serial input ready IRQ vector
	DW	ORIR	;VSEROR - serial output ready IRQ vector
	DW	OCIR	;VSEROC - serial output complete IRQ vector
	DW	XIR	;VTIMR1 - POKEY timer 1 IRQ vector
	DW	XIR	;VTIMR2 - POKEY timer 2 IRQ vector
	DW	XIR	;VTIMR4 - POKEY timer 4 IRQ vector
	DW	IIR	;VIMIRQ - immediate IRQ vector
	DW	0	;CDTMV1 - countdown timer 1 vector
	DW	0	;CDTMV2 - countdown timer 2 vector
	DW	0	;CDTMV3 - countdown timer 3 vector
	DW	0	;CDTMV4 - countdown timer 4 vector
	DW	0	;CDTMV5 - countdown timer 5 vector
	DW	IVNM	;VVBLKI - immediate VBLANK NMI vector
	DW	DVNM	;VVBLKD - deferred VBLANK NMI vector

TIHVL	=	*-TIHV	;length
;	SPACE	4,10
;**	PMI - Perform Miscellaneous Initialization
;*
;*	ENTRY	JSR	PMI
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Fix initial address for RAM sizing.
;*		   R. K. Nordin	03/23/84


PMI	=	*	;entry

;	Check for cartridge special execution case.

	LDA	TRIG3
	ROR	A
	BCC	PMI1	;if cartridge not inserted

	LDA	CART
	BNE	PMI1	;if not cartridge

	LDA	CARTFG	;cartridge flags
	BPL	PMI1	;if special execution not desired

;	Execute cartridge.

	JMP	(CARTAD)	;execute cartridge

;	Initialize hardware.

PMI1	JSR	IHW	;initialize hardware

;	Disable BASIC.

	LDA	PORTB
	ORA	#$02	;disable BASIC
	STA	PORTB	;update port B memory control

;	If warmstart, check previous BASIC status.

	LDA	WARMST
	BEQ	PMI2	;if coldstart

	LDA	BASICF	;BASIC flag
	BNE	PMI4	;if BASIC not previously enabled

	BEQ	PMI3	;enable BASIC

;	Check OPTION key.

PMI2	LDA	CONSOL	;console switches
	AND	#$04	;OPTION key indicator
	BEQ	PMI4	;if OPTION key pressed, do not enable BASIC

;	Enable BASIC.

PMI3	LDA	PORTB
	AND	#$FD	;enable BASIC
	STA	PORTB	;update port B memory control

;	Determine size of RAM.

	IF	RAMSYS
PMI4	LDA	#high $4000	;16K
	STA	TRAMSZ		;set RAM size
	RTS			;return
	ELSE	;RAMSYS

PMI4	LDA	#low $4000	;initial low address
	TAY			;offset to first byte of page
	STA	TRAMSZ-1	;set initial low address

	LDA	#high $4000	;initial RAM size
	STA	TRAMSZ		;set initial RAM size (high address)

PMI5	LDA	(TRAMSZ-1),Y	;first byte of page
	EOR	#$FF		;complement
	STA	(TRAMSZ-1),Y	;attempt to store complement
	CMP	(TRAMSZ-1),Y
	BNE	PMI6		;if complement not stored

	EOR	#$FF		;original value
	STA	(TRAMSZ-1),Y	;attempt to store original value
	CMP	(TRAMSZ-1),Y
	BNE	PMI6		;if original value not stored

	INC	TRAMSZ		;increment high address
	BNE	PMI5		;continue

;	Exit.

PMI6	RTS			;return
	ENDIF	;RAMSYS
;	SPACE	4,10
;**	CCE - Check Cartridge Equivalence
;*
;*	ENTRY	JSR	CCE
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Fix initial address for equivalence checksum.
;*		   R. K. Nordin	03/23/84


CCE	=	*	;entry

;	Initialize.

	LDA	#0	;initial sum
	TAX		;offset to first byte
	CLC

;	Checksum 256 bytes of cartridge area.

CCE1	ADC	$BF00,X	;add in byte
	INX
	BNE	CCE1	;if not done

;	Exit.

	CMP	CARTCK	;previous checksum
	STA	CARTCK	;new checksum
	RTS		;return
;	SPACE	4,10
;**	IHW - Initialize Hardware
;*
;*	ENTRY	JSR	IHW
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Change initialization of PORTB.
;*		   R. K. Nordin 03/27/84
;*		3. Initialize PDVS to zero.
;*		   Mike Barall 06/08/84
;*		4. Remove PDVS initialization.
;*		   Mike Barall 09/06/84


IHW	=	*	;entry

;	Initialize CTIA, ANTIC, POKEY and PIA registers.

	LDA	#0		;initialization value
	TAX			;initial offset
	STA	PBCTL		;set for direction register first

IHW1	STA	CTIA,X		;initialize CTIA/GTIA area register
	STA	ANTIC,X		;initialize ANTIC area register
	STA	POKEY,X		;initialize POKEY area register
	CPX	#low PORTB
	BEQ	IHW2		;if port B, don't initialize

	STA	PIA,X		;initialize PIA area register

IHW2	INX
	BNE	IHW1		;if not done

;	Initialize PIA.

	LDA	#$3C
	STA	PBCTL	;precondition port B outputs
	LDA	#$CF
	STA	PORTB	;initialize port B
	LDA	#$38
	STA	PACTL	;select data direction register
	STA	PBCTL	;select data direction register
	LDA	#$00
	STA	PORTA	;all inputs
	LDA	#$FF
	STA	PORTB	;all outputs
	LDA	#$3C
	STA	PACTL	;back to port
	STA	PBCTL	;back to port
	LDA	PORTB	;clear interrupts
	LDA	PORTA	;clear interrupts

;	Initialize POKEY.

	LDA	#$22	;get POKEY out of initialize mode and set ch. 4
	STA	SKCTL	;set serial port control

	LDA	#$A0	;pure tone, no volume
	STA	AUDC3	;turn off channel 3
	STA	AUDC4	;turn off channel 4

	LDA	#$28	;clock ch. 3 with 1.79 MHz, ch. 4 with ch. 3
	STA	AUDCTL	;set audio control

	LDA	#$FF
	STA	SEROUT	;start bit only

;	If coldstart, return

	LDA	WARMST
	BNE	IHW3		;if warmstart
	RTS

;	If warmstart, exit through the RESET routine

IHW3	JMP	ACMVAR
;	SPACE	4,10
;**	ISW - Initialize Software
;*
;*	ENTRY	JSR	ISW
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Remove PBI support.
;*		   Mike Barall	09/06/84


ISW	=	*		;entry

;	Initialize BREAK key handling.

	DEC	BRKKEY		;turn off BREAK key flag

	LDA	#low BIR
	STA	BRKKY		;set BREAK key IRQ routine address
	LDA	#high BIR
	STA	BRKKY+1

;	Initialize RAMSIZ and MEMTOP.

	LDA	TRAMSZ		;determined size of RAM
	STA	RAMSIZ		;size of RAM
	STA	MEMTOP+1	;high top of memory
	LDA	#$00
	STA	MEMTOP		;low top of memory

;	Initialize MEMLO.

	LDA	#low INIML	;initial MEMLO address
	STA	MEMLO
	LDA	#high INIML
	STA	MEMLO+1

;	Initialize device handlers.

	JSR	EDITRV+12	;initialize editor handler
	JSR	SCRENV+12	;initialize screen handler
	JSR	KEYBDV+12	;initialize keyboard handler
	JSR	PRINTV+12	;initialize printer handler
	JSR	CASETV+12	;initialize cassette handler

;	Initialize various routines.

	JSR	IHV		;initialize help text viewer
	JSR	CIOINV		;initialize CIO
	JSR	SIOINV		;initialize SIO
	JSR	INTINV		;initialize interrupt handler
	JSR	DINITV		;initialize DIO

;	Set status of START key.

	LDA	CONSOL		;console switches
	AND	#$01		;START key indicator
	EOR	#$01		;START key status
	STA	CKEY		;cassette boot request flag

	RTS			;return
;	SPACE	4,10
;**	ADB - Attempt Disk Boot
;*
;*	ENTRY	JSR	ADB
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ADB	=	*	;entry

;	Check type of reset.

	LDA	WARMST
	BEQ	ADB1	;if not warmstart

;	Process warmstart.

	LDA	BOOTq	;successful boot flags
	AND	#$01	;successful disk boot indicator
	BEQ	BAI2	;if disk boot not successful, return

;	Initialize disk booted software.

	JMP	IBS	;initialize booted software

;	Process coldstart.

ADB1	LDA	#1
	STA	DUNIT	;disk unit number
	LDA	#STATC	;status
	STA	DCOMND	;command
	JSR	DSKINV	;issue command
	BMI	BAI2	;if error, return

;	Boot.

;	JMP	ABI	;attempt boot and initialize
;	SPACE	4,10
;**	ABI - Attempt Boot and Initialize
;*
;*	ENTRY	JSR	ABI
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ABI	=	*		;entry

	LDA	#high 1
	STA	DAUX2
	LDA	#low 1		;sector number
	STA	DAUX1

	LDA	#low (CASBUF+3)	;buffer address
	STA	DBUFLO
	LDA	#high (CASBUF+3)
	STA	DBUFHI

;	JMP	BAI		;boot and initialize
;	SPACE	4,10
;**	BAI - Boot and Initialize
;*
;*	ENTRY	JSR	BAI
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


BAI	=	*	;entry

;	Read first sector.

	JSR	GNS	;get next sector
	BPL	CBI	;if no error, complete boot and initialize

;	Process error.

BAI1	JSR	DBE	;display boot error message

	LDA	CASSBT
	BEQ	ABI	;if not cassette boot, try again

;	Exit.

BAI2	RTS		;return
;	SPACE	4,10
;**	CBI - Complete Boot and Initialize
;*
;*	ENTRY	JSR	CBI
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


CBI	=	*	;entry

;	Transfer flags.

	LDX	#3

CBI1	LDA	CASBUF+3,X	;byte from buffer
	STA	DFLAGS,X	;flag byte
	DEX
	BPL	CBI1		;if not done

;	Transfer sector.

	LDA	BOOTAD
	STA	RAMLO		;set boot address
	LDA	BOOTAD+1
	STA	RAMLO+1

	LDA	CASBUF+7
	STA	DOSINI		;establish initializtion address
	LDA	CASBUF+8
	STA	DOSINI+1

CBI2	LDY	#127		;offset to last byte of sector

CBI3	LDA	CASBUF+3,Y	;byte of sector buffer
	STA	(RAMLO),Y	;byte of boot program
	DEY
	BPL	CBI3		;if not done

;	Increment loader buffer pointer.

	CLC
	LDA	RAMLO
	ADC	#$80
	STA	RAMLO
	LDA	RAMLO+1
	ADC	#0
	STA	RAMLO+1		;increment boot loader buffer pointer

;	Decrement and check number of sectors.

	DEC	DBSECT		;decrement number of sectors
	BEQ	CBI5		;if no more sectors

;	Get next sector.

	INC	DAUX1	;increment sector number

CBI4	JSR	GNS	;get next sector
	BPL	CBI2	;if status OK

;	Process error.

	JSR	DBE	;display boot error message
	LDA	CASSBT
	BNE	BAI1	;if cassette, start over

	BEQ	CBI4	;try sector again

;	Clean up.

CBI5	LDA	CASSBT
	BEQ	CBI6	;if not cassette boot

	JSR	GNS	;get EOF record (but do not use it)

;	Execute boot loader.

CBI6	JSR	EBL	;execute boot loader
	BCS	BAI1	;if bad boot, try again

;	Initialize booted software.

	JSR	IBS	;initialize booted software
	INC	BOOTq	;indicate boot success
	RTS		;return
;	SPACE	4,10
;**	EBL - Execute Boot Loader
;*
;*	ENTRY	JSR	EBL
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


EBL	=	*		;entry

;	Move boot loader start address to RAMLO.

	CLC
	LDA	BOOTAD
	ADC	#6
	STA	RAMLO		;boot loader start address
	LDA	BOOTAD+1
	ADC	#0
	STA	RAMLO+1

;	Execute boot loader.

	JMP	(RAMLO)		;execute boot loader
;	SPACE	4,10
;**	IBS - Initialize Booted Software
;*
;*	ENTRY	JSR	IBS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IBS	=	*		;entry
	JMP	(DOSINI)	;initialize booted software
;	SPACE	4,10
;**	DBE - Display Boot Error Message
;*
;*	ENTRY	JSR	DBE
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: bytes wasted by LDX/TXA and LDY/TYA
;*		combinations.
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DBE	=	*		;entry

;	Set up IOCB.

	LDX	#low BMSG	;boot error message
	LDY	#high BMSG
	TXA
	LDX	#SEIOCB		;screen editor IOCB index
	STA	ICBAL,X 	;low buffer address
	TYA
	STA	ICBAH,X		;high buffer address
	LDA	#PUTREC
	STA	ICCOM,X		;command
	LDA	#$FF
	STA	ICBLL,X		;buffer length

;	Perform CIO.

	JMP	CIOV		;vector to CIO, return
;	SPACE	4,10
;**	GNS - Get Next Sector
;*
;*	ENTRY	JSR	GNS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


GNS	=	*	;entry

;	Check type of boot.

	LDA	CASSBT
	BEQ	GNS1	;if not cassette boot

;	Read block from cassette.

	JMP	RBLOKV	;vector to read cassette block routine, return

;	Read sector from disk.

GNS1	LDA	#READ
	STA	DCOMND	;command
	LDA	#1	;drive number 1
	STA	DUNIT	;set drive number
	JMP	DSKINV	;vector to DIO, return
;	SPACE	4,10
;**	ACB - Attempt Cassette Boot
;*
;*	ENTRY	JSR	ACB
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ACB	=	*	;entry

;	Check type.

	LDA	WARMST	;warmstart flag
	BEQ	ACB1	;if coldstart

;	Perform warmstart procedures.

	LDA	BOOTq	;successful boot flags
	AND	#$02	;successful cassette boot indicator
	BEQ	ACB2	;if cassette boot not successful

	JMP	ACB3	;initialize cassette

;	Perform coldstart procedures.

ACB1	LDA	CKEY	;cassette boot request flag
	BEQ	ACB2	;if cassette boot not requested, return

;	Boot cassette.

	LDA	#$80
	STA	FTYPE	;set long IRG type
	INC	CASSBT	;set cassette boot flag
	JSR	CSOPIV	;open cassette for input
	JSR	BAI	;boot and initialize
	LDA	#0
	STA	CASSBT	;clear cassette boot flag
	STA	CKEY	;clear cassette boot request flag
	ASL	BOOTq	;indicate successful cassette boot

	LDA	DOSINI
	STA	CASINI	;cassette software initialization address
	LDA	DOSINI+1
	STA	CASINI+1

;	Exit.

ACB2	RTS		;return

;	Initialize cassette booted program.

ACB3	JMP	(CASINI)	;initialize cassette booted program
;	SUBTTL	'Disk Input/Ouput'
;	SPACE	4,10
;**	IDIO - Initialize DIO
;*
;*	ENTRY	JSR	IDIO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IDIO	=	*		;entry
	LDA	#160		;160 second timeout
	STA	DSKTIM		;set initial disk timeout
	LDA	#low DSCTSZ	;disk sector size
	STA	DSCTLN
	LDA	#high DSCTSZ
	STA	DSCTLN+1
	RTS			;return
;	SPACE	4,10
;**	DIO - Disk I/O
;*
;*	ENTRY	JSR	DIO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DIO	=	*		;entry

;	Initialize.

	LDA	#DISKID		;disk bus ID
	STA	DDEVIC		;device bus ID
	LDA	DSKTIM		;timeout
	LDX	DCOMND		;command
	CPX	#FOMAT
	BEQ	DIO1		;if FORMAT command

	LDA	#7		;set timeout to 7 seconds

DIO1	STA	DTIMLO		;timeout

;	Set SIO command.

	LDX	#GETDAT		;assume GET DATA

	LDA	DCOMND		;command
	CMP	#PUTSEC
	BEQ	DIO2		;if PUT SECTOR command

	CMP	#WRITE
	BNE	DIO3		;if not WRITE command

DIO2	LDX	#PUTDAT		;select PUT DATA

;	Check command.

DIO3	CMP	#STATC
	BNE	DIO4		;if not STATUS command

;	Set up STATUS command.

	LDA	#low DVSTAT
	STA	DBUFLO		;buffer address
	LDA	#high DVSTAT
	STA	DBUFHI
	LDY	#low 4		;low byte count
	LDA	#high 4		;high byte count
	BEQ	DIO5		;perform SIO

;	Set up other commands.

DIO4	LDY	DSCTLN		;low byte count
	LDA	DSCTLN+1	;high byte count

;	Perform SIO.

DIO5	STX	DSTATS		;SIO command
	STY	DBYTLO		;low byte count
	STA	DBYTHI		;high byte count
	JSR	SIOV		;vector to SIO
	BPL	DIO6		;if no error

;	Process error.

	RTS			;return

;	Process successful operation.

DIO6	LDA	DCOMND		;command
	CMP	#STATC
	BNE	DIO7		;if not STATUS command

	JSR	SBA		;set buffer address
	LDY	#2
	LDA	(BUFADR),Y	;timeout status
	STA	DSKTIM		;disk timeout

;	Set byte count.

DIO7	LDA	DCOMND
	CMP	#FOMAT
	BNE	DIO10		;if not FORMAT command

	JSR	SBA		;set buffer address
	LDY	#$FE		;initial buffer pointer

DIO8	INY			;increment buffer pointer
	INY			;increment buffer pointer

DIO9	LDA	(BUFADR),Y	;low bad sector data
	CMP	#$FF
	BNE	DIO8		;if low not $FF

	INY
	LDA	(BUFADR),Y	;high bad sector data
	INY
	CMP	#$FF
	BNE	DIO9		;if high not $FF

	DEY
	DEY
	STY	DBYTLO		;low bad sector byte count
	LDA	#0
	STA	DBYTHI		;high bad sector byte count

;	Exit.

DIO10	LDY	DSTATS		;status
	RTS			;return
;	SPACE	4,10
;**	SBA - Set Buffer Address
;*
;*	ENTRY	JSR	SBA
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SBA	=	*		;entry
	LDA	DBUFLO
	STA	BUFADR		;buffer address
	LDA	DBUFHI
	STA	BUFADR+1
	RTS			;return
;	SUBTTL	'Self-test, Part 1'
;	SPACE	4,10
;**	SES - Select and Execute Self-test
;*
;*	SES selects the self-test ROM and executes the self-test.
;*
;*	ENTRY	JSR	SES
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: this could be contiguous with other OS ROM
;*		self-test code (near TSTO).
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SES	=	*	;entry

	LDA	#$FF
	STA	COLDST	;force coldstart on RESET

	LDA	PORTB
	AND	#$7F	;enable self-test ROM
	STA	PORTB	;update port B memory control

	JMP	SLFTSV	;vector to self-test
;	SUBTTL	'Parallel Input/Output'
;	SPACE	4,10
;**	PARALLEL DEVICE NULL ENTRY POINTS

GOP	=	*
GCL	=	*
GGB	=	*
GPB	=	*
GST	=	*
GSP	=	*

	LDY	#NONDEV		;Nonexistent device error

GIN	=	*

	RTS
;	SUBTTL	'Self-test, Part 2'
;	SPACE	4,10
;**	TSTO - Table of Self-test Text Offsets


TSTO	DB	TXT0-TTXT	;0 - offset to "MEMORY TEST   ROM" text
	DB	TXT1-TTXT	;1 - offset to "RAM" text
	DB	TXT2-TTXT	;2 - offset to "KEYBOARD TEST" text
	DB	TXT3-TTXT	;3 - offset to "S P A C E   B A R" text
	DB	TXT4-TTXT	;4 - offset to "SH" text
	DB	TXT5-TTXT	;5 - offset to "SH" text
	DB	TXT6-TTXT	;6 - offset to "B S" text
	DB	TXT7-TTXT	;7 - offset to keyboard text
	DB	TXT8-TTXT	;8 - offset to control key text
	DB	TXT9-TTXT	;9 - offset to "VOICE #" text
;	SPACE	4,10
;**	TTXT - Table of Text Sequences


TTXT	=	*
;	SPACE	4,10
;**	TXT0 - "MEMORY TEST   ROM" Text


TXT0	DB	$00,$00
	DB	$2D,$25,$2D,$2F,$32,$39	;"MEMORY"
	DB	$00
	DB	$34,$25,$33,$34		;"TEST"
	DB	$00,$00,$00
	DB	$32,$2F,$2D		;"ROM"

TXT0L	=	*-TXT0	;length
;	SPACE	4,10
;**	TXT1 - "RAM" Text


TXT1	DB	$32,$21,$2D		;"RAM"

TXT1L	=	*-TXT1	;length
;	SPACE	4,10
;**	TXT2 - "KEYBOARD TEST" Text


TXT2	DB	$00,$00
	DB	$2B,$25,$39,$22,$2F,$21,$32,$24	;"KEYBOARD"
	DB	$00
	DB	$34,$25,$33,$34			;"TEST"
	DB	$00,$00,$00
	DB	$00

TXT2L	=	*-TXT2	;length
;	SPACE	4,10
;**	TXT7 - Keyboard


TXT7	=	*

;	First Row (Function Keys)

	DB	$A8		;"H"
	DB	$00
	DB	$B2		;"R"
	DB	$00
	DB	$00		;" "
	DB	$00
	DB	$00		;" "
	DB	$00
	DB	$00		;" "
	DB	$00
	DB	$00		;" "
	DB	$00
	DB	$00		;" "
	DB	$00,$00,$00

;	Second Row ("1 2 3 4 5 6 7 8 9 0 < >")

	DB	$5B
	DB	$00
	DB	$11		;"1"
	DB	$00
	DB	$12		;"2"
	DB	$00
	DB	$13		;"3"
	DB	$00
	DB	$14		;"4"
	DB	$00
	DB	$15		;"5"
	DB	$00
	DB	$16		;"6"
	DB	$00
	DB	$17		;"7"
	DB	$00
	DB	$18		;"8"
	DB	$00
	DB	$19		;"9"
	DB	$00
	DB	$10		;"0"
	DB	$00
	DB	$1C		;"<"
	DB	$00
	DB	$1E		;">"
	DB	$00
	DB	$FE		;left triangle
	DB	$00
	DB	$A2		;"B"
	DB	$00,$00,$00

;	Third Row ("Q W E R T Y U I O P - =")

	DB	$FF
	DB	$FF
	DB	$00
	DB	$31		;"Q"
	DB	$00
	DB	$37		;"W"
	DB	$00
	DB	$25		;"E"
	DB	$00
	DB	$32		;"R"
	DB	$00
	DB	$34		;"T"
	DB	$00
	DB	$39		;"Y"
	DB	$00
	DB	$35		;"U"
	DB	$00
	DB	$29		;"I"
	DB	$00
	DB	$2F		;"O"
	DB	$00
	DB	$30		;"P"
	DB	$00
	DB	$0D		;"-"
	DB	$00
	DB	$1D		;"="
	DB	$00
	DB	$B2		;"R"
	DB	$B4		;"T"
	DB	$00,$00,$00

;	Fourth Row ("A S D F G H J K L ; + *")

	DB	$80
	DB	$DC
	DB	$80
	DB	$00
	DB	$21		;"A"
	DB	$00
	DB	$33		;"S"
	DB	$00
	DB	$24		;"D"
	DB	$00
	DB	$26		;"F"
	DB	$00
	DB	$27		;"G"
	DB	$00
	DB	$28		;"H"
	DB	$00
	DB	$2A		;"J"
	DB	$00
	DB	$2B		;"K"
	DB	$00
	DB	$2C		;"L"
	DB	$00
	DB	$1B		;";"
	DB	$00
	DB	$0B		;"+"
	DB	$00
	DB	$0A		;"*"
	DB	$00
	DB	$A3		;"C"
	DB	$00,$00,$00

;	Fifth Row ("Z X C V B N M , . /")

	DB	$80
	DB	$B3		;"S"
	DB	$A8		;"H"
	DB	$80
	DB	$00
	DB	$3A		;"Z"
	DB	$00
	DB	$38		;"X"
	DB	$00
	DB	$23		;"C"
	DB	$00
	DB	$36		;"V"
	DB	$00
	DB	$22		;"B"
	DB	$00
	DB	$2E		;"N"
	DB	$00
	DB	$2D		;"M"
	DB	$00
	DB	$0C		;","
	DB	$00
	DB	$0E		;"."
	DB	$00
	DB	$0F		;"/"
	DB	$00
	DB	$B3		;"S"
	DB	$A8		;"H"
	DB	$00
	DB	$A1		;"A"
	DB	$00,$00,$00

;	Sixth Row (Space Bar)

	DB	$00,$00,$00,$00,$00
	DB	$80
	DB	$B3		;"S"
	DB	$80
	DB	$B0		;"P"
	DB	$80
	DB	$A1		;"A"
	DB	$80
	DB	$A3		;"C"
	DB	$80
	DB	$A5		;"E"
	DB	$80
	DB	$80
	DB	$80
	DB	$A2		;"B"
	DB	$80
	DB	$A1		;"A"
	DB	$80
	DB	$B2		;"R"
	DB	$80

TXT7L	=	*-TXT7	;length
;	SPACE	4,10
;**	TXT3 - "S P A C E   B A R" Text


TXT3	DB	$00
	DB	$33		;"S"
	DB	$00
	DB	$30		;"P"
	DB	$00
	DB	$21		;"A"
	DB	$00
	DB	$23		;"C"
	DB	$00
	DB	$25		;"E"
	DB	$00
	DB	$00
	DB	$00
	DB	$22		;"B"
	DB	$00
	DB	$21		;"A"
	DB	$00
	DB	$32		;"R"
	DB	$00

TXT3L	=	*-TXT3	;length
;	SPACE	4,10
;**	TXT4 - "SH" Text


TXT4	DB	$00
	DB	$33,$28		;"SH"
	DB	$00

TXT4L	=	*-TXT4	;length
;	SPACE	4,10
;**	TXT5 - "SH" Text


TXT5	DB	$33,$28		;"SH"

TXT5L	=	*-TXT5	;length
;	SPACE	4,10
;**	TXT6 - "B S" Text


TXT6	DB	$7E	;left triangle

TXT6L	=	*-TXT6	;length
;	SPACE	4,10
;**	TXT8 - Control Key


TXT8	DB	$00
	DB	$5C
	DB	$00

TXT8L	=	*-TXT8	;length
;	SPACE	4,10
;**	TXT9 - "VOICE #" Text


TXT9	DB	$36,$2F,$29,$23,$25	;"VOICE"
	DB	$00
	DB	$03			;"#"

TXT9L	=	*-TXT9	;length
;	SUBTTL	'Help Text Viewer, Part 1'
;	SPACE	4,10
;**	HTV - Help Text Viewer
;*
;*	Saves the screen image to the disk, implements a menu-driven
;*	disk-based help system, and then restores the screen image.
;*
;*	This routine will be called if the user presses HELP while
;*	the "E:" device is waiting for input in graphics mode 0.
;*
;*	This routine is vectored at HTXTVV for use by applications.
;*
;*	Input Parameters:
;*	SAVMSC = Start address of screen RAM
;*	RELADR = Address of help text filespec
;*	LMARGN,RMARGN = Screen margins
;*	RECLEN<>0 if screen save & restore is desired
;*	LCOUNT = Context entry point
;*	HIBYTE = Character to use for dividing line (display code)
;*
;*	Output Parameters:
;*	Y-register = I/O error code
;*	RECLEN Bit 7 = 1 if screen erased and not restored
;*
;*	ENTRY	JSR	HTV
;*
;*	MODS
;*		Original Author Mike Barall 07/13/84


HTV	=	*

;	Indicate screen not erased

	LDA	POKMSK
	ASL	A		;carry = break key enable status
	LDA	RECLEN
	BEQ	HTV7		;if screen save not desired
	LDA	#$20
HTV7	ROL	A		;shift in break enable status
	STA	RECLEN

;	Find a free IOCB

	LDX	#0
HTV4	LDA	IOCB,X
	CMP	#IOCFRE
	BEQ	HTV2		;if IOCB is free
	TXA
	CLC
	ADC	#IOCBSZ		;next IOCB
	TAX
	CPX	#MAXIOC
	BNE	HTV4		;if more IOCB's to check

	LDY	#PRVOPN		;error code for IOCB open
HTV1	RTS

;	Open the help text disk file

HTV2	JSR	HDB		;disable break key
	LDA	#$FF
	STA	CH		;show no keypress

	STX	ICIDNO		;save IOCB
	LDA	RELADR
	STA	ICBAL,X
	LDA	RELADR+1
	STA	ICBAH,X		;store filespec address into IOCB
	LDA	#OPNIN+OPNOT
	STA	ICAX1,X
	LDA	#0
	STA	ICAX2,X
	LDA	#OPEN
	JSR	HCC		;do the open

;	Read 10-byte file header

	LDA	#10		;number of bytes to read
	JSR	HRD		;do the read

;	Check the 2-byte file type code

	LDY	#BADHFT		;error code for incorrect file type
	LDA	#$FD
	CMP	HFTYPE
	BNE	HTV36		;if incorrect file type code
	CMP	HFTYPE+1
	BNE	HTV36		;if incorrect file type code
	BIT	RECLEN
	BVC	HTV37		;if screen save not desired
	LDA	HFILL
	BNE	HTV37		;if screen swap area available
HTV36	JMP	HAB		;file type incorrect, so abort

;	Locate context entry point

HTV37	LDY	#2
HTV38	LDA	HFIRST,Y
	STA	HNEXT,Y
	DEY
	BPL	HTV38
	LDA	LCOUNT		;desired entry point
	BEQ	HTV41		;if desired entry is first screen
	LDX	HCOUNT		;get number of entry points
	STA	HCOUNT		;init counter
	CPX	HCOUNT
	BCC	HTV41		;if desired entry is out of range

HTV40	LDA	#3		;number of bytes to read
	JSR	HRD		;do read command
	DEC	HCOUNT
	BNE	HTV40		;if more data to read

HTV41	BIT	RECLEN
	BVC	HTV8		;if screen save not desired

;	Point to screen image

	LDY	#HIMAGE-PARMBL	;index for point data to screen image
	JSR	HPT		;do point command

;	Save the screen

	LDA	#PUTCHR		;put command
	JSR	HTI		;transmit screen image

;	Indicate screen erased

HTV8	LDA	RECLEN
	ORA	#$80
	STA	RECLEN

;	Display first screen

HTV3	LDA	#HNEXT-PARMBL	;index to next screen point data

;	Clear the screen

HTV5	PHA
	LDA	HIBYTE		;dividing line character
	JSR	HCS
	PLA

;	Point to screen to be displayed

	TAY
	JSR	HPT

;	Display the screen

	JSR	SMS		;set ADRESS to address of screen RAM
	LDA	#21
	STA	HROW		;init line counter

HTV9	LDA	LMARGN
	STA	HCOL		;init cursor to left margin

HTV10	JSR	HRO		;read a byte
	LDA	HCHAR		;load the byte into A
	CMP	#$C0
	BEQ	HTV11		;if 'escape'
	CMP	#$C1
	BNE	HTV12		;if not 'carriage return'

	LDA	HROW
	BMI	HTV9		;if past last line
	DEC	HROW		;count the row
	JSR	HAF		;add 40 to ADRESS
	JMP	HTV9		;next line

HTV12	SEC
	SBC	#$C2
	BEQ	HTV13		;if 'page feed'

	CMP	#$1E
	BCS	HTV14		;if a normal character

	CLC			;else, must be 'multiple space'
	ADC	HCOL
	CMP	RMARGN
	BCC	HTV15		;if not past right margin
	LDA	RMARGN		;position at right margin
HTV15	STA	HCOL
	JMP	HTV16

HTV11	JSR	HRO		;read a byte

HTV14	LDA	HROW
	BMI	HTV10		;if past last line
	LDY	HCOL
	CPY	RMARGN
	BEQ	HTV17		;if at right margin
	BCS	HTV10		;if past right margin
HTV17	LDA	HCHAR
	STA	(ADRESS),Y	;place character into screen RAM
HTV16	INC	HCOL		;move to next column
	JMP	HTV10

;	Read page type

HTV13	JSR	HRO

;	Display prompt

	JSR	SMS		;put addr of first line into ADRESS
	LDX	#23		;row where prompt goes
HTV22	JSR	HAF		;advance pointer to next line
	DEX
	BNE	HTV22

HTV21	LDX	#HMMMSG-HMESAG	;init index for main menu message
	LDA	HPTYPE		;get page type
	BMI	HTV18		;if main menu
	LDX	#HSMMSG-HMESAG	;init index for secondary menu message
	CMP	#2
	BCS	HTV18		;if a menu
	LDX	#HTSMSG-HMESAG	;init index for text screen message
	CMP	#1
	BEQ	HTV18		;if a continuing text screen
	LDX	#HCSMSG-HMESAG	;init index for concluding screen mesg.
HTV18	AND	#$7F		;mask main menu flag
	STA	HPTYPE

	LDY	LMARGN
HTV19	CPY	RMARGN
	BEQ	HTV23
	BCS	HTV20		;if past right margin
HTV23	LDA	HMESAG,X	;get a byte of message
	BMI	HTV20		;if done with message
	STA	(ADRESS),Y	;put it into screen RAM
	INY
	INX
	BNE	HTV19		;unconditional

;	Get response from user

HTV20	SEI
	LDA	POKMSK
	ORA	#$80		;enable break key
	STA	POKMSK
	STA	IRQEN
	CLI

HTV42	LDA	BRKKEY
	BEQ	HTV24		;if break, exit
	LDA	CH
	CMP	#$FF
	BEQ	HTV42		;if no keypress, keep waiting

	PHA
	LDA	#$FF
	STA	CH		;clear character buffer
	JSR	HDB		;disable break key
	LDX	NOCLIK
	BNE	HTV25		;if no keyclick desired
	JSR	CLICK		;sound key click

HTV25	PLA
	AND	#$3F		;mask shift and control
	TAX
	LDA	ATASCI,X	;convert to ATASCII
	CMP	#$1B
	BNE	HTV26
	LDA	#HFIRST-PARMBL	;index to first screen point data
	JMP	HTV5		;if escape, go to first screen

HTV26	CMP	#$9B
	BNE	HTV27
	LDX	#0
	BEQ	HTV28		;if return, go to previous menu

HTV27	LDX	HPTYPE
	CPX	#2
	BCS	HTV29		;if a menu
	CMP	#$20
	BNE	HTV20		;if not space
	BEQ	HTV28		;unconditional

HTV29	SEC
	SBC	#'a'
	BCC	HTV20		;if not a letter
	CMP	#26
	BCS	HTV20		;if not a letter
	CMP	HPTYPE
	BCS	HTV20		;if out of range
	TAX
	INX

HTV28	STX	HCOUNT		;index into point data list
HTV30	LDA	#3		;number of bytes to read
	JSR	HRD		;do read operation
	DEC	HCOUNT
	BPL	HTV30		;if more data to read

	JMP	HTV3		;display the next screen

;	Restore saved screen image

HTV24	JSR	HDB		;disable break key
	LDA	#0		;display code blank
	JSR	HCS		;clear screen
	BIT	RECLEN
	BVC	HTV31		;if screen save & restore disabled
	LDY	#HIMAGE-PARMBL
	JSR	HPT		;point to saved screen image
	LDA	#GETCHR		;get characters command
	JSR	HTI		;transmit screen image
	LDA	RECLEN
	AND	#$7F
	STA	RECLEN		;indicate screen restored

;	Close the IOCB and return

HTV31	LDA	#CLOSE
	JSR	HCC		;do CIO command
	JMP	HRB		;restore break key status, return
;	SPACE	4,10
;**	HCS - Help Viewer Clear Screen
;*
;*	Input Parameter:
;*	Accumulator = dividing line character
;*
;*	ENTRY	JSR	HCS
;*
;*	MODS
;*		Original Author Mike Barall 07/17/84


HCS	=	*
	PHA
	JSR	SMS		;set ADRESS to first line of screen
	LDX	#23		;row counter
	BNE	HCS2		;unconditional
HCS5	JSR	HAF		;add 40 to ADRESS
HCS2	LDA	#0
	CPX	#1
	BNE	HCS3		;if not dividing row
	PLA			;dividing line character
HCS3	LDY	#39		;last column
HCS4	STA	(ADRESS),Y
	DEY
	BPL	HCS4		;if not done with all columns
	DEX
	BPL	HCS5		;if not done with all rows
	RTS
;	SPACE	4,10
;**	SMS - Set Memory Scan Counter Address
;*
;*	ENTRY	JSR	SMS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SMS	=	*		;entry
	LDA	SAVMSC		;saved low memory scan counter
	STA	ADRESS		;set low address
	LDA	SAVMSC+1	;saved high memory scan counter
	STA	ADRESS+1	;set high address
	RTS			;return
;	SUBTTL	'International Character Set'
;	SPACE	4,10
	FIX	ICSORG
;	SPACE	4,10
;**	International Character Set


	DB	$00,$00,$00,$00,$00,$00,$00,$00	;$00 - space
	DB	$00,$18,$18,$18,$18,$00,$18,$00	;$01 - !
	DB	$00,$66,$66,$66,$00,$00,$00,$00	;$02 - "
	DB	$00,$66,$FF,$66,$66,$FF,$66,$00	;$03 - #
	DB	$18,$3E,$60,$3C,$06,$7C,$18,$00	;$04 - $
	DB	$00,$66,$6C,$18,$30,$66,$46,$00	;$05 - %
	DB	$1C,$36,$1C,$38,$6F,$66,$3B,$00	;$06 - &
	DB	$00,$18,$18,$18,$00,$00,$00,$00	;$07 - '
	DB	$00,$0E,$1C,$18,$18,$1C,$0E,$00	;$08 - (
	DB	$00,$70,$38,$18,$18,$38,$70,$00	;$09 - )
	DB	$00,$66,$3C,$FF,$3C,$66,$00,$00	;$0A - asterisk
	DB	$00,$18,$18,$7E,$18,$18,$00,$00	;$0B - plus
	DB	$00,$00,$00,$00,$00,$18,$18,$30	;$0C - comma
	DB	$00,$00,$00,$7E,$00,$00,$00,$00	;$0D - minus
	DB	$00,$00,$00,$00,$00,$18,$18,$00	;$0E - period
	DB	$00,$06,$0C,$18,$30,$60,$40,$00	;$0F - /

	DB	$00,$3C,$66,$6E,$76,$66,$3C,$00	;$10 - 0
	DB	$00,$18,$38,$18,$18,$18,$7E,$00	;$11 - 1
	DB	$00,$3C,$66,$0C,$18,$30,$7E,$00	;$12 - 2
	DB	$00,$7E,$0C,$18,$0C,$66,$3C,$00	;$13 - 3
	DB	$00,$0C,$1C,$3C,$6C,$7E,$0C,$00	;$14 - 4
	DB	$00,$7E,$60,$7C,$06,$66,$3C,$00	;$15 - 5
	DB	$00,$3C,$60,$7C,$66,$66,$3C,$00	;$16 - 6
	DB	$00,$7E,$06,$0C,$18,$30,$30,$00	;$17 - 7
	DB	$00,$3C,$66,$3C,$66,$66,$3C,$00	;$18 - 8
	DB	$00,$3C,$66,$3E,$06,$0C,$38,$00	;$19 - 9
	DB	$00,$00,$18,$18,$00,$18,$18,$00	;$1A - colon
	DB	$00,$00,$18,$18,$00,$18,$18,$30	;$1B - semicolon
	DB	$06,$0C,$18,$30,$18,$0C,$06,$00	;$1C - <
	DB	$00,$00,$7E,$00,$00,$7E,$00,$00	;$1D - =
	DB	$60,$30,$18,$0C,$18,$30,$60,$00	;$1E - >
	DB	$00,$3C,$66,$0C,$18,$00,$18,$00	;$1F - ?

	DB	$00,$3C,$66,$6E,$6E,$60,$3E,$00	;$20 - @
	DB	$00,$18,$3C,$66,$66,$7E,$66,$00	;$21 - A
	DB	$00,$7C,$66,$7C,$66,$66,$7C,$00	;$22 - B
	DB	$00,$3C,$66,$60,$60,$66,$3C,$00	;$23 - C
	DB	$00,$78,$6C,$66,$66,$6C,$78,$00	;$24 - D
	DB	$00,$7E,$60,$7C,$60,$60,$7E,$00	;$25 - E
	DB	$00,$7E,$60,$7C,$60,$60,$60,$00	;$26 - F
	DB	$00,$3E,$60,$60,$6E,$66,$3E,$00	;$27 - G
	DB	$00,$66,$66,$7E,$66,$66,$66,$00	;$28 - H
	DB	$00,$7E,$18,$18,$18,$18,$7E,$00	;$29 - I
	DB	$00,$06,$06,$06,$06,$66,$3C,$00	;$2A - J
	DB	$00,$66,$6C,$78,$78,$6C,$66,$00	;$2B - K
	DB	$00,$60,$60,$60,$60,$60,$7E,$00	;$2C - L
	DB	$00,$63,$77,$7F,$6B,$63,$63,$00	;$2D - M
	DB	$00,$66,$76,$7E,$7E,$6E,$66,$00	;$2E - N
	DB	$00,$3C,$66,$66,$66,$66,$3C,$00	;$2F - O

	DB	$00,$7C,$66,$66,$7C,$60,$60,$00	;$30 - P
	DB	$00,$3C,$66,$66,$66,$6C,$36,$00	;$31 - Q
	DB	$00,$7C,$66,$66,$7C,$6C,$66,$00	;$32 - R
	DB	$00,$3C,$60,$3C,$06,$06,$3C,$00	;$33 - S
	DB	$00,$7E,$18,$18,$18,$18,$18,$00	;$34 - T
	DB	$00,$66,$66,$66,$66,$66,$7E,$00	;$35 - U
	DB	$00,$66,$66,$66,$66,$3C,$18,$00	;$36 - V
	DB	$00,$63,$63,$6B,$7F,$77,$63,$00	;$37 - W
	DB	$00,$66,$66,$3C,$3C,$66,$66,$00	;$38 - X
	DB	$00,$66,$66,$3C,$18,$18,$18,$00	;$39 - Y
	DB	$00,$7E,$0C,$18,$30,$60,$7E,$00	;$3A - Z
	DB	$00,$1E,$18,$18,$18,$18,$1E,$00	;$3B - [
	DB	$00,$40,$60,$30,$18,$0C,$06,$00	;$3C - \
	DB	$00,$78,$18,$18,$18,$18,$78,$00	;$3D - ]
	DB	$00,$08,$1C,$36,$63,$00,$00,$00	;$3E - ^
	DB	$00,$00,$00,$00,$00,$00,$FF,$00	;$3F - underline

	DB	$0C,$18,$3C,$06,$3E,$66,$3E,$00	;$40 - acute accent a
	DB	$30,$18,$00,$66,$66,$66,$3E,$00	;$41 - acute accent u
	DB	$36,$6C,$00,$76,$76,$7E,$6E,$00	;$42 - tilde N
	DB	$0C,$18,$7E,$60,$7C,$60,$7E,$00	;$43 - acute accent E
	DB	$00,$00,$3C,$60,$60,$3C,$18,$30	;$44 - cedilla c
	DB	$3C,$66,$00,$3C,$66,$66,$3C,$00	;$45 - circumflex o
	DB	$30,$18,$00,$3C,$66,$66,$3C,$00	;$46 - grave accent o
	DB	$30,$18,$00,$38,$18,$18,$3C,$00	;$47 - grave accent i
	DB	$1C,$30,$30,$78,$30,$30,$7E,$00	;$48 - U.K. currency
	DB	$00,$66,$00,$38,$18,$18,$3C,$00	;$49 - diaeresis i
	DB	$00,$66,$00,$66,$66,$66,$3E,$00	;$4A - umlaut u
	DB	$36,$00,$3C,$06,$3E,$66,$3E,$00	;$4B - umlaut a
	DB	$66,$00,$3C,$66,$66,$66,$3C,$00	;$4C - umlaut O
	DB	$0C,$18,$00,$66,$66,$66,$3E,$00	;$4D - grave accent u
	DB	$0C,$18,$00,$3C,$66,$66,$3C,$00	;$4E - acute accent o
	DB	$00,$66,$00,$3C,$66,$66,$3C,$00	;$4F - umlaut o

	DB	$66,$00,$66,$66,$66,$66,$7E,$00	;$50 - umlaut U
	DB	$3C,$66,$1C,$06,$3E,$66,$3E,$00	;$51 - circumflex a
	DB	$3C,$66,$00,$66,$66,$66,$3E,$00	;$52 - circumflex u
	DB	$3C,$66,$00,$38,$18,$18,$3C,$00	;$53 - circumflex i
	DB	$0C,$18,$3C,$66,$7E,$60,$3C,$00	;$54 - acute accent e
	DB	$30,$18,$3C,$66,$7E,$60,$3C,$00	;$55 - grave accent e
	DB	$36,$6C,$00,$7C,$66,$66,$66,$00	;$56 - tilde n
	DB	$3C,$C3,$3C,$66,$7E,$60,$3C,$00	;$57 - circumflex e
	DB	$18,$00,$3C,$06,$3E,$66,$3E,$00	;$58 - ring a
	DB	$30,$18,$3C,$06,$3E,$66,$3E,$00	;$59 - grave accent a
	DB	$18,$00,$18,$3C,$66,$7E,$66,$00	;$5A - ring A
	DB	$78,$60,$78,$60,$7E,$18,$1E,$00	;$5B - display escape
	DB	$00,$18,$3C,$7E,$18,$18,$18,$00	;$5C - up arrow
	DB	$00,$18,$18,$18,$7E,$3C,$18,$00	;$5D - down arrow
	DB	$00,$18,$30,$7E,$30,$18,$00,$00	;$5E - left arrow
	DB	$00,$18,$0C,$7E,$0C,$18,$00,$00	;$5F - right arrow

	DB	$18,$00,$18,$18,$18,$18,$18,$00	;$60 - Spanish !
	DB	$00,$00,$3C,$06,$3E,$66,$3E,$00	;$61 - a
	DB	$00,$60,$60,$7C,$66,$66,$7C,$00	;$62 - b
	DB	$00,$00,$3C,$60,$60,$60,$3C,$00	;$63 - c
	DB	$00,$06,$06,$3E,$66,$66,$3E,$00	;$64 - d
	DB	$00,$00,$3C,$66,$7E,$60,$3C,$00	;$65 - e
	DB	$00,$0E,$18,$3E,$18,$18,$18,$00	;$66 - f
	DB	$00,$00,$3E,$66,$66,$3E,$06,$7C	;$67 - g
	DB	$00,$60,$60,$7C,$66,$66,$66,$00	;$68 - h
	DB	$00,$18,$00,$38,$18,$18,$3C,$00	;$69 - i
	DB	$00,$06,$00,$06,$06,$06,$06,$3C	;$6A - j
	DB	$00,$60,$60,$6C,$78,$6C,$66,$00	;$6B - k
	DB	$00,$38,$18,$18,$18,$18,$3C,$00	;$6C - l
	DB	$00,$00,$66,$7F,$7F,$6B,$63,$00	;$6D - m
	DB	$00,$00,$7C,$66,$66,$66,$66,$00	;$6E - n
	DB	$00,$00,$3C,$66,$66,$66,$3C,$00	;$6F - o

	DB	$00,$00,$7C,$66,$66,$7C,$60,$60	;$70 - p
	DB	$00,$00,$3E,$66,$66,$3E,$06,$06	;$71 - q
	DB	$00,$00,$7C,$66,$60,$60,$60,$00	;$72 - r
	DB	$00,$00,$3E,$60,$3C,$06,$7C,$00	;$73 - s
	DB	$00,$18,$7E,$18,$18,$18,$0E,$00	;$74 - t
	DB	$00,$00,$66,$66,$66,$66,$3E,$00	;$75 - u
	DB	$00,$00,$66,$66,$66,$3C,$18,$00	;$76 - v
	DB	$00,$00,$63,$6B,$7F,$3E,$36,$00	;$77 - w
	DB	$00,$00,$66,$3C,$18,$3C,$66,$00	;$78 - x
	DB	$00,$00,$66,$66,$66,$3E,$0C,$78	;$79 - y
	DB	$00,$00,$7E,$0C,$18,$30,$7E,$00	;$7A - z
	DB	$66,$66,$18,$3C,$66,$7E,$66,$00	;$7B - umlaut A
	DB	$18,$18,$18,$18,$18,$18,$18,$18	;$7C - |
	DB	$00,$7E,$78,$7C,$6E,$66,$06,$00	;$7D - display clear
	DB	$08,$18,$38,$78,$38,$18,$08,$00	;$7E - display backspace
	DB	$10,$18,$1C,$1E,$1C,$18,$10,$00	;$7F - display tab
;	SUBTTL	'Self-test, Part 3'
;	SPACE	4,10
	FIX	$D000
	LOC	$5000	;$D000 - $D7FF mapped to $5000 - $57FF
;	SPACE	4,10
;**	STH - Self-test Hardware
;*
;*	ENTRY	JSR	STH
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: this is superfluous; SLFTSV could vector to
;*		EST.
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


STH	=	*	;entry
	JMP	EST	;execute self-test
;	SPACE	4,10
;**	EMS - Execute Memory Self-test
;*
;*	ENTRY	JSR	EMS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


EMS	=	*	;entry
	JSR	IST	;initialize self-test
	JMP	STM	;self-test memory
;	SPACE	4,10
;**	EST - Execute Self-test
;*
;*	ENTRY	JSR	EST
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


EST	=	*	;entry
	JSR	IST	;initialize self-test
;	JMP	SEL	;self-test
;	SPACE	4,10
;**	SEL - Self-test
;*
;*	ENTRY	JSR	SEL
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SEL	=	*		;entry

;	Initialize.

	LDA	#0
	STA	STTIME		;clear main screen timeout timer
	STA	STTIME+1
	STA	STAUT		;clear auto-mode flag
	STA	AUDCTL		;initialize audio control register
	LDA	#$03		;initialize POKEY
	STA	SKCTL		;serial port control
	JSR	SAS		;silence all sounds
	LDA	#$40		;disable DLI
	STA	NMIEN		;NMI enable
	LDX	#0		;main screen colors
	JSR	SUC		;set up colors
	LDX	#low DISL1	;display list for main screen
	LDY	#high DISL1
	JSR	SDL		;set up display list
	LDA	#low PMD	;process main screen DLI routine
	STA	VDSLST		;display list NMI address
	LDA	#high PMD
	STA	VDSLST+1
	LDX	#3*4		;main screen bold lines
	LDA	#$AA		;color 1
	JSR	SVR		;set value in range

;	Wait for all screen DLI's to clear and for VBLANK.

	LDX	#0

SEL1	STX	WSYNC		;wait for HBLANK synchronization
	INX
	BNE	SEL1		;if not done waiting

;	Wait until beam close to top (main screen DLI near).

SEL2	LDA	VCOUNT
	CMP	#24
	BCS	SEL2		;if not done waiting

;	Preset for self-test type determination.

	LDA	#$10		;initially select memory test
	STA	STPASS		;pass indicator
	LDA	#$C0		;enable DLI
	STA	NMIEN

;	Determine type of self-test.

SEL3	LDA	CONSOL		;console switches
	AND	#$01		;START key indicator
	BNE	SEL3		;if START key not pressed

	LDA	#$FF		;clear character
	STA	CH

	LDA	STSEL		;selection
	AND	#$0F		;selection
	CMP	#$01		;memory test indicator
	BEQ	SEL5		;if memory test

	CMP	#$02
	BEQ	SEL6		;if audio-visual test

	CMP	#$04
	BEQ	SEL7		;if keyboard test

;	Self-test all.

SEL4	LDA	#$88		;indicate all tests
	STA	STSEL		;selection
	LDA	#$FF		;auto-mode indicator
	STA	STAUT		;auto-mode flag

;	Self-test memory.

SEL5	JMP	STM		;self-test memory

;	Self-test audio-visual.

SEL6	JMP	STV		;self-test audio-visual

;	Self-test keyboard.

SEL7	JMP	STK		;self-test keyboard
;	SPACE	4,10
;**	IST - Initialize Self-test
;*
;*	ENTRY	JSR	IST
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IST	=	*	;entry
	LDA	#$11	;indicate memory test
	STA	STSEL	;selection
	LDA	#$21
	STA	SDMCTL	;select small size playfield
	LDA	#$C0
	STA	NMIEN	;enable DLI
	LDA	#$41
	STA	STJMP	;ANTIC jump instruction
	LDA	#$FF	;clear code indicator
	STA	CH	;key code
	RTS		;return
;	SPACE	4,10
;**	SDL - Set Up Display List
;*
;*	ENTRY	JSR	SDL
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SDL	=	*	;entry

	STA	STKST		;keyboard self-test flag
	TYA
	PHA			;save high address
	TXA
	PHA			;save low address
	LDA	#0
	STA	SDMCTL		;DMACTL (DMA control) shadow
	STA	HELPFG		;HELP key flag
	LDA	#low POD	;process DLI routine
	STA	VDSLST
	LDA	#high POD
	STA	VDSLST+1
	LDX	#0*4		;screen memory
	TXA			;value is 0
	JSR	SVR		;set value in range
	PLA			;saved low address
	TAX
	PLA			;saved high address
	TAY
	STX	SDLSTL		;low display list address
	STX	STJMP+1		;low display list address
	STY	SDLSTH		;high display list address
	STY	STJMP+2		;high display list address
	LDA	#$21
	STA	SDMCTL
	RTS		;return
;	SPACE	4,10
;**	PMD - Process Main Screen DLI
;*
;*	1) IF MAIN SCREEN IS ON FOR MORE than FIVE MINUTES
;*	THEN 'ALL TESTS' SELECTION IS SELECTED AND EXECUTED
;*	2) COLORS FOR CURRENTLY SELECTED CHOICE AND THE
;*	NON-SELECTED CHOICES ARE DISPLAYED ON FLY
;*	3) SELECTION PROCESS IS HANDLED
;*
;*	ENTRY	JMP	PMD
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PMD	=	*	;entry

;	Initialize.

	PHA		;save A
	TXA
	PHA		;save X

;	Check for 4th time.

PMD1	LDX	#$7A	;assume non-selected color
	LDA	STPASS	;pass indicator
	CMP	#$01	;4th time indicator
	BEQ	PMD3	;if 4th time

;	Check for selection.

	AND	#$01	;selection indicatorn
	BEQ	PMD2	;if selected

;	Increment and check blink counter.

	INC	STBL	;increment blink counter
	LDA	STBL	;blink counter
	AND	#$20	;blink indicator
	BEQ	PMD2	;if not to blink

	LDX	#$2C	;use selected color

;	Set color.

PMD2	STX	WSYNC	;wait for HBLANK synchronization
	STX	COLPF0	;playfield 0 color
	CLC
	ROR	STPASS	;advance pass indicator
	LDA	#0
	STA	ATRACT

;	Exit.

	PLA
	TAX		;restore X
	PLA		;restore A
	RTI		;return

;	Check for SELECT previously pressed.

PMD3	LDA	STSPP	;SELECT previously pressed  flag
	BNE	PMD4	;if SELECT previously pressed

;	Check for SELECT pressed.

	LDA	CONSOL	;console switches
	AND	#$02	;SELECT key indicator
	BNE	PMD5	;if SELECT not pressed, exit

;	Process SELECT pressed.

	LDA	STSEL	;current selection
	ROL	A	;???
	ROL	STSEL	;next selection
	LDA	#$20	;blink indicator
	STA	STBL	;blink counter
	LDA	#$FF	;SELECT previously pressed indicator
	STA	STSPP	;SELECT previously pressed flag
	BNE	PMD5	;???

;	Process SELECT previously pressed.

PMD4	LDA	CONSOL	;console switches
	AND	#$02	;SELECT key indicator
	BEQ	PMD5	;if SELECT still pressed

	LDA	#0	;SELECT not previously pressed indicator
	STA	STSPP	;SELECT previously pressed flag

;	???every 4th time???

PMD5	LDA	STSEL	;selection
	AND	#$0F	;???
	ORA	#$10	;reset indicate memory test???
	STA	STPASS	;pass indicator

;	Advance main screen timer.

	INC	STTIME
	BNE	PMD6	;if low not zero

	INC	STTIME+1	

;	Check main screen timer.

PMD6	LDA	STTIME+1
	CMP	#250	;main screen timeout
	BNE	PMD7	;if main screen timed out

;	Process main screen timeout.

	CLI
	JMP	SEL4	;self-test all

;	Continue.

PMD7	JMP	PMD1	;continue
;	SPACE	4,10
;**	DISL1 - Display List for Main Screen


DISL1	DB	$70,$70,$70,$70,$70
	DB	$47
	DW	SMEM1
	DB	$70,$70,$70
	DB	$4E
	DW	ST3000
	DB	$70
	DB	$F0
	DB	$C6
	DW	SMEM2
	DB	$70,$86
	DB	$70,$86
	DB	$70,$06
	DB	$70,$70
	DB	$4E
	DW	ST3000
	DB	$70,$70,$70
	DB	$42
	DW	SMEM3
	DB	$41
	DW	DISL1
;	SPACE	4,10
;**	SMEM1 - "SELF TEST" Text


SMEM1	DB	$00,$00,$00,$00
	DB	$33,$25,$2C,$26		;"SELF"
	DB	$00
	DB	$34,$25,$33,$34		;"TEST"
	DB	$00,$00,$00
;	SPACE	4,10
;**	SMEM2 - "MEMORY AUDIO-VISUAL KEYBOARD ALL TESTS" Text


SMEM2	DB	$00,$00
	DB	$2D,$25,$2D,$2F,$32,$39			;"MEMORY"
	DB	$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00
	DB	$21,$35,$24,$29,$2F			;"AUDIO"
	DB	$0D					;"-"
	DB	$36,$29,$33,$35,$21,$2C			;"VISUAL"
	DB	$00,$00,$00,$00
	DB	$2B,$25,$39,$22,$2F,$21,$32,$24		;"KEYBOARD"
	DB	$00,$00,$00,$00,$00,$00,$00,$00
	DB	$21,$2C,$2C				;"ALL"
	DB	$00
	DB	$34,$25,$33,$34,$33			;"TESTS"
	DB	$00,$00,$00,$00,$00
;	SPACE	4,10
;**	SMEM3 - "SELECT,START OR RESET" Text


SMEM3	DB	$00,$00,$00,$00
	DB	$42
	DB	$B3,$A5,$AC,$A5,$A3,$B4		;"SELECT"
	DB	$56
	DB	$0C				;","
	DB	$42
	DB	$B3,$B4,$A1,$B2,$B4		;"START"
	DB	$56
	DB	$2F,$32				;"OR"
	DB	$42
	DB	$B2,$A5,$B3,$A5,$B4		;"RESET"
	DB	$56
	DB	$00,$00,$00
;	SPACE	4,10
;**	DISL2 - Display List for Memory Test


DISL2	DB	$70,$70,$70
	DB	$46
	DW	ST3000
	DB	$70
	DB	$70,$06
	DB	$70,$08
	DB	$70
	DB	$70,$06
	DB	$70,$08
	DB	$70,$08
	DB	$70,$08
	DB	$70,$08
	DB	$70,$70,$70
	DB	$01
	DW	DISL3
;	SPACE	4,10
;**	DISL3 - Display List for Exit Text


DISL3	DB	$A0,$40
	DB	$42
	DW	SMEM4
	DB	$01
	DW	STJMP
;	SPACE	4,10
;**	SMEM4 - "RESET OR HELP TO EXIT" Text


SMEM4	DB	$00,$00,$00,$00,$00
	DB	$42
	DB	$B2,$A5,$B3,$A5,$B4	;"RESET"
	DB	$56
	DB	$2F,$32			;"OR"
	DB	$42
	DB	$A8,$A5,$AC,$B0		;"HELP"
	DB	$56
	DB	$34,$2F			;"TO"
	DB	$00
	DB	$25,$38,$29,$34		;"EXIT"
	DB	$00,$00,$00,$00,$00
;	SPACE	4,10
;**	DISL4 - Display List for Keyboard Test


DISL4	DB	$70,$70,$70,$70
	DB	$46
	DW	ST3000
	DB	$70,$70,$70
	DB	$70,$02
	DB	$70
	DB	$70,$02
	DB	$70,$02
	DB	$70,$02
	DB	$70,$02
	DB	$70,$02
	DB	$70,$70
	DB	$01
	DW	DISL3
;	SPACE	4,10
;**	DISL5 - Display List for Audio-visual Test


DISL5	DB	$70,$70,$70,$70
	DB	$46
	DW	SMEM5
	DB	$70,$06
	DB	$70,$70
	DB	$4B
	DW	ST3100
	DB	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
	DB	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
	DB	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
	DB	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
	DB	$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
	DB	$0B,$0B
	DB	$70
	DB	$46
	DW	ST3000
	DB	$70
	DB	$01
	DW	DISL3
;	SPACE	4,10
;**	SMEM5 - "AUDIO-VISUAL TEST" Text


SMEM5	DB	$00,$00
	DB	$21,$35,$24,$29,$2F		;"AUDIO"
	DB	$0D				;"-"
	DB	$36,$29,$33,$35,$21,$2C		;"VISUAL"
	DB	$00,$00,$00,$00
	DB	$00,$00,$00,$00
	DB	$34,$25,$33,$34			;"TEST"
	DB	$00,$00,$00,$00,$00,$00
;	SPACE	4,10
;**	STM - Self-test Memory
;*
;*	STM verifies ROM and RAM by verifying the ROM checksums and
;*	writing and reading all possible values to each byte of RAM.
;*
;*	ENTRY	JSR	STM
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: searches beyond end of TMNT.
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


STM	=	*		;entry

;	Initialize.

	LDX	#low DISL2	;memory test display list
	LDY	#high DISL2
	LDA	#0		;indicate not keyboard self-test
	JSR	SDL		;set up display list
	LDX	#1		;memory test colors
	JSR	SUC		;set up colors
	LDX	#0		;offset to "MEMORY TEST   ROM" test
	JSR	SSM		;set screen memory
	LDX	#1		;offset to "RAM" text
	JSR	SSM		;set screen memory

;	Test first 8K ROM.

STM1	LDA	ST3020		;???
	CMP	#$AA		;color 1 for failure
	BEQ	STM4		;if first 8K ROM already failed

	LDA	#$55		;color 0 for test
	JSR	DFS		;display first ROM status
	JSR	DMW		;delay a middling while
	JSR	VFR		;verify first 8K ROM
	BCS	STM2		;if ROM failed

	LDA	#$FF		;color 2 for success
	JMP	STM3

STM2	LDA	#$AA		;color 1 for failure

STM3	JSR	DFS		;display first ROM status

;	Test second 8K ROM.

STM4	LDA	ST3024		;???
	CMP	#$AA		;color 1 for failure
	BEQ	STM7		;if second 8K ROM already failed

	LDA	#$55		;color 0 for test
	JSR	DSS		;display second ROM status
	JSR	DMW		;delay a middling while
	JSR	VSR		;verify second 8K ROM
	BCS	STM5		;if ROM failed

	LDA	#$FF		;color 2 for success
	JMP	STM6

STM5	LDA	#$AA		;color 1 for failure

STM6	JSR	DSS		;display second ROM status

;	Test RAM.

STM7	LDA	#$C0		;mask for left side of a screen byte
	STA	STSMM		;???
	LDA	#$04		;initially select LED 1 off
	STA	STLM		;LED mask
	LDA	#0
	STA	STSMP		;initialize ???
	STA	STPAG		;initialize current page
	STA	STPAG+1
	STA	ST1K		;initialize current 1K to test

;	Test 1K of RAM.

STM8	LDX	STSMP		;screen memory pointer
	LDA	ST3038,X	;???
	AND	STSMM
	CMP	#$80
	BEQ	STM17		;if already failed

	CMP	#$08
	BEQ	STM17		;if already failed

	LDA	#$44		;color 0 for test
	JSR	DRS		;display RAM block status
	LDA	STLM		;LED mask
	JSR	SLD		;set LED's
	LDA	STLM		;current LED mask
	EOR	#$0C		;complement LED's selected
	STA	STLM		;update LED mask

;	Check for memory not to test.

	LDX	#TMNTL-1+2	;2 bytes beyond last byte of table

STM9	LDA	TMNT,X		;range to test
	CMP	STPAG+1		;high current page
	BEQ	STM15		;if not to test, indicate success

	DEX
	BPL	STM9		;if not done

;	Test 1K of RAM.

	LDA	#4		;number of pages to test
	STA	STPC		;page count

;	Write initial list to page.

STM10	LDX	#0		;initial value to write

;	Write list to page.

STM11	LDY	#0		;offset to first byte of page

STM12	TXA
	STA	(STPAG),Y	;byte of page
	INX
	INY
	BNE	STM12		;if not done writing page

;	Verify list written to page.

	STX	STMVAL		;first correct value to test
	LDY	#0		;offset to first byte of page

STM13	LDA	(STPAG),Y	;byte of page
	CMP	STMVAL		;correct value
	BNE	STM14		;if not correct value

	INC	STMVAL		;increment value to test
	INY
	BNE	STM13		;if not done verifying page

;	Increment and test initial value to write.

	INX			;increment initial value to write
	BNE	STM11		;if not done, write another list

;	Decrement and test page counter.

	INC	STPAG+1		;increment high current page
	DEC	STPC		;decrement page count
	BNE	STM10		;if not done testing pages

	BEQ	STM16		;indicate success

;	Display failure.

STM14	JSR	DMW		;delay a middling while
	LDA	#$88		;color 1 for failure
	JSR	DRS		;display RAM block status
	JMP	STM17		;???

;	Delay for simulating test of memory not to test.

STM15	JSR	DLW		;delay a long while

;	Display success.

STM16	LDA	#$CC		;color 2 for success
	JSR	DRS		;display RAM block status

;	???.

STM17	LDA	STSMM		;???
	BMI	STM20		;if ???

	LDA	#$C0
	STA	STSMM		;???
	INC	STSMP		;increment screen memory pointer

;	???.

STM18	CLC
	LDA	ST1K		;current 1K to test
	ADC	#high $0400	;add 1K
	STA	STPAG+1		;high current page
	STA	ST1K		;update current 1K to test
	CMP	RAMSIZ		;RAM size
	BNE	STM8		;if not done testing RAM

;	Check for auto-mode.

	LDA	STAUT		;auto-mode flag
	BNE	STM19		;if auto-mode, perform audio-visual test

;	Test memory again.

	JMP	STM1		;test memory again

;	Process auto-mode.

STM19	LDA	#$0C	;indicate LED 1 and 2 off
	JSR	SLD	;set LED's
	JSR	DLW	;delay a long while
	JMP	STV	;self-test audio-visual

;	???.

STM20	LDA	#$0C	;???
	STA	STSMM	;???
	BNE	STM18	;???
;	SPACE	4,10
;**	DFS - Display First ROM Status
;*
;*	ENTRY	JSR	DFS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DFS	=	*		;entry
	LDX	#1*4		;first 8K ROM display
	JSR	SVR		;set value in range
	AND	#$FC		;???
	STA	ST3020+3	;???
	RTS			;return
;	SPACE	4,10
;**	DSS - Display Second ROM Status
;*
;*	ENTRY	JSR	DSS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DSS	=	*		;entry
	LDX	#2*4		;second 8K ROM display
	JSR	SVR		;set value in range
	AND	#$FC		;???
	STA	ST3024+3	;???
	RTS			;return
;	SPACE	4,10
;**	SLD - Set LED's
;*
;*	ENTRY	JSR	SLD
;*		A = LED mask (bit 3 - LED 2, bit 2 - LED 1)
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SLD	=	*		;entry
	STA	STTMP5		;save LED mask
	LDA	PORTB
	AND	#$F3		;clear LED control
	ORA	STTMP5		;set LED control according to mask
	STA	PORTB		;update port B memory control
	RTS			;return
;	SPACE	4,10
;**	DMW - Delay a Middling While
;*
;*	ENTRY	JSR	DMW
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DMW	=	*		;entry
	LDX	#60		;60-VBLANK delay
	BNE	DAW		;delay a while
;	SPACE	4,10
;**	DLW - Delay a Long While
;*
;*	ENTRY	JSR	DLW
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DLW	=	*		;entry
	LDX	#150		;150-VBLANK delay
;	JMP	DAW		;delay a while, return
;	SPACE	4,10
;**	DAW - Delay a While
;*
;*	ENTRY	JSR	DAW
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DAW	=	*		;entry

DAW1	LDY	#$FF		;initialize inner loop counter

DAW2	STY	WSYNC		;wait for HBLANK synchronization
	DEY
	BNE	DAW2		;if inner loop not done

	DEX
	BNE	DAW1		;if outer loop not done

	RTS			;return
;	SPACE	4,10
;**	DRS - Display RAM Block Status
;*
;*	ENTRY	JSR	DRS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DRS	=	*		;entry
	PHA			;save color
	LDX	STSMP		;???
	LDA	STSMM		;???
	EOR	#$FF		;complement ???
	AND	ST3038,X	;???
	STA	ST3038,X	;???
	PLA			;saved color
	AND	STSMM		;???
	ORA	ST3038,X	;???
	STA	ST3038,X	;???
	RTS			;return
;	SPACE	4,10
;**	POD - Process Other DLI's
;*
;*	POD turns the last line on the screen into white on black,
;*	handles keyboard self-test display of console switches, handles
;*	HELP key for exit, and ensures no attract-mode.
;*
;*	ENTRY	JMP	POD
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


POD	=	*	;entry

;	Initialize.

	PHA		;save A

;	Select ???.

	LDA	#$0C	;white color
	STA	COLPF1	;playfield 1 color
	LDA	COLOR4	;background color
	STA	COLPF2	;playfield 2 color

;	Ensure no attract-mode.

	LDA	#0	;no attract-mode
	STA	ATRACT	;attract-mode timer/flag

;	Check HELP key.

	LDA	HELPFG	;HELP key flag
	BEQ	POD1	;if HELP not pressed

;	Process HELP key.

	LDA	#0	;HELP key not pressed indicator
	STA	HELPFG	;HELP key flag
	LDA	#$0C	;LED's off
	JSR	SLD	;set LED's
	CLI
	JMP	SEL	;start over with main screen

;	Check for keyboard self-test.

POD1	LDA	STKST	;keyboard self-test flag
	BEQ	POD10	;if not keyboard self-test, exit

;	Set display of console switches pressed.

	LDA	CONSOL	;console switches
	AND	#$01	;START key indicator
	BEQ	POD2	;if START key pressed

	LDA	#$B3
	BNE	POD3	;set display

POD2	LDA	#$33

POD3	STA	ST301C	;set START key display

	LDA	CONSOL	;console switches
	AND	#$02	;SELECT key indicator
	BEQ	POD4	;if SELECT key pressed

	LDA	#$F3
	BNE	POD5	;set display

POD4	LDA	#$73

POD5	STA	ST301E	;set SELECT key display

	LDA	CONSOL	;console switches
	AND	#$04	;OPTION key indicator
	BEQ	POD6	;if OPTION key pressed

	LDA	#$AF
	BNE	POD7	;set display

POD6	LDA	#$2F

POD7	STA	ST3020	;set OPTION key display

;	Sound tone if console switches pressed.

	LDA	CONSOL	;console switches
	AND	#$07	;key indicators
	CMP	#$07	;no keys pressed
	BEQ	POD8	;if no keys pressed

	LDA	#100	;frequency
	STA	AUDF2	;set frequency of voice 2
	LDA	#$A8	;pure tone, half volume
	BNE	POD9	;set control of voice 2

POD8	LDA	#0	;zero volume

POD9	STA	AUDC2	;set control of voice 2

;	Exit.

POD10	PLA		;restore A
	RTI		;return
;	SPACE	4,10
;**	TMNT - Table of Memory Not to Test
;*
;*	NOTES
;*		Problem: bytes wasted by redundant entries.


TMNT	DB	high $0000	;$0000 - $03FF, zero page and stack
	DB	high $5000	;$5000 - $53FF, self-test ROM
	DB	high $5400	;$5400 - $57FF, self-test ROM
	DB	high ST3000	;ST3000 - ST3000+$03FF, screen memory
	DB	high ST3000	;ST3000 - ST3000+$03FF, screen memory
	DB	high ST3000	;ST3000 - ST3000+$03FF, screen memory

TMNTL	=	*-TMNT	;length
;	SPACE	4,10
;**	STK - Self-test Keyboard
;*
;*	STK verifies the operation of the keyboard by displaying
;*	keys as they are pressed.  In auto-mode, the verification
;*	is simulated.
;*
;*	ENTRY	JSR	STK
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: one too many bytes taken from TSKP table???
;*		Problem: wasted bytes for extra LDA CH???
;*		Problem: logic is convoluted (due to SBT and SAS
;*		subroutines appearing in the middle of STK).
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


STK	=	*		;entry

;	Initialize.

	LDX	#0
	STX	STSKP		;initialize simulated keypress index
	LDX	#3		;keyboard test colors
	JSR	SUC		;set up colors
	LDX	#low DISL4	;keyboard display list
	LDY	#high DISL4
	LDA	#$FF		;indicate keyboard self-test
	JSR	SDL		;set up display list

;	Test keyboard.

STK1	LDX	#2		;offset to "KEYBOARD TEST" text
	JSR	SSM		;set screen memory
	LDX	#7		;offset to keyboard text
	JSR	SSM		;set screen memory

;	Check auto-mode.

	LDA	STAUT		;auto-mode flag
	BEQ	STK3		;if not auto-mode

;	Simulate keypress.

STK2	LDX	STSKP		;offset to next simulated keypress
	LDA	TSKP,X		;simulated keypress
	INC	STSKP		;advance offset to simulated keypress
	LDX	STSKP		;offset to simulated keypress
	CPX	#TSKPL+1	;last offset+1+1
	BNE	STK4		;if last keypress not processed

;	Self-test memory.

	JSR	DLW		;delay a long while
	JMP	STM		;self-test memory

;	Get a keypress.

STK3	LDA	CH		;key code
	CMP	#$FF		;clear code indicator
	BEQ	STK3		;if no key pressed

	CMP	#$C0
	BCS	STK3		;if ???

	LDA	CH		;key code

;	Process keypress.

STK4	LDX	#$FF		;clear code indicator
	STX	CH		;key code
	PHA			;save key code
	AND	#$80
	BEQ	STK5		;if not CTRL

	LDX	#8		;offset to control key text
	JSR	SSM		;set screen memory

;	Check for shift key.

STK5	PLA			;saved key code
	PHA			;save key code
	AND	#$40
	BEQ	STK6		;if not shift key

;	Process keyboard shift key display.

	LDX	#5		;offset to "SH"
	JSR	SSM		;set screen memory
	LDX	#4		;offset to "SH"
	JSR	SSM		;set screen memory

;	Check for special keys.

STK6	PLA			;saved key code
	AND	#$3F
	CMP	#$21
	BEQ	KSB		;if space bar, process display

	CMP	#$2C
	BEQ	KTK		;if tab key, process display

	CMP	#$34
	BEQ	KBK		;if backspace key, process display

	CMP	#$0C
	BEQ	KRK		;if return key, process display

;	Process other key displays.

	TAX			;key code
	LDA	TSMC,X		;display character
	PHA			;save display character

	LDA	#low ST3021
	STA	STTMP1		;screen pointer
	LDA	#high ST3021
	STA	STTMP1+1

;	Find display character in screen memory.

	PLA			;saved display character
	LDY	#$FF		;preset offset

STK7	INY
	CMP	(STTMP1),Y	;???
	BNE	STK7		;if not found

;	Display inverse video.

	LDA	(STTMP1),Y	;???
	EOR	#$80		;invert video
	STA	(STTMP1),Y	;update ???

;	Check auto-mode.

STK8	LDA	STAUT		;auto-mode flag
	BEQ	STK9		;if not auto-mode

;	Process auto-mode.

	JSR	SBT		;sound beep tone
	LDX	#20		;20-VBLANK delay
	JSR	DAW		;delay a while
	JSR	SAS		;silence all sounds
	LDX	#10		;10-VBLANK delay
	JSR	DAW		;delay a while
	JMP	STK1		;get next simulated keypress

;	Process manual mode.

STK9	JSR	SBT		;sound beep tone

STK10	LDA	SKSTAT		;???
	AND	#$04
	BEQ	STK10		;if ???

	JSR	SAS		;silence all sounds
	JMP	STK1		;get next keypress
;	SPACE	4,10
;**	SBT - Sound Beep Tone
;*
;*	ENTRY	JSR	SBT
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SBT	=	*	;entry
	LDA	#$64	;frequency
	STA	AUDF1	;set frequency
	LDA	#$A8	;pure tone, half volume
	STA	AUDC1	;set control
	RTS		;return
;	SPACE	4,10
;**	SAS - Silence All Sounds
;*
;*	ENTRY	JSR	SAS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SAS	=	*	;entry
	LDA	#0	;volume 0
	STA	AUDC1	;silence voice 1
	STA	AUDC2	;silence voice 2
	STA	AUDC3	;silence voice 3
	STA	AUDC4	;silence voice 4
	RTS		;return
;	SPACE	4,10
;**	KSB - Process Keyboard Space Bar Display
;*
;*	ENTRY	JSR	KSB
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


KSB	=	*	;entry
	LDX	#3	;offset to "S P A C E   B A R" text
	JSR	SSM	;set screen memory
	JMP	STK8	;continue
;	SPACE	4,10
;**	KBK - Process Keyboard Backspace Key Display
;*
;*	ENTRY	JSR	KBK
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


KBK	=	*	;entry
	LDX	#6	;offset to "B S" text
	JSR	SSM	;set screen memory
	JMP	STK8	;continue
;	SPACE	4,10
;**	KTK - Process Keyboard Tab Key Display
;*
;*	ENTRY	JSR	KTK
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


KTK	=	*	;entry
	LDA	#$7F	;???
	STA	ST3052
	STA	ST3052+1
	BNE	STK8	;continue
;	SPACE	4,10
;**	KRK - Process Keyboard Return Key Display
;*
;*	ENTRY	JSR	KRK
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


KRK	=	*	;entry
	LDA	#$32	;???
	STA	ST306D
	LDA	#$34	;???
	STA	ST306D+1
	BNE	STK8	;continue
;	SPACE	4,10
;**	TSKP - Table of Simulated Keypresses


TSKP	DB	$52,$08,$0A,$2B,$28,$0D,$3D,$39,$2D	;"Copyright"
	DB	$1F,$30,$35,$18				;"1984"
	DB	$7F,$2D,$3F,$28,$0D			;"Atari"

TSKPL	=	*-TSKP	;length
;	SPACE	4,10
;**	STV - Self-test Audio-visual
;*
;*	STV verifies the operation of the display and voices by
;*	displaying and playing a tune.
;*
;*	ENTRY	JSR	STV
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS	M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


STV	=	*		;entry

;	Initialize.

	LDX	#2		;audio-visual test colors
	JSR	SUC		;set up colors

;	Test audio-visual.

STV1	LDA	#0
	STA	STVOC		;initialize voice indicator

;	Test voice.

STV2	LDA	#0
	STA	STNOT		;initialize note counter
	LDX	#low DISL5	;audio-visual display list
	LDY	#high DISL5
	LDA	#0		;indicate not keyboard self-test
	JSR	SDL		;set up display list

;	Display voice number.

	LDX	#9		;offset to "VOICE #" text
	JSR	SSM		;set screen memory
	LDA	STVOC		;voice indicator
	LSR	A		;voice number
	CLC
	ADC	#$11		;adjust for screen memory
	STA	ST300B		;voice number display

;	Display staff.

	LDX	#$0F		;offset to last byte of staff lines

STV3	LDA	#$FF		;color 2
	STA	ST3150,X	;byte of first line of staff
	STA	ST31B0,X	;byte of second line of staff
	STA	ST3210,X	;byte of third line of staff
	STA	ST3270,X	;byte of fourth line of staff
	STA	ST32D0,X	;byte of fifth line of staff
	DEX
	BPL	STV3		;if not done

;	Display cleft.

	LDA	#0		;offset to first cleft display address
	STA	STCDI		;cleft display pointer
	LDA	#2*6
	STA	STCDA		;cleft data pointer

STV4	LDX	STCDI		;cleft display pointer
	LDA	TCDA+1,X	;high address of cleft display
	TAY
	LDA	TCDA,X		;low address of cleft display
	TAX
	LDA	STCDA		;cleft data pointer
	JSR	DVN		;display ???
	CLC
	LDA	STCDA		;cleft data pointer
	ADC	#6
	STA	STCDA		;update cleft data pointer
	INC	STCDI		;increment cleft display pointer
	INC	STCDI
	LDA	STCDI		;cleft display pointer
	CMP	#TCDAL		;length of cleft display table
	BNE	STV4		;if not done

;	Delay.

	JSR	DMW		;delay a middling while

;	Display and play first note.

	LDX	#low ST3154	;first note ???
	LDY	#high ST3154
	LDA	#0*6
	JSR	DVN		;display ???

	LDA	#$51		;first note frequency
	JSR	SVN		;sound ???

;	Display and play second note.

	LDX	#low ST3186	;second note ???
	LDY	#high ST3186
	LDA	#0*6
	JSR	DVN		;display ???

	LDA	#$5B		;second note frequency
	JSR	SVN		;sound ???

;	Display and play third note.

	LDX	#low ST30F8	;third note ???
	LDY	#high ST30F8
	LDA	#12*6
	JSR	DVN		;display ???
	LDX	#low ST30C7	;third note ???
	LDY	#high ST30C7
	LDA	#14*6
	JSR	DVN		;display ???
	LDX	#low ST3248	;third note ???
	LDY	#high ST3248
	LDA	#13*6
	JSR	DVN		;display ???

	LDA	#$44		;third note frequency
	JSR	SVN		;sound ???

;	Display and play fourth note.

	LDX	#low ST30CA	;fourth note ???
	LDY	#high ST30CA
	LDA	#12*6
	JSR	DVN		;display ???
	LDX	#low ST321A	;fourth note ???
	LDY	#high ST321A
	LDA	#13*6
	JSR	DVN		;display ???
	LDX	#low ST31CA	;fourth note ???
	LDY	#high ST31CA
	LDA	#1*6
	JSR	DVN		;display ???

	LDA	#$3C		;fourth note frequency
	JSR	SVN		;sound ???

;	Display and play fifth note.

	LDX	#low ST303C	;fifth note ???
	LDY	#high ST303C
	LDA	#12*6
	JSR	DVN		;display ???
	LDX	#low ST318C	;fifth note ???
	LDY	#high ST318C
	LDA	#13*6
	JSR	DVN		;display ???
	LDX	#low ST313C	;fifth note ???
	LDY	#high ST313C
	LDA	#1*6
	JSR	DVN		;display ???

	LDA	#$2D		;fifth note frequency
	JSR	SVN		;sound ???

;	Display and play sixth note.

	LDX	#low ST309E	;sixth note ???
	LDY	#high ST309E
	LDA	#12*6
	JSR	DVN		;display ???
	LDX	#low ST31EE	;sixth note ???
	LDY	#high ST31EE
	LDA	#13*6
	JSR	DVN		;display ???

	LDA	#$35		;sixth note frequency
	JSR	SVN		;sound ???

;	Delay.

	JSR	DLW		;delay a long while

;	Advance to next voice.

	INC	STVOC		;increment voice indicator
	INC	STVOC
	LDA	STVOC		;voice indicator
	CMP	#8		;last voice indicator
	BNE	STV5		;if all voices not processed

;	Process test completion.

	LDA	STAUT		;auto-mode flag
	BNE	STV6		;if auto-mode, perform keyboard test

	JMP	STV1		;repeat audio-visual test

;	Test next voice.

STV5	JMP	STV2		;test next voice

;	Self-test keyboard.

STV6	JSR	DLW		;delay a long while
	JMP	STK		;self-test keyboard
;	SPACE	4,10
;**	SVN - Sound ???
;*
;*	ENTRY	JSR	SVN
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SVN	=	*		;entry

;	Sound note.

	LDY	STVOC		;current voice indicator
	STA	AUDF1,Y		;set frequency
	LDA	#$A8		;pure tone, half volume
	STA	AUDC1,Y		;set control

;	Delay a while.

	LDX	STNOT		;current note
	LDA	TNDD,X		;delay time
	TAX
	JSR	DAW		;delay a while

;	Increment note counter.

	INC	STNOT		;increment note counter

;	Exit.

	JSR	SAS		;silence all sounds
	RTS			;return
;	SPACE	4,10
;**	DVN - Display ???
;*
;*	ENTRY	JSR	DVN
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DVN	=	*		;entry
	STX	STTMP2		;???
	STY	STTMP2+1	;???
	TAX			;offset to ???
	LDY	#0
	LDA	#16		;???
	STA	STTMP3		;???
	LDA	#6		;???
	STA	STTMP4		;???

DVN1	LDA	TAVD,X		;byte of ???
	ORA	(STTMP2),Y	;???
	STA	(STTMP2),Y	;update ???
	JSR	AST		;add 16
	DEC	STTMP3		;???
	BNE	DVN1		;if ???

	INC	STTMP3		;???
	INX
	DEC	STTMP4
	BNE	DVN1		;if ???

	RTS			;return
;	SPACE	4,10
;**	AST - Add Sixteen
;*
;*	ENTRY	JSR	AST
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


AST	=	*		;entry
	CLC
	LDA	STTMP2		;current low value
	ADC	#16		;add 16
	STA	STTMP2		;new low value
	BCC	AST1		;if no carry

	INC	STTMP2+1	;adjust high value

AST1	RTS			;return
;	SPACE	4,10
;**	TNDD - Table of Note Duration Delays


TNDD	DB	32	;0 - first note
	DB	32	;1 - second note
	DB	32	;2 - third note
	DB	16	;3 - fourth note
	DB	16	;4 - fifth note
	DB	32	;5 - sixth note
;	SPACE	4,10
;**	TAVD - Table of Audio-visual Test Display Data


TAVD	DB	$01,$1F,$3F,$7F,$3E,$1C		;0 - ???
	DB	$00,$41,$42,$4C,$70,$40		;1 - ???
	DB	$00,$01,$02,$04,$08,$10		;2 - ???
	DB	$00,$43,$44,$48,$48,$48		;3 - ???
	DB	$00,$44,$22,$10,$08,$07		;4 - ???
	DB	$00,$04,$08,$05,$02,$00		;5 - ???
	DB	$00,$30,$48,$88,$84,$84		;6 - ???
	DB	$00,$88,$88,$90,$A0,$C0		;7 - ???
	DB	$00,$F0,$88,$84,$82,$82		;8 - ???
	DB	$00,$82,$82,$84,$88,$F0		;9 - ???
	DB	$00,$00,$00,$00,$00,$80		;10 - ???
	DB	$80,$80,$80,$80,$80,$80		;11 - ???
	DB	$00,$1C,$3E,$7F,$7E,$7C		;12 - ???
	DB	$40,$00,$00,$00,$00,$00		;13 - ???
	DB	$00,$04,$04,$06,$05,$06		;14 - ???
;	SPACE	4,10
;**	TCDA - Table of Cleft Display Addresses


TCDA	DW	ST30C1	;0 - ???
	DW	ST3121	;1 - ???
	DW	ST3181	;2 - ???
	DW	ST31F1	;3 - ???
	DW	ST3002	;4 - ???
	DW	ST3062	;5 - ???
	DW	ST3122	;6 - ???
	DW	ST3182	;7 - ???
	DW	ST30C2	;8 - ???
	DW	ST31C2	;9 - ???

TCDAL	=	*-TCDA		;length
;	SPACE	4,10
;**	SVR - Set Value in Range
;*
;*	ENTRY	JSR	SVR
;*		A = value to set
;*		X = offset to TARS range
;*
;*	EXIT
;*		A = value set
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SVR	=	*		;entry

;	Initialize.

	PHA			;save value

;	Set address range.

	LDA	TARS,X		;start of range
	STA	STADR1
	LDA	TARS+1,X
	STA	STADR1+1
	LDA	TARS+2,X	;end of range
	STA	STADR2
	LDA	TARS+3,X
	STA	STADR2+1

;	Set value in range.

	LDY	#0		;offset to first byte

SVR1	PLA			;saved value
	STA	(STADR1),Y	;byte of range
	INC	STADR1		;increment low address
	BNE	SVR2		;if no carry

	INC	STADR1+1	;adjust high address

SVR2	PHA			;save value
	LDA	STADR1		;low current address
	CMP	STADR2		;low end of range
	BNE	SVR1		;if definitely not done

	LDA	STADR1+1	;high current address
	CMP	STADR2+1	;high end of range
	BNE	SVR1		;if not done

;	Exit.

	PLA			;restore value
	RTS			;return
;	SPACE	4,10
;**	SSM - Set Screen Memory
;*
;*	ENTRY	JSR	SSM
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SSM	=	*		;entry
	LDA	TSTO,X		;offset to source
	TAY
	LDA	TSTL,X		;length of source
	STA	STADR1		;length
	LDA	TSTD,X		;offset to destination
	TAX

SSM1	LDA	TTXT,Y		;byte of source
	STA	ST3000,X	;byte of destination
	INY
	INX
	DEC	STADR1		;decrement length
	BNE	SSM1		;if not done

	RTS			;return
;	SPACE	4,10
;**	SUC - Set Up Colors
;*
;*	ENTRY	JSR	SUC
;*		X = 0, if main screen colors
;*		  = 1, if memory test colors
;*		  = 2, if keyboard test colors
;*		  = 3, if audio-visual test colors
;*
;*	EXIT
;*		COLOR0, COLOR1, COLOR2 and COLOR4 set.
;*
;*	CHANGES
;*		A
;*
;*	CALLS
;*		-none-
;*
;*	MODS
;*		M. W. Colburn	10/26/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SUC	=	*		;entry

	LDA	SUCA,X
	STA	COLOR0	;playfield 0 color

	LDA	SUCB,X
	STA	COLOR1	;playfield 1 color

	LDA	SUCC,X
	STA	COLOR2	;playfield 2 color

	LDA	SUCD,X
	STA	COLOR4	;background color

	RTS		;return


SUCA	DB	$2C	;0 - main screen playfield 0 color
	DB	$0C	;1 - memory test playfield 0 color
	DB	$2A	;2 - keyboard test playfield 0 color
	DB	$18	;3 - audio-visual test playfield 0 color

SUCB	DB	$0F	;0 - main screen playfield 1 color
	DB	$32	;1 - memory test playfield 1 color
	DB	$0C	;2 - keyboard test playfield 1 color
	DB	$0E	;3 - audio-visual test playfield 1 color

SUCC	DB	$D2	;0 - main screen playfield 2 color
	DB	$D6	;1 - memory test playfield 2 color
	DB	$00	;2 - keyboard test playfield 2 color
	DB	$B4	;3 - audio-visual test playfield 2 color

SUCD	DB	$D2	;0 - main screen background color
	DB	$A0	;1 - memory test background color
	DB	$30	;2 - keyboard test background color
	DB	$B4	;3 - audio-visual test background color
;	SPACE	4,10
;**	TSMC - Table of Screen Memory Character Codes
;*
;*	Entry n is the screen memory character code for key code n.


TSMC	DB	$2C	;$00 - L key
	DB	$2A	;$01 - J key
	DB	$1B	;$02 - semicolon key
	DB	$00	;$03
	DB	$00	;$04
	DB	$2B	;$05 - K key
	DB	$0B	;$06 - plus key
	DB	$0A	;$07 - asterisk key
	DB	$2F	;$08 - O key
	DB	$00	;$09
	DB	$30	;$0A - P key
	DB	$35	;$0B - U key
	DB	$B2	;$0C - RETURN key
	DB	$29	;$0D - I key
	DB	$0D	;$0E - minus key
	DB	$1D	;$0F - = key

	DB	$36	;$10 - V key
	DB	$A8	;$11 - Help key
	DB	$23	;$12 - C key
	DB	$00	;$13
	DB	$00	;$14
	DB	$22	;$15 - B key
	DB	$38	;$16 - X key
	DB	$3A	;$17 - Z key
	DB	$14	;$18 - 4 key
	DB	$00	;$19
	DB	$13	;$1A - 3 key
	DB	$16	;$1B - 6 key
	DB	$5B	;$1C - ESC key
	DB	$15	;$1D - 5 key
	DB	$12	;$1E - 2 key
	DB	$11	;$1F - 1 key

	DB	$0C	;$20 - comma key
	DB	$00	;$21 - space key
	DB	$0E	;$22 - period key
	DB	$2E	;$23 - N key
	DB	$00	;$24
	DB	$2D	;$25 - M key
	DB	$0F	;$26 - / key
	DB	$A1	;$27 - inverse video key
	DB	$32	;$28 - R key
	DB	$00	;$29
	DB	$25	;$2A - E key
	DB	$39	;$2B - Y key
	DB	$FF	;$2C - TAB key
	DB	$34	;$2D - T key
	DB	$37	;$2E - W key
	DB	$31	;$2F - Q key

	DB	$19	;$30 - 9 key
	DB	$00	;$31
	DB	$10	;$32 - 0 key
	DB	$17	;$33 - 7 key
	DB	$A2	;$34 - backspace key
	DB	$18	;$35 - 8 key
	DB	$1C	;$36 - < key
	DB	$1E	;$37 - > key
	DB	$26	;$38 - F key
	DB	$28	;$39 - H key
	DB	$24	;$3A - D key
	DB	$00	;$3B
	DB	$A3	;$3C - CAPS key
	DB	$27	;$3D - G key
	DB	$33	;$3E - S key
	DB	$21	;$3F - A key
;	SPACE	4,10
;**	TARS - Table of Address Ranges to Set


TARS	DW	ST3000,ST3000+$0EFF	;0 - screen memory
	DW	ST3020,ST3020+4		;1 - memory test first 8K ROM
	DW	ST3024,ST3024+4		;2 - memory test second 8K ROM
	DW	ST3000,ST3000+32	;3 - main screen bold lines
;	SPACE	4,10
;**	TSTL - Table of Self-test Text Lengths


TSTL	DB	TXT0L	;0 - length of "MEMORY TEST   ROM" text
	DB	TXT1L	;1 - length of "RAM" text
	DB	TXT2L	;2 - length of "KEYBOARD TEST" text
	DB	TXT3L	;3 - length of "S P A C E   B A R" text
	DB	TXT4L	;4 - length of "SH" text
	DB	TXT5L	;5 - length of "SH" text
	DB	TXT6L	;6 - length of "B S" text
	DB	TXT7L	;7 - length of keyboard text
	DB	TXT8L	;8 - length of control key text
	DB	TXT9L	;9 - length of "VOICE #" text
;	SPACE	4,10
;**	TSTD - Table of Self-test Text Destination Offsets


TSTD	DB	ST3000-ST3000	;0 - offset to "MEMORY TEST   ROM" text
	DB	ST3028-ST3000	;1 - offset to "RAM" text
	DB	ST3000-ST3000	;2 - offset to "KEYBOARD TEST" text
	DB	ST30B7-ST3000	;3 - offset to "S P A C E   B A R" text
	DB	ST3092-ST3000	;4 - offset to "SH" text
	DB	ST30AB-ST3000	;5 - offset to "SH" text
	DB	ST304C-ST3000	;6 - offset to "B S" text
	DB	ST3022-ST3000	;7 - offset to keyboard text
	DB	ST3072-ST3000	;8 - offset to control key text
	DB	ST3004-ST3000	;9 - offset to "VOICE #" text
;	SUBTTL	'Floating Point Package'
;	SPACE	4,10
;***	(C) Copyright 1978 Shepardson Microsystems, Inc.???
;	SPACE	4,10
	FIX	$5800
	ORG	$D800
;	SPACE	4,10
;***	FPP - Floating Point Package
;*
;*	FPP is a collection of routines for floating point
;*	computations.  A floating point number is represented
;*	in 6 bytes:
;*
;*	Byte 0
;*		Bit 7		Sign of mantissa
;*		Bits 0 - 6	BCD exponent, biased by $40
;*
;*	Bytes 1 - 5		BCD mantissa
;*
;*	MODS
;*		Shepardson Microsystems	??/??/78
;*
;*		Produce 2K version.
;*		M. Lorenzen	09/06/81
;	SPACE	4,10
	FIX	AFP
;	SPACE	4,10
;**	AFP - Convert ASCII to Floating Point
;*
;*	ENTRY	JSR	AFP
;*		INBUFF = line buffer pointer
;*		CIX = offset to first byte of number
;*		??
;*
;*	EXIT
;*		C clear, if valid number
;*		C set, if invalid number
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: bytes wasted by check for "-", near AFP7.
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;AFP	=	*		;entry

;	Initialize.

	JSR	SLB	;skip leading blanks

;	Check for number.

	JSR	TVN	;test for valid number character
	BCS	AFP5	;if not number character

;	Set initial values.

	LDX	#EEXP	;exponent
	LDY	#4	;indicate 4 bytes to clear
	JSR	ZXLY	;zero ???
	LDX	#$FF
	STX	DIGRT	;number of digits after decimal point
	JSR	ZFR0	;zero FR0
	BEQ	AFP2	;get first character

;	Indicate not first character.

AFP1	LDA	#$FF	;indicate not first character
	STA	FCHFLG	;first character flag

;	Get next character.

AFP2	JSR	GNC	;get next character
	BCS	AFP6	;if character not numeric

;	Process numeric character.

	PHA			;save digit
	LDX	FR0M		;first byte
	BNE	AFP3		;if not zero

;	???.

	JSR	S0L		;shift FR0 left 1 digit
	PLA			;saved digit
	ORA	FR0M+FMPREC-1	;insert into last byte
	STA	FR0M+FMPREC-1	;update last byte

;	Check for decimal point.

	LDX	DIGRT	;number of digits after decimal point
	BMI	AFP1	;if no decimal point, process next character

;	Increment number of digits after decimal point.

	INX		;increment number of digits
	STX	DIGRT	;number of digits after decimal point
	BNE	AFP1	;process next character

;	Increment exponent, if necessary.

AFP3	PLA		;clean stack
	LDX	DIGRT	;number of digits after decimal point
	BPL	AFP4	;if already have decimal point

	INC	EEXP	;increment number of digits more than 9

;	Process next character.

AFP4	JMP	AFP1	;process next character

;	Exit.

AFP5	RTS		;return

;	Process non-numeric character.

AFP6	CMP	#'.'
	BEQ	AFP8	;if ".", process decimal point

	CMP	#'E'
	BEQ	AFP9	;if "E", process exponent

	LDX	FCHFLG	;first character flag
	BNE	AFP16	;if not first character, process end of input

	CMP	#'+'
	BEQ	AFP1	;if "+", process next character

	CMP	#'-'
	BEQ	AFP7	;if "-", process negative sign

;	Process negative sign.

AFP7	STA	NSIGN	;sign of number
	BEQ	AFP1	;process next character

;	Process decimal point.

AFP8	LDX	DIGRT	;number of digits after decimal point
	BPL	AFP16	;if already have decimal point

	INX		;zero
	STX	DIGRT	;number of digits after decimal point
	BEQ	AFP1	;process next character

;	Process exponent.

AFP9	LDA	CIX	;offset to character
	STA	FRX	;save offset to character
	JSR	GNC	;get next character
	BCS	AFP13	;if not numeric

;	Process numeric character in exponent.

AFP10	TAX		;first character of exponent
	LDA	EEXP	;number of digits more than 9
	PHA		;save number of digits more than 9
	STX	EEXP	;first character of exponent

;	Process second character of exponent.

	JSR	GNC	;get next character
	BCS	AFP11	;if not numeric, no second digit

	PHA		;save second digit
	LDA	EEXP	;first digit
	ASL	A	;2 times first digit
	STA	EEXP	;2 times first digit
	ASL	A	;4 times first digit
	ASL	A	;8 times first digit
	ADC	EEXP	;add 2 times first digit
	STA	EEXP	;save 10 times first digit
	PLA		;saved second digit
	CLC
	ADC	EEXP	;insert in exponent
	STA	EEXP	;update exponent

;	Process third character of exponent???

	LDY	CIX	;offset to third character
	JSR	ICX	;increment offset

AFP11	LDA	ESIGN	;sign of exponent
	BEQ	AFP12	;if no sign on exponent

;	Process negative exponent.

	LDA	EEXP	;exponent
	EOR	#$FF	;complement exponent
	CLC
	ADC	#1	;add 1 for 2's complement
	STA	EEXP	;update exponent

;	Add in number of digits more than 9.

AFP12	PLA		;saved number of digits more than 9
	CLC
	ADC	EEXP	;add exponent
	STA	EEXP	;update exponent
	BNE	AFP16	;process end of input

;	Process non-numeric in exponent.

AFP13	CMP	#'+'
	BEQ	AFP14	;if "+", process next character

	CMP	#'-'
	BNE	AFP15	;if not "-", ???

	STA	ESIGN	;save sign of exponent

;	Process next character.

AFP14	JSR	GNC	;get next character
	BCC	AFP10	;if numeric, process numeric character

;	Process other non-numeric in exponent.

AFP15	LDA	FRX	;saved offset
	STA	CIX	;restore offset

;	Process end of input.

AFP16	DEC	CIX	;decrement offset
	LDA	EEXP	;exponent
	LDX	DIGRT	;number of digits after decimal point
	BMI	AFP17	;if no decimal point

	BEQ	AFP17	;if no digits after decimal point

	SEC
	SBC	DIGRT	;subtract number of digits after decimal point

AFP17	PHA		;save adjusted exponent
	ROL	A	;set C with sign of exponent
	PLA		;saved adjusted exponent
	ROR	A	;shift right
	STA	EEXP	;save power of 100
	BCC	AFP18	;if no carry, process even number

	JSR	S0L	;shift FR0 left 1 digit

AFP18	LDA	EEXP	;exponent
	CLC
	ADC	#$40+4	;add bias plus 4 for normalization
	STA	FR0	;save exponent

	JSR	NORM	;normalize number
	BCS	AFP20	;if error

;	Check sign of number.

	LDX	NSIGN	;sign of number
	BEQ	AFP19	;if sign of number not negative

;	Process negative number.

	LDA	FR0	;first byte of mantissa
	ORA	#$80	;indicate negative
	STA	FR0	;update first byte of mantissa

;	Exit.

AFP19	CLC		;indicate valid number

AFP20	RTS		;return
;	SPACE	4,10
	FIX	FASC
;	SPACE	4,10
;**	FASC - Convert Floating Point Number to ASCII
;*
;*	ENTRY	JSR	FASC
;*		FR0 - FR0+5 = number to convert
;*		??
;*
;*	EXIT
;*		INBUFF = pointer to start of number
;*		High order bit of last charecter set
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FASC	=	*	;entry

;	Initialize.

	JSR	ILP	;initialize line buffer pointer
	LDA	#'0'
	STA	LBPR2	;put "0" in front of line buffer

;	Check for E format required.

	LDA	FR0	;exponent
	BEQ	FASC2	;if exponent zero, number zero

	AND	#$7F	;clear sign
	CMP	#$40-1	;bias-1
	BCC	FASC3	;if exponent < bias-1, E format required

	CMP	#$40+5	;bias+5
	BCS	FASC3	;if >= bias+5, E format required

;	Process E format not required.

	SEC
	SBC	#$40-1	;subtract bias-1, yielding decimal position
	JSR	C0A	;convert FR0 to ASCII
	JSR	FNZ	;find last non-zero character
	ORA	#$80	;set high order bit
	STA	LBUFF,X	;update last character
	LDA	LBUFF	;first character
	CMP	#'.'
	BEQ	FASC1	;if decimal point

	JMP	FASC10	;???

FASC1	JSR	DLP	;decrement line buffer pointer
	JMP	FASC11	;perform final adjustment

;	Process zero.

FASC2	LDA	#$80+'0'	;"0" with high order bit set
	STA	LBUFF		;put zero character in line buffer
	RTS			;return

;	Process E format required.

FASC3	LDA	#1	;GET DECIMAL POSITION???
	JSR	C0A	;convert FR0 to ASCII
	JSR	FNZ	;find last non-zero character
	INX		;increment offset to last character
	STX	CIX	;save offset to last character

;	Adjust exponent.

	LDA	FR0	;exponent
	ASL	A	;double exponent
	SEC
	SBC	#$40*2	;subtract 2 times bias

;	Check first character for "0".

	LDX	LBUFF	;first character
	CPX	#'0'
	BEQ	FASC5	;if "0"

;	Put decimal after first character.

	LDX	LBUFF+1	;second character
	LDY	LBUFF+2	;decimal point
	STX	LBUFF+2	;decimal point
	STY	LBUFF+1	;third character
	LDX	CIX	;offset
	CPX	#2	;former offset to decimal point
	BNE	FASC4	;if offset pointed to second character

	INC	CIX	;increment offset

FASC4	CLC
	ADC	#1	;adjust exponent for movement of decimal point

;	Convert exponent to ASCII.

FASC5	STA	EEXP	;exponent
	LDA	#'E'
	LDY	CIX	;offset
	JSR	SAL	;store ASCII character in line buffer
	STY	CIX	;save offset
	LDA	EEXP	;exponent
	BPL	FASC6	;if exponent positive

	LDA	#0
	SEC
	SBC	EEXP	;complement exponent
	STA	EEXP	;update exponent
	LDA	#'-'
	BNE	FASC7	;store "-"

FASC6	LDA	#'+'

FASC7	JSR	SAL	;store ASCII character in line buffer
	LDX	#0	;initial number of 10's
	LDA	EEXP	;exponent

FASC8	SEC
	SBC	#10	;subtract 10
	BCC	FASC9	;if < 0, done

	INX		;increment number of 10's
	BNE	FASC8	;continue

FASC9	CLC
	ADC	#10	;add back 10
	PHA		;save remainder
	TXA		;number of 10's
	JSR	SNL	;store number in line buffer
	PLA		;saved remainder
	ORA	#$80	;set high order bit
	JSR	SNL	;store number in line buffer

;	Perform final adjustment.

FASC10	LDA	LBUFF	;first character
	CMP	#'0'
	BNE	FASC11	;if not "0", ???

;	Increment pointer to point to non-zero character.

	CLC
	LDA	INBUFF		;line buffer pointer
	ADC	#1		;add 1
	STA	INBUFF		;update line buffer pointer
	LDA	INBUFF+1
	ADC	#0
	STA	INBUFF+1

;	Check for positive exponent.

FASC11	LDA	FR0		;exponent
	BPL	FASC12		;if exponent positive, exit

;	Process negative exponent.

	JSR	DLP		;decrement line buffer pointer
	LDY	#0		;offset to first character
	LDA	#'-'
	STA	(INBUFF),Y	;put "-" in line buffer

;	Exit.

FASC12	RTS			;return
;	SPACE	4,10
	FIX	IFP
;	SPACE	4,10
;**	IFP - Convert Integer to Floating Point Number
;*
;*	ENTRY	JSR	IFP
;*		FR0 - FR0+1 = integer to convert
;*		??
;*
;*	EXIT
;*		FR0 - FR0+5 = floating point number
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;IFP	=	*	;entry

;	Initialize.

	LDA	FR0		;low integer
	STA	ZTEMP4+1	;save low integer
	LDA	FR0+1		;high integer
	STA	ZTEMP4		;save high integer
	JSR	ZFR0		;zero FR0

;	Convert to floating point.

	SED
	LDY	#16		;number of bits in integer

IFP1	ASL	ZTEMP4+1	;shift integer
	ROL	ZTEMP4		;shift integer, setting C if bit present

	LDX	#3		;offset to last possible byte of number

IFP2	LDA	FR0,X		;byte of number
	ADC	FR0,X		;double byte, adding in carry
	STA	FR0,X		;update byte of number
	DEX
	BNE	IFP2		;if not done

	DEY			;decrement count of integer bits
	BNE	IFP1		;if not done

	CLD

;	Set exponent.

	LDA	#$40+2		;indicate decimal after last digit
	STA	FR0		;exponent

;	Exit.

	JMP	NORM		;normalize ???, return
;	SPACE	4,10
	FIX	FPI
;	SPACE	4,10
;**	FPI - Convert Floating Point Number to Integer
;*
;*	ENTRY	JSR	FPI
;*		FR0 - FR0+5 = floating point number
;*		??
;*
;*	EXIT
;*		C set, if error
;*		C clear, if no error
;*		FR0 - FR0+1 = integer
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FPI	=	*		;entry

;	Initialize.

	LDA	#0
	STA	ZTEMP4		;zero integer
	STA	ZTEMP4+1

;	Check exponent.

	LDA	FR0		;exponent
	BMI	FPI4		;if sign of exponent is negative, error

	CMP	#$40+3		;bias+3
	BCS	FPI4		;if number too big, error

	SEC
	SBC	#$40		;subtract bias
	BCC	FPI2		;if number less than 1, test for round

;	Compute number of digits to convert.

	ADC	#0		;add carry
	ASL	A		;2 times exponent-$40+1???
	STA	ZTEMP1		;number of digits to convert

;	Convert.

FPI1	JSR	SIL		;shift integer left
	BCS	FPI4		;if number too big, error

	LDA	ZTEMP4		;2 times integer
	STA	ZTEMP3		;save 2 times integer
	LDA	ZTEMP4+1
	STA	ZTEMP3+1
	JSR	SIL		;shift integer left
	BCS	FPI4		;if number too big, error

	JSR	SIL		;shift integer left
	BCS	FPI4		;if number too big, error

	CLC
	LDA	ZTEMP4+1	;8 times integer
	ADC	ZTEMP3+1	;add 2 times integer
	STA	ZTEMP4+1	;10 times integer
	LDA	ZTEMP4
	ADC	ZTEMP3
	STA	ZTEMP4
	BCS	FPI4		;if overflow???, error

	JSR	GND		;get next digit
	CLC
	ADC	ZTEMP4+1	;insert digit in ???
	STA	ZTEMP4+1	;update ???
	LDA	ZTEMP4		;???
	ADC	#0		;add carry
	BCS	FPI4		;if overflow, error

	STA	ZTEMP4		;update ???
	DEC	ZTEMP1		;decrement count of digits to convert
	BNE	FPI1		;if not done

;	Check for round required.

FPI2	JSR	GND		;get next digit
	CMP	#5
	BCC	FPI3		;if digit less than 5, do not round

;	Round.

	CLC
	LDA	ZTEMP4+1	;???
	ADC	#1		;add 1 to round
	STA	ZTEMP4+1	;update ???
	LDA	ZTEMP4
	ADC	#0
	STA	ZTEMP4

;	Return integer.

FPI3	LDA	ZTEMP4+1	;low integer
	STA	FR0		;low integer result
	LDA	ZTEMP4		;high integer
	STA	FR0+1		;high integer result
	CLC			;indicate success
	RTS			;return

;	Return error.

FPI4	SEC			;indicate error
	RTS			;return
;	SPACE	4,10
	FIX	ZFR0
;	SPACE	4,10
;**	ZFR0 - Zero FR0
;*
;*	ENTRY	JSR	ZFR0
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;ZFR0	=	*	;entry

	LDX	#FR0	;indicate zero FR0
;	JMP	ZF1	;zero floating point number, return
;	SPACE	4,10
	FIX	ZF1
;	SPACE	4,10
;**	ZF1 - Zero Floating Point Number
;*
;*	ENTRY	JSR	ZF1
;*		X = offset to register
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;ZF1	=	*	;entry

	LDY	#6	;number of bytes to zero
;	JMP	ZXLY	;zero bytes, return
;	SPACE	4,10
;**	ZXLY - Zero Page Zero Location X for Length Y
;*
;*	ENTRY	JSR	ZXLY
;*		X = offset
;*		Y = length
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ZXLY	=	*	;entry

	LDA	#0

ZXLY1	STA	$0000,X	;zero byte
	INX
	DEY
	BNE	ZXLY1	;if not done

	RTS		;return
;	SPACE	4,10
;**	ILP - Initialize Line Buffer Pointer
;*
;*	ENTRY	JSR	ILP
;*
;*	EXIT
;*		INBUFF - INBUFF+1 = line buffer address
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ILP	=	*		;entry
	LDA	#high LBUFF	;high buffer address
	STA	INBUFF+1	;high line buffer pointer
	LDA	#low LBUFF	;low buffer address
	STA	INBUFF		;low line buffer pointer
	RTS			;return
;	SPACE	4,10
;**	SIL - Shift Integer Left
;*
;*	ENTRY	JSR	SIL
;*		ZTEMP4 - ZTEMP4+1 = number (high, low) to shift
;*		??
;*
;*	EXIT
;*		ZTEMP4 - ZTEMP4+1 shifted left 1
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SIL	=	*		;entry
	CLC
	ROL	ZTEMP4+1	;shift low
	ROL	ZTEMP4		;shift high
	RTS			;return
;	SPACE	4,10
	FIX	FSUB
;	SPACE	4,10
;**	FSUB - Perform Floating Point Subtract
;*
;*	FSUB subtracts FR1 from FR0.
;*
;*	ENTRY	JSR	FSUB
;*		FR0 - FR0+5 = minuend
;*		FR1 - FR1+5 = subtrahend
;*		??
;*
;*	EXIT
;*		C set, if error
;*		C clear, if no error
;*		FR0 - FR0+5 = difference
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FSUB	=	*	;entry

;	Complement sign of subtrahend and add.

	LDA	FR1	;subtrahend exponent
	EOR	#$80	;complement sign of subtrahend
	STA	FR1	;update subtrahend exponent
;	JMP	FADD	;perform add, return
;	SPACE	4,10
	FIX	FADD
;	SPACE	4,10
;**	FADD - Perform Floating Point Add
;*
;*	ENTRY	JSR	FADD
;*		FR0 - FR0+5 = augend
;*		FR1 - FR1+5 = addend
;*		??
;*
;*	EXIT
;*		C set, if error
;*		C clear, if no error
;*		FR0 - FR0+5 = sum
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FADD	=	*	;entry

;	Initialize.

FADD1	LDA	FR1	;exponent of addend
	AND	#$7F	;clear sign of addend mantissa
	STA	ZTEMP4	;save addend exponent
	LDA	FR0	;exponent of augend
	AND	#$7F	;clear sign of augend mantissa
	SEC
	SBC	ZTEMP4	;subtract addend exponent
	BPL	FADD3	;if augend exponent >= addend exponent

;	Swap augend and addend.

	LDX	#FPREC-1	;offset to last byte

FADD2	LDA	FR0,X		;byte of augend
	LDY	FR1,X		;byte of addend
	STA	FR1,X		;move byte of augend to addend
	TYA
	STA	FR0,X		;move byte of addend to augend
	DEX
	BPL	FADD2		;if not done

	BMI	FADD1		;re-initialize

;	Check alignment.

FADD3	BEQ	FADD4	;if exponent difference zero, already aligned

	CMP	#FMPREC	;mantissa precision
	BCS	FADD6	;if exponent difference < mantissa precision

;	Align.

	JSR	S1R	;shift FR1 right

;	Check for like signs of mantissas.

FADD4	SED
	LDA	FR0	;augend exponent
	EOR	FR1	;EOR with addend exponent
	BMI	FADD8	;if signs differ, subtract

;	Add.

	LDX	#FMPREC-1	;offset to last byte of mantissa
	CLC

FADD5	LDA	FR0M,X		;byte of augend mantissa
	ADC	FR1M,X		;add byte of addend mantissa
	STA	FR0M,X		;update byte of result mantissa
	DEX
	BPL	FADD5		;if not done

	CLD
	BCS	FADD7		;if carry, process carry

;	Exit.

FADD6	JMP	NORM		;normalize ???, return

;	Process carry.

FADD7	LDA	#1		;indicate shift 1
	JSR	S0R		;shift FR0 right
	LDA	#1		;carry
	STA	FR0M		;set carry in result

;	Exit.

	JMP	NORM		;normalize ???, return

;	Subtract.

FADD8	LDX	#FMPREC-1	;offset to last byte of mantissa
	SEC

FADD9	LDA	FR0M,X		;byte of augend mantissa
	SBC	FR1M,X		;subtract byte of addend mantissa
	STA	FR0M,X		;update byte of result mantissa
	DEX
	BPL	FADD9		;if not done

	BCC	FADD10		;if borrow, process borrow

;	Exit.

	CLD
	JMP	NORM		;normalize ???, return

;	Process borrow.

FADD10	LDA	FR0		;result exponent
	EOR	#$80		;complement sign of result
	STA	FR0		;update result exponent

	SEC
	LDX	#FMPREC-1	;offset to last byte of mantissa

FADD11	LDA	#0
	SBC	FR0M,X		;complement byte of result mantissa
	STA	FR0M,X		;update byte of result mantissa
	DEX
	BPL	FADD11		;if not done

;	Exit.

	CLD
	JMP	NORM		;normalize ???, return
;	SPACE	4,10
	FIX	FMUL
;	SPACE	4,10
;**	FMUL - Perform Floating Point Multiply
;*
;*	ENTRY	JSR	FMUL
;*		FR0 - FR0+5 = multiplicand
;*		FR1 - FR1+5 = multiplier
;*		??
;*
;*	EXIT
;*		C set, if error
;*		C clear, if no error
;*		FR0 - FR0+5 = product
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FMUL	=	*	;entry

;	Check for zero multiplicand.

	LDA	FR0	;multiplicand exponent
	BEQ	FMUL8	;if multiplicand exponent zero, result is zero

;	Check for zero multiplier.

	LDA	FR1	;multiplier exponent
	BEQ	FMUL7	;if multiplier exponent zero, result is zero

;	???.

	JSR	SUE	;set up exponent???
	SEC
	SBC	#$40	;subtract bias
	SEC		;add 1
	ADC	FR1	;add multiplier exponent
	BMI	FMUL9	;if overflow, error

;	Set up.

	JSR	SUP	;set up

;	Compute number of times to add multiplicand.

FMUL1	LDA	FRE+FPREC-1	;last byte of FRE
	AND	#$0F		;extract low order digit
	STA	ZTEMP1+1	;???

;	Check for completion???

FMUL2	DEC	ZTEMP1+1	;decrement counter???
	BMI	FMUL3		;if done

	JSR	FRA10		;add FR1 to FR0
	JMP	FMUL2		;continue

;	Compute number of times to add 10 times multiplicand.

FMUL3	LDA	FRE+FPREC-1	;last byte of FRE
	LSR	A
	LSR	A
	LSR	A
	LSR	A		;high order digit
	STA	ZTEMP1+1	;???

;	Check for completion.

FMUL4	DEC	ZTEMP1+1	;decrement counter
	BMI	FMUL5		;if done

	JSR	FRA20		;add FR2 to FR0
	JMP	FMUL4		;continue

;	Set up for next set of adds.

FMUL5	JSR	S0ER		;shift FR0/FRE right

;	Decrement counter and test for completion.

	DEC	ZTEMP1		;decrement ???
	BNE	FMUL1		;if not done

;	Set exponent.

FMUL6	LDA	EEXP		;exponent
	STA	FR0		;result exponent
	JMP	N0E		;normalize ???, return

;	Return zero result.

FMUL7	JSR	ZFR0		;zero FR0

;	Return no error.

FMUL8	CLC			;indicate no error
	RTS			;return

;	Return error.

FMUL9	SEC			;indicate error
	RTS			;return
;	SPACE	4,10
	FIX	FDIV
;	SPACE	4,10
;**	FDIV - Perform Floating Point Divide
;*
;*	ENTRY	JSR	FDIV
;*		FR0 - FR0+5 = dividend
;*		FR1 - FR1+5 = divisor
;*		??
;*
;*	EXIT
;*		C clear, if no error
;*		C set, if error
;*		FR0 - FR0+5 = quotient
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FDIV	=	*	;entry

;	Check for zero divisor.

	LDA	FR1	;divisor exponent
	BEQ	FMUL9	;if divisor exponent zero, error

;	Check for zero dividend.

	LDA	FR0	;dividend exponent
	BEQ	FMUL8	;if dividend exponent zero, result is zero

;	???.

	JSR	SUE	;set up exponent
	SEC
	SBC	FR1	;subtract divisor exponent
	CLC
	ADC	#$40	;add bias
	BMI	FMUL9	;if overflow, error

;	???.

	JSR	SUP	;set up
	INC	ZTEMP1	;divide requires extra pass
	JMP	FDIV3	;skip shift

;	Shift FR0/FRE left one byte.

FDIV1	LDX	#0		;offset to first byte to shift

FDIV2	LDA	FR0+1,X		;byte to shift
	STA	FR0,X		;byte of destination
	INX
	CPX	#FMPREC*2+2	;number of bytes to shift
	BNE	FDIV2		;if not done

;	Subtract 2 times divisor from dividend.

FDIV3	LDY	#FPREC-1	;offset to last byte
	SEC
	SED

FDIV4	LDA	FRE,Y		;byte of dividend
	SBC	FR2,Y		;subtract byte of 2*divisor
	STA	FRE,Y		;update byte of dividend
	DEY
	BPL	FDIV4		;if not done

	CLD
	BCC	FDIV5		;if difference < 0

	INC	QTEMP		;increment ???
	BNE	FDIV3		;continue

;	Adjust.

FDIV5	JSR	FRA2E	;add FR2 to FR0

;	Shift last byte of quotient left one digit.

	ASL	QTEMP
	ASL	QTEMP
	ASL	QTEMP
	ASL	QTEMP

;	Subtract divisor from dividend.

FDIV6	LDY	#FPREC-1	;offset to last byte
	SEC
	SED

FDIV7	LDA	FRE,Y		;byte of dividend
	SBC	FR1,Y		;subtract byte of divisor
	STA	FRE,Y		;update byte of dividend
	DEY
	BPL	FDIV7		;if not done

	CLD
	BCC	FDIV8		;if difference < 0

	INC	QTEMP		;increment
	BNE	FDIV6		;continue

;	Adjust.

FDIV8	JSR	FRA1E	;add FR1 to FR0
	DEC	ZTEMP1	;decrement ???
	BNE	FDIV1	;if not done

;	Clear exponent???

	JSR	S0ER	;shift  FR0/FRE right

;	Exit.

	JMP	FMUL6	;???, return
;	SPACE	4,10
;**	GNC - Get Next Character
;*
;*	ENTRY	JSR	GNC
;*		INBUFF - INBUFF+1 = line buffer pointer
;*		CIX = offset to character
;*		??
;*
;*	EXIT
;*		C set, if character not numeric
;*		A = non-numeric character
;*		C clear, if character numeric
;*		CIX = offset to next character
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


GNC	=	*		;entry
	JSR	TNC		;test for numeric character
	LDY	CIX		;offset
	BCC	ICX		;if numeric, increment offset, return

	LDA	(INBUFF),Y	;character
;	JMP	ICX		;increment offset, return
;	SPACE	4,10
;**	ICX - Increment Character Offset
;*
;*	ENTRY	JSR	ICX
;*		Y = offset
;*		??
;*
;*	EXIT
;*		CIX = offset to next character
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ICX	=	*	;entry
	INY		;increment offset
	STY	CIX	;offset
	RTS		;return
;	SPACE	4,10
;**	SLB - Skip Leading Blanks
;*
;*	ENTRY	JSR	???
;*		INBUFF - INBUFF+1 = line buffer pointer
;*		CIX = offset
;*		??
;*
;*	EXIT
;*		CIX = offset to first non-blank character
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SLB	=	*		;entry

;	Initialize.

	LDY	CIX		;offset to character
	LDA	#' '

;	Search for first non-blank character.

SLB1	CMP	(INBUFF),Y	;character
	BNE	SLB2		;if non-blank character

	INY
	BNE	SLB1		;if not done

;	Exit.

SLB2	STY	CIX		;offset to first non-blank character
	RTS			;return
;	SPACE	4,10
;**	TNC - Test for Numeric Character
;*
;*	ENTRY	JSR	TNC
;*		INBUFF - INBUFF+1 = line buffer pointer
;*		CIX = offset
;*		??
;*
;*	EXIT
;*		C set, if numeric
;*		C clear if non-numeric
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


TNC	=	*		;entry
	LDY	CIX		;offset
	LDA	(INBUFF),Y	;character
	SEC
	SBC	#'0'	
	BCC	TVN2		;if < "0", return failure

	CMP	#'9'-'0'+1	;return success or failure
	RTS			;return
;	SPACE	4,10
;**	TVN - Test for Valid Number Character
;*
;*	ENTRY	JSR	TVN
;*		??
;*
;*	EXIT
;*		C set, if not number
;*		C clear, if number
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: bytes wasted by BCC TVN5.
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


TVN	=	*	;entry

;	Initialize.

	LDA	CIX	;offset
	PHA		;save offset

;	Check next character.

	JSR	GNC	;get next character
	BCC	TVN5	;if numeric, return success

	CMP	#'.'
	BEQ	TVN4	;if ".", check next character

	CMP	#'+'
	BEQ	TVN3	;if "+", check next character

	CMP	#'-'
	BEQ	TVN3	;if "-", check next character

;	Clean stack.

TVN1	PLA		;clean stack

;	Return failure.

TVN2	SEC		;indicate failure
	RTS		;return

;	Check character after "+" or "-".

TVN3	JSR	GNC	;get next character
	BCC	TVN5	;if numeric, return success

	CMP	#'.'
	BNE	TVN1	;if not ".", return failure

;	Check character after ".".

TVN4	JSR	GNC	;get next character
	BCC	TVN5	;if numeric, return success

	BCS	TVN1	;return failure

;	Return success.

TVN5	PLA		;saved offset
	STA	CIX	;restore offset
	CLC		;indicate success
	RTS		;return
;	SPACE	4,10
;**	S2L - Shift FR2 Left One Digit
;*
;*	ENTRY	JSR	S2L
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


S2L	=	*	;entry
	LDX	#FR2+1	;indicate shift of FR2 mantissa
	BNE	SML	;shift mantissa left 1 digit, return
;	SPACE	4,10
;**	S0L - Shift FR0 Left One Digit
;*
;*	ENTRY	JSR	S0L
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


S0L	=	*	;entry
	LDX	#FR0M	;indicate shift of FR0 mantissa
;	JMP	SML	;shift mantissa left 1 digit, return
;	SPACE	4,10
;**	SML - Shift Mantissa Left One Digit
;*
;*	ENTRY	JSR	SML
;*		??
;*
;*	EXIT
;*		FRX = excess digit
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SML	=	*	;entry
	LDY	#4	;number of bits to shift

SML2	CLC
	ROL	$0004,X	;shift 5th byte left 1 bit
	ROL	$0003,X	;shift 4th byte left 1 bit
	ROL	$0002,X	;shift 3rd byte left 1 bit
	ROL	$0001,X	;shift 2nd byte left 1 bit
	ROL	$0000,X	;shift 1st byte left 1 bit
	ROL	FRX	;shift excess digit left 1 bit
	DEY
	BNE	SML2	;if not done

	RTS		;return
;	SPACE	4,10
;**	NORM - Normalize FR0
;*
;*	ENTRY	JSR	NORM
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


NORM	=	*		;entry
	LDX	#0
	STX	FRE		;byte to shift in
;	JMP	N0E		;normalize FR0/FRE, return
;	SPACE	4,10
;**	N0E - Normalize FR0/FRE
;*
;*	ENTRY	JSR	N0E
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


N0E	=	*		;entry
	LDX	#FMPREC-1	;mantissa size
	LDA	FR0		;exponent
	BEQ	N0E5		;if exponent zero, number is zero

N0E1	LDA	FR0M		;first byte of mantissa
	BNE	N0E3		;if not zero, no shift

;	Shift mantissa left 1 byte.

	LDY	#0		;offset to first byte of mantissa

N0E2	LDA	FR0M+1,Y	;byte to shift
	STA	FR0M,Y		;byte of destination
	INY
	CPY	#FMPREC		;size of mantissa
	BCC	N0E2		;if not done

;	Decrement exponent and check for completion.

	DEC	FR0		;decrement exponent
	DEX
	BNE	N0E1		;if not done

;	Check first byte of mantissa.

	LDA	FR0M	;first byte of mantissa
	BNE	N0E3	;if mantissa not zero

;	Zero exponent.

	STA	FR0	;zero exponent
	CLC
	RTS		;return

;	Check for overflow.

N0E3	LDA	FR0	;exponent
	AND	#$7F	;clear sign
	CMP	#$40+49	;bias+49
	BCC	N0E4	;if exponent < 49, no overflow

;	Return error.

;	SEC		;indicate error
	RTS		;return

;	Check for underflow.

N0E4	CMP	#$40-49
	BCS	N0E5	;if exponent >= -49, no underflow

;	Zero result.

	JSR	ZFR0	;zero FR0

;	Exit.

N0E5	CLC		;indicate no error
	RTS		;return
;	SPACE	4,10
;**	S0R - Shift FR0 Right
;*
;*	ENTRY	JSR	S0R
;*		A = shift count
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


S0R	=	*	;entry
	LDX	#FR0	;indicate shift of FR0
	BNE	SRR	;???, return
;	SPACE	4,10
;**	S1R - Shift FR1 Right
;*
;*	ENTRY	JSR	S1R
;*		A = shift count
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


S1R	=	*	;entry
	LDX	#FR1	;indicate shift of FR1
;	JMP	SRR	;???, return
;	SPACE	4,10
;**	SRR - Shift Register Right
;*
;*	ENTRY	JSR	SRR
;*		X = offset to register
;*		A = shift count
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SRR	=	*		;entry
	STX	ZTEMP3		;register
	STA	ZTEMP4		;shift count
	STA	ZTEMP4+1	;save shift count

SRR1	LDY	#FMPREC-1	;mantissa size-1

SRR2	LDA	$0004,X		;byte to shift
	STA	$0005,X		;byte of destination
	DEX
	DEY
	BNE	SRR2		;if not done

	LDA	#0
	STA	$0005,X		;first byte of mantissa
	LDX	ZTEMP3		;register
	DEC	ZTEMP4		;decrement shift count
	BNE	SRR1		;if not done

;	Adjust exponent.

	LDA	$0000,X		;exponent
	CLC
	ADC	ZTEMP4+1	;subtract shift count
	STA	$0000,X		;update exponent
	RTS			;return
;	SPACE	4,10
;**	S0ER - Shift FR0/FRE Right
;*
;*	ENTRY	JSR	S0ER
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


S0ER	=	*		;entry
	LDX	#FMPREC*2	;number of bytes to shift

S0ER1	LDA	FR0,X		;byte to shift
	STA	FR0+1,X		;byte of destination
	DEX
	BPL	S0ER1		;if not done

	LDA	#0
	STA	FR0		;shift in 0
	RTS			;return
;	SPACE	4,10
;**	C0A - Convert FR0 to ASCII
;*
;*	ENTRY	JSR	C0A
;*		A = decimal point position
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


C0A	=	*	;entry

;	Initialize.

	STA	ZTEMP4	;decimal point position counter
	LDX	#0	;offset to first byte of FR0M
	LDY	#0	;offset to first byte of LBUF

;	Convert next byte.

C0A1	JSR	TDP	;test for decimal point
	SEC
	SBC	#1	;decrement deciaml point position
	STA	ZTEMP4	;update deciaml point position counter

;	Convert first digit of next byte.

	LDA	FR0M,X	;byte
	LSR	A
	LSR	A
	LSR	A
	LSR	A	;first digit
	JSR	SNL	;store number in line buffer

;	Convert second digit of next byte.

	LDA	FR0M,X	;byte
	AND	#$0F	;extract second digit
	JSR	SNL	;store number in line buffer
	INX
	CPX	#FMPREC	;nuber of bytes
	BCC	C0A1	;if not done

;	Exit.

;	JMP	TDP	;test for decimal point, return
;	SPACE	4,10
;**	TDP - Test for Decimal Point
;*
;*	ENTRY	JSR	TDP
;*		ZTEMP4 = decimal point position counter
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


TDP	=	*	;entry

;	Check decimal point position counter.

	LDA	ZTEMP4	;decimal point position counter
	BNE	TDP1	;if not decimal point position, exit

;	Insert decimal point.

	LDA	#'.'
	JSR	SAL	;store ASCII character in line buffer

;	Exit.

TDP1	RTS		;return
;	SPACE	4,10
;**	SNL - Store Number in Line Buffer
;*
;*	ENTRY	JSR	SNL
;*		A = digit to store
;*		Y = offset
;*		??
;*
;*	EXIT
;*		ASCII digit placed in line buffer
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SNL	=	*	;entry
	ORA	#$30	;convert digit to ASCII
;	JMP	SAL	;store ASCII character in line buffer, return
;	SPACE	4,10
;**	SAL - Store ASCII Character in Line Buffer
;*
;*	ENTRY	JSR	SAL
;*		Y = offset
;*		A = character
;*		??
;*
;*	EXIT
;*		Character placed in line buffer
;*		Y = incremented offset
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SAL	=	*	;entry
	STA	LBUFF,Y	;store character in line buffer
	INY		;increment offset
	RTS		;return
;	SPACE	4,10
;**	FNZ - Find Last Non-zero Character in Line Buffer
;*
;*	FNZ returns the last non-zero character.  If the last
;*	non-zero character is ".", FNZ returns the character
;*	preceding the ".".  If no other non-zero character is
;*	encountered, FNZ returns the first character.
;*
;*	ENTRY	JSR	FNZ
;*		??
;*
;*	EXIT
;*		A = character
;*		X = offset to character
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


FNZ	=	*	;entry

;	Initialize.

	LDX	#10	;offset to last possible character

;	Check next character.

FNZ1	LDA	LBUFF,X	;character
	CMP	#'.'
	BEQ	FNZ2	;if ".", return preceding character

	CMP	#'0'
	BNE	FNZ3	;if not "0", exit

;	Decrement offset and check for completion.

	DEX
	BNE	FNZ1	;if not done

;	Return character preceding "." or first character.

FNZ2	DEX		;offset to character
	LDA	LBUFF,X	;character

;	Exit.

FNZ3	RTS		;return
;	SPACE	4,10
;**	GND - Get Next Digit
;*
;*	ENTRY	JSR	GND
;*		FR0 - FR0+5 = number
;*		??
;*
;*	EXIT
;*		A = digit
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


GND	=	*	;entry
	JSR	S0L	;shift FR0 left 1 digit
	LDA	FRX	;excess digit
	AND	#$0F	;extract low order digit
	RTS		;return
;	SPACE	4,10
;**	DLP - Decrement Line Buffer Pointer
;*
;*	ENTRY	JSR	DLP
;*		INBUFF - INBUFF+1 = line buffer pointer
;*		??
;*
;*	EXIT
;*		INBUFF - INBUFF+1 = incremented line buffer pointer
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DLP	=	*		;entry
	SEC
	LDA	INBUFF		;line buffer pointer
	SBC	#1		;subtract 1
	STA	INBUFF		;update line buffer pointer
	LDA	INBUFF+1
	SBC	#0
	STA	INBUFF+1
	RTS			;return
;	SPACE	4,10
;**	SUE - Set Up Exponent for Multiply or Divide
;*
;*	ENTRY	JSR	SUE
;*		??
;*
;*	EXIT
;*		A = FR0 exponent (without sign)
;*		FR1 = FR1 exponent (without sign)
;*		FRSIGN = sign of result
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SUE	=	*	;entry
	LDA	FR0	;FR0 exponent
	EOR	FR1	;EOR with FR1 exponent
	AND	#$80	;extract sign
	STA	FRSIGN	;sign of result
	ASL	FR1	;shift out FR1 sign
	LSR	FR1	;FR1 exponent without sign
	LDA	FR0	;FR0 exponent
	AND	#$7F	;FR0 exponent without sign
	RTS		;return
;	SPACE	4,10
;**	SUP - Set Up for Multiply or Divide
;*
;*	ENTRY	JSR	SUP
;*		A = exponent
;		CC - SET BY ADD OR SUB TO GET A??????
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SUP	=	*	;entry
	ORA	FRSIGN	;place sign in exponent
	STA	EEXP	;exponent
	LDA	#0
	STA	FR0	;clear FR0 exponent
	STA	FR1	;clear FR0 exponent
	JSR	M12	;move FR1 to FR2
	JSR	S2L	;shift FR2 left 1 digit
	LDA	FRX	;excess digit
	AND	#$0F	;extract low order digit
	STA	FR2	;shift in low order digit
	LDA	#FMPREC	;mantissa size
	STA	ZTEMP1	;mantissa size
	JSR	M0E	;move FR0 to FRE
	JSR	ZFR0	;zero FR0
	RTS		;return
;	SPACE	4,10
;**	FRA10 - Add FR1 to FR0
;*
;*	ENTRY	JSR	FRA10
;*		FR0 - FR0+5 = augend
;*		FR1 - FR1+5 = addend
;*		??
;*
;*	EXIT
;*		FR0 - FR0+5 = sum
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


FRA10	=	*		;entry
	LDX	#FR0+FPREC-1	;offset to last byte of FR0
	BNE	F1R		;???
;	SPACE	4,10
;**	FRA20 - Add FR2 to FR0
;*
;*	ENTRY	JSR	FRA20
;*		FR0 - FR0+5 = augend
;*		FR2 - FR2+5 = addend
;*		??
;*
;*	EXIT
;*		FR0 - FR0+5 = sum
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


FRA20	=	*		;entry
	LDX	#FR0+FPREC-1	;offset to last byte of FR0
	BNE	F2R		;???
;	SPACE	4,10
;**	FRA1E - Add FR1 to FRE
;*
;*	ENTRY	JSR	FRA1E
;*		FRE - FRE+5 = augend
;*		FR1 - FR1+5 = addend
;*		??
;*
;*	EXIT
;*		FRE - FRE+5 = sum
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


FRA1E	=	*		;entry
	LDX	#FRE+FPREC-1	;offset to last byte of FRE
;	JMP	F1R		;???, return
;	SPACE	4,10
;**	F1R - Add FR1 to Register
;*
;*	ENTRY	JSR	F1R
;*		X = offset to last byte of augend register
;*		FR1 - FR1+5 = addend
;*		??
;*
;*	EXIT
;*		Sum in augend register
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


F1R	=	*		;entry
	LDY	#FR1+FPREC-1	;offset to last byte of FR1
	BNE	FARR		;???
;	SPACE	4,10
;**	FRA2E - Add FR2 to FRE
;*
;*	ENTRY	JSR	FRA2E
;*		FRE - FRE+5 = augend
;*		FR2 - FR2+5 = addend
;*		??
;*
;*	EXIT
;*		FRE - FRE+5 = sum
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


FRA2E	=	*		;entry
	LDX	#FRE+FPREC-1	;offset to last byte of FRE
;	JMP	F2R		;???, return
;	SPACE	4,10
;**	F2R - Add FR2 to Register
;*
;*	ENTRY	JSR	F2R
;*		X = offset to last byte of augend register
;*		FR2 - FR2+5 = addend
;*		??
;*
;*	EXIT
;*		Sum in augend register
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


F2R	=	*		;entry
	LDY	#FR2+FPREC-1	;offset to last byte of FR2
;	JMP	FARR		;???, return
;	SPACE	4,10
;**	FARR - Add Register to Register
;*
;*	ENTRY	JSR	FARR
;*		X = offset to last byte of augend register
;*		Y = offset to last byte of addend register
;*		??
;*
;*	EXIT
;*		Sum in augend register
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


FARR	=	*		;entry

;	Initialize.

	LDA	#FPREC-1	;floating point number size-1
	STA	ZTEMP4		;byte count
	CLC
	SED

;	Add.

FARR1	LDA	$0000,X		;byte of augend
	ADC	$0000,Y		;add byte of addend
	STA	$0000,X		;update byte of augend
	DEX
	DEY
	DEC	ZTEMP4		;decrement byte count
	BPL	FARR1		;if not done

;	Exit.

	CLD
	RTS			;return
;	SPACE	4,10
;**	M12 - Move FR1 to FR2
;*
;*	ENTRY	JSR	M12
;*		FR1 - FR1+5 = number to move
;*		??
;*
;*	EXIT
;*		FR2 - FR2+5 = moved number
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


M12	=	*		;entry
	LDY	#FPREC-1	;offset to last byte

M121	LDA	FR1,Y		;byte of source
	STA	FR2,Y		;byte of destination
	DEY
	BPL	M121		;if not done

	RTS			;return
;	SPACE	4,10
;**	M0E - Move FR0 to FRE
;*
;*	ENTRY	JSR	M0E
;*		FR0 - FR0+5 = number to move
;*		??
;*
;*	EXIT
;*		FRE - FRE+5 = moved number
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


M0E	=	*		;entry
	LDY	#FPREC-1	;offset to last byte

M0E1	LDA	FR0,Y		;byte of source
	STA	FRE,Y		;byte of destination
	DEY
	BPL	M0E1		;if not done

	RTS			;return
;	SPACE	4,10
	FIX	PLYEVL
;	SPACE	4,10
;**	PLYEVL - Evaluate Polynomial
;*
;*	Y = A(0)+A(1)*X+A(2)*X^2+...+A(N)*X^N
;*
;*	ENTRY	JSR	PLYEVL
;*		X = low address of coefficient table
;*		Y = high address of coefficient table
;*		FR0 - FR0+5 = X argument
;*		A = N+1
;*		??
;*
;*	EXIT
;*		FR0 - FR0+5 = Y result
;*		??
;*
;*	CHANGES
;*		USES FPTR2, PLYCNT, PLYARG
;*		??
;*
;*	CALLS
;*		CALLS FST0R, FMOVE, FLD1R, FADD, FMUL
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;PLYEVL	=	*		;entry

	STX	FPTR2		;save pointer to coefficients
	STY	FPTR2+1
	STA	PLYCNT		;degree
	LDX	#low PLYARG
	LDY	#high PLYARG
	JSR	FST0R		;save argument
	JSR	FMOVE		;move argument to FR1
	LDX	FPTR2
	LDY	FPTR2+1
	JSR	FLD0R		;initialize sum in FR0
	DEC	PLYCNT		;decrement degree
	BEQ	PLY3		;if complete, exit

PLY1	JSR	FMUL		;argument times current sum
	BCS	PLY3		;if overflow

	CLC
	LDA	FPTR2		;current low coefficient address
	ADC	#FPREC		;add floating point number size
	STA	FPTR2		;update low coefficient address
	BCC	PLY2		;if no carry

	LDA	FPTR2+1		;current high coefficceint address
	ADC	#0		;adjust high coefficient address
	STA	FPTR2+1		;update high coefficient address

PLY2	LDX	FPTR2		;low coefficient address
	LDY	FPTR2+1		;high coefficient address
	JSR	FLD1R		;get next coefficient
	JSR	FADD		;add coefficient to argument times sum
	BCS	PLY3		;if overflow

	DEC	PLYCNT		;decrement degree
	BEQ	PLY3		;if complete, exit

	LDX	#low PLYARG	;low argument address
	LDY	#high PLYARG	;high argument address
	JSR	FLD1R		;get argument
	BMI	PLY1		;continue

PLY3	RTS			;return
;	SPACE	4,10
	FIX	FLD0R
;	SPACE	4,10
;**	FLD0R - ???
;*
;*	ENTRY	JSR	FLD0R
;*		X = low pointer
;*		Y = high pointer
;*		??
;*
;*	EXIT
;*		FR0 loaded
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FLD0R	=	*		;entry
	STX	FLPTR		;low pointer
	STY	FLPTR+1		;high pointer
;	JMP	FLD0P		;???, return
;	SPACE	4,10
	FIX	FLD0P
;	SPACE	4,10
;**	FLD0P - ???
;*
;*	ENTRY	JSR	FLD0P
;*		FLPTR - FLPTR+1 = pointer
;*		??
;*
;*	EXIT
;*		FR0 loaded
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FLD0P	=	*		;entry

	LDY	#FPREC-1	;offset to last byte

FLD01	LDA	(FLPTR),Y	;byte of source
	STA	FR0,Y		;byte of destination
	DEY
	BPL	FLD01		;if not done

	RTS			;return
;	SPACE	4,10
	FIX	FLD1R
;	SPACE	4,10
;**	FLD1R - ???
;*
;*	ENTRY	JSR	FLD1R
;*		X = low pointer
;*		Y = high pointer
;*		??
;*
;*	EXIT
;*		FR1 loaded
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FLD1R	=	*		;entry
	STX	FLPTR		;low pointer
	STY	FLPTR+1		;high pointer
;	JMP	FLD1P		;???, return
;	SPACE	4,10
	FIX	FLD1P
;	SPACE	4,10
;**	FLD1P - ???
;*
;*	ENTRY	JSR	FLD1P
;*		FLPTR - FLPTR+1 = pointer
;*		??
;*
;*	EXIT
;*		FR1 loaded
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FLD1P	=	*		;entry

	LDY	#FPREC-1	;offset to last byte

FLD11	LDA	(FLPTR),Y	;byte of source
	STA	FR1,Y		;byte of destination
	DEY
	BPL	FLD11		;if not done

	RTS			;return
;	SPACE	4,10
	FIX	FST0R
;	SPACE	4,10
;**	FST0R - ???
;*
;*	ENTRY	JSR	FST0R
;*		FR0 - FR0+5 = number
;*		X = low pointer
;*		Y = high pointer
;*		??
;*
;*	EXIT
;*		FR0 stored
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FST0R	=	*		;entry
	STX	FLPTR		;low pointer
	STY	FLPTR+1		;high pointer
;	JMP	FST0P		;???, return
;	SPACE	4,10
	FIX	FST0P
;	SPACE	4,10
;**	FST0P - ???
;*
;*	ENTRY	JSR	FST0P
;*		FR0 - FR0+5 = number
;*		FLPTR - FLPTR+1 = pointer
;*		??
;*
;*	EXIT
;*		FR0 stored
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FST0P	=	*		;entry

	LDY	#FPREC-1	;offset to last byte

FST01	LDA	FR0,Y		;byte of source
	STA	(FLPTR),Y	;byte of destination
	DEY
	BPL	FST01		;if not done

	RTS			;return
;	SPACE	4,10
	FIX	FMOVE
;	SPACE	4,10
;**	FMOVE - ???
;
;	MOVE FR0 TO FR1
;*
;*	ENTRY	JSR	FMOVE
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;FMOVE	=	*		;entry

	LDX	#FPREC-1	;offset to last byte

FMO1	LDA	FR0,X		;byte of source
	STA	FR1,X		;byte of destination
	DEX
	BPL	FMO1		;if not done

	RTS			;return
;	SPACE	4,10
	FIX	EXP
;	SPACE	4,10
;**	EXP - ???
;*
;*	ENTRY	JSR	EXP
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;EXP	=	*		;entry

;	Initialize.

	LDX	#low LOG10E	;base 10 logarithm of e
	LDY	#high LOG10E
	JSR	FLD1R		;load FR1

;	Compute X*LOG10(E).

	JSR	FMUL		;multiply
	BCS	EXP6		;if overflow, error

;	Compute result = 10^(X*LOG10(E)).

;	JMP	EXP10		;???, return
;	SPACE	4,10
	FIX	EXP10
;	SPACE	4,10
;**	EXP10 - ???
;*
;*	ENTRY	JSR	EXP10
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;EXP10	=	*		;entry

;	Initialize.

	LDA	#0
	STA	XFMFLG		;zero integer part
	LDA	FR0
	STA	SGNFLG		;save argument sign
	AND	#$7F		;extract absolute value
	STA	FR0		;update argument

;	Check for argument less than 1.

	SEC
	SBC	#$40		;subtract bias
	BMI	EXP1		;if argument < 1

;	Extract integer and fractional parts of exponent.

	CMP	#FPREC-2
	BPL	EXP6		;if argument too big, error

	LDX	#low FPSCR
	LDY	#high FPSCR
	JSR	FST0R		;save argument
	JSR	FPI		;convert argument to integer
	LDA	FR0
	STA	XFMFLG		;save interger part
	LDA	FR0+1		;most significant byte of integer part
	BNE	EXP6		;if integer part too large, error

	JSR	IFP		;convert integer part to floating point
	JSR	FMOVE		;???
	LDX	#low FPSCR
	LDY	#high FPSCR
	JSR	FLD0R		;argument
	JSR	FSUB		;subtract to get fractional part

;	Compute 10 to fractional exponent.

EXP1	LDA	#NPCOEF
	LDX	#low P10COF
	LDY	#high P10COF
	JSR	PLYEVL		;P(X)
	JSR	FMOVE
	JSR	FMUL		;P(X)*P(X)

;	Check integer part.

	LDA	XFMFLG		;integer part
	BEQ	EXP4		;if integer part zero

;	Compute 10 to integer part.

	CLC
	ROR	A		;integer part divided by 2
	STA	FR1		;exponent
	LDA	#1		;assume mantissa 1
	BCC	EXP2		;if integer part even

	LDA	#$10		;substitute mantissa 10

EXP2	STA	FR1M		;mantissa
	LDX	#FMPREC-1	;offset to last byte of mantissa
	LDA	#0

EXP3	STA	FR1M+1,X	;zero byte of mantissa
	DEX
	BPL	EXP3		;if not done

	LDA	FR1		;exponent
	CLC
	ADC	#$40		;add bias
	BCS	EXP6		;if too big, error

	BMI	EXP6		;if underflow????, error

	STA	FR1		;10 to integer part

;	Compute product of 10 to integer part and 10 to fractional part.

	JSR	FMUL		;multiply to get result

;	Invert result if argument < 0.

EXP4	LDA	SGNFLG		;argument sign
	BPL	EXP5		;if argument >= 0

	JSR	FMOVE		;???
	LDX	#low FONE
	LDY	#high FONE
	JSR	FLD0R		;???
	JSR	FDIV		;divide to get result

;	Exit.

EXP5	RTS			;return

;	Return error.

EXP6	SEC			;indicate error
	RTS			;return
;	SPACE	4,10
;**	P10COF - ???


P10COF	DB	$3D,$17,$94,$19,$00,$00	;0.0000179419
	DB	$3D,$57,$33,$05,$00,$00	;0.0000573305
	DB	$3E,$05,$54,$76,$62,$00	;0.0005547662
	DB	$3E,$32,$19,$62,$27,$00	;0.0032176227
	DB	$3F,$01,$68,$60,$30,$36	;0.0168603036
	DB	$3F,$07,$32,$03,$27,$41	;0.0732032741
	DB	$3F,$25,$43,$34,$56,$75	;0.2543345675
	DB	$3F,$66,$27,$37,$30,$50	;0.6627373050
	DB	$40,$01,$15,$12,$92,$55	;1.15129255
	DB	$3F,$99,$99,$99,$99,$99	;0.9999999999

NPCOEF	=	(*-P10COF)/FPREC
;	SPACE	4,10
;**	LOG10E - Base 10 Logarithm of e


LOG10E	DB	$3F,$43,$42,$94,$48,$19	;base 10 logarithm of e
;	SPACE	4,10
;**	FONE - 1.0


FONE	DB	$40,$01,$00,$00,$00,$00	;1.0
;	SPACE	4,10
;**	XFORM - ???
;*
;*	Z = (X-C)/(X+C)
;*
;*	ENTRY	JSR	XFORM
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


XFORM	=	*		;entry
	STX	FPTR2
	STY	FPTR2+1
	LDX	#low PLYARG
	LDY	#high PLYARG
	JSR	FST0R		;save argument
	LDX	FPTR2
	LDY	FPTR2+1
	JSR	FLD1R		;???
	JSR	FADD		;X+C
	LDX	#low FPSCR
	LDY	#high FPSCR
	JSR	FST0R		;???
	LDX	#low PLYARG
	LDY	#high PLYARG
	JSR	FLD0R		;???
	LDX	FPTR2
	LDY	FPTR2+1
	JSR	FLD1R		;???
	JSR	FSUB		;X-C
	LDX	#low FPSCR
	LDY	#high FPSCR
	JSR	FLD1R		;???
	JSR	FDIV		;divide to get result
	RTS			;return
;	SPACE	4,10
	FIX	LOG
;	SPACE	4,10
;**	LOG - ???
;*
;*	ENTRY	JSR	LOG
;*		FR0 - FR0+5 = argument
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;LOG	=	*	;entry

	LDA	#1	;indicate base e logarithm
	BNE	LOGS	;compute logartihm, return
;	SPACE	4,10
	FIX	LOG10
;	SPACE	4,10
;**	LOG10 - ???
;*
;*	ENTRY	JSR	LOG10
;*		FR0 - FR0+5 = argument
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


;LOG10	=	*	;entry

	LDA	#0	;indicate base 10 logartihm
;	JMP	LOGS	;compute logarithm, return
;	SPACE	4,10
;**	LOGS - Compute Logarithm
;*
;*	ENTRY	JSR	LOGS
;*		A = 0, if base 10 logarithm
;*		  = 1, if base e logartihm
;*		FR0 - FR0+5 = argument
;*		??
;*
;*	EXIT
;*		C set, if error
;*		C clear, if no error
;*		FR0 - FR0+5 = result
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


LOGS	=	*	;entry

;	Initialize.

	STA	SGNFLG	;save logarithm base indicator

;	Check argument.

	LDA	FR0	;argument exponent
	BEQ	LOGS1	;if argument zero, error

	BMI	LOGS1	;if argument negative, error

;	X = F*(10^Y), 1<F<10
;	10^Y HAS SAME EXP BYTE AS X
;	& MANTISSA BYTE = 1 OR 10

	JMP	LOGQ	;???, return

;	Return error.

LOGS1	SEC		;indicate error
	RTS		;return
;	SPACE	4,10
;**	LOGC - Complete Computation of Logarithm
;*
;*	ENTRY	JSR	LOGC
;*		SGNFLG = 0, if base 10 logarithmr
;*		       = 1, if base e logarithm
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: logic is convoluted because LOGQ code
;*		was moved.
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


LOGC	=	*		;entry

;	Initialize.

	SBC	#$40
	ASL	A
	STA	XFMFLG		;save Y
	LDA	FR0+1
	AND	#$F0
	BNE	LOGC2		;if ???

	LDA	#1		;mantissa is 1
	BNE	LOGC3		;set mantissa

LOGC2	INC	XFMFLG		;increment Y
	LDA	#$10		;mantissa is 10

LOGC3	STA	FR1M		;mantissa
	LDX	#FMPREC-1	;offset to last byte of mantissa
	LDA	#0

LOGC4	STA	FR1M+1,X	;zero byte of mantissa
	DEX
	BPL	LOGC4		;if not done

	JSR	FDIV		;???X = X/(10^Y), S.B. IN (1,10)

;	Compute LOG10(X), 1 <= X <= 10.

	LDX	#low SQR10
	LDY	#high SQR10
	JSR	XFORM		;Z = (X-C)/(X+C); C*C = 10
	LDX	#low FPSCR
	LDY	#high FPSCR
	JSR	FST0R		;SAVE Z
	JSR	FMOVE		;???
	JSR	FMUL		;Z*Z
	LDA	#NLCOEF
	LDX	#low LGCOEF
	LDY	#high LGCOEF
	JSR	PLYEVL		;P(Z*Z)
	LDX	#low FPSCR
	LDY	#high FPSCR
	JSR	FLD1R		;???
	JSR	FMUL		;Z*P(Z*Z)
	LDX	#low FHALF
	LDY	#high FHALF
	JSR	FLD1R
	JSR	FADD		;0.5 + Z*P(Z*Z)
	JSR	FMOVE		;???
	LDA	#0
	STA	FR0+1
	LDA	XFMFLG
	STA	FR0
	BPL	LOGC5		;if ???

	EOR	#<-$01		;complement sign???
	CLC
	ADC	#1
	STA	FR0

LOGC5	JSR	IFP		;convert integer to floating point
	BIT	XFMFLG
	BPL	LOGC6		;if ???

	LDA	#$80
	ORA	FR0
	STA	FR0		;update exponent

LOGC6	JSR	FADD		;LOG(X) = LOG(X)+Y

;	Check base of logarithm.

	LDA	SGNFLG		;logarithm base indicator
	BEQ	LOGC7		;if LOG10 (not LOG)

;	Compute base e logarithm.

	LDX	#low LOG10E	;base 10 logarithm of e
	LDY	#high LOG10E
	JSR	FLD1R		;???
	JSR	FDIV		;result is LOG(X) divided by LOG10(e)

;	Exit.

LOGC7	CLC			;indicate success
	RTS			;return
;	SPACE	4,10
;**	SQR10 - Square Root of 10


SQR10	DB	$40,$03,$16,$22,$77,$66	;square root of 10
;	SPACE	4,10
;**	FHALF - 0.5


FHALF	DB	$3F,$50,$00,$00,$00,$00	;0.5
;	SPACE	4,10
;**	LGCOEF - Logartihm Coefficients


LGCOEF	DB	$3F,$49,$15,$57,$11,$08	;0.4915571108
	DB	$BF,$51,$70,$49,$47,$08	;-0.5170494708
	DB	$3F,$39,$20,$57,$61,$95	;0.3920576195
	DB	$BF,$04,$39,$63,$03,$55	;-0.0439630355
	DB	$3F,$10,$09,$30,$12,$64	;0.1009301264
	DB	$3F,$09,$39,$08,$04,$60	;0.0939080460
	DB	$3F,$12,$42,$58,$47,$42	;0.1242584742
	DB	$3F,$17,$37,$12,$06,$08	;0.1737120608
	DB	$3F,$28,$95,$29,$71,$17	;0.2895297117
	DB	$3F,$86,$85,$88,$96,$44	;0.8685889644

NLCOEF	=	(*-LGCOEF)/FPREC
;	SPACE	4,10
;**	ATCOEF - Arctangent Coefficients
;*
;*	NOTES
;*		Problem: not used.


	DB	$3E,$16,$05,$44,$49,$00	;0.001605444900
	DB	$BE,$95,$68,$38,$45,$00	;-0.009568384500
	DB	$3F,$02,$68,$79,$94,$16	;0.0268799416
	DB	$BF,$04,$92,$78,$90,$80	;-0.0492789080
	DB	$3F,$07,$03,$15,$20,$00	;0.0703152000
	DB	$BF,$08,$92,$29,$12,$44	;-0.0892291244
	DB	$3F,$11,$08,$40,$09,$11	;0.1108400911
	DB	$BF,$14,$28,$31,$56,$04	;-0.1428315604
	DB	$3F,$19,$99,$98,$77,$44	;0.1999987744
	DB	$BF,$33,$33,$33,$31,$13	;-0.3333333113
	DB	$3F,$99,$99,$99,$99,$99	;0.9999999999

	DB	$3F,$78,$53,$98,$16,$34	;pi/4 = arctan 1
;	SPACE	4,10
;**	LOGQ - ???
;*
;*	ENTRY	JSR	LOGQ
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: logic is convoluted because this code was
;*		moved.
;*		Problem: for readability, this might be relocated
;*		before tables.
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


LOGQ	=	*	;entry
	LDA	FR0	;???
	STA	FR1	;???
	SEC
	JMP	LOGC	;???, return
;	SUBTTL	'Domestic Character Set'
;	SPACE	4,10
	FIX	DCSORG
;	SPACE	4,10
;**	Domestic Character Set


	DB	$00,$00,$00,$00,$00,$00,$00,$00	;$00 - space
	DB	$00,$18,$18,$18,$18,$00,$18,$00	;$01 - !
	DB	$00,$66,$66,$66,$00,$00,$00,$00	;$02 - "
	DB	$00,$66,$FF,$66,$66,$FF,$66,$00	;$03 - #
	DB	$18,$3E,$60,$3C,$06,$7C,$18,$00	;$04 - $
	DB	$00,$66,$6C,$18,$30,$66,$46,$00	;$05 - %
	DB	$1C,$36,$1C,$38,$6F,$66,$3B,$00	;$06 - &
	DB	$00,$18,$18,$18,$00,$00,$00,$00	;$07 - '
	DB	$00,$0E,$1C,$18,$18,$1C,$0E,$00	;$08 - (
	DB	$00,$70,$38,$18,$18,$38,$70,$00	;$09 - )
	DB	$00,$66,$3C,$FF,$3C,$66,$00,$00	;$0A - asterisk
	DB	$00,$18,$18,$7E,$18,$18,$00,$00	;$0B - plus
	DB	$00,$00,$00,$00,$00,$18,$18,$30	;$0C - comma
	DB	$00,$00,$00,$7E,$00,$00,$00,$00	;$0D - minus
	DB	$00,$00,$00,$00,$00,$18,$18,$00	;$0E - period
	DB	$00,$06,$0C,$18,$30,$60,$40,$00	;$0F - /

	DB	$00,$3C,$66,$6E,$76,$66,$3C,$00	;$10 - 0
	DB	$00,$18,$38,$18,$18,$18,$7E,$00	;$11 - 1
	DB	$00,$3C,$66,$0C,$18,$30,$7E,$00	;$12 - 2
	DB	$00,$7E,$0C,$18,$0C,$66,$3C,$00	;$13 - 3
	DB	$00,$0C,$1C,$3C,$6C,$7E,$0C,$00	;$14 - 4
	DB	$00,$7E,$60,$7C,$06,$66,$3C,$00	;$15 - 5
	DB	$00,$3C,$60,$7C,$66,$66,$3C,$00	;$16 - 6
	DB	$00,$7E,$06,$0C,$18,$30,$30,$00	;$17 - 7
	DB	$00,$3C,$66,$3C,$66,$66,$3C,$00	;$18 - 8
	DB	$00,$3C,$66,$3E,$06,$0C,$38,$00	;$19 - 9
	DB	$00,$00,$18,$18,$00,$18,$18,$00	;$1A - colon
	DB	$00,$00,$18,$18,$00,$18,$18,$30	;$1B - semicolon
	DB	$06,$0C,$18,$30,$18,$0C,$06,$00	;$1C - <
	DB	$00,$00,$7E,$00,$00,$7E,$00,$00	;$1D - =
	DB	$60,$30,$18,$0C,$18,$30,$60,$00	;$1E - >
	DB	$00,$3C,$66,$0C,$18,$00,$18,$00	;$1F - ?

	DB	$00,$3C,$66,$6E,$6E,$60,$3E,$00	;$20 - @
	DB	$00,$18,$3C,$66,$66,$7E,$66,$00	;$21 - A
	DB	$00,$7C,$66,$7C,$66,$66,$7C,$00	;$22 - B
	DB	$00,$3C,$66,$60,$60,$66,$3C,$00	;$23 - C
	DB	$00,$78,$6C,$66,$66,$6C,$78,$00	;$24 - D
	DB	$00,$7E,$60,$7C,$60,$60,$7E,$00	;$25 - E
	DB	$00,$7E,$60,$7C,$60,$60,$60,$00	;$26 - F
	DB	$00,$3E,$60,$60,$6E,$66,$3E,$00	;$27 - G
	DB	$00,$66,$66,$7E,$66,$66,$66,$00	;$28 - H
	DB	$00,$7E,$18,$18,$18,$18,$7E,$00	;$29 - I
	DB	$00,$06,$06,$06,$06,$66,$3C,$00	;$2A - J
	DB	$00,$66,$6C,$78,$78,$6C,$66,$00	;$2B - K
	DB	$00,$60,$60,$60,$60,$60,$7E,$00	;$2C - L
	DB	$00,$63,$77,$7F,$6B,$63,$63,$00	;$2D - M
	DB	$00,$66,$76,$7E,$7E,$6E,$66,$00	;$2E - N
	DB	$00,$3C,$66,$66,$66,$66,$3C,$00	;$2F - O

	DB	$00,$7C,$66,$66,$7C,$60,$60,$00	;$30 - P
	DB	$00,$3C,$66,$66,$66,$6C,$36,$00	;$31 - Q
	DB	$00,$7C,$66,$66,$7C,$6C,$66,$00	;$32 - R
	DB	$00,$3C,$60,$3C,$06,$06,$3C,$00	;$33 - S
	DB	$00,$7E,$18,$18,$18,$18,$18,$00	;$34 - T
	DB	$00,$66,$66,$66,$66,$66,$7E,$00	;$35 - U
	DB	$00,$66,$66,$66,$66,$3C,$18,$00	;$36 - V
	DB	$00,$63,$63,$6B,$7F,$77,$63,$00	;$37 - W
	DB	$00,$66,$66,$3C,$3C,$66,$66,$00	;$38 - X
	DB	$00,$66,$66,$3C,$18,$18,$18,$00	;$39 - Y
	DB	$00,$7E,$0C,$18,$30,$60,$7E,$00	;$3A - Z
	DB	$00,$1E,$18,$18,$18,$18,$1E,$00	;$3B - [
	DB	$00,$40,$60,$30,$18,$0C,$06,$00	;$3C - \
	DB	$00,$78,$18,$18,$18,$18,$78,$00	;$3D - ]
	DB	$00,$08,$1C,$36,$63,$00,$00,$00	;$3E - ^
	DB	$00,$00,$00,$00,$00,$00,$FF,$00	;$3F - underline

	DB	$00,$36,$7F,$7F,$3E,$1C,$08,$00	;$40 - heart card
	DB	$18,$18,$18,$1F,$1F,$18,$18,$18	;$41 - mid left window
	DB	$03,$03,$03,$03,$03,$03,$03,$03	;$42 - right box
	DB	$18,$18,$18,$F8,$F8,$00,$00,$00	;$43 - low right window
	DB	$18,$18,$18,$F8,$F8,$18,$18,$18	;$44 - mid right window
	DB	$00,$00,$00,$F8,$F8,$18,$18,$18	;$45 - up right window
	DB	$03,$07,$0E,$1C,$38,$70,$E0,$C0	;$46 - right slant box
	DB	$C0,$E0,$70,$38,$1C,$0E,$07,$03	;$47 - left slant box
	DB	$01,$03,$07,$0F,$1F,$3F,$7F,$FF	;$48 - right slant solid
	DB	$00,$00,$00,$00,$0F,$0F,$0F,$0F	;$49 - low right solid
	DB	$80,$C0,$E0,$F0,$F8,$FC,$FE,$FF	;$4A - left slant solid
	DB	$0F,$0F,$0F,$0F,$00,$00,$00,$00	;$4B - up right solid
	DB	$F0,$F0,$F0,$F0,$00,$00,$00,$00	;$4C - up left solid
	DB	$FF,$FF,$00,$00,$00,$00,$00,$00	;$4D - top box
	DB	$00,$00,$00,$00,$00,$00,$FF,$FF	;$4E - bottom box
	DB	$00,$00,$00,$00,$F0,$F0,$F0,$F0	;$4F - low left solid

	DB	$00,$1C,$1C,$77,$77,$08,$1C,$00	;$50 - club card
	DB	$00,$00,$00,$1F,$1F,$18,$18,$18	;$51 - up left window
	DB	$00,$00,$00,$FF,$FF,$00,$00,$00	;$52 - mid box
	DB	$18,$18,$18,$FF,$FF,$18,$18,$18	;$53 - mid window
	DB	$00,$00,$3C,$7E,$7E,$7E,$3C,$00	;$54 - solid circle
	DB	$00,$00,$00,$00,$FF,$FF,$FF,$FF	;$55 - bottom solid
	DB	$C0,$C0,$C0,$C0,$C0,$C0,$C0,$C0	;$56 - left box
	DB	$00,$00,$00,$FF,$FF,$18,$18,$18	;$57 - up mid window
	DB	$18,$18,$18,$FF,$FF,$00,$00,$00	;$58 - low mid window
	DB	$F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0	;$59 - left solid
	DB	$18,$18,$18,$1F,$1F,$00,$00,$00	;$5A - low left window
	DB	$78,$60,$78,$60,$7E,$18,$1E,$00	;$5B - display escape
	DB	$00,$18,$3C,$7E,$18,$18,$18,$00	;$5C - up arrow
	DB	$00,$18,$18,$18,$7E,$3C,$18,$00	;$5D - down arrow
	DB	$00,$18,$30,$7E,$30,$18,$00,$00	;$5E - left arrow
	DB	$00,$18,$0C,$7E,$0C,$18,$00,$00	;$5F - right arrow

	DB	$00,$18,$3C,$7E,$7E,$3C,$18,$00	;$60 - diamond card
	DB	$00,$00,$3C,$06,$3E,$66,$3E,$00	;$61 - a
	DB	$00,$60,$60,$7C,$66,$66,$7C,$00	;$62 - b
	DB	$00,$00,$3C,$60,$60,$60,$3C,$00	;$63 - c
	DB	$00,$06,$06,$3E,$66,$66,$3E,$00	;$64 - d
	DB	$00,$00,$3C,$66,$7E,$60,$3C,$00	;$65 - e
	DB	$00,$0E,$18,$3E,$18,$18,$18,$00	;$66 - f
	DB	$00,$00,$3E,$66,$66,$3E,$06,$7C	;$67 - g
	DB	$00,$60,$60,$7C,$66,$66,$66,$00	;$68 - h
	DB	$00,$18,$00,$38,$18,$18,$3C,$00	;$69 - i
	DB	$00,$06,$00,$06,$06,$06,$06,$3C	;$6A - j
	DB	$00,$60,$60,$6C,$78,$6C,$66,$00	;$6B - k
	DB	$00,$38,$18,$18,$18,$18,$3C,$00	;$6C - l
	DB	$00,$00,$66,$7F,$7F,$6B,$63,$00	;$6D - m
	DB	$00,$00,$7C,$66,$66,$66,$66,$00	;$6E - n
	DB	$00,$00,$3C,$66,$66,$66,$3C,$00	;$6F - o

	DB	$00,$00,$7C,$66,$66,$7C,$60,$60	;$70 - p
	DB	$00,$00,$3E,$66,$66,$3E,$06,$06	;$71 - q
	DB	$00,$00,$7C,$66,$60,$60,$60,$00	;$72 - r
	DB	$00,$00,$3E,$60,$3C,$06,$7C,$00	;$73 - s
	DB	$00,$18,$7E,$18,$18,$18,$0E,$00	;$74 - t
	DB	$00,$00,$66,$66,$66,$66,$3E,$00	;$75 - u
	DB	$00,$00,$66,$66,$66,$3C,$18,$00	;$76 - v
	DB	$00,$00,$63,$6B,$7F,$3E,$36,$00	;$77 - w
	DB	$00,$00,$66,$3C,$18,$3C,$66,$00	;$78 - x
	DB	$00,$00,$66,$66,$66,$3E,$0C,$78	;$79 - y
	DB	$00,$00,$7E,$0C,$18,$30,$7E,$00	;$7A - z
	DB	$00,$18,$3C,$7E,$7E,$18,$3C,$00	;$7B - spade card
	DB	$18,$18,$18,$18,$18,$18,$18,$18	;$7C - |
	DB	$00,$7E,$78,$7C,$6E,$66,$06,$00	;$7D - display clear
	DB	$08,$18,$38,$78,$38,$18,$08,$00	;$7E - display backspace
	DB	$10,$18,$1C,$1E,$1C,$18,$10,$00	;$7F - display tab
;	SUBTTL	'Device Handler Vector Tables'
;	SPACE	4,10
	FIX	EDITRV
;	SPACE	4,10
;
; SCREEN EDITOR HANDLER ENTRY POINT
;
        DW      EOPEN-1
        DW      RETUR1-1    ;(CLOSE)
        DW      EGETCH-1
        DW      EOUTCH-1
        DW      RETUR1-1    ;(STATUS)
        DW      NOFUNC-1    ;(SPECIAL)
        JMP     PWRONA
        DB      0           ;ROM FILLER BYTE
;	SPACE	4,10
	FIX	SCRENV
;	SPACE	4,10
;
; DISPLAY HANDLER ENTRY POINT
;
        DW      DOPEN-1
        DW      RETUR1-1    ;(CLOSE)
        DW      GETCH-1
        DW      OUTCH-1
        DW      RETUR1-1    ;(STATUS)
        DW      DRAW-1      ;(SPECIAL)
        JMP     PWRONA
        DB      0           ;ROM FILLER BYTE
;	SPACE	4,10
	FIX	KEYBDV
;	SPACE	4,10
;
;
; KEYBOARD HANDLER ENTRY POINT
;
        DW      RETUR1-1
        DW      RETUR1-1    ;(CLOSE)
        DW      KGETCH-1
        DW      NOFUNC-1    ;(OUTCH)
        DW      RETUR1-1    ;(STATUS)
        DW      NOFUNC-1    ;(SPECIAL)
        JMP     PWRONA
        DB      0           ;ROM FILLER BYTE
;	SPACE	4,10
	FIX	PRINTV
;	SPACE	4,10
;**	PRINTV - Printer Handler Vector Table


	DW	PHOPEN-1	;perform printer OPEN
	DW	PHCLOS-1	;perform printer CLOSE
	DW	BADST-1		;perform printer GET
	DW	PHWRIT-1	;perform printer PUT-BYTE
	DW	PHSTAT-1	;perform printer STATUS
	DW	BADST-1		;perform printer SPECIAL
	JMP	PHINIT		;initialize printer
	DB	0	;reserved
;	SPACE	4,10
	FIX	CASETV
;	SPACE	4,10
;**	CASETV - Cassette Handler Vector Table


	DW	OPENC-1		;perform cassette OPEN
	DW	CLOSEC-1	;perform cassette CLOSE
	DW	GBYTE-1		;perform cassette GET-BYTE
	DW	PBYTE-1		;perform cassette PUT-BYTE
	DW	STATU-1		;perform cassette STATUS
	DW	SPECIAL-1	;perform cassette SPECIAL
	JMP	INIT		;initialize cassette
	DB	0	;reserved
	SUBTTL	'Jump Vectors'
;	SPACE	4,10
;**	Jump Vectors


	FIX	DINITV
	JMP	IDIO	;initialize DIO

	FIX	DSKINV
	JMP	DIO	;perform DIO

	FIX	CIOV
	JMP	CIO	;perform CIO

	FIX	SIOV
	JMP	SIO	;perform SIO

	FIX	SETVBV
	JMP	SVP	;set VBLANK parameters

	FIX	SYSVBV
	JMP	IVNM	;process immediate VBLANK NMI

	FIX	XITVBV
	JMP	DVNM	;process deferred VBLANK NMI

	FIX	SIOINV
	JMP	ISIO	;initialize SIO

	FIX	SENDEV
	JMP	ESS	;enable SIO SEND

	FIX	INTINV
	JMP	IIH	;initialize interrupt handler

	FIX	CIOINV
	JMP	ICIO	;initialize CIO

	FIX	BLKBDV
	JMP	PPD	;perform power-up display

	FIX	WARMSV
	JMP	PWS	;perform warmstart

	FIX	COLDSV
	JMP	PCS	;perform coldstart

	FIX	RBLOKV
        JMP     RBLOK	;read cassette block

	FIX	CSOPIV
        JMP     OPINP	;open cassette for input

	FIX	PUPDIV
	JMP	PPD	;perform power-up display

	FIX	SLFTSV
	JMP	STH	;self-test hardware

	FIX	PHENTV
	JMP	PHE	;peripheral handler entry

	FIX	PHUNLV
	JMP	PHU	;peripheral handler unlinking (null)

	FIX	PHINIV
	JMP	PHI	;peripheral handler initialization (null)
	SUBTTL	'Generic Parallel Device Handler Vector Table'
;	SPACE	4,10
	FIX	GPDVV
;	SPACE	4,10
;**	GPDVV - Generic Parallel Device Handler Vector Table


	DW	GOP-1	;perform generic parallel device OPEN (null)
	DW	GCL-1	;perform generic parallel device CLOSE (null)
	DW	GGB-1	;perform generic parallel device GET-BYTE (null)
	DW	GPB-1	;perform generic parallel device PUT-BYTE (null)
	DW	GST-1	;perform generic parallel device STATUS (null)
	DW	GSP-1	;perform generic parallel device SPECIAL (null)
	JMP	GIN	;initialize generic parallel device (null)
	DB	0	;filler byte
	SUBTTL	'Additional Jump Vectors'
;	SPACE	4,10
;**	Additional Jump Vectors


	FIX	HTXTVV
	JMP	HTV	;enter help text viewer
;	SUBTTL	'$E4C0 Patch'
;	SPACE	4,10
	FIX	$E4C0
;	SPACE	4,10
;**	E4C0 - $E4C0 Patch
;*
;*	For compatibility with OS Revision B, return.
;*
;*	MODS
;*       	1. Also include vector to CIO at $E4C4.
;*		   Mike Barall 09/06/84


	RTS		;return
	LDY	#NOTOPN		;IOCB not open error
	RTS
	JMP	CIO		;vector to CIO
;	SUBTTL	'Central Input/Output'
;	SPACE	4,10
;**	ICIO - Initialize CIO
;*
;*	ENTRY	JSR	ICIO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ICIO	=	*		;entry

;	Initialize IOCB's.

	LDX	#0		;index of first IOCB

ICIO1	LDA	#IOCFRE		;IOCB free indicator
	STA	ICHID,X		;set IOCB free
	LDA	#low (IIN-1)
	STA	ICPTL,X		;initialize PUT-BYTE routine address
	LDA	#high (IIN-1)
	STA	ICPTH,X
	TXA			;index of current IOCB
	CLC
	ADC	#IOCBSZ		;add IOCB size
	TAX			;index of next IOCB
	CMP	#MAXIOC		;index of first invalid IOCB
	BCC	ICIO1		;if not done

	RTS			;return
;	SPACE	4,10
;**	IIN - Indicate IOCB Not Open Error
;*
;*	ENTRY	JSR	IIN
;*
;*	EXIT
;*		Y = IOCB Not Open error code
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IIN	=	*	;entry
	LDY	#NOTOPN	;IOCB not open error
	RTS		;return
;	SPACE	4,10
;**	CIO - Central Input/Output
;*
;*	ENTRY	JSR	CIO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Remove calls to Peripheral Handler Loading Facility.
;*		   Mike Barall 07/12/84


CIO	=	*	;entry

;	Initialize.

	STA	CIOCHR	;save possible output byte value
	STX	ICIDNO	;save IOCB index

;	Check IOCB index validity.

	TXA		;IOCB index
	AND	#$0F	;index modulo 16
	BNE	CIO1	;if IOCB not multiple of 16, error

	CPX	#MAXIOC	;index of first invalid IOCB
	BCC	CIO2	;if index within range

;	Indicate Invalid IOCB Index error.

CIO1	LDY	#BADIOC	;invalid IOCB index error
	JMP	SSC	;set status and complete operation, return

;	Move part of IOCB to zero page IOCB.

CIO2	LDY	#0		;offset to first byte of page zero IOCB

CIO3	LDA	IOCB,X		;byte of IOCB
	STA	IOCBAS,Y	;byte of zero page IOCB
	INX
	INY
	CPY	#ICSPRZ-IOCBAS	;offset to first undesired byte
	BCC	CIO3		;if not done

;	Perform command, return

;	JMP	PCC
;	SPACE	4,10
;**	PCC - Perform CIO Command
;*
;*	ENTRY	JSR	PCC
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PCC	=	*	;entry

;	Check command validity.

	LDY	#NVALID		;assume invalid code
	LDA	ICCOMZ		;command
	CMP	#OPEN		;first valid command
	BCC	XOP1		;if command invalid

	TAY			;command

	CPY	#SPECIL		;last valid command
	BCC	PCC1		;if valid

	LDY	#SPECIL		;substitute SPECIAL command

;	Obtain vector offset.

PCC1	STY	ICCOMT		;save command
	LDA	TCVO-3,Y	;vector offset for command
	BEQ	XOP		;if OPEN command, process

;	Perform command.

	CMP	#2
	BEQ	XCL		;if CLOSE command, process

	CMP	#8
	BCS	XSS		;if STATUS or SPECIAL command, process

	CMP	#4
	BEQ	XGT		;if GET command, process

	JMP	XPT		;process PUT command, process
;	SPACE	4,10
;**	XOP - Execute OPEN Command
;*
;*	ENTRY	JSR	XOP
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Remove calls to Peripheral Handler Loading Facility
;*		   Mike Barall 07/12/84


XOP	=	*	;entry

;	Check IOCB free.

	LDA	ICHIDZ	;handler ID
	CMP	#IOCFRE	;IOCB free indicator
	BEQ	XOP2	;if IOCB free

;	Process error.

	LDY	#PRVOPN	;IOCB previously open error

XOP1	JMP	SSC	;set status and complete operation, return

;	Search handler table.

XOP2	JSR	SHT	;search handler table
	BCS	XOP1	;if not found, error

;	Initialize status.

	LDA	#0
	STA	DVSTAT	;clear status
	STA	DVSTAT+1

;	Initialize IOCB.

;	JMP	IIO	;initialize IOCB for OPEN, return
;	SPACE	4,10
;**	IIO - Initialize IOCB for OPEN
;*
;*	ENTRY	JSR	IIO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IIO	=	*	;entry

;	Compute handler entry point.

	JSR	CEP	;compute handler entry point
	BCS	XOP1	;if error

;	Execute command.

	JSR	EHC	;execute handler command

;	Set PUT-BYTE routine address in IOCB.

	LDA	#PUTCHR
	STA	ICCOMT	;command
	JSR	CEP	;compute handler entry point
	LDA	ICSPRZ	;PUT-BYTE routine address
	STA	ICPTLZ	;IOCB PUT-BYTE routine address
	LDA	ICSPRZ+1
	STA	ICPTHZ
	JMP	CCO	;complete CIO operation, return
;	SPACE	4,10
;**	XCL - Execute CLOSE Command
;*
;*	ENTRY	JSR	XCL
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


XCL	=	*		;entry

;	Initialize.

	LDY	#SUCCES		;assume success
	STY	ICSTAZ		;status
	JSR	CEP		;compute handler entry point
	BCS	XCL1		;if error

;	Execute command.

	JSR	EHC		;execute handler command

;	Close IOCB.

XCL1	LDA	#IOCFRE		;IOCB free indicator
	STA	ICHIDZ		;indicate IOCB free
	LDA	#high (IIN-1)
	STA	ICPTHZ		;reset initial PUT-BYTE routine address
	LDA	#low (IIN-1)
	STA	ICPTLZ
	JMP	CCO		;complete CIO operation, return
;	SPACE	4,10
;**	XSS - Execute STATUS and SPECIAL Commands
;*
;*	???word about implicit OPEN and CLOSE.
;*
;*	ENTRY	JSR	XSS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


XSS	=	*	;entry

;	Check IOCB free.

	LDA	ICHIDZ	;handler ID
	CMP	#IOCFRE
	BNE	XSS1	;if IOCB not free

;	Open IOCB.

	JSR	SHT	;search handler table
	BCS	XOP1	;if error

;	Execute command.

XSS1	JSR	CEP	;compute handler entry point
	JSR	EHC	;execute handler command

;	Restore handler ID, in case IOCB implicitly opened.

	LDX	ICIDNO	;IOCB index
	LDA	ICHID,X	;original handler ID
	STA	ICHIDZ	;restore zero page handler ID
	JMP	CCO	;complete CIO operation, return
;	SPACE	4,10
;**	XGT - Execute GET Command
;*
;*	ENTRY	JSR	XGT
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


XGT	=	*	;entry

;	Check GET validity.

	LDA	ICCOMZ	;command
	AND	ICAX1Z	;???
	BNE	XGT2	;if GET command valid

;	Process error.

	LDY	#WRONLY	;IOCB opened for write only error

XGT1	JMP	SSC	;set status and complete operation, return

;	Compute and check handler entry point.

XGT2	JSR	CEP	;compute handler entry point
	BCS	XGT1	;if error

;	Check buffer length.

	LDA	ICBLLZ		;buffer length
	ORA	ICBLLZ+1
	BNE	XGT3		;if buffer length non-zero

;	Get byte.

	JSR	EHC	;execute handler command
	STA	CIOCHR	;data
	JMP	CCO	;complete CIO operation, return

;	Fill buffer.    	

XGT3	JSR	EHC		;execute handler command
	STA	CIOCHR		;data
	BMI	XGT7		;if error, end transfer

	LDY	#0
	STA	(ICBALZ),Y	;byte of buffer
	JSR	IBP		;increment buffer pointer
	LDA	ICCOMZ		;command
	AND	#$02
	BNE	XGT4		;if GET RECORD command

;	Check for EOL.

	LDA	CIOCHR	;data
	CMP	#EOL
	BNE	XGT4	;if not EOL

;	Process EOL.

	JSR	DBL	;decrement buffer length
	JMP	XGT7	;clean up

;	Check buffer full.

XGT4	JSR	DBL	;decrement buffer length
	BNE	XGT3	;if buffer not full, continue

;	Check command.

	LDA	ICCOMZ	;command
	AND	#$02
	BNE	XGT7	;if GET CHARACTER command, clean up

;	Process GET RECORD.

XGT5	JSR	EHC	;execute handler command
	STA	CIOCHR	;data
	BMI	XGT6	;if error

;	Check for EOL.

	LDA	CIOCHR	;data
	CMP	#EOL
	BNE	XGT5	;if not EOL, continue

;	Process end of record.

	LDA	#TRNRCD	;truncated record error
	STA	ICSTAZ	;status

;	Process error.

XGT6	JSR	DBP		;decrement buffer pointer
	LDY	#0
	LDA	#EOL
	STA	(ICBALZ),Y	;set EOL in buffer
	JSR	IBP		;increment buffer pointer

;	Clean up.

XGT7	JSR	SFL	;set final buffer length
	JMP	CCO	;complete CIO operation, return
;	SPACE	4,10
;**	XPT - Execute PUT Command
;*
;*	ENTRY	JSR	XPT
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


XPT	=	*	;entry

;	Check PUT validity.

	LDA	ICCOMZ	;command
	AND	ICAX1Z
	BNE	XPT2	;if PUT command valid

;	Process error.

	LDY	#RDONLY	;IOCB opened for read only error

XPT1	JMP	SSC	;set status and complete operation, return

;	Compute and check handler entry point.

XPT2	JSR	CEP	;compute handler entry point
	BCS	XPT1	;if error

;	Check buffer length.

	LDA	ICBLLZ	;buffer length
	ORA	ICBLLZ+1
	BNE	XPT3	;if buffer length non-zero

;	Put byte.

	LDA	CIOCHR	;data
	INC	ICBLLZ	;set buffer length to 1
	BNE	XPT4	;transfer one byte

;	Transfer data from buffer to handler.

XPT3	LDY	#0
	LDA	(ICBALZ),Y	;byte from buffer
	STA	CIOCHR		;data

XPT4	JSR	EHC		;execute handler command
	PHP			;save status
	JSR	IBP		;increment buffer pointer
	JSR	DBL		;decrement buffer length
	PLP			;status
	BMI	XPT6		;if error

;	Check command.

	LDA	ICCOMZ	;command
	AND	#$02
	BNE	XPT5	;if PUT RECORD command

;	Check for EOL.

	LDA	CIOCHR	;data
	CMP	#EOL
	BEQ	XPT6	;if EOL, clean up

;	Check for buffer empty.

XPT5	LDA	ICBLLZ		;buffer length
	ORA	ICBLLZ+1
	BNE	XPT3		;if buffer not empty, continue

;	Check command.

	LDA	ICCOMZ	;command
	AND	#$02
	BNE	XPT6	;if PUT CHARACTER command

;	Write EOL.

	LDA	#EOL
	JSR	EHC	;execute handler command

;	Clean up.

XPT6	JSR	SFL	;set final buffer length
	JMP	CCO	;complete CIO operation, return
;	SPACE	4,10
;**	SSC - Set Status and Complete Operation
;*
;*	ENTRY	JSR	SSC
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SSC	=	*	;entry
	STY	ICSTAZ	;status
;	JMP	CCO	;complete CIO operation, return
;	SPACE	4,10
;**	CCO - ???
;*
;	RETURNS WITH STATUS STORED IN ICSTAZ
;	MOVE IOCB IN ZERO PAGE BACK TO USER AREA
;*
;*	ENTRY	JSR	CCO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


CCO	=	*		;entry

;	Initialize.

	LDY	ICIDNO		;IOCB index

;	Restore buffer pointer.

	LDA	ICBAL,Y
	STA	ICBALZ		;restore buffer pointer
	LDA	ICBAH,Y
	STA	ICBAHZ

;	Move part of zero page IOCB to IOCB.

	LDX	#0		;first byte of zero page IOCB

CCO1	LDA	IOCBAS,X	;byte of zero page IOCB
	STA	IOCB,Y		;byte of IOCB
	INX
	INY
	CPX	#ICSPRZ-IOCBAS	;offset to first undesired byte
	BCC	CCO1		;if not done

;	Restore A, X and Y.

	LDA	CIOCHR		;data
	LDX	ICIDNO		;IOCB index
	LDY	ICSTAZ		;status
	RTS			;return
;	SPACE	4,10
;**	CEP - Compute Handler Entry Point
;*
;*	ENTRY	JSR	CEP
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


CEP	=	*		;entry

;	Check handler ID validity.

	LDY	ICHIDZ		;handler ID
	CPY	#MAXDEV+1	;first invalid ID
	BCC	CEP1		;if handler ID within range

;	Process error.

	LDY	#NOTOPN		;IOCB not open error
	BCS	CEP2		;return

;	Compute entry point.

CEP1	LDA	HATABS+1,Y	;low address
	STA	ICSPRZ
	LDA	HATABS+2,Y	;high address
	STA	ICSPRZ+1
	LDY	ICCOMT		;command
	LDA	TCVO-3,Y	;vector offset for command
	TAY
	LDA	(ICSPRZ),Y	;low vector address
	TAX			;low vector address
	INY
	LDA	(ICSPRZ),Y	;high vector address
	STA	ICSPRZ+1	;set high address
	STX	ICSPRZ		;set low address
	CLC			;indicate success

;	Exit.

CEP2	RTS			;return
;	SPACE	4,10
;**	DBL - Decrement Buffer Length
;*
;*	Z FLAG = 0 ON RETURN IF LENGTH = 0 AFTER DECREMENT????
;*
;*	ENTRY	JSR	DBL
;*		??
;*
;*	EXIT
;*		Z set if buffer length = 0
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DBL	=	*		;entry
	LDA	ICBLLZ		;low buffer length
	BNE	DBL1		;if low buffer length non-zero

	DEC	ICBLLZ+1	;decrement high buffer length

DBL1	DEC	ICBLLZ		;decrement low buffer length
	LDA	ICBLLZ
	ORA	ICBLLZ+1	;indicate buffer length status
	RTS			;return
;	SPACE	4,10
;**	DBP - Decrement Buffer Pointer
;*
;*	ENTRY	JSR	DBP
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DBP	=	*		;entry
	LDA	ICBALZ		;low buffer address
	BNE	DBP1		;if low buffer address non-zero

	DEC	ICBALZ+1	;decrement high buffer address

DBP1	DEC	ICBALZ		;decrement low buffer address
	RTS			;return
;	SPACE	4,10
;**	IBP - Increment Buffer Pointer
;*
;*	ENTRY	JSR	IBP
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IBP	=	*		;entry
	INC	ICBALZ		;increment low buffer address
	BNE	IBP1		;if low buffer address non-zero

	INC	ICBALZ+1	;increment high buffer address

IBP1	RTS			;return
;	SPACE	4,10
;**	SFL - Set Final Buffer Length
;*
;*	SET BUFFER LENGTH = BUFFER LENGTH - WORKING BYTE COUNT???
;*
;*	ENTRY	JSR	SFL
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SFL	=	*		;entry
	LDX	ICIDNO		;IOCB index
	SEC
	LDA	ICBLL,X		;initial length
	SBC	ICBLLZ		;subtract byte count
	STA	ICBLLZ		;update length
	LDA	ICBLH,X
	SBC	ICBLLZ+1
	STA	ICBLHZ
	RTS			;return
;	SPACE	4,10
;**	EHC - Execute Handler Command
;*
;*	Y= STATUS ON RETURN, N FLAG=1 IF ERROR ON RETURN
;*
;*	ENTRY	JSR	EHC
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


EHC	=	*		;entry
	LDY	#FNCNOT		;assume function not defined error
EHC1	JSR	IDH		;invoke device handler
				;Warning: do not remove label EHC1 from
				;the JSR IDH statement.
	STY	ICSTAZ		;status
	CPY	#0		;set N accordingly
	RTS			;return
;	SPACE	4,10
;**	IDH - Invoke Device Handler
;*
;*	ENTRY	JSR	IDH
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IDH	=	*		;entry
	TAX			;save A
	LDA	ICSPRZ+1	;high vector
	PHA			;put high vector on stack
	LDA	ICSPRZ		;low vector
	PHA			;put low vector on stack
	TXA			;restore A
	LDX	ICIDNO		;IOCB index
	RTS			;invoke handler (address on stack)
;	SPACE	4,10
;**	SHT - Search Handler Table
;*
;*	ENTRY	JSR	SHT
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Accept device number 0 (like revision B did).
;*		   Mike Barall 06/21/84


SHT	=	*	;entry

;	Set device number.

	SEC
	LDY	#1
	LDA	(ICBALZ),Y	;device number
	SBC	#'0'

	CMP	#10
	BCC	SHT2		;if number in range "0" to "9"

SHT1	LDA	#1		;substitute device number "1"

SHT2	STA	ICDNOZ		;device number (0 through 9)

;	Find device handler.

	LDY	#0		;offset to device code
	LDA	(ICBALZ),Y	;device code
;	JMP	FDH		;find device handler, return
;	SPACE	4,10
;**	FDH - Find Device Handler
;*
;*	ENTRY	JSR	FDH
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


FDH	=	*		;entry

;	Check device code.

	BEQ	FDH2		;if device code null

;	Search handler table for device.

	LDY	#MAXDEV		;offset to last possible entry

FDH1	CMP	HATABS,Y	;device code from table
	BEQ	FDH3		;if device found

	DEY
	DEY
	DEY
	BPL	FDH1		;if not done

;	Process device not found.

FDH2	LDY	#NONDEV		;nonexistent device error
PHU	=	*
PHI	=	*
	SEC			;indicate error
	RTS			;return

;	Set handler ID.

FDH3	TYA			;offset to device code in table
	STA	ICHIDZ		;set handler ID
	CLC			;indicate no error
	RTS			;return
;	SPACE	4,10
;**	TCVO - Table of Command Vector Offsets
;*
;*	Entry n is the vector offset for command n+3.


TCVO	DB	0	;3 - open
	DB	4	;4 - get ???
	DB	4	;5 - get record
	DB	4	;6 - get ???
	DB	4	;7 - get byte(s)
	DB	6	;8 - put ???
	DB	6	;9 - put record
	DB	6	;10 - put ???
	DB	6	;11 - put byte(s)
	DB	2	;12 - close
	DB	8	;13 - status
	DB	10	;14 - special
;	SUBTTL	'Help Text Viewer, Part 2'
;	SPACE	4,10
;**	CHK - Check Help Key
;*
;*	Check to see if help key is being pressed and if system
;*	environment is correct for entry into help text viewer.
;*
;*	ENTRY	JSR	CHK
;*
;*	EXIT
;*		CH in the Accumulator
;*
;*	MODS
;*		Original Author Mike Barall 07/13/84
;*		1. Place CH in accumualtor before returning.
;*		   Mike Barall 09/06/84


CHK	=	*

;	Check to see that help key has been pressed

	LDA	HELPFG
	BNE	CHK8		;if help key pressed
	LDA	CH		;return with CH in accumulator
	RTS

;	See if error code handling of help key is enabled

CHK8	LDA	HNDLOD
	BEQ	CHK7		;if error code handling disabled
	PLA
	PLA			;cancel subroutine call from KGB
	LDX	#0
	STX	HELPFG		;clear help key flag
	LDA	#HELPKD		;error status code for help key
	STA	DSTAT
	JMP	GETOUT		;return through code in KGB

;	Check that KGB was called by EGETC1

CHK7	TSX
	INX
	INX
	INX
	LDA	$100,X		;get a byte from the stack
	CMP	#low (EGETC1+2)
	BNE	CHK1		;if wrong address
	INX
	LDA	$100,X		;get a byte from stack
	CMP	#high (EGETC1+2)
	BNE	CHK1		;if wrong address

;	Check for graphics mode 0

	LDA	BOTSCR
	EOR	#24
	ORA	DINDEX
	BNE	CHK1		;if not mode 0

;	Check that help key is being pressed.

	LDA	SKSTAT
	AND	#$04
	BNE	CHK1		;no key currently pressed, so exit
	LDA	KBCODE
	AND	#$3F		;mask shift and control
	EOR	#HELP
	BNE	CHK1		;key isn't help, so exit

;	Save all CIO variables onto the stack

	LDX	#0
CHK3	LDA	IOCBAS,X	;byte of zero-page IOCB
	PHA
	INX
	CPX	#15
	BNE	CHK3
	LDA	ICCOMT		;CIO command temporary
	PHA

;	Set screen border color

	LDA	COLOR4		;current border color
	PHA			;save it
	LDA	COLOR2
	STA	COLOR4		;make border same color as background
	STA	COLBK		;write to hardware, too

;	Invoke the help text viewer

	LDA	#$40
	STA	RECLEN		;indicate screen save & restore desired
	JSR	HTV

;	Restore screen border color

	PLA
	STA	COLOR4

;	Restore CIO variables

	PLA
	STA	ICCOMT
	LDX	#14
CHK4	PLA
	STA	IOCBAS,X	;restore byte of zeropage IOCB
	DEX
	BPL	CHK4

;	Check to see if screen was restored

	LDA	RECLEN
	BPL	CHK6		;if screen was restored
	JSR	CLRSCR		;clear the screen
	JSR	RETUR2		;set exit conditions

;	Return to KGB

CHK6	LDA	#0
	STA	HELPFG		;clear help key flag
	STA	ESCFLG		;clear escape flag
CHK1	LDA	CH		;return with CH in accumulator
	RTS
;	SPACE	4,10
;**	IHV - Initialize Help Text Viewer
;*
;*	ENTRY	JSR	IHV
;*
;*	MODS
;*		Original Author Mike Barall 07/13/84


IHV	=	*

;	Initialize pointer to help text filespec

	LDA	#low HFILE
	STA	RELADR
	LDA	#high HFILE
	STA	RELADR+1

	LDA	#'R'		;horizontal line graphics character
	STA	HIBYTE		;init dividing line character
	RTS
;	SPACE	4,10
;**	HFILE - Default Help Viewer Filespec

HFILE	DB	'D1:HELPTEXT.SYS',EOL
;	SPACE	4,10
;**	HRO - Help Viewer Read One Byte
;*
;*	ENTRY	JSR	HRO
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HRO	=	*
	LDA	#1		;number of bytes to read
;	JMP	HRD		;do read command, return
;	SPACE	4,10
;**	HRD - Help Viewer Read Disk File
;*
;*	Input Parameter:
;*	Accumulator = Number of bytes to read
;*	ICIDNO = IOCB number
;*
;*	Output Parameter:
;*	PARMBL contains the bytes read
;*
;*	ENTRY	JSR	HRD
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HRD	=	*
	LDX	ICIDNO
	STA	ICBLL,X		;put number of bytes into IOCB
	LDA	#0
	STA	ICBLH,X
	LDA	#low PARMBL	;address where bytes will go
	STA	ICBAL,X
	LDA	#high PARMBL
	STA	ICBAH,X
	LDA	#GETCHR		;get characters command
;	JMP	HCC		;do CIO command, return
;	SPACE	4,10
;**	HCC - Help Viewer CIO Call
;*
;*	Input Parameters:
;*	Accumulator = CIO command
;*	ICIDNO = IOCB index
;*	IOCB = Command parameters
;*
;*	Output Parameters:
;*	On error, returns to caller of HTV with error code in Y-reg.
;*
;*	ENTRY	JSR	HCC
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HCC	=	*
	LDX	ICIDNO		;IOCB
	STA	ICCOM,X		;store command into IOCB
	JSR	CIOV		;execute the command
	BPL	HRB1		;if success, return

	PLA
	PLA			;cancel subroutine call

;	JMP	HAB		;abort help text viewer
;	SPACE	4,10
;**	HAB - Help Viewer Abort
;*
;*	Closes the disk IOCB and returns to caller of HTV
;*
;*	ENTRY	JMP	HAB
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HAB	=	*
	TYA
	PHA			;save error code
	LDX	ICIDNO
	LDA	#CLOSE
	STA	ICCOM,X
	JSR	HDB		;disable break key
	JSR	CIOV		;close the IOCB
	PLA
	TAY			;restore error code

;	JMP	HRB
;	SPACE	4,10
;**	HRB - Restore Break Key Enable Status
;*
;*	ENTRY	JSR	HRB
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HRB	=	*
	SEI
	LDA	POKMSK
	ASL	A
	TAX
	LDA	RECLEN
	ROR	A		;put old break enable status into carry
	TXA
	ROR	A		;shift it into IRQ mask
	STA	POKMSK
	STA	IRQEN
	CLI

HRB1	RTS
;	SPACE	4,10
;**	HDB - Disable Break Key
;*
;*	ENTRY	JSR	HDB
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HDB	=	*
	SEI
	LDA	#$7F
	STA	BRKKEY		;show no break
	AND	POKMSK		;disable the break key
	STA	POKMSK
	STA	IRQEN
	CLI
	RTS
;	SPACE	4,10
;**	HMESAG - Help text viewer messages


HMESAG	=	*

HTSMSG	DB	'P'-32,'R'-32,'E'-32,'S'-32,'S'-32,' '-32
	DB	'S'-32,'P'-32,'A'-32,'C'-32,'E'-32,' '-32
	DB	'B'-32,'A'-32,'R'-32,' '-32
	DB	'T'-32,'O'-32,' '-32
	DB	'C'-32,'O'-32,'N'-32,'T'-32,'I'-32,'N'-32,'U'-32,'E'-32
	DB	EOL

HSMMSG	DB	'S'-32,'E'-32,'L'-32,'E'-32,'C'-32,'T'-32,' '-32
	DB	'T'-32,'O'-32,'P'-32,'I'-32,'C'-32,' '-32
	DB	'O'-32,'R'-32,' '-32
	DB	'R'-32,'E'-32,'T'-32,'U'-32,'R'-32,'N'-32,' '-32
	DB	'F'-32,'O'-32,'R'-32,' '-32
	DB	'L'-32,'A'-32,'S'-32,'T'-32,' '-32
	DB	'M'-32,'E'-32,'N'-32,'U'-32
	DB	EOL

HMMMSG	DB	'S'-32,'E'-32,'L'-32,'E'-32,'C'-32,'T'-32,' '-32
	DB	'T'-32,'O'-32,'P'-32,'I'-32,'C'-32,' '-32
	DB	'O'-32,'R'-32,' '-32
	DB	'B'-32,'R'-32,'E'-32,'A'-32,'K'-32,' '-32
	DB	'T'-32,'O'-32,' '-32
	DB	'E'-32,'X'-32,'I'-32,'T'-32,' '-32
	DB	EOL

HCSMSG	DB	'P'-32,'R'-32,'E'-32,'S'-32,'S'-32,' '-32
	DB	'S'-32,'P'-32,'A'-32,'C'-32,'E'-32,' '-32
	DB	'B'-32,'A'-32,'R'-32,' '-32
	DB	'F'-32,'O'-32,'R'-32,' '-32
	DB	'M'-32,'E'-32,'N'-32,'U'-32
	DB	EOL
;	SPACE	4,10
;**	HAF - Add 40 To ADRESS
;*
;*	ENTRY	JSR	HAF
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HAF	=	*
	LDA	ADRESS
	CLC
	ADC	#40
	STA	ADRESS
	BCC	HAF1
	INC	ADRESS+1
HAF1	RTS
;	SPACE	4,10
;**	HTI - Help Viewer Transmit Screen Image
;*
;*	Input Parameters:
;*	Accumulator = CIO command
;*	ICIDNO = IOCB number
;*
;*	ENTRY	JSR	HTI
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HTI	=	*
	LDX	ICIDNO
	TAY			;save command
	LDA	SAVMSC
	STA	ICBAL,X
	LDA	SAVMSC+1
	STA	ICBAH,X
	LDA	#low (40*24)
	STA	ICBLL,X
	LDA	#high (40*24)
	STA	ICBLH,X
	TYA
	JMP	HCC		;do CIO command, return
;	SPACE	4,10
;**	HPT - Help Viewer Point Command
;*
;*	Input Parameters:
;*	Y-register = Index into PARMBL where point data is located
;*	ICIDNO = IOCB number
;*
;*	ENTRY	JSR	HPT
;*
;*	MODS
;*		Original Author Mike Barall 07/16/84


HPT	=	*
	LDX	ICIDNO
	LDA	PARMBL,Y
	STA	ICAX2+1,X
	LDA	PARMBL+1,Y
	STA	ICAX2+2,X
	LDA	PARMBL+2,Y
	STA	ICAX2+3,X
	LDA	#$25		;point command
	JMP	HCC		;do CIO command, return
;	SUBTTL	'$E8ED Patch'
;	SPACE	4,10
	FIX	$E8ED
;	SPACE	4,10
;**	E8ED - $E8ED Patch
;*
;*	For compatibilty with OS Revision B, set VBLANK parameters.


	JMP	SVP	;set VBLANK parameters, return
;	SUBTTL	'$E912 Patch'
;	SPACE	4,10
	FIX	$E912
;	SPACE	4,10
;**	E912 - $E912 Patch
;*
;*	For compatibilty with OS Revision B, set VBLANK parameters.


	JMP	SVP	;set VBLANK parameters, return
;	SUBTTL	'$E959 Patch'
;	SPACE	4,10
	FIX	$E959
;	SPACE	4,10
;**	E959 - $E959 Patch
;*
;*	For compatibilty with OS Revision B, perform SIO.


	JMP	SIO	;perform SIO, return
;	SUBTTL	'Serial Input/Output'
;	SPACE	4,10
;**	ISIO - Initialize SIO
;*
;*	ENTRY	JSR	ISIO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ISIO	=	*	;entry

	LDA	#MOTRST
	STA	PACTL	;turn off motor

	LDA	#NCOMHI
	STA	PBCTL	;raise NOT COMMAND line

	LDA	#$03	;POKEY out of initialize mode
	STA	SSKCTL	;SKCTL shadow
	STA	SOUNDR	;select noisy I/O
	STA	SKCTL	;???

	RTS		;return
;	SPACE	4,10
;**	SIO - Serial Input/Output
;*
;*	ENTRY	JSR	SIO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Add 'supercritical I/O' flag for data frame receive
;*		   at 38400 baud.
;*		   Mike Barall 07/24/84


SIO	=	*	;entry

;	Initialize.

	TSX
	STX	STACKP	;save stack pointer
	LDA	#1	;critical section indicator
	STA	CRITIC	;indicate critical section

;	Check device ID.

	LDA	DDEVIC	;device ID
	CMP	#CASET
	BNE	SIO1	;if not cassette

;	Process cassette.

	JMP	PCI	;process cassette I/O, return

;	Process intelligent device.

SIO1	LDA	#0
	STA	CASFLG	;indicate not cassette

	LDA	#DRETRI
	STA	DRETRY	;set device retry count

SIO2	LDA	#CRETRI
	STA	CRETRY	;set command frame retry count

;	Send command frame.

SIO3	LDA	#low B19200
	STA	AUDF3		;set baud rate to 19200
	LDA	#high B19200
	STA	AUDF4
	LDA	#1
	STA	CRITIC		;clear 'supercritical I/O' flag

;	Set up command buffer.

	CLC
	LDA	DDEVIC		;device ID
	ADC	DUNIT		;add unit number
	ADC	#$FF		;subtract 1
	STA	CDEVIC		;device bus ID
	LDA	DCOMND		;command
	STA	CCOMND
	LDA	DAUX1		;auxiliary information 1
	STA	CAUX1
	LDA	DAUX2		;auxiliary information 2
	STA	CAUX2

;	Set buffer pointer to command frame buffer.

	CLC
	LDA	#low CDEVIC	;low buffer address
	STA	BUFRLO		;low buffer address
	ADC	#4
	STA	BFENLO		;low buffer end address
	LDA	#high CDEVIC	;high buffer address
	STA	BUFRHI		;high buffer address
	STA	BFENHI		;high buffer end address

;	Send command frame to device.

	LDA	#NCOMLO
	STA	PBCTL		;lower NOT COMMAND line
	JSR	SID		;send command frame
	LDA	ERRFLG		;error flag
	BNE	SIO4		;if error received

	TYA			;status???
	BNE	SIO5		;if ACK received

;	Process NAK or timeout.

SIO4	DEC	CRETRY	;decrement command frame retry count
	BPL	SIO3	;if retries not exhausted

;	Process command frame retries exhausted.

	JMP	SIO10	;process error

;	Process ACK.

SIO5	LDA	DSTATS	;status???? type????
	BPL	SIO6	;if no data to send

;	Send data frame to device.

	LDA	#CRETRI
	STA	CRETRY	;set command frame retry count
	JSR	SBP	;set buffer pointers
	JSR	SID	;send data frame
	BEQ	SIO10	;if error

;	Wait for complete.

SIO6	JSR	GTO	;set device timeout
	LDA	#0
	STA	ERRFLG	;clear error flag
	JSR	STW	;set timer and wait
	BEQ	SIO8	;if timeout

;	Process no timeout.

	BIT	DSTATS	;???
	BVS	SIO7	;if more data follows

	LDA	ERRFLG	;error flag
	BNE	SIO10	;if error

;	Process no error.

	BEQ	CSO	;complete SIO operation

;	Receive data frame from device.

SIO7	JSR	SBP	;set buffer pointers
	JSR	RCD	;receive data

;	Check error flag.

SIO8	LDA	ERRFLG	;error flag
	BEQ	SIO9	;if no error preceded data

;	Process error.

	LDA	TSTAT	;temporary status
	STA	STATUS	;status

;	Check status.

SIO9	LDA	STATUS	;status
	CMP	#SUCCES
	BEQ	CSO	;if successful, complete operation, return

;	Process error.

SIO10	DEC	DRETRY	;decrement device retry count
	BMI	CSO	;if retries exhausted, complete, return

;	Retry.

	JMP	SIO2	;retry
;	SPACE	4,10
;**	CSO - Complete SIO Operation
;*
;*	ENTRY	JSR	CSO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


CSO	=	*	;entry
	JSR	DSR	;disable SEND and RECEIVE
	LDA	#0	;not critical section indicator
	STA	CRITIC	;critical section flag
	LDY	STATUS	;status
	STY	DSTATS	;status
	RTS		;return
;	SPACE	4,10
;**	ISI - Invoke Serial Input Ready Routine
;*
;*	ENTRY	JSR	ISI
;*
;*	MODS
;*		Original Author Mike Barall 07/24/84


ISI	=	*

;	ISI must be on page $EAxx so that JSR ISI contains $EA (the
;	opcode for NOP) in its last byte.  This is necessary because
;	RTI (unlike RTS) does not increment the program counter.
	ASSERT	(high ISI)=$EA

	PHP
	PHA
	JMP	(VSERIN)
;	SPACE	4,10
;**	WCA - Wait for Completion or ACK
;*
;*	ENTRY	JSR	WCA
;*		??
;*
;*	EXIT
;*		Y = 0, if failure
;*		  = $FF, if success
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Correct mishandling of NAK.
;*		   R. K. Nordin	03/23/84
;*		3. Add support for 38400 baud serial bus rate.
;*		   Mike Barall 07/13/84


WCA	=	*		;entry

;	Initialize.

	LDA	#0
	STA	ERRFLG		;clear error flag

;	Set buffer pointer.

	CLC
	LDA	#low TEMP	;low temporary address
	STA	BUFRLO		;low buffer address
	ADC	#1
	STA	BFENLO		;low buffer end address
	LDA	#high TEMP	;high temporary address
	STA	BUFRHI		;high buffer address
	STA	BFENHI		;high buffer end address
	LDA	#$FF
	STA	NOCKSM		;indicate no checksum follows
	JSR	REC		;receive
	LDY	#$FF		;assume success
	LDA	STATUS		;status
	CMP	#SUCCES
	BNE	WCA2		;if failure

	LDA	TEMP		;byte received
	CMP	#ACK
	BEQ	WCA4		;if ACK, exit

	CMP	#COMPLT
	BEQ	WCA4		;if complete, exit

	CMP	#HSACK
	BNE	WCA0		;if not high speed ACK

;	Set baud rate to 38400

	LDA	#low B38400
	STA	AUDF3
	LDA	#high B38400
	STA	AUDF4
	LDA	#$81
	STA	CRITIC		;set 'supercritical I/O' flag

	JMP	WCA4		;exit with success

WCA0	CMP	#ERROR
	BNE	WCA1		;if device did not send back

;	Process unrecognized response.

	LDA	#DERROR
	STA	STATUS		;indicate device error
	BNE	WCA2		;check for timeout

;	Process nothing sent back.

WCA1	LDA	#DNACK
	STA	STATUS		;indicate NAK

;	Check for timeout.

WCA2	LDA	STATUS		;status
	CMP	#TIMOUT
	BEQ	WCA3		;if timeout

;	Process other error.?????

	LDA	#$FF		;error indicator
	STA	ERRFLG		;indicate error

;	Indicate failure.

WCA3	LDY	#0		;failure indicator

;	Exit.

WCA4	LDA	STATUS		;status
	STA	TSTAT		;temporary status
	RTS			;return
;	SPACE	4,10
;**	SEN - Send
;*
;*	SEN sends a buffer over the serial bus.
;*
;*	ENTRY	JSR	SEN
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Initialize CHKSUM before transmitting first byte.
;*		   R. K. Nordin	03/23/84


SEN	=	*		;entry

;	Initialize.

	LDA	#SUCCES		;assume success
	STA	STATUS		;status
	JSR	ESS		;enable SIO SEND
	LDY	#0
	STY	CHKSUM		;clear checksum
	STY	CHKSNT		;clear checksum sent flag
	STY	XMTDON		;clear transmit-frame done flag

;	Initiate TRANSMIT.

	LDA	(BUFRLO),Y	;first byte from buffer
	STA	CHKSUM		;initialize checksum
	STA	SEROUT		;serial output register

;	Check BREAK key.

SEN1	LDA	BRKKEY
	BNE	SEN2		;if BREAK key not pressed

;	Process BREAK key.

	JMP	PBK		;process BREAK key, return

;	Process BREAK key not pressed.

SEN2	LDA	XMTDON		;transmit-frame done flag
	BEQ	SEN1		;if transmit-frame not done

;	Exit.

	JSR	DSR		;disable SEND and RECEIVE
	RTS			;return
;	SPACE	4,10
;**	ORIR - Process Serial Output Ready IRQ
;*
;*	ENTRY	JMP	ORIR
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ORIR	=	*	;entry

;	Initialize.

	TYA
	PHA		;save Y
	INC	BUFRLO	;increment low buffer pointer
	BNE	ORI1	;if low buffer pointer non-zero

	INC	BUFRHI	;increment high buffer pointer

;	Check end of buffer.

ORI1	LDA	BUFRLO	;buffer address
	CMP	BFENLO	;buffer end address
	LDA	BUFRHI
	SBC	BFENHI
	BCC	ORI4	;if not past end of buffer

;	Process end of buffer.

	LDA	CHKSNT	;checksum sent flag
	BNE	ORI2	;if checksum already sent

;	Send checksum.

	LDA	CHKSUM	;checksum
	STA	SEROUT	;serial output register
	LDA	#$FF
	STA	CHKSNT	;indicate checksum sent
	BNE	ORI3	;???

;	Enable TRANSMIT done interrupt.

ORI2	LDA	POKMSK	;???
	ORA	#$08	;???
	STA	POKMSK	;???
	STA	IRQEN	;???

;	Exit.

ORI3	PLA
	TAY		;restore Y
	PLA		;restore A
	RTI		;return

;	Transmit next byte from buffer.

ORI4	LDY	#0
	LDA	(BUFRLO),Y	;byte from buffer
	STA	SEROUT		;serial output register
	CLC
	ADC	CHKSUM		;add byte to checksum
	ADC	#0
	STA	CHKSUM		;update checksum
	JMP	ORI3		;exit
;	SPACE	4,10
;**	OCIR - Process Serial Output Complete IRQ
;*
;*	ENTRY	JMP	OCIR
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


OCIR	=	*	;entry

;	Check checksum sent.

	LDA	CHKSNT	;checksum sent flag
	BEQ	OCI1	;if checksum not yet sent

;	Process checksum sent.

	STA	XMTDON	;indicate transmit-frame done

;	Disable TRANSMIT done interrupt.

	LDA	POKMSK	;???
	AND	#$F7	;???
	STA	POKMSK	;???
	STA	IRQEN	;???

;	Exit.

OCI1	PLA		;restore A
	RTI		;return
;	SPACE	4,10
;**	PTR - Prepare to Receive
;*
;*	ENTRY	JSR	PTR


PTR	=	*

	LDA	#0
	LDY	CASFLG
	BNE	PTR1	;if cassette

	STA	CHKSUM	;initialize checksum

PTR1	STA	BUFRFL	;clear buffer full flag
	STA	RECVDN	;clear receive-frame done flag
	LDA	#SUCCES	;assume success
	STA	STATUS	;status
	JSR	ESR	;enable SIO RECEIVE
	LDA	#NCOMHI
	STA	PBCTL	;raise COMMAND line
	RTS
;	SPACE	4,10
;**	RCD - Receive a Data Frame
;*
;*	ENTRY	JSR	RCD
;*
;*	MODS
;*		Original Author Mike Barall 07/24/84


RCD	=	*

;	Check for 'supercritical I/O'

	LDA	CRITIC
	BPL	REC	;If 19200 baud, use standard receive routine

;	Initialize

	SEI		;38400 baud is too fast to allow IRQ's
	JSR	PTR	;Prepare to receive

;	Check for timeout

RCD1	LDA	TIMFLG
	BEQ	ITO	;if timeout

;	Check for serial input ready

	LDA	#$20
	BIT	IRQST
	BNE	RCD2	;if not ready

;	Process serial input ready

	LDA	#not $20
	STA	IRQEN	;clear serial input ready interrupt bit
	LDA	POKMSK
	STA	IRQEN
	JSR	ISI	;invoke serial input ready routine

;	Check for receive done

	LDA	RECVDN
	BEQ	RCD1	;if not done
	CLI
	RTS

;	Check for break key

RCD2	BMI	RCD1	;if not break key

;	Process break key

	CLI		;break key IRQ should occur immediately
	JMP	PBK	;go process break
;	SPACE	4,10
;**	REC - Receive
;*
;*	ENTRY	JSR	REC
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


REC	=	*	;entry

;	Initialize.

	JSR	PTR	;prepare to receive

;	Check BREAK key.

REC2	LDA	BRKKEY
	BNE	REC3	;if BREAK key not pressed

;	Process BREAK key.

	JMP	PBK	;process BREAK key, return

;	Process BREAK key not pressed.

REC3	LDA	TIMFLG	;timeout flag
	BEQ	ITO	;if timeout, indicate timeout

;	Process no timeout.

	LDA	RECVDN	;receive-frame done flag
	BEQ	REC2	;if receive-frame done, continue

;	Exit.

	RTS		;return
;	SPACE	4,10
;**	ITO - Indicate Timeout
;*
;*	ENTRY	JSR	ITO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Add CLI instruction.
;*		   Mike Barall 07/24/84


ITO	=	*	;entry
	CLI
	LDA	#TIMOUT	;timeout indicator
	STA	STATUS	;indicate timeout
	RTS		;return
;	SPACE	4,10
;**	IRIR - Process Serial Input Ready IRQ
;*
;*	ENTRY	JMP	IRIR
;*		??
;*
;*	EXIT
;*		Exits via RTI
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


IRIR	=	*	;entry

;	Initialize.

	TYA
	PHA		;save Y
	LDA	SKSTAT
	STA	SKRES	;reset status register

;	Check for frame error.
;	THIS MAY NOT BE THE PLACE TO DO IT ????????

	BMI	IRI1	;if no frame error

;	Process frame error.

	LDY	#FRMERR	;frame error
	STY	STATUS	;indicate frame error

;	Check for overrun error.

IRI1	AND	#$20
	BNE	IRI2	;if no overrun error

;	Process overrun error.

	LDY	#OVRRUN	;overrun error
	STY	STATUS	;indicate overrun error

;	Check for buffer full.

IRI2	LDA	BUFRFL
	BEQ	IRI5	;if buffer not yet full

;	Process buffer full.

	LDA	SERIN	;checksum from device
	CMP	CHKSUM	;computed checksum
	BEQ	IRI3	;if checksums match

;	Process checksum error.

	LDY	#CHKERR	;checksum error
	STY	STATUS	;indicate checksum error

;	Indicate receive-frame done.

IRI3	LDA	#$FF	;receive-frame done indicator
	STA	RECVDN	;indicate receive-frame done

;	Exit.

IRI4	PLA
	TAY		;restore Y
	PLA		;restore A
	RTI		;return

;	Process buffer not full.

IRI5	LDA	SERIN		;serial input register
	LDY	#0
	STA	(BUFRLO),Y	;byte of buffer
	CLC
	ADC	CHKSUM		;add byte to checksum
	ADC	#0
	STA	CHKSUM		;update checksum
	INC	BUFRLO		;increment low buffer pointer
	BNE	IRI6		;if low buffer pointer non-zero

	INC	BUFRHI		;increment high buffer pointer

;	Check end of buffer.

IRI6	LDA	BUFRLO		;buffer address
	CMP	BFENLO		;buffer end address
	LDA	BUFRHI
	SBC	BFENHI
	BCC	IRI4		;if not past end of buffer

;	Process end of buffer.

	LDA	NOCKSM		;no checksum follows flag
	BEQ	IRI7		;if checksum will follow

;	Process no checksum will follow.

	LDA	#0
	STA	NOCKSM		;clear no checksum follows flag
	BEQ	IRI3		;indicate receive-frame done

;	Process checksum will follow.

IRI7	LDA	#$FF
	STA	BUFRFL		;indicate buffer full
	BNE	IRI4		;exit
;	SPACE	4,10
;**	SBP - Set Buffer Pointers
;*
;*	ENTRY	JSR	SBP
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SBP	=	*	;entry
	CLC
	LDA	DBUFLO
	STA	BUFRLO	;low buffer address
	ADC	DBYTLO
	STA	BFENLO	;low buffer end address
	LDA	DBUFHI
	STA	BUFRHI	;high buffer address
	ADC	DBYTHI
	STA	BFENHI	;high buffer end address
	RTS		;return
;	SPACE	4,10
;**	PCI - Process Cassette I/O
;*
;*	ENTRY	JSR	PCI
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PCI	=	*	;entry

;	Check command type.

	LDA	DSTATS		;command type
	BPL	PCI3		;if READ

;	Write a record.

	LDA	#low B00600
	STA	AUDF3		;set 600 baud
	LDA	#high B00600
	STA	AUDF4
	JSR	ESS		;enable SIO SEND
	LDX	PALNTS		;PAL/NTSC offset
	LDY	WSIRGX,X	;low short WRITE IRG time
	LDA	DAUX2		;IRG type
	BMI	PCI1		;if short IRG is desired

	LDY	WIRGLX,X	;low long WRITE IRG time

PCI1	LDX	#WIRGHI		;high IRG time
	JSR	SSV		;set SIO VBLANK parameters
	LDA	#MOTRGO
	STA	PACTL		;turn on motor

PCI2	LDA	TIMFLG		;timeout flag
	BNE	PCI2		;if no timeout

	JSR	SBP		;set buffer pointers
	JSR	SEN		;send
	JMP	PCI6		;exit

;	Read a record.

PCI3	LDA	#$FF		;cassette I/O indicator
	STA	CASFLG		;cassette I/O flag

	LDX	PALNTS		;PAL/NTSC offset
	LDY	RSIRGX,X	;low short READ IRG time
	LDA	DAUX2		;IRG type
	BMI	PCI4		;if short IRG desired

	LDY	RIRGLX,X	;low long READ IRG time

PCI4	LDX	#RIRGHI		;high READ IRG time
	JSR	SSV		;set SIO VBLANK parameters
	LDA	#MOTRGO
	STA	PACTL		;turn on motor

PCI5	LDA	TIMFLG		;timeout flag
	BNE	PCI5		;if no timeout

	JSR	SBP		;set buffer pointers
	JSR	GTO		;get device timeout
	JSR	SSV		;set SIO VBLANK parameters
	JSR	SBR		;set initial baud rate
	JSR	REC		;receive

;	Exit.

PCI6	LDA	DAUX2		;IRG type
	BMI	PCI7		;if doing short IRG

	LDA	#MOTRST
	STA	PACTL		;turn off motor

PCI7	JMP	CSO		;complete SIO operation, return
;	SPACE	4,10
;**	PTE - Process Timer Expiration
;*
;*	ENTRY	JSR	PTE
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PTE	=	*	;entry
	LDA	#0	;timeout indicator
	STA	TIMFLG	;timeout flag
	RTS		;return
;	SPACE	4,10
;**	ESS - Enable SIO SEND
;*
;*	ENTRY	JSR	ESS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ESS	=	*	;entry

;	???.

	LDA	#$07	;mask off previous serail bus control bits
	AND	SSKCTL
	ORA	#$20	;set SEND mode

;	Check device type.

	LDY	DDEVIC
	CPY	#CASET
	BNE	ESS1	;if not cassette

;	Process cassette.

	ORA	#$08	;set FSK output
	LDY	#LOTONE	;set FSK tone frequencies
	STY	AUDF2
	LDY	#HITONE
	STY	AUDF1

;	Set serial bus control.

ESS1	STA	SSKCTL	;SKCTL shadow
	STA	SKCTL	;???
	LDA	#$C7	;mask off previous serial bus interrupt bits
	AND	POKMSK	;and with POKEY IRQ enable
	ORA	#$10	;enable output data needed interrupt
	JMP	SSR	;set for SEND, return
;	SPACE	4,10
;**	ESR - Enable SIO RECEIVE
;*
;*	ENTRY	JSR	ESR
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


ESR	=	*	;entry
	LDA	#$07	;mask off previous serial bus control bits
	AND	SSKCTL	;and with ???
	ORA	#$10	;set receive mode asynchronous
	STA	SSKCTL	;SKCTL shadow
	STA	SKCTL	;???
	STA	SKRES	;???
	LDA	#$C7	;mask off previous serial bus interrupt bits
	AND	POKMSK	;and with POKEY IRQ enable
	ORA	#$20	;enable RECEIVE interrupt
;	JMP	SSR	;set for RECEIVE, return
;	SPACE	4,10
;**	SSR - Set for SEND or RECEIVE
;*
;*	ENTRY	JSR	SSR
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SSR	=	*	;entry

;	Initialize.

	STA	POKMSK	;update POKEY IRQ enable
	STA	IRQEN	;IRQ enable
	LDA	#$28	;clock ch. 3 with 1.79 MHz, ch. 4 with ch. 3
	STA	AUDCTL	;set audio control

;	Set voice controls.

	LDX	#6	;offset to last voice control
	LDA	#$A8	;pure tone, half volume
	LDY	SOUNDR	;noisy I/O flag
	BNE	SSR1	;if noisy I/O desired

	LDA	#$A0	;pure tone, no volume

SSR1	STA	AUDC1,X	;set tone and volume
	DEX
	DEX
	BPL	SSR1	;if not done

;	Turn off certain voices.

	LDA	#$A0	;pure tone, no volume
	STA	AUDC3	;turn off sound on voice 3
	LDY	DDEVIC	;device bus ID
	CPY	#CASET	;cassette device ID
	BEQ	SSR2	;if cassette device

	STA	AUDC1	;turn off sound on voice 1
	STA	AUDC2	;turn off sound on voice 2

SSR2	RTS		;return
;	SPACE	4,10
;**	DSR - Disable SEND and RECEIVE
;*
;*	ENTRY	JSR	DSR
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: NOP necessary?
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


DSR	=	*	;entry

;	Disable serial bus interrupts.

	NOP
	LDA	#$C7	;mask to clear serial bus interrupts
	AND	POKMSK	;and with POKEY IRQ enable
	STA	POKMSK	;update POKEY IRQ enable
	STA	IRQEN	;IRQ enable

;	Turn off audio volume.

	LDX	#6	;offset to last voice control
	LDA	#$00	;no volume

DSR1	STA	AUDC1,X	;turn off voice
	DEX
	DEX
	BPL	DSR1	;if not done

	RTS		;return
;	SPACE	4,10
;**	GTO - Get Device Timeout
;*
;*	ENTRY	JSR	GTO
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


GTO	=	*	;entry
	LDA	DTIMLO	;device timeout
	ROR	A
	ROR	A
	TAY		;rotated timeout
	AND	#$3F	;lower 6 bits
	TAX		;high timeout
	TYA		;rotated timeout
	ROR	A
	AND	#$C0	;upper 2 bits
	TAY		;low timeout
	RTS		;return
;	SPACE	4,10
;**	TSIH - Table of SIO Interrupt Handlers
;*
;*	NOTES
;*		Problem: not used.


TSIH	DW	IRIR	;serial input ready IRQ
	DW	ORIR	;serial output ready IRQ
	DW	OCIR	;serial output complete IRQ
;	SPACE	4,10
;**	SID - Send to Intelligent Device
;*
;*	ENTRY	JSR	SID
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: bytes wasted by outer delay loop???
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SID	=	*	;entry

;	Delay.

	LDX	#1

SID1	LDY	#255

SID2	DEY
	BNE	SID2		;if inner loop not done

	DEX
	BNE	SID1		;if outer loop not done

;	Send data frame.

	JSR	SEN		;send

;	Set timer and wait.

	LDY	#low CTIM	;frame acknowledge timeout
	LDX	#high CTIM
;	JMP	STW		;set timer and wait, return
;	SPACE	4,10
;**	STW - Set Timer and Wait
;*
;*	ENTRY	JSR	STW
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


STW	=	*	;entry
	JSR	SSV	;set SIO VBLANK parameters
	JSR	WCA	;wait for completion or ACK
	TYA		;wait termination status
	RTS		;return
;	SPACE	4,10
;**	CBR - Compute Baud Rate
;*
;*	CBR computes value for POKEY frequency for the baud rate as
;*	measured by an interval of the VCOUNT timer.
;*
;*	ENTRY	JSR	CBR
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


CBR	=	*		;entry
	STA	TIMER2		;save final timer value
	STY	TIMER2+1
	JSR	AVV		;adjust VCOUNT value
	STA	TIMER2		;save adjusted timer 2 value
	LDA	TIMER1
	JSR	AVV		;adjust VCOUNT value
	STA	TIMER1		;save adjusted timer 1 value
	LDA	TIMER2
	SEC
	SBC	TIMER1
	STA	TEMP1		;save difference
	LDA	TIMER2+1
	SEC
	SBC	TIMER1+1
	TAY			;difference
	LDX	PALNTS
	LDA	#0
	SEC
	SBC	CONS1X,X	;???

CBR1	CLC
	ADC	CONS1X,X	;accumulate product
	DEY
	BPL	CBR1		;if not done

	CLC
	ADC	TEMP1		;add to get total VCOUNT difference
	TAY			;total VCOUNT difference
	LSR	A
	LSR	A
	LSR	A
	ASL	A		;interval divided by 4
	SEC
	SBC	#22		;adjust offset
	TAX			;offset
	TYA			;total VCOUNT difference
	AND	#7		;extract lower 3 bits of interval
	TAY			;lower 3 bits of interval
	LDA	#<-11

CBR2	CLC
	ADC	#11		;accumulate interpolation constant
	DEY
	BPL	CBR2		;if done

	LDY	#0		;assume no addition correction
	SEC
	SBC	#7		;adjust interpolation constant
	BPL	CBR3		;if ???

	DEY			;indicate addition correction

CBR3	CLC
	ADC	TPFV,X		;add constant to table value
	STA	CBAUDL		;low POKEY frequency value
	TYA
	ADC	TPFV+1,X
	STA	CBAUDH		;high POKEY frequency value
	RTS			;return
;	SPACE	4,10
;**	AVV - Adjust VCOUNT Value
;*
;*	ENTRY	JSR	AVV
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


AVV	=	*	;entry
	CMP	#$7C
	BMI	AVV1	;if >= $7C ???

	SEC
	SBC	#$7C
	RTS		;return

AVV1	CLC
	LDX	PALNTS
	ADC	CONS2X,X
	RTS		;return
;	SPACE	4,10
;**	SBR - Set Initial Baud Rate
;*
;*	INITIAL BAUD RATE MEASUREMENT -- USED TO SET THE
;*	BAUD RATE AT THE START OF A RECORD.
;*
;*	IT IS ASSUMED THAT THE FIRST TWO BYTES OF EVERY
;*	RECORD ARE $AA.
;*
;*	ENTRY	JSR	SBR
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	NOTES
;*		Problem: bytes wasted by branch around branch (SBR3).
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SBR	=	*		;entry

SBR1	LDA	BRKKEY
	BNE	SBR2		;if BREAK key not pressed

	JMP	PBK		;process BREAK key, return

SBR2	SEI
	LDA	TIMFLG		;timeout flag
	BNE	SBR3		;if no timeout

	BEQ	SBR5		;process timeout

SBR3	LDA	SKSTAT		;???
	AND	#$10		;extract start bit???
	BNE	SBR1		;if start bit

	STA	SAVIO		;save serial data in
	LDX	VCOUNT		;vertical line counter
	LDY	RTCLOK+2	;low byte of VBLANK clock
	STX	TIMER1
	STY	TIMER1+1	;save initial timer value
	LDX	#1
	STX	TEMP3		;set mode flag???
	LDY	#10		;10 bits

SBR4	LDA	BRKKEY		;???
	BEQ	PBK		;if BREAK key pressed, process, return

	LDA	TIMFLG		;timeout flag
	BNE	SBR6		;if no timeout

SBR5	CLI
	JMP	ITO		;indicate timeout, return

SBR6	LDA	SKSTAT		;???
	AND	#$10		;extract ???
	CMP	SAVIO		;previous serial data in
	BEQ	SBR4		;if data in not changed

	STA	SAVIO		;save serial data in
	DEY			;decrement bit counter
	BNE	SBR4		;if not done

	DEC	TEMP3		;decrement mode???
	BMI	SBR7		;if done with both modes

	LDA	VCOUNT		;???
	LDY	RTCLOK+2	;???
	JSR	CBR		;compute baud rate
	LDY	#9		;9 bits
	BNE	SBR4		;set bit counter

SBR7	LDA	CBAUDL
	STA	AUDF3
	LDA	CBAUDH
	STA	AUDF4		;set POKEY baud rate
	LDA	#0
	STA	SKSTAT
	LDA	SSKCTL
	STA	SKSTAT		;???initialize POKEY serial port
	LDA	#$55		;???
	STA	(BUFRLO),Y	;first byte of buffer
	INY
	STA	(BUFRLO),Y	;second byte of buffer
	LDA	#$AA		;checksum for two bytes of $AA???
	STA	CHKSUM		;checksum
	CLC
	LDA	BUFRLO
	ADC	#2		;add 2
	STA	BUFRLO		;update low buffer pointer
	LDA	BUFRHI
	ADC	#0
	STA	BUFRHI		;update high buffer pointer
	CLI
	RTS			;return
;	SPACE	4,10
;**	PBK - Process BREAK Key
;*
;*	ENTRY	JSR	PBK
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83
;*		2. Change DEC BRKKEY to STA BRKKEY.
;*		   Mike Barall 07/24/84


PBK	=	*	;entry
	JSR	DSR	;disable SEND and RECEIVE
	LDA	#MOTRST
	STA	PACTL	;turn off motor
	LDA	#NCOMHI
	STA	PBCTL	;raise NOT COMMAND line
	LDA	#BRKABT	;BREAK abort error
	STA	STATUS	;status
	LDX	STACKP	;saved stack pointer
	TXS		;restore stack pointer
	STA	BRKKEY	;indicate BREAK
	CLI
	JMP	CSO	;complete SIO operation, return to caller of SIO
;	SPACE	4,10
;**	SSV - Set SIO VBLANK Parameters
;*
;*	ENTRY	JSR	SSV
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


SSV	=	*		;entry
	LDA	#low PTE	;timer expiration routine address
	STA	CDTMA1
	LDA	#high PTE
	STA	CDTMA1+1
	LDA	#1		;timer 1
	SEI
	JSR	SETVBV		;set VBLANK parameters
	LDA	#1		;no timeout indicator
	STA	TIMFLG		;timeout flag
	CLI
	RTS			;return
;	SPACE	4,10
;**	TPFV - Table of POKEY Frequency Values
;*
;*	TPFV translates VCOUNT interval timer measurements to POKEY
;*	frequency register values.
;*
;*	Table entries are AUDF+7.
;*
;*	Frequency-out is Frequency-in divided by 2*(AUDF+M), where
;*	Frequency-in = 1.78979 Mhz and M = 7.
;*
;*	AUDF+7=(11.365167)*T-out, where T-out is the number of counts
;*	(127 used cd soulution???) of VCOUNT for one character
;*	time (10 bit times).
;*
;*	Baud rate is ????.


;	DW	636	;baud rate 1407, VCOUNT interval 56
;	DW	727	;baud rate 1231, VCOUNT interval 64
;	DW	818	;baud rate 1094, VCOUNT interval 72
;	DW	909	;baud rate 985, VCOUNT interval 80

TPFV	DW	1000	;baud rate 895, VCOUNT interval 88
	DW	1091	;baud rate 820, VCOUNT interval 96
	DW	1182	;baud rate 757, VCOUNT interval 104
	DW	1273	;baud rate 703, VCOUNT interval 112
	DW	1364	;baud rate 656, VCOUNT interval 120
	DW	1455	;baud rate 615, VCOUNT interval 128
	DW	1546	;baud rate 579, VCOUNT interval 136
	DW	1637	;baud rate 547, VCOUNT interval 144
	DW	1728	;baud rate 518, VCOUNT interval 152
	DW	1818	;baud rate 492, VCOUNT interval 160
	DW	1909	;baud rate 469, VCOUNT interval 168
	DW	2000	;baud rate 447, VCOUNT interval 176

;	DW	2091	;baud rate 428, VCOUNT interval 184
;	DW	2182	;baud rate 410, VCOUNT interval 192
;	DW	2273	;baud rate 394, VCOUNT interval 200
;	DW	2364	;baud rate 379, VCOUNT interval 208
;	DW	2455	;baud rate 365, VCOUNT interval 216
;	DW	2546	;baud rate 352, VCOUNT interval 224
;	DW	2637	;baud rate 339, VCOUNT interval 232
;	DW	2728	;baud rate 328, VCOUNT interval 240
;	DW	2819	;baud rate 318, VCOUNT interval 248
;	SPACE	4,10
;**	NTSC/PAL Constant Tables


WIRGLX	DB	low WIRGLN	;NTSC low long write IRG
	DB	low WIRGLP	;PAL low long write IRG

RIRGLX	DB	low RIRGLN	;NTSC low long read IRG
	DB	low RIRGLP	;PAL low long read IRG

WSIRGX	DB	low WSIRGN	;NTSC low short write IRG
	DB	low WSIRGP	;PAL low short write IRG

RSIRGX	DB	low RSIRGN	;NTSC low short read IRG
	DB	low RSIRGP	;PAL low short read IRG

CONS1X	DB	131		;NTSC ???
	DB	156		;PAL ???

CONS2X	DB	7		;NTSC ???
	DB	32		;PAL ???
;	SUBTTL	'Printer Handler, Part 1'


;**	PRINTER HANDLER
;*
;*	This is the printer handler of the Rev. B OS, patched to
;*	accept printer unit numbers.

	FIX	PRNORG

;
;       PRINTER HANDLER INITIALIZATION ROUTINE
;
PHINIT: LDA     #30
        STA     PTIMOT      ;SET UP INITIAL PRINTER TIMEOUT OF 30 SEC.
        RTS
;
;
;       PRINTER HANDLER CONSTANTS
;
PHSTLO: DW      DVSTAT      ;STATUS BUFFER POINTER
PHCHLO: DW      PRNBUF      ;CHAR. BUFFER POINTER
;
;
;
;       ************************
;       PRINTER HANDLER ROUTINES
;       ************************
;
;
;
;
;
;       PRINTER HANDLER STATUS ROUTINE
;
PHSTAT: LDA     #4
        STA     PBUFSZ      ;SET BUFFER SIZE TO 4 BYTES
        LDX     PHSTLO
        LDY     PHSTLO+1    ;SET POINTER TO STATUS BUFFER
        LDA     #STATC      ;SET COMMAND TO "STATUS"
        STA     DCOMND      ;SET STATUS COMMAND
        STA     DAUX1
        JSR     SETDCB      ;GO SETUP DCB
        JSR     SIOV        ;SEND STATUS COMMAND
        BMI     BADST       ;GO IF ERROR
        JSR     PHPUT       ;YES,PUT STATUS INTO GLOBAL BUFFER.
BADST:  RTS
;
;
;
;
;       PRINTER HANDLER OPEN ROUTINE
;
PHOPEN: JSR     PHSTAT      ;DO STATUS COMMAND TO SIO
        LDA     #0
        STA     PBPNT       ;CLEAR PRINT BUFFER POINTER
        RTS
;
;
;
;
;       PRINTER HANDLER WRITE ROUTINE
;
PHWRIT: STA     PTEMP       ;SAVE ACCUM

;**	Patch for variable unit number
;       JSR     PRMODE      ;GO DETERMINE PRINT MODE
	JSR	PHPAT
;**
        LDX     PBPNT
        LDA     PTEMP       ;GET CHAR. SENT BY CIO
        STA     PRNBUF,X    ;PUT CHAR. IN PRINT BUFFER
        INX                 ;INCR. BUFFER POINTER
        CPX     PBUFSZ      ;BUFFER POINTER=BUFFER SIZE?
        BEQ     BUFFUL
        STX     PBPNT       ;SAVE BUFFER POINTER
        CMP     #CR         ;IS CHAR. = EOL ?
        BEQ     BLFILL      ;IF YES, GO DO BLANK FILL.
        LDY     #SUCCES     ;PUT GOOD STATUS IN Y REG FOR CIO.
        RTS
BLFILL: LDA     #SPACE      ;PUT BLANK IN ACCUM.
FILLBF: STA     PRNBUF,X    ;STORE IT IN PRINT BUFFER.
        INX
        CPX     PBUFSZ
        BNE     FILLBF      ;BUFFER BLANK FILLED?
BUFFUL: LDA     #0
        STA     PBPNT       ;CLEAR PRINT BUFFER POINTER
        LDX     PHCHLO
        LDY     PHCHLO+1    ;SET POINTER TO PRINT BUFFER
        JSR     SETDCB      ;GO SETUP DCB
        JSR     SIOV        ;SEND PRINT COMMAND
        RTS                 ;YES.
;
;
;
;
;       PRINTER HANDLER CLOSE ROUTINE
;
PHCLOS: JSR     PRMODE      ;GO DETERMINE PRINT MODE
        LDX     PBPNT
        BNE     BLFILL
        LDY     #SUCCES
        RTS
;
;
;
;
;
;
;
;
;       S U B R O U T I N E S
;
;
;
;
;
;       SET UP DCB TO CALL SIO
;
SETDCB: STX     DBUFLO
        STY     DBUFHI      ;SET BUFFER POINTER
        LDA     #PDEVN
        STA     DDEVIC      ;SET PRINTER BUS I.D. FOR DCB

;****
; PATCH to support variable unit #
;
;       LDA     #1
	LDA	ICDNOZ
        STA     DUNIT       ;SET UNIT NUMBER
;****

        LDA     #$80        ;DEVICE WILL EXPECT DATA
        LDX     DCOMND
        CPX     #STATC      ;STATUS COMMAND?
        BNE     PSIOC
        LDA     #$40        ;EXPECT DATA FROM DEVICE
PSIOC:  STA     DSTATS      ;SET SIO MODE COMMAND.
        LDA     PBUFSZ
        STA     DBYTLO      ;SET LO BYTE COUNT
        LDA     #0
        STA     DBYTHI      ;SET HI BYTE COUNT
        LDA     PTIMOT
        STA     DTIMLO      ;SET DEVICE TIMEOUT COUNT
        RTS
;
;
;
;
; GET DEVICE TIMEOUT FROM STATUS & SAVE IT
;
PHPUT:  LDA     DVSTAT+2
        STA     PTIMOT      ;SAVE DEVICE TIMEOUT
        RTS
;
;
;
;
; DETERMINE PRINT MODE & SETUP PRINT BUFFER SIZE, DCB PRINT
; COMMAND, & DCB AUX1 FOR PRINT MODE
;
PRMODE: LDY     #WRITEC     ;PUT WRITE COMMAND IN Y REG
        LDA     ICAX2Z      ;READ PRINT MODE
CMODE:  CMP     #N
        BNE     CDUBL       ;PRINT NORMAL ?
        LDX     #NBUFSZ     ;YES, SET NORMAL CHAR. BUFFER SIZE
        BNE     SETBSZ
CDUBL:  CMP     #D
        BNE     CSIDE       ;PRINT DOUBLE?
        LDX     #DBUFSZ     ;YES, SET DOUBLE CHAR. BUFFER SIZE
        BNE     SETBSZ
CSIDE:  CMP     #S          ;PRINT SIDEWAYS ?
        BNE     GOERR       ;IF NOT, GO TO ERROR ROUTINE
        LDX     #SBUFSZ     ;YES, SET SIDEWAYS BUFFER SIZE
SETBSZ: STX     PBUFSZ      ;STORE PRINT BUFFER SIZE
        STY     DCOMND      ;STORE DCB COMMAND
        STA     DAUX1       ;STORE DCB AUX1 PRINT MODE
        RTS
GOERR:  LDA     #N          ;SET DEFAULT PRINT MODE TO NORMAL
        BNE     CMODE


;**	Check for correct module length

	ASSERT	*=$EF41
;        SUBTTL	'Casette Handler, Part 1'

;**	CASSETTE HANDLER
;*
;*	This is the cassette handler of the Rev. B OS, patched to
;*	work with both PAL and NTSC.

	FIX	CASORG

CBUFH   =       HIGH CASBUF
CBUFL   =       LOW CASBUF
SRSTA   =       $40         ;SIO READ STATUS
SWSTA   =       $80         ;SIO WRITE STATUS
;MOTRGO =       $34
;MOTRST =       $3C
;
;
;
; INIT ROUTINE
;
INIT:   LDA     #$CC
        STA     CBAUDL
        LDA     #$05
        STA     CBAUDH      ;SET CASSET BAUD RATE TO 600
SPECIAL:                    ;THATS ALL FOLKS
        RTS
;
; OPEN FUNCTION - WITH NO TIMING ADJUST
;
OPENC:  LDA     ICAX2Z      ;GET AX2
        STA     FTYPE       ;SAVE IT FOR FUTURE REFERENCE
        LDA     ICAX1Z
        AND     #$0C        ;IN AND OUT BITS
        CMP     #$04
        BEQ     OPINP
        CMP     #$08        ;SEE IF OPEN FOR OUTPUT
        BEQ     OPOUT
        RTS                 ;IF ALREADY OPEN, RETURN LEAVING STATUS=$84
OPINP:  LDA     #0
        STA     WMODE       ;SET READ MODE
        STA     FEOF        ;NO EOF YET
SFH:    LDA     #TONE2      ;TONE FOR PRESS PLAY
        JSR     BEEP        ;GO BEEP
        BMI     OPNRTN      ;IF ERROR DURING BEEP
        LDA     #MOTRGO
        STA     PACTL       ;TURN MOTOR ON

;****
; PAL & NTSC compiled time switch

;       IF      PALFLG
;       LDY     #$E0
;       LDX     #1
;       ENDIF
;       IF      PALFLG-1
;       LDY     #$40        ;5-31-79 9 SEC READ LEADER
;       LDX     #2
;       ENDIF

;****
; PATCH to make a combined PAL & NTSC version

;       LDY     #$40        ;5-31-79 9 SEC READ LEADER
;       LDX     #2

	JMP	CHPAT1
	NOP

CHP1RT
;
;****
        LDA     #3
        STA     CDTMF3
        JSR     SETVBV      ;SET UP VBLANK TIMER
WAITTM: LDA     CDTMF3
        BNE     WAITTM      ;WAIT FOR MOTOR TO COME UP TO SPEED
        LDA     #$80        ;NEXT BYTE=NO BYTES IN BUFFER
        STA     BPTR
        STA     BLIM
        JMP     OPOK        ;OPEN OK
;
; OPEN FOR OUTPUT
;
PBRK:   LDY     #BRKABT     ;BREAK KEY ABORT STATUS
        DEC     BRKKEY      ;RESET BREAK KEY
OPNRTN: LDA     #0          ;CLEAR WRITE MODE FLAG
        STA     WMODE
        RTS                 ;AND EXIT.
;
OPOUT:  LDA     #$80
        STA     WMODE       ;SET WRITE MODE
        LDA     #TONE1      ;TELL USER TO TURN ON RECORD MODE
        JSR     BEEP
        BMI     OPNRTN      ;IF ERROR DURING BEEP
        LDA     #$CC        ;SET BAUD RATE
        STA     AUDF3       ;WHICH SEEMS TO BE NESSECARY
        LDA     #$05        ;FOR SOME OBSCURE REASON
        STA     AUDF4
        LDA     #$60
        STA     DDEVIC
        JSR     SENDEV      ;TELL POKEY TO WRITE MARKS
        LDA     #MOTRGO     ;WRITE 5 SEC BLANK TAPE
        STA     PACTL

;****
;

;       LDA     #3
;****
; combine PAL & NTSC compile time flag

;       IF      PALFLG
;       LDX     #$3
;       LDY     #$C0
;       ENDIF
;       IF      PALFLG-1
;       LDX     #4          ;5/30/79 20 SEC LEADER
;       LDY     #$80
;       ENDIF

;****
; PATCH to make a combined PAL & NTSC version

;	LDA	#3
;       LDX     #4          ;5/30/79 20 SEC LEADER
;       LDY     #$80

	JMP	CHPAT2
	NOP

CHP2RT
        LDA     #3
;
;****
        JSR     SETVBV
        LDA     #$FF
        STA     CDTMF3
WDLR:   LDA     BRKKEY
        BEQ     PBRK        ;IF BREAK DURING WRITE LEADER
        LDA     CDTMF3
        BNE     WDLR
        LDA     #0          ;INIT BUFFER POINTER
        STA     BPTR
OPOK:   LDY     #SUCCES
        RTS
        EJECT
;
; GET BYTE
;
GBYTE:  LDA     FEOF        ;IF AT EOF ALREADY
        BMI     ISEOF       ;RETURN EOF STATUS
        LDX     BPTR        ;BUFFER POINTER
        CPX     BLIM        ;IF END OF BUFFER
        BEQ     RBLOK       ;READ ANOTHER BLOCK
        LDA     CASBUF+3,X  ;GET NEXT BYTE
        INC     BPTR        ;BUMP POINTER
        LDY     #SUCCES     ;OK STATUS
GBX:    RTS
RBLOK:  LDA     #'R'        ;READ OPCODE
        JSR     SIOSB       ;SIO ON SYS BUF
        TYA
        BMI     GBX         ;IF SIO ERRORS, RETURN
        LDA     #0
        STA     BPTR        ;RESET POINTER
        LDX     #$80        ;DEFAULT # BYTES
        LDA     CASBUF+2
        CMP     #EOT
        BEQ     ATEOF       ;IF HEADER, GO READ AGAIN
        CMP     #DT1        ;IF LAST DATA REC
        BNE     NLR
        LDX     CASBUF+130  ;LAST DATA RECORD, GET # BYTES
NLR:    STX     BLIM
        JMP     GBYTE       ;GET NEXT BYTE
ATEOF:  DEC     FEOF        ;SET FEOF
ISEOF:  LDY     #EOFERR     ;ENDFILE STATUS
        RTS
        EJECT
;
; PUT BYTE TO BUFFER
;
PBYTE:  LDX     BPTR        ;BUFFER POINTER
        STA     CASBUF+3,X  ;STORE CHAR AWAY
        INC     BPTR        ;BUMP POINTER
        LDY     #SUCCES     ;OK STATUS
        CPX     #127        ;IF BUFFER FULL
        BEQ     *+3
        RTS
; WRITE OUT THE BUFFER
        LDA     #DTA        ;RECORD TYPE = DATA
        JSR     WSIOSB      ;DO WRITE ON SYSTEM BUFFER
        LDA     #0
        STA     BPTR        ;RESET BUFFER POINTER
        RTS                 ;EXIT.
        EJECT
;
; STATUS - RETURN STATUS INFO THRU DVSTAT
;
STATU:  LDY     #SUCCES
        RTS
        EJECT
;
; CLOSE
;
CLOSEC: LDA     WMODE       ;SEE IF WRITING
        BMI     CLWRT       ;GO CLOSE FOR WRITE
; CLOSE FOR READ - FLAG CLOSED
        LDY     #SUCCES     ;SUCCESSFULL
FCAX:   LDA     #MOTRST     ;STOP THE MOTOR IN CASE WAS SHORT IRG MODE
        STA     PACTL
        RTS
CLWRT:  LDX     BPTR        ;BUFFER POINTER
        BEQ     WTLR        ;IF NO DATA BYTES IN BUFFER, NO DT1 REC
        STX     CASBUF+130  ;WRITE TO LAST RECORD
        LDA     #DT1        ;REC TYPE
        JSR     WSIOSB      ;WRITE OUT USER BUFFER
        BMI     FCAX        ;GO IF ERROR
WTLR:   LDX     #127        ;ZERO BUFFER
        LDA     #0
ZTBUF:  STA     CASBUF+3,X
        DEX
        BPL     ZTBUF
        LDA     #EOT        ;WRITE EOT RECORD
        JSR     WSIOSB
        JMP     FCAX        ;FLAG CLOSED AND EXIT
        EJECT
;
; SUBROUTINES
;
; BEEP - GENERATE TONE ON KEYBOARD SPEAKER
; ON ENTRY A= FREQ
;
BEEP:   STA     FREQ
BEEP1:  LDA     RTCLOK+2    ;CURRENT CLOCK

;****
; compile time flag for PAL & NTSC
;
;       CLC
;       IF      PALFLG
;       ADC     #25
;       ENDIF
;       IF      PALFLG-1
;       ADC     #30         ;1 SEC TONE
;       ENDIF

;****
; PATCH #3 for casette handler

;	CLC
;	ADC	#30	    ;1 SEC TONE

	JMP	CHPAT3
CHP3RT
;
;****

        TAX
WFL:    LDA     #$FF
        STA     CONSOL      ;TURN ON SPEAKER
        LDA     #0
        LDY     #$F0
        DEY
        BNE     *-1
        STA     CONSOL      ;TURN OFF SPEAKER
        LDY     #$F0
        DEY
        BNE     *-1
        CPX     RTCLOK+2    ;SEE IF 1 SEC IS UP YET
        BNE     WFL
        DEC     FREQ        ;COUNT BEEPS
        BEQ     WFAK        ;IF ALL DONE GO WAIT FOR KEY
        TXA

;****
; compile time flag for PAL & NTSC
;
;       CLC
;       IF      PALFLG
;       ADC     #8
;       ENDIF
;       IF      PALFLG-1
;       ADC     #10
;       ENDIF

;****
; PATCH #4 for casette handler

;	CLC
;	ADC	#10

	JMP	CHPAT4
CHP4RT
;
;****


        TAX
        CPX     RTCLOK+2
        BNE     *-2
        BEQ     BEEP1       ;UNCOND GO BEEP AGIN
WFAK:   JSR     WFAK1       ;USE SIMULATED "JMP (KGETCH)"
        TYA
        RTS
WFAK1:  LDA     KEYBDV+5
        PHA
        LDA     KEYBDV+4    ;SIMULATE "JMP (KGETCH)"
        PHA
        RTS
;
; SIOSB - CALL SIO ON SYSTEM BUFFER
;
SIOSB:  STA     DCOMND      ;SAVE COMMAND
        LDA     #0
        STA     DBYTHI      ;SET BUFFER LENGTH
        LDA     #131
        STA     DBYTLO
        LDA     #CBUFH
        STA     DBUFHI      ;SET BUFFER ADDRESS
        LDA     #CBUFL
        STA     DBUFLO
CSIO:   LDA     #$60        ;CASSET PSEUDO DEVICE
        STA     DDEVIC
        LDA     #0
        STA     DUNIT
        LDA     #35         ;DEVICE TIMEOUT (5/30/79)
        STA     DTIMLO
        LDA     DCOMND      ;GET COMMAND BACK
        LDY     #SRSTA      ;SIO READ STATUS COMMAND
        CMP     #'R'
        BEQ     *+4
        LDY     #SWSTA      ;SIO WRITE STATUS COMMAND
        STY     DSTATS      ;SET STATUS FOR SIO
        LDA     FTYPE
        STA     DAUX2       ;INDICATE IF SHORT IRG MODE
        JSR     SIOV        ;GO CALL SIO
        RTS
;
; WSIOSB - WRITE SIO SYSTEM BUFFER
;
WSIOSB: STA     CASBUF+2    ;STORE TYPE BYTE
        LDA     #$55
        STA     CASBUF+0
        STA     CASBUF+1
        LDA     #'W'        ;WRITE
        JSR     SIOSB       ;CALL SIO ON SYSTEM BUFFER
        RTS                 ;RETURN


;**	Check for correct module length

	ASSERT	*=$F0E3
;	SUBTTL	'Printer Handler, Part 2'
;****
; PATCH for printer hander to support multiple unit
; We must fetch unit number from page 3 IOCB block because
; BASIC sometimes does not update zero page IOCB

PHPAT
	LDA	ICDNO,X
	STA	ICDNOZ
	JMP	PRMODE
;	SUBTTL	'Cassette Handler, Part 2'

;****
; PATCH  for CASETTE handler so that it supports both PAL and NTSC

CHPAT1
	LDX	PALNTS
	LDY	RLEADL,X
	LDA	RLEADH,X
	TAX
	JMP	CHP1RT


;****
; PATCH  for CASETTE handler so that it supports both PAL and NTSC

CHPAT2
	LDX	PALNTS
	LDY	WLEADL,X
	LDA	WLEADH,X
	TAX
	JMP	CHP2RT

;****
; PATCH #3 for CASETTE handler so that it supports both PAL and NTSC

CHPAT3
	LDX	PALNTS
	CLC
	ADC	BEEPNX,X
	JMP	CHP3RT

;****
; PATCH #4 for CASETTE handler so that it supports both PAL and NTSC

CHPAT4
	LDX	PALNTS
	CLC
	ADC	BEEPFX,X
	JMP	CHP4RT
;	SPACE	4,10
;**	NTSC/PAL Constant Tables


WLEADH	DB	high WLEADN	;high NTSC WRITE file leader
	DB	high WLEADP	;high PAL WRITE file leader

WLEADL	DB	low WLEADN	;low NTSC WRITE file leader
	DB	low WLEADP	;low PAL WRITE file leader

RLEADH	DB	high RLEADN	;high NTSC READ file leader
	DB	high RLEADP	;high PAL READ file leader

RLEADL	DB	low RLEADN	;low NTSC READ file leader
	DB	low RLEADP	;low PAL READ file leader

BEEPNX	DB	BEEPNN		;NTSC beep duration
	DB	BEEPNP		;PAL beep duration

BEEPFX	DB	BEEPFN		;NTSC beep separation
	DB	BEEPFP		;PAL beep separation
;	SUBTTL	'Peripheral Handler Entry Routine'
;	SPACE	4,10
;**	PHE - Perform Peripheral Handler Entry
;*
;*	PHE attempts to enter a peripheral handler in the handler table.
;*
;*	ENTRY	JSR	PHE
;*		X = device code
;*		A = high linkage table address
;*		Y = low linkage table address
;*
;*	EXIT
;*		Success:
;*		C clear
;*		Handler table entry made
;*
;*		Failure due to entry previously made:
;*		C set
;*		N clear
;*		X = offset to second byte of duplicate entry
;*		A, Y unchanged
;*
;*		Failure due to handler table full:
;*		C set
;*		N set
;*
;*	CHANGES
;*		A X Y
;*
;*	CALLS
;*		-none-
;*
;*	MODS
;*		R. S. Scheiman	04/??/82
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


PHE	=	*	;entry

;	Initialize.

	PHA		;save high linkage table address
	TYA
	PHA		;save low linkage table address

;	Search for device code in handler table.

	TXA			;device code
	LDX	#0		;offset to first entry of table

PHE1	CMP	HATABS,X	;device code from table
	BEQ	PHE3		;if device code found

	INX
	INX
	INX
	CPX	#MAXDEV+1	;offset+1 of last possible entry
	BMI	PHE1		;if not done

;	Search for empty entry in handler table.

	LDX	#0		;offset to first entry of table
	TAY			;save device code
	LDA	#0

PHE2	CMP	HATABS,X	;device code from table
	BEQ	PHE4		;if empty entry found

	INX
	INX
	INX
	CPX	#MAXDEV+1	;offset+1 of last possible entry
	BMI	PHE2		;if not done

;	Return table full condition.

	PLA		;clean stack
	PLA
	LDY	#$FF	;indicate table full (set N)
	SEC		;indicate failure
	RTS		;return

;	Return device code found condition.

PHE3	PLA		;saved Y
	TAY		;restore Y
	PLA		;restore A
	INX		;indicate device code found (clear N)
	SEC		;indicate failure
	RTS		;return

;	Enter handler in table.

PHE4	TYA			;device code
	STA	HATABS,X	;enter device code
	PLA			;saved low linkage table address
	STA	HATABS+1,X	;low address
	PLA			;saved high linkage table address
	STA	HATABS+2,X	;high address

;	Return success condition.

	CLC		;indicate success
	RTS		;return
;	SUBTTL	'Self-test, Part 4'
;	SPACE	4,10
;**	VFR - Verify First 8K ROM
;*
;*	ENTRY	JSR	VFR
;*		??
;*
;*	EXIT
;*		C clear, if verified
;*		  set, if not verified
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


VFR	=	*	;entry

;	Initialize.

	LDX	#0	;offset to first region to checksum
	STX	STCHK	;initial sum is zero
	STX	STCHK+1

;	Checksum ROM.

VFR1	JSR	CRR	;checksum region of ROM
	CPX	#12
	BNE	VFR1	;if not done

;	Compare result.

	LDA	$C000	;low checksum in ROM
	LDX	$C001	;high checksum in ROM
;	JMP	VCS	;verify checksum, return
;	SPACE	4,10
;**	VCS - Verify Checksum
;*
;*	ENTRY	JSR	VCS
;*		??
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


VCS	=	*	;entry
	CMP	STCHK	;low checksum
	BNE	VCS1	;if low checksum bad

	CPX	STCHK+1	;high checksum
	BNE	VCS1	;if high checksum bad

	CLC		;indicate verified
	RTS		;return

VCS1	SEC		;indicate not verified
	RTS		;return
;	SPACE	4,10
;**	VSR - Verify Second 8K ROM
;*
;*	ENTRY	JSR	VSR
;*		??
;*
;*	EXIT
;*		C clear, if verified
;*		  set, if not verified
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


VSR	=	*	;entry
	LDX	#0
	STX	STCHK	;initial sum is zero
	STX	STCHK+1
	LDX	#12	;offset to first region to checksum
	JSR	CRR	;checksum region of ROM
	JSR	CRR	;checksum region of ROM
	LDA	$FFF8	;low checksum from ROM
	LDX	$FFF9	;high checksum from ROM
	JMP	VCS	;verify checksum, return
;	SPACE	4,10
;**	CRR - Checksum Region of ROM
;*
;*	ENTRY	JSR	CRR
;*		X = offset???
;*
;*	EXIT
;*		??
;*
;*	CHANGES
;*		??
;*
;*	CALLS
;*		??
;*
;*	MODS
;*		Original Author Unknown	??/??/??
;*		1. Bring closer to Coding Standard (object unchanged).
;*		   R. K. Nordin	11/01/83


CRR	=	*	;entry

;	Transfer range addresses.

	LDY	#0

CRR1	LDA	TARV,X
	STA	STADR1,Y
	INX
	INY
	CPY	#4	;4 bytes for 2 addresses
	BNE	CRR1	;if not done

;	Checksum range.

	LDY	#0

CRR2	CLC
	LDA	(STADR1),Y
	ADC	STCHK
	STA	STCHK
	BCC	CRR3	;if low value non-zero

	INC	STCHK+1	;adjust high value

CRR3	INC	STADR1	;advance address
	BNE	CRR4	;if low address non-zero

	INC	STADR1+1	;adjust high address

CRR4	LDA	STADR1	;current address
	CMP	STADR2	;end of range
	BNE	CRR2	;if not done

	LDA	STADR1+1
	CMP	STADR2+1
	BNE	CRR2	;if not done

	RTS		;return
;	SPACE	4,10
;**	TARV - Table of Address Ranges to Verify


TARV	DW	$C002,$D000	;first 8K ROM, $C002 - $CFFF
	DW	$5000,$5800	;first 8K ROM, $D000 - $D7FF
	DW	$D800,$E000	;first 8K ROM, $D800 - $DFFF

	DW	$E000,$FFF8	;second 8K ROM, $E000 - $FFF7
	DW	$FFFA,$0000	;second 8K ROM, $FFFA - $FFFF
;	SUBTTL	'$F223 Patch'
;	SPACE	4,10
	FIX	$F223
;	SPACE	4,10
;**	F223 - $F223 Patch
;*
;*	For compatibility with OS Revision B, perform power-up display.


PPD	=	*	;entry
	JMP	SES	;select and execute self-test
;	SUBTTL	'Keyboard, Editor, and Screen Handler'
;	SPACE	4,10
;**	KEYBOARD, EDITOR, AND SCREEN HANDLER
;*
;*	This is the E:, K:, and S: handlers of the Rev. B OS, with
;*	the following patches:
;*
;*	1. Graphics modes 12, 13, 14, and 15 are supported.
;*
;*	2. Clear Screen routine has been patched so that it does not
;*	   write past the top of memory.
;*
;*	3. Keyclick routine has been modified so that it does not
;*	   use WSYNC.
;*
;*	4. Keyclick turn-off via NOCLIK is supported.
;*
;*	5. Help key and help text viewer are supported.

;	SPACE	4,10
;**	TSMA - Table of Screen Memory Allocation
;*
;*	Entry n is the number of $40-byte blocks to allocate for
;*	graphics mode n.


TSMA	DB	24	;0
	DB	16	;1
	DB	10	;2
	DB	10	;3
	DB	16	;4
	DB	28	;5
	DB	52	;6
	DB	100	;7
	DB	196	;8
	DB	196	;9
	DB	196	;10
	DB	196	;11
	DB	28	;12
	DB	16	;13
	DB	100	;14
	DB	196	;15
;	SPACE	4,10
;**	TDLE - Table of Display List Entry Counts
;*
;*	Each entry is 2 bytes.  The first byte is ??????


TDLE	DB	23,23	;0
	DB	11,23	;1
	DB	47,47	;2
	DB	95,95	;3
	DB	97,97	;4
	DB	97,97	;5
	DB	23,11	;6
	DB	191,97	;7
TMDL
	DB	19,19	;8
	DB	9,19	;9
	DB	39,39	;10
	DB	79,79	;11
	DB	65,65	;12
	DB	65,65	;13
	DB	19,9	;14
	DB	159,65	;15
;	SPACE	4,10
;**	TAGM - Table of ANTIC Graphics Modes
;*
;*	Entry n is the ANTIC graphics mode corresponding to internal
;*	graphics mode n.


TAGM	DB	$02	;internal 0 - 40x2x8 characters
	DB	$06	;internal 1 - 20x5x8 characters
	DB	$07	;internal 2 - 20x5x16 characters
	DB	$08	;internal 3 - 40x4x8 graphics
	DB	$09	;internal 4 - 80x2x4 graphics
	DB	$0A	;internal 5 - 80x4x4 graphics
	DB	$0B	;internal 6 - 160x2x2 graphics
	DB	$0D	;internal 7 - 160x4x2 graphics
	DB	$0F	;internal 8 - 320x2x1 graphics
	DB	$0F	;internal 9 - 320x2x1 GTIA "lum" mode
	DB	$0F	;internal 10 - 320x2x1 GTIA "color/lum" mode
	DB	$0F	;internal 11 - 320x2x1 GTIA "color" mode
	DB	$04	;internal 12 - 40x5x8 characters
	DB	$05	;internal 13 - 40x5x16 characters
	DB	$0C	;internal 14 - 160x2x1 graphics
	DB	$0E	;internal 15 - 160x4x1 graphics
;	SPACE	4,10
;**	TDLV - Table of Display List Vulnerability
;*
;*	Entry n is non-zero if the display list for mode n cannot
;*	cross a page boundary.


TDLV	DB	0	;0
	DB	0	;1
	DB	0	;2
	DB	0	;3
	DB	0	;4
	DB	0	;5
	DB	0	;6
	DB	1	;7
	DB	1	;8
	DB	1	;9
	DB	1	;10
	DB	1	;11
	DB	0	;12
	DB	0	;13
	DB	1	;14
	DB	1	;15
;	SPACE	4,10
;**	TLSC - Table of Left Shift Counts
;*
;*	Entry n is the NUMBER OF LEFT SHIFTS NEEDED TO MULTIPLY
;*	COLCRS BY # BYTES/ROW ((ROWCRS*5)/(2**TLSC)) for mode n.???


TLSC	DB	2	;0
	DB	1	;1
	DB	1	;2
	DB	0	;3
	DB	0	;4
	DB	1	;5
	DB	1	;6
	DB	2	;7
	DB	2	;8
	DB	2	;9
	DB	2	;10
	DB	2	;11
	DB	2	;12
	DB	2	;13
	DB	1	;14
	DB	2	;15
;	SPACE	4,10
;**	TMCC - Table of Mode Column Counts
;*
;*	Entry n is the low column count for mode n.


TMCC	DB	low 40		;0
	DB	low 20		;1
	DB	low 20		;2
	DB	low 40		;3
	DB	low 80		;4
	DB	low 80		;5
	DB	low 160		;6
	DB	low 160		;7
	DB	low 320		;8
	DB	low 80		;9
	DB	low 80		;10
	DB	low 80		;11
	DB	low 40		;12
	DB	low 40		;13
	DB	low 160		;14
	DB	low 160		;15
;	SPACE	4,10
;**	TMRC - Table of Mode Row Counts
;*
;*	Entry n is the row count for mode n.


TMRC	DB	24	;0
	DB	24	;1
	DB	12	;2
	DB	24	;3
	DB	48	;4
	DB	48	;5
	DB	96	;6
	DB	96	;7
	DB	192	;8
	DB	192	;9
	DB	192	;10
	DB	192	;11
	DB	24	;12
	DB	12	;13
	DB	192	;14
	DB	192	;15
;	SPACE	4,10
;**	TRSC - Table of Right Shift Counts
;*
;*	Entry n is ??? for mode n.
;*	HOW MANY RIGHT SHIFTS FOR HCRSR FOR PARTIAL BYTE MODES


TRSC	DB	0	;0
	DB	0	;1
	DB	0	;2
	DB	2	;3
	DB	3	;4
	DB	2	;5
	DB	3	;6
	DB	2	;7
	DB	3	;8
	DB	1	;9
	DB	1	;10
	DB	1	;11
	DB	0	;12
	DB	0	;13
	DB	3	;14
	DB	2	;15
;	SPACE	4,10
;**	TDSM - Table of Display Masks
;*
;*	NOTES
;*		Includes TBTM - Table of Bit Masks.


TDSM	DB	$FF	;1
	DB	$F0	;2
	DB	$0F	;3
	DB	$C0	;4
	DB	$30	;5
	DB	$0C	;6
	DB	$03	;7

TBTM	DB	$80	;8 (0)
	DB	$40	;9 (1)
	DB	$20	;10 (2)
	DB	$10	;11 (3)
	DB	$08	;12 (4)
	DB	$04	;13 (5)
	DB	$02	;14 (6)
	DB	$01	;15 (7)
;	SPACE	4,10
;**	KEYBOARD INTERRUPT ROUTINE
;
;
;
;
;
KIR	=	*
PIRQ:   LDA     KBCODE
        CMP     CH1         ;TEST AGAINST LAST KEY PRESSED
        BNE     PIRQ3       ;IF NOT, GO PROCESS KEY
        LDA     KEYDEL      ;IF KEY DELAY BYTE > 0
        BNE     PIRQ4       ;IGNORE KEY AS BOUNCE
PIRQ3:  LDA     KBCODE      ;RESTORE AC
        CMP     #CNTL1      ;TEST CONTROL 1 (SSFLAG)
        BNE     PIRQ1
        LDA     SSFLAG
        EOR     #$FF
        STA     SSFLAG
        BCS     PIRQ4       ;(UNCONDITIONAL) MAKE ^1 INVISIBLE
PIRQ1:  PHA		    ;SAVE THE CHARACTER
	AND	#$3F	    ;MASK OFF SHIFT AND CONTROL
	CMP	#HELP
	BNE	PIRQ6	    ;IF NOT THE HELP KEY
	PLA
	STA	HELPFG	    ;INDICATE HELP KEY PRESSED
	JMP	PIRQ7
PIRQ6:  PLA
	STA     CH
        STA     CH1
PIRQ7:  LDA     #3
        STA     KEYDEL      ;INITIALIZE KEY DELAY FOR DEBOUNCE
        LDA     #0          ;CLEAR COLOR SHIFT BYTE
        STA     ATRACT
PIRQ4:  LDA     KRPDEL
        STA     SRTIMR
PIRQ2:  PLA
        RTI
;
;




;****
; PATCH to fix clear screen write over RAMTOP

PCLRSC
	LDY	ADRESS		;Y get current bias w/i memory page
	LDA	#0
	STA	ADRESS		;make low byte of indirect ptr = 0
	RTS

;****
; PATCH  to eliminate WSYNC from click routine

PCLICK
	LDX	#2*63		;two times trip count
	PHA			;will need to use A
PCLIC1
	STX	CONSOL		;turn loudspeaker on

	LDA	VCOUNT		;loop til VCOUNT changes
PCLIC2
	CMP	VCOUNT		;ea VCOUNT = 2 WSYNCs
	BEQ	PCLIC2

	DEX
	BMI	PCLIC3
	DEX
	BPL	PCLIC1		;loop til count = 0
PCLIC3
	PLA			;restore A
	RTS


;****
; PATCH #1 for DISPLAY handler
; entered w/ X = DINDEX to identify mode 9,10,11,and 15
;	IF (9,10,11)	jump to DHP1RT
;	ELSE IF 15	jump to C0C6
;	ELSE		jump to NOT8

DHPAT1
	CPX	#8
	BCC	DHP1_2

	CPX	#15
	BNE	DHP1_1
	JMP	COC6

DHP1_1
	CPX	#12
	BCS	DHP1_2
	JMP	DHP1RT

DHP1_2
	JMP	NOT8

;****
; PATCH #2 for DISPLAY handler
; IF >= 12	jump C0C10
; ELSE CMP #9	jump DHP2RT

DHPAT2
	LDA	DINDEX
	CMP	#12
	BCS	DHP2_1

	CMP	#9
	JMP	DHP2RT
DHP2_1
	JMP	COC10


;****
; PATCH #3 for DISPLAY handler
; to identify mode 9,10,11,and 15
;	IF (8,9,10,11)	jump to DHP3RT
;	IF (15)		fix DL and jump to DHP3R1
;	ELSE		jump to DOPEN5
; entry w/ A = DINDEX

DHPAT3
	CMP	#8
	BCC	DHP3_2

	CMP	#15
	BEQ	DHP3_3

	CMP	#12
	BCS	DHP3_2
DHP3_1
	JMP	DHP3RT
DHP3_2
	JMP	DOPEN5
DHP3_3
        LDX     #93         ;GET REMAINING NUMBER OF DLE'S
        LDA     RAMTOP      ;RELOAD MEMORY SCAN COUNTER
        SEC
        SBC     #$10
        JSR     STORE
        LDA     #0
        JSR     STORE
        LDA     #$4E        ;(ANTIC) RELOAD MSC CODE FOR GRAPHICS 15
	JMP	DHP3R1

;**	Patch #4 for display handler
;*
;*	Sound keyclick if desired

KFEED	=	*
	LDX	NOCLIK
	BNE	KFEED1		;if keyclick inhibited
	JMP	CLICK
KFEED1
	RTS

;**	Patch #5 for display handler
;*
;*	Do editor open following error.

DHPAT5
	STA	DERRF		;indicate open error
	JSR	EOPEN
	LDA	#0
	STA	DERRF		;indicate no error
	JMP	DHP5RT		;return

;
        FIX	KBDORG
;
; HANDLER DEPENDENT EQUATES
;
CLRCOD  =       CLS         ;CLEAR SCREEN ATASCI CODE
;
PWRONA: LDA     #$FF
        STA     CH
        LDA     MEMTOP+1
        AND     #$F0        ;INSURE 4K PAGE BOUNDARY
        STA     RAMTOP
        LDA     #$40        ;DEFAULT TO UPPER CASE ALPHA AT PWRON
        STA     SHFLOK
        RTS                 ;POWER ON COMPLETED
;
;
; BEGIN DISPLAY HANDLER OPEN PROCESSING
;
DOPEN:  LDA     ICAX2Z      ;GET AUX 2 BYTE
        AND     #$F
        BNE     OPNCOM      ;IF MODE ZERO, CLEAR ICAX1Z
EOPEN:  LDA     ICAX1Z      ;CLEAR "CLR INHIBIT" AND "MXD MODE" BITS
        AND     #$F
        STA     ICAX1Z
        LDA     #0
OPNCOM: STA     DINDEX
        LDA     #$E0        ;INITIALIZE GLOBAL VBLANK RAM
        STA     CHBAS
        LDA     #2
        STA     CHACT
        STA     SDMCTL      ;TURN OFF DMA NEXT VBLANK
        LDA     #SUCCES
        STA     DSTAT       ;CLEAR STATUS
        LDA     #$C0        ;DO IRQEN
        ORA     POKMSK
        STA     POKMSK
        STA     IRQEN
        LDA     #0
        STA     TINDEX      ;TEXT INDEX MUST ALWAYS BE 0
        STA     ADRESS
        STA     SWPFLG
        STA     CRSINH      ;TURN CURSOR ON AT OPEN
        LDY     #14         ;CLEAR TAB STOPS
        LDA     #1          ;INIT TAB STOPS TO EVERY 8 CHARACTERS
CLRTBS: STA     TABMAP,Y
        DEY
        BPL     CLRTBS
        LDX     #4          ;LOAD COLOR REGISTERS
DOPEN8: LDA     COLRTB,X
        STA     COLOR0,X
        DEX
        BPL     DOPEN8
        LDY     RAMTOP      ;DO TXTMSC=$2C40 (IF MEMTOP=3000)
        DEY
        STY     TXTMSC+1
        LDA     #$60
        STA     TXTMSC
        LDX     DINDEX

;****
; change to reference a XL OS table
;
;       LDA     ANCONV,X    ;CONVERT IT TO ANTIC CODE
	LDA	TAGM,X

        BNE     DOPENA      ;UNCONDITIONAL
OPNERR: LDA     #BADMOD     ;SET ERROR STATUS
        STA     DSTAT
DOPENA: STA     HOLD1
        LDA     RAMTOP      ;SET UP AN INDIRECT POINTER
        STA     ADRESS+1

;****
; change to reference XL OS table
;
;       LDY     ALOCAT,X    ;ALLOCATE N BLOCKS OF 40 BYTES
	LDY	TSMA,X

DOPEN1: LDA     #40
        JSR     DBSUB
        DEY
        BNE     DOPEN1
        LDA     GPRIOR      ;CLEAR GTIA MODES
        AND     #$3F
        STA     OPNTMP+1
        TAY

;****
; PATCH #1

;       CPX     #8	    ;TEST IF 320x1
;       BCC     NOT8

	JMP	DHPAT1
	NOP

DHP1RT
;
;****

        TXA                 ;GET 2 LOW BITS
        ROR     A
        ROR     A
        ROR     A
        AND     #$C0        ;NOW 2 TOP BITS
        ORA     OPNTMP+1
        TAY

COC6			    ;label from XL OS to support PATCH #1

        LDA     #16         ;SUBTRACT 16 MORE FOR PAGE BOUNDARY
        JSR     DBSUB
        CPX     #11         ;TEST MODE 11
        BNE     NOT8        ;IF MODE = 11
        LDA     #6          ;PUT GTIA LUM VALUE INTO BACKGROUND REGISTER
        STA     COLOR4
NOT8:   STY     GPRIOR      ;STORE NEW PRIORITY
        LDA     ADRESS      ;SAVE MEMORY SCAN COUNTER ADDRESS
        STA     SAVMSC
        LDA     ADRESS+1
        STA     SAVMSC+1
VBWAIT: LDA     VCOUNT      ;WAIT FOR NEXT VBLANK BEFORE MESSING
        CMP     #$7A        ;WITH THE DISPLAY LIST
        BNE     VBWAIT
        JSR     DBDEC       ;START PUTTING DISPLAY LIST RIGHT UNDER RAM

;****
; change to reference XL OS table
;
;       LDA     PAGETB,X    ;TEST IF DISPLAY LIST WILL BE IN TROUBLE
	LDA	TDLV,X

        BEQ     NOMOD       ;OF CROSSING A 256 BYTE PAGE BOUNDARY
        LDA     #$FF        ;IF SO, DROP DOWN A PAGE
        STA     ADRESS
        DEC     ADRESS+1
NOMOD:  LDA     ADRESS      ;SAVE END OF DISPLAY LIST FOR LATER
        STA     SAVADR
        LDA     ADRESS+1
        STA     SAVADR+1
        JSR     DBDDEC      ;(DOUBLE BYTE DOUBLE DECREMENT)
        LDA     #$41        ;(ANTIC) WAIT FOR VBLANK AND JMP TO TOP
        JSR     STORE
        STX     OPNTMP
        LDA     #24         ;INITIALIZE BOTSCR
        STA     BOTSCR

;****
; PATCH #2

;       LDA     DINDEX      ;DISALLOW MIXED MODE IF MODE.GE.9
;       CMP     #9

	JMP	DHPAT2
	NOP

DHP2RT
;
;****
        BCS     NOTMXD

COC10			    ; label from XL OS to support PATCH #2

        LDA     ICAX1Z      ;TEST MIXED MODE
        AND     #$10
        BEQ     NOTMXD
        LDA     #4
        STA     BOTSCR
        LDX     #2          ;ADD 4 LINES OF TEXT AT BOTTOM OF SCREEN
DOPEN2: LDA     #2
        JSR     STORE
        DEX
        BPL     DOPEN2
        LDY     RAMTOP      ;RELOAD MSC FOR TEXT
        DEY
        TYA
        JSR     STORE
        LDA     #$60
        JSR     STORE
        LDA     #$42
        JSR     STORE
        CLC

;****
; change to reference XL OS table
;
;       LDA     #MXDMDE-NUMDLE ;POINT X AT MIXED MODE TABLE
	LDA	#TMDL-TDLE

        ADC     OPNTMP
        STA     OPNTMP
NOTMXD: LDY     OPNTMP

;****
; change to reference XL OS table
;
;       LDX     NUMDLE,Y    ;GET NUMBER OF DISPLAY LIST ENTRIES
	LDX	TDLE,Y

DOPEN3: LDA     HOLD1       ;STORE N DLE'S
        JSR     STORE
        DEX
        BNE     DOPEN3
        LDA     DINDEX      ;DO THE MESSY 320X1 PROBLEM

;****
; PATCH #3

;       CMP     #8
;       BCC     DOPEN5

	JMP	DHPAT3
	NOP

DHP3RT
;
;****
        LDX     #93         ;GET REMAINING NUMBER OF DLE'S
        LDA     RAMTOP      ;RELOAD MEMORY SCAN COUNTER
        SEC
        SBC     #$10
        JSR     STORE
        LDA     #0
        JSR     STORE
        LDA     #$4F        ;(ANTIC) RELOAD MSC CODE
DHP3R1  JSR     STORE
DOPEN4: LDA     HOLD1       ;DO REMAINING DLE'S
        JSR     STORE
        DEX
        BNE     DOPEN4
DOPEN5: LDA     SAVMSC+1    ;POLISH OFF DISPLAY LIST
        JSR     STORE
        LDA     SAVMSC
        JSR     STORE
        LDA     HOLD1
        ORA     #$40
        JSR     STORE
        LDA     #$70        ;24 BLANK LINES
        JSR     STORE
        LDA     #$70
        JSR     STORE
        LDA     ADRESS      ;SAVE DISPLAY LIST ADDRESS
        STA     SDLSTL
        LDA     ADRESS+1
        STA     SDLSTL+1
        LDA     #$70        ;ADD LAST BLANK LINE ENTRY
        JSR     STORE       ;POSITION ADRESS=SDLSTL-1
        LDA     ADRESS      ;STORE NEW MEMTOP
        STA     MEMTOP
        LDA     ADRESS+1
        STA     MEMTOP+1
        LDA     SAVADR
        STA     ADRESS
        LDA     SAVADR+1
        STA     ADRESS+1
        LDA     SDLSTL+1
        JSR     STORE
        LDA     SDLSTL
        JSR     STORE
        LDA     DSTAT       ;IF ERROR OCURRED ON ALLOCATION, OPEN THE EDITOR
        BPL     DOPEN9
        PHA                 ;SAVE STATUS

;	Patch #5
;       JSR     EOPEN       ;OPEN THE EDITOR
	JMP	DHPAT5
DHP5RT

        PLA                 ;RESTORE STATUS
        TAY                 ;AND RETURN IT TO CIO
        RTS
DOPEN9: LDA     ICAX1Z      ;TEST CLEAR INHIBIT BIT
        AND     #$20
        BNE     DOPEN7
        JSR     CLRSCR      ;CLEAR SCREEN
        STA     TXTROW      ;AND HOME TEXT CURSOR (AC IS ZERO)
        LDA     LMARGN
        STA     TXTCOL
DOPEN7: LDA     #$22        ;EVERYTHING ELSE IS SET UP
        ORA     SDMCTL      ;SO TURN ON DMACTL
        STA     SDMCTL
        JMP     RETUR2
;
;
GETCH:  JSR     RANGE       ;GETCH DOES INCRSR, GETPLT DOESN'T
        JSR     GETPLT
        JSR     INATAC      ;CONVERT INTERNAL CODE TO ATASCII
        JSR     INCRSB
        JMP     RETUR1
GETPLT: JSR     CONVRT      ;CONVERT ROW/COLUMN TO ADRESS
        LDA     (ADRESS),Y
        AND     DMASK
SHIFTD: LSR     SHFAMT      ;SHIFT DATA DOWN TO LOW BITS
        BCS     SHIFT1
        LSR     A
        BPL     SHIFTD      ;(UNCONDITIONAL)
SHIFT1: STA     CHAR
        CMP     #0          ;RESTORE FLAGS ALSO
        RTS
;
;
OUTCH:  STA     ATACHR
        JSR     RANGE
;       JSR     OFFCRS
OUTCHA: LDA     ATACHR      ;TEST FOR CLEAR SCREEN
        CMP     #CLRCOD
        BNE     OUTCHE
        JSR     CLRSCR
        JMP     RETUR2
OUTCHE: LDA     ATACHR      ;TEST FOR CARRIAGE RETURN
        CMP     #CR
        BNE     OUTCHB
        JSR     DOCRWS      ;DO CR
        JMP     RETUR2
OUTCHB: JSR     OUTPLT
        JSR     INCRSR
        JMP     RETUR2
;
;
OUTPLT: LDA     SSFLAG      ;*****LOOP HERE IF START/STOP FLAG IS NON-0
        BNE     OUTPLT
        LDX     #2
CRLOOP: LDA     ROWCRS,X    ;SAVE CURSOR LOCATION FOR DRAW LINE TO DRAW FROM
        STA     OLDROW,X
        DEX
        BPL     CRLOOP
        LDA     ATACHR      ;CONVERT ATASCII(ATACHR) TO INTERNAL(CHAR)
        TAY                 ;SAVE ATACHR
        ROL     A
        ROL     A
        ROL     A
        ROL     A
        AND     #3
        TAX                 ;X HAS INDEX INTO ATAINT
        TYA                 ;RESTORE ATACHR
        AND     #$9F        ;STRIP OFF COLUMN ADDRESS
        ORA     ATAINT,X    ;OR IN NEW COLUMN ADDRESS
OUTCH2: STA     CHAR
        JSR     CONVRT
        LDA     CHAR
SHIFTU: LSR     SHFAMT      ;SHIFT UP TO PROPER POSITION
        BCS     SHIFT2
        ASL     A
        JMP     SHIFTU
SHIFT2: AND     DMASK
        STA     TMPCHR      ;SAVE SHIFTED DATA
        LDA     DMASK       ;INVERT MASK
        EOR     #$FF
        AND     (ADRESS),Y  ;MASK OFF OLD DATA
        ORA     TMPCHR      ;OR IN NEW DATA
        STA     (ADRESS),Y
        RTS
;
;
RETUR2: JSR     GETPLT      ;DO CURSOR ON THE WAY OUT
        STA     OLDCHR
        LDX     DINDEX      ;GRAPHICS HAVE INVISIBLE CURSOR
        BNE     RETUR1
        LDX     CRSINH      ;TEST CURSOR INHIBIT
        BNE     RETUR1
        EOR     #$80        ;TOGGLE MSB
        JSR     OUTCH2      ;DISPLAY IT
RETUR1: LDY     DSTAT       ;RETURN TO CIO WITH STATUS IN Y
        LDA     #SUCCES
        STA     DSTAT       ;SET STATUS= SUCCESSFUL COMPLETION
        LDA     ATACHR      ;PUT ATACHR IN AC FOR RETURN TO CIO
NOFUNC: RTS                 ;(NON-EXISTENT FUNCTION RETURN POINT)
;
;
;
; END OF DISPLAY HANDLER
;
;;
;
EGETCH: JSR     SWAP
        JSR     ERANGE
        LDA     BUFCNT      ;ANYTHING IN THE BUFFER?
        BNE     EGETC3      ;YES
        LDA     ROWCRS      ;NO, SO SAVE BUFFER START ADDRESS
        STA     BUFSTR
        LDA     COLCRS
        STA     BUFSTR+1
EGETC1: JSR     KGETCH ;LET'S FILL OUR BUFFER
        STY     DSTAT       ;SAVE KEYBOARD STATUS
        LDA     ATACHR      ;TEST FOR CR
        CMP     #CR
        BEQ     EGETC2
        JSR     DOSS        ;NO, SO PRINT IT
        JSR     SWAP        ;JSR DOSS DID SWAP SO SWAP BACK
        LDA     LOGCOL      ;BEEP IF NEARING LOGICAL COL 120
        CMP     #113
        BNE     EGETC6
        JSR     BELL
EGETC6: JMP     EGETC1
EGETC2: JSR     OFFCRS      ;GET BUFFER COUNT
        JSR     DOBUFC
        LDA     BUFSTR      ;RETURN A CHARACTER
        STA     ROWCRS
        LDA     BUFSTR+1
        STA     COLCRS
EGETC3: LDA     BUFCNT
        BEQ     EGETC5
EGETC7: DEC     BUFCNT      ;AND RETURN TILL BUFCNT=0
        BEQ     EGETC5
        LDA     DSTAT       ;IF ERR, LOOP ON EGETC7 UNTIL BUFR IS EMPTIED
        BMI     EGETC7
        JSR     GETCH
        STA     ATACHR
        JMP     SWAP        ;AND RETURN WITHOUT TURNING CURSOR BACK ON
EGETC5: JSR     DOCRWS      ;DO REAL CARRIAGE RETURN
        LDA     #CR         ;AND RETURN EOL
        STA     ATACHR
        JSR     RETUR2      ;TURN ON CURSOR THEN SWAP
        STY     DSTAT       ;SAVE KEYBOARD STATUS
        JMP     SWAP        ;AND RETURN THROUGH RETUR1
;
JSRIND: JMP     (ADRESS)    ;JSR TO THIS CAUSES JSR INDIRECT
;
EOUTCH: STA     ATACHR      ;SAVE ATASCII VALUE
        JSR     SWAP
        JSR     ERANGE
DOSS:   JSR     OFFCRS      ;TURN OFF CURSOR
        JSR     TSTCTL      ;TEST FOR CONTROL CHARACTERS (Z=1 IF CTL)
        BEQ     EOUTC5
EOUTC6: ASL     ESCFLG      ;ESCFLG ONLY WORKS ONCE
        JSR     OUTCHE
ERETN:  JMP     SWAP        ;AND RETURN THROUGH RETUR1
EOUTC5: LDA     DSPFLG      ;DO DSPFLG AND ESCFLG
        ORA     ESCFLG
        BNE     EOUTC6      ;IF NON-0 DISPLAY RATHER THAN EXECUTE IT
        ASL     ESCFLG
        INX                 ;PROCESS CONTROL CHARACTERS
        LDA     CNTRLS,X    ;GET DISPLACEMENT INTO ROUTINE
        STA     ADRESS
        LDA     CNTRLS+1,X  ;GET HIGH BYTE
        STA     ADRESS+1
        JSR     JSRIND      ;DO COMPUTED JSR
        JSR     RETUR2      ;DO CURSOR
        JMP     SWAP        ;ALL DONE SO RETURN THROUGH RETUR1
;
;
;
;
; END SCREEN EDITOR.
;
;
; BEGIN KEYBOARD HANDLER
;
;
;
;
KGETC2: LDA     #$FF
        STA     CH
KGETCH: LDA     ICAX1Z      ;TEST LSB OF AUX1 FOR SPECIAL EDITOR READ MODE
        LSR     A
        BCS     GETOUT
        LDA     #BRKABT
        LDX     BRKKEY      ;TEST BREAK
        BEQ     K7          ;IF BREAK, PUT BRKABT IN DSTAT AND CR IN ATACHR
;       LDA     CH
	JSR	CHK

        CMP     #$FF
        BEQ     KGETCH
        STA     HOLDCH      ;SAVE CH FOR SHIFT LOCK PROC
        LDX     #$FF        ;"CLEAR" CH
        STX     CH
        JSR     KFEED       ;DO KEYBOARD AUDIO FEEDBACK (A IS OK)
KGETC3: TAX                 ;DO ASCCON
        CPX     #$C0        ;TEST FOR CTL & SHIFT TOGETHER
        BCC     ASCCO1
        LDX     #3          ;BAD CODE
ASCCO1: LDA     ATASCI,X
        STA     ATACHR      ;DONE
        CMP     #$80        ;DO NULLS
        BEQ     KGETC2
        CMP     #$81        ;CHECK ATARI KEY
        BNE     KGETC1
        LDA     INVFLG
        EOR     #$80
        STA     INVFLG
        JMP     KGETC2      ;DONT RETURN A VALUE
KGETC1: CMP     #$82        ;CAPS/LOWER
        BNE     K1
        LDA     #0          ;CLEAR SHFLOK
        STA     SHFLOK
        BEQ     KGETC2
K1:     CMP     #$83        ;SHIFT CAPS/LOWER
        BNE     K2
        LDA     #$40
        STA     SHFLOK      ;SHIFT BIT
        BNE     KGETC2
K2:     CMP     #$84        ;CNTL CAPS/LOWER
        BNE     K3
        LDA     #$80        ;CNTL BIT
        STA     SHFLOK
        BNE     KGETC2
K3:     CMP     #$85        ;DO EOF
        BNE     K6
        LDA     #EOFERR
K7:     STA     DSTAT
        STA     BRKKEY      ;RESTORE BREAK
GETOUT: LDA     #CR         ;PUT CR IN ATACHR
        BNE     K8          ;(UNCONDITIONAL)
K6:     LDA     HOLDCH      ;PROCESS SHIFT LOCKS
        CMP     #$40        ;REGULAR SHIFT AND CONTROL TAKE PRECEDENCE
        BCS     K5          ;OVER LOCK
        LDA     ATACHR      ;TEST FOR ALPHA
        CMP     #$61        ;LOWER CASE A
        BCC     K5          ;NOT ALPHA IF LT
        CMP     #$7B        ;LOWER CASE Z+1
        BCS     K5          ;NOT ALPHA IF GE
        LDA     SHFLOK      ;DO SHIFT/CONTROL LOCK
        BEQ     K5          ;IF NO LOCK, DONT RE-DO IT
        ORA     HOLDCH
        JMP     KGETC3      ;DO RETRY
K5:     JSR     TSTCTL      ;DONT INVERT MSB OF CONTROL CHARACTERS
        BEQ     K4
        LDA     ATACHR
        EOR     INVFLG
K8:     STA     ATACHR
K4:     JMP     RETUR1      ;ALL DONE
;
;
        EJECT
;
;
; CONTROL CHARACTER PROCESSORS
;
ESCAPE: LDA     #$80        ;SET ESCAPE FLAG
        STA     ESCFLG
        RTS
CRSRUP: DEC     ROWCRS
        BPL     COMRET
        LDX     BOTSCR      ;WRAPAROUND
        DEX
UPDNCM: STX     ROWCRS
COMRET: JMP     STRBEG      ;COLVERT ROW AND COL TO LOGCOL AND RETURN
CRSRDN: INC     ROWCRS
        LDA     ROWCRS
        CMP     BOTSCR
        BCC     COMRET
        LDX     #0
        BEQ     UPDNCM      ;(UNCONDITIONAL)
CRSRLF: DEC     COLCRS
        LDA     COLCRS
        BMI     CRSRL1      ;(IF LMARGN=0, THIS ELIMINATES PROBLEM CASE)
        CMP     LMARGN
        BCS     COMRE1
CRSRL1: LDA     RMARGN
LFRTCM: STA     COLCRS
COMRE1: JMP     DOLCOL      ;COLVERT ROW AND COL TO LOGCOL AND RETURN
CRSRRT: INC     COLCRS
        LDA     COLCRS
        CMP     RMARGN
        BCC     COMRE1
        BEQ     COMRE1      ;(CAUSE BLE)
        LDA     LMARGN
        JMP     LFRTCM      ;UNCONDITIONAL TO COMMON STORE
CLRSCR: JSR     PUTMSC
;       LDY     #0
;       TYA                 ;PUT 0 IN THE AC
	JSR	PCLRSC 	    ;do substitution routine
CLRSC2: STA     (ADRESS),Y  ;(AC IS ZERO)
        INY
        BNE     CLRSC2
        INC     ADRESS+1
        LDX     ADRESS+1
        CPX     RAMTOP
        BCC     CLRSC2
        LDA     #$FF        ;CLEAN UP LOGICAL LINE BIT MAP
CLRSC3: STA     LOGMAP,Y    ;(Y IS ZERO AFTER CLRSC2 LOOP)
        INY
        CPY     #4
        BCC     CLRSC3
HOME:   JSR     COLCR       ;PLACE COLCRS AT LEFT EDGE
        STA     LOGCOL
        STA     BUFSTR+1
        LDA     #0
        STA     ROWCRS
        STA     COLCRS+1
        STA     BUFSTR
        RTS
;
BS:     LDA     LOGCOL      ;BACKSPACE
        CMP     LMARGN
        BEQ     BS1
BSA:    LDA     COLCRS      ;LEFT EDGE?
        CMP     LMARGN
        BNE     BS3         ;NO
        JSR     DELTIM      ;YES, SEE IF LINE SHOULD BE DELETED
BS3:    JSR     CRSRLF
        LDA     COLCRS
        CMP     RMARGN
        BNE     BS2
        LDA     ROWCRS
        BEQ     BS2
        JSR     CRSRUP
BS2:    LDA     #$20        ;MAKE BACKSPACE DESTRUCTIVE
        STA     ATACHR
        JSR     OUTPLT
BS1:    JMP     DOLCOL      ;AND RETURN
TAB:    JSR     CRSRRT      ;BEGIN SEARCH
        LDA     COLCRS      ;TEST FOR NEW LINE
        CMP     LMARGN
        BNE     TAB1        ;NO
        JSR     DOCR        ;DO CARRIAGE RETURN
        JSR     LOGGET      ;CHECK IF END OF LOGICAL LINE
        BCC     TAB1        ;NO, CONTINUE
        BCS     TAB2        ;(UNCONDITIONAL)
TAB1:   LDA     LOGCOL      ;CHECK FOR TAB STOP
        JSR     BITGET
        BCC     TAB         ;NO, SO KEEP LOOKING
TAB2:   JMP     DOLCOL      ;COLVERT ROW AND COL TO LOGCOL AND RETURN
SETTAB: LDA     LOGCOL
        JMP     BITSET      ;SET BIT IN MAP AND RETURN
CLRTAB: LDA     LOGCOL
        JMP     BITCLR      ;CLEAR " " " " "
INSCHR: JSR     PHACRS
        JSR     GETPLT      ;GET CHARACTER UNDER CURSOR
        STA     INSDAT
        LDA     #0
        STA     SCRFLG
INSCH4: JSR     OUTCH2      ;STORE DATA
        LDA     LOGCOL      ;SAVE LOGCOL: IF AFTER INCRSA LOGCOL IS
        PHA                 ;< THAN IT IS NOW, END LOOP
        JSR     INCRSA      ;SPECIAL INCRSR ENTRY POINT
        PLA
        CMP     LOGCOL
        BCS     INSCH3      ;QUIT
INSCH1: LDA     INSDAT      ;KEEP GOING
        PHA
        JSR     GETPLT
        STA     INSDAT
        PLA
        JMP     INSCH4
INSCH3: JSR     PLACRS
INSCH6: DEC     SCRFLG
        BMI     INSCH5      ;IF SCROLL OCCURRED
        DEC     ROWCRS      ;MOVE CURSOR UP
        BNE     INSCH6      ;(UNCOND) CONTINUE UNTIL SCRFLG IS MINUS
INSCH5: JMP     DOLCOL      ;COLVERT ROW AND COL TO LOGCOL AND RETURN
;
;
DELCHR: JSR     PHACRS
DELCH1: JSR     CONVRT      ;GET DATA TO THE RIGHT OF THE CURSOR
        LDA     ADRESS
        STA     SAVADR      ;SAVE ADRESS TO KNOW WHERE TO PUT DATA
        LDA     ADRESS+1
        STA     SAVADR+1
        LDA     LOGCOL
        PHA
        JSR     INCRSB      ;PUT CURSOR OVER NEXT CHARACTER
        PLA
        CMP     LOGCOL      ;TEST NEW LOGCOL AGAINST OLD LOGCOL
        BCS     DELCH2      ;IF OLD.GE.NEW THEN QUIT
        LDA     ROWCRS      ;IS ROW OFF SCREEN?
        CMP     BOTSCR
        BCS     DELCH2      ;YES, SO QUIT
        JSR     GETPLT      ;GET DATA UNDER CURSOR
        LDY     #0
        STA     (SAVADR),Y  ;PUT IT IN PREVIOUS POSITION
        BEQ     DELCH1      ;AND LOOP (UNCONDITIONAL)
DELCH2: LDY     #0
        TYA
        STA     (SAVADR),Y  ;CLEAR THE LAST POSITION
        JSR     DELTIA      ;TRY TO DELETE A LINE
        JSR     PLACRS
        JMP     DOLCOL      ;AND RETURN
INSLIN: SEC                 ;NORMAL INSLIN PUTS "1" INTO BIT MAP
INSLIA: JSR     EXTEND      ;ENTRY POINT FOR C=0
        LDA     LMARGN      ;DO CARRIAGE RETURN (NO LF)
        STA     COLCRS
        JSR     CONVRT      ;GET ADDRESS
        LDA     ADRESS      ;SET UP T0=40+FROM (FROM = CURSOR)
        STA     FRMADR
        CLC
        ADC     #40
        STA     TOADR
        LDA     ADRESS+1
        STA     FRMADR+1
        ADC     #0
        STA     TOADR+1
        LDX     ROWCRS      ;SET UP LOOP COUNTER
        CPX     #23
        BEQ     INSLI2
INSLI1: JSR     MOVLIN
        INX
        CPX     #23
        BNE     INSLI1
INSLI2: JSR     CLRLIN      ;CLEAR CURRENT LINE
        JMP     DOLCOL      ;COLVERT ROW AND COL TO LOGCOL AND RETURN
DELLIN: JSR     DOLCOL      ;GET BEGINNING OF LOG LINE (HOLD1)
DELLIA: LDY     HOLD1       ;SQUEEZE BIT MAP
        STY     ROWCRS      ;PUT CURSOR THERE
DELLIB: LDY     ROWCRS
DELLI1: TYA
        SEC
        JSR     LO2GET      ;GET NEXT BIT
        PHP
        TYA
        CLC
        ADC     #120
        PLP
        JSR     BITPUT      ;WRITE IT OVER PRESENT BIT
        INY
        CPY     #24
        BNE     DELLI1      ;LOOP
        LDA     LOGMAP+2    ;SET LSB
        ORA     #1
        STA     LOGMAP+2
DELLI2: LDA     LMARGN      ;DELETE LINE OF DATA USING PART OF SCROLL
        STA     COLCRS      ;CR NO LF
        JSR     CONVRT
        JSR     SCROL1
        JSR     LOGGET      ;TEST NEXT LINE FOR CONTINUATION
; IS IT A NEW LOG LINE?
        BCC     DELLIB      ;NO SO DELETE ANOTHER
        JMP     DOLCOL      ;YES SO DOLCOL AND RETURN
BELL:   LDY     #$20
BELL1:  JSR     CLICK
        DEY
        BPL     BELL1
        RTS
        EJECT
;
;
; ROUTINES
;
;
; DOUBLE BYTE DECREMENT OF INDIRECT POINTER
; INCLUDING DB SUBTRACT AND DB DOUBLE DECREMENT
;
DBDDEC: LDA     #2
        BNE     DBSUB       ;(UNCONDITIONAL)
;
; STORE DATA INDIRECT AND DECREMENT POINTER
; (PLACED HERE TO SAVE JMP DBDEC AFTER STORE)
STORE:  LDY     DSTAT       ;RETURN ON ERROR
        BMI     STROK
        LDY     #0
STORE1: STA     (ADRESS),Y
;       JMP     DBDEC       DECREMENT AND RETURN
;
DBDEC:  LDA     #1
DBSUB:  STA     SUBTMP
        LDA     DSTAT       ;RETURN ON ERROR
        BMI     STROK
        LDA     ADRESS
        SEC
        SBC     SUBTMP
        STA     ADRESS
        BCS     DBSUB1
        DEC     ADRESS+1
DBSUB1: LDA     APPMHI+1    ;MAKE SURE NOTHING EVER OVERWRITES APPMHI
        CMP     ADRESS+1
        BCC     STROK       ;OK
        BNE     STRERR      ;ERROR
        LDA     APPMHI
        CMP     ADRESS
        BCC     STROK
STRERR: LDA     #SCRMEM     ;SHOW MEM TOO SMALL FOR SCREEN ERROR
        STA     DSTAT
STROK:  RTS
;
;
;
; CONVERT ROW/COLUMN CURSOR INTO REAL ADDRESS (FROM SAVMSC ON UP)
;
CONVRT: LDA     ROWCRS      ;SAVE CURSOR
        PHA
        LDA     COLCRS
        PHA
        LDA     COLCRS+1
        PHA
        JSR     PUTMSC
        LDA     ROWCRS      ;PUT 10*ROWCRS INTO MLTTMP
        STA     MLTTMP
        LDA     #0
        STA     MLTTMP+1
        LDA     MLTTMP      ;QUICK X8
        ASL     A
        ROL     MLTTMP+1
        STA     HOLD1       ;(SAVE 2X VALUE)
        LDY     MLTTMP+1    ;""
        STY     HOLD2       ;""
        ASL     A
        ROL     MLTTMP+1
        ASL     A
        ROL     MLTTMP+1
        CLC                 ;ADD IN 2X
        ADC     HOLD1
        STA     MLTTMP
        LDA     MLTTMP+1
        ADC     HOLD2
        STA     MLTTMP+1
        LDX     DINDEX      ;NOW SHIFT MLTTMP LEFT DHLINE TIMES TO FINISH
;****
; change to reference modified XL OS table
;
;       LDY     DHLINE,X    ;MULTIPLY
	LDY	TLSC,X

CONVR1: DEY                 ;LOOP N TIMES
        BMI     CONVR2
        ASL     MLTTMP
        ROL     MLTTMP+1
        JMP     CONVR1

;****
; change to reference XL OS table
;
;CONVR2: LDY     DIV2TB,X    ;NOW DIVIDE HCRSR TO ACCOUNT FOR PARTIAL BYTES
CONVR2	LDY	TRSC,X

        LDA     COLCRS
        LDX     #7          ;* TRICKY *
CONVR3: DEY
        BMI     CONVR4
        DEX
        LSR     COLCRS+1
        ROR     A
        ROR     TMPLBT      ;SAVE LOW BITS FOR MASK
        JMP     CONVR3
CONVR4: INY                 ;SO Y IS ZERO UPON RETURN FROM THIS ROUTINE
        CLC
        ADC     MLTTMP      ;ADD SHIFTED COLCRS TO MLTTMP
        STA     MLTTMP
        BCC     CONVR5
        INC     MLTTMP+1
CONVR5: SEC                 ;* TRICKY *
CONVR6: ROR     TMPLBT      ;SLIDE A "1" UP AGAINST LOW BITS (CONTINUE TILL X=-1)
        CLC
        DEX                 ;AND FINISH SHIFT SO LOW BITS ARE
        BPL     CONVR6      ;RIGHT JUSTIFIED.
        LDX     TMPLBT      ;TMPLBT IS NOW THE INDEX INTO DMASKTB
        LDA     MLTTMP      ;PREPARE FOR RETURN
        CLC
        ADC     ADRESS
        STA     ADRESS
        STA     OLDADR      ;REMEMBER THIS ADDRESS FOR CURSOR
        LDA     MLTTMP+1
        ADC     ADRESS+1
        STA     ADRESS+1
        STA     OLDADR+1
        LDA     DMASKT,X
        STA     DMASK
        STA     SHFAMT
        PLA
        STA     COLCRS+1
        PLA
        STA     COLCRS
        PLA
        STA     ROWCRS
        RTS
;
;
; INCREMENT CURSOR AND DETECT BOTH END OF LINE AND END OF SCREEN
;
INCRSB: LDA     #0          ;NON-EXTEND ENTRY POINT
        BEQ     INCRSC
INCRSR: LDA     #$9B        ;SPECIAL CASE ELIMINATOR
INCRSC: STA     INSDAT
INCRSA: INC     LOGCOL      ;(INSCHR ENTRY POINT)
        INC     COLCRS
        BNE     INCRS2      ;DO HIGH BYTE
        INC     COLCRS+1
INCRS2: LDA     COLCRS      ;TEST END OF LINE
        LDX     DINDEX

;****
; change to reference XL OS table
;
;       CMP     COLUMN,X    ;TEST TABLED VALUE FOR ALL SCREEN MODES
	CMP	TMCC,X

        BEQ     INC2A       ;DO CR IF EQUAL
        CPX     #0          ;MODE 0?
        BNE     INCRS3      ;IF NOT, JUST RETURN
        CMP     RMARGN      ;TEST AGAINST RMARGN
        BEQ     INCRS3      ;EQUAL IS OK
        BCS     INC2A       ;IF GREATER THAN, DO CR
INCRS3: RTS
INC2A:  CPX     #8          ;CHECK MODE
        BCC     DOCR1       ;NOT 320X1 SO DO IT
        LDA     COLCRS+1    ;TEST MSD
        BEQ     INCRS3      ;ONLY AT 64 SO DON'T DO IT
DOCR1:  LDA     DINDEX      ;DON'T MESS WITH LOGMAP IF NO MODE ZERO
        BNE     DOCR
        LDA     LOGCOL      ;TEST LINE OVERRUN
        CMP     #81
        BCC     DOCR1B      ;IF LESS THAN 81 IT IS DEFINITELY NOT LINE 3
        LDA     INSDAT
        BEQ     DOCR        ;ONLY DO LOG LINE OVERFLOW IF INSDAT <>0
        JSR     DOCRWS      ;LOG LINE OVERFLOW IS SPECIAL CASE
        JMP     INCRS1      ;RETURN
DOCR1B: JSR     DOCR        ;GET IT OVER WITH
        LDA     ROWCRS
        CLC                 ;TEST LOGICAL LINE BIT MAP
        ADC     #120
        JSR     BITGET
        BCC     DOCR1A      ;DON'T EXTEND IF OVERRUN IS INTO MIDDLE OF LOG LINE
        LDA     INSDAT      ;DON'T EXTEND IF INSDAT IS ZERO
        BEQ     DOCR1A      ;(INSCHR SPECIAL CASE)
        CLC                 ;INSERT "0" INTO BIT MAP
        JSR     INSLIA
DOCR1A: JMP     DOLCOL      ;CONVERT ROW AND COL TO LOGCOL AND RETURN
NOSCRL: LDA     #0          ;DOCR WITHOUT SCROLL
        BEQ     NOSCR1      ;(UNCONDITIONAL)
DOCRWS: LDA     #$9B        ;DOCR WITH SCROLLING (NORMAL MODE)
NOSCR1: STA     INSDAT
DOCR:   JSR     COLCR       ;PLACE COLCRS AT LEFT EDGE
        LDA     #0
        STA     COLCRS+1
        INC     ROWCRS
DOCR2:  LDX     DINDEX
        LDY     #24         ;SET UP SCROLL LOOP COUNTER
        BIT     SWPFLG
        BPL     DOCR2A      ;BRANCH IF NORMAL
        LDY     #4
        TYA
        BNE     DOCR2B      ;(UNCONDITIONAL)

;****
; change to reference XL OS table
;
;DOCR2A: LDA     NOROWS,X    ;GET NO OF ROWS
DOCR2A	LDA	TMRC,X

DOCR2B: CMP     ROWCRS
        BNE     INCRS1
        STY     HOLD3
        TXA                 ;DON'T SCROLL IF MODE <> 0
        BNE     INCRS1
        LDA     INSDAT      ;OR IF INSDAT = 0
        BEQ     INCRS1
;       LDA     INSDAT      IF INSDAT <> $9B THEN ROLL IN A 0
        CMP     #$9B        ;TO EXTEND BOTTOM LOGICAL LINE
        SEC
        BEQ     DOCR4B
        CLC
DOCR4B: JSR     SCROLL      ;LOOP BACK TO HERE IF >1 SCROLLS
        INC     SCRFLG
        DEC     BUFSTR      ;ROWS MOVE UP SO BUFSTR SHOULD TOO
        DEC     HOLD3
        LDA     LOGMAP
        SEC                 ;FOR PARTIAL LINES, ROLL IN A "1"
        BPL     DOCR4B      ;AGAIN IF PARTIAL LOGICAL LINE
        LDA     HOLD3       ;PLACE CURSOR AT NEW LINE NEAR THE BOTTOM
        STA     ROWCRS
INCRS1: JMP     DOLCOL      ;COLVERT ROW AND COL TO LOGCOL AND RETURN
;
;
; SUBEND: SUBTRACT ENDPT FROM ROWAC OR COLAC. (X=0 OR 2)
;
SUBEND: SEC
        LDA     ROWAC,X
        SBC     ENDPT
        STA     ROWAC,X
        LDA     ROWAC+1,X
        SBC     ENDPT+1
        STA     ROWAC+1,X
        RTS
;
;
; RANGE: DO CURSOR RANGE TEST. IF ERROR, POP STACK TWICE AND JMP RETURN
;        (ERANGE IS EDITOR ENTRY POINT AND TEST IF EDITOR IS OPEN.
;         IF IT ISNT IT OPENS THE EDITOR AND CONTINUES)
;
ERANGE: LDA     BOTSCR      ;IF BOTSCR=4
        CMP     #4
        BEQ     RANGE       ;THEN IT IS IN MIXED MODE AND OK
        LDA     DINDEX      ;IF MODE = 0
        BEQ     RANGE       ;THEN IT IS IN EDITOR MODE AND OK
        JSR     EOPEN       ;IF NOT, OPEN EDITOR
RANGE:  LDA     #39         ;***** RANGE CHECK RMARGN ***** SET UP AC
        CMP     RMARGN      ;***** RANGE CHECK RMARGN ***** COMPARE
        BCS     RANGE3      ;***** RANGE CHECK RMARGN ***** BRANCH GE
        STA     RMARGN      ;***** RANGE CHECK RMARGN ***** BAD SO STORE 39
RANGE3: LDX     DINDEX

;****
; change to reference XL OS table
;
;       LDA     NOROWS,X    ;CHECK ROWS
	LDA	TMRC,X

        CMP     ROWCRS
        BCC     RNGERR      ;(ERROR IF TABLE.GE.ROWCRS)
        BEQ     RNGERR
        CPX     #8          ;CHECK FOR 320X1
        BNE     RANGE1      ;SPECIAL CASE IT
        LDA     COLCRS+1
        BEQ     RNGOK       ;IF HIGH BYTE IS 0, COL IS OK
        CMP     #1
        BNE     RNGERR      ;IF >1, BAD
        BEQ     RANGE2      ;IF 1, GO CHECK LOW BYTE
RANGE1: LDA     COLCRS+1    ;FOR OTHERS, NON-ZERO HIGH BYTE IS BAD
        BNE     RNGERR

;****
; change to reference XL OS table
;
;RANGE2: LDA     COLUMN,X    ;CHECK LOW BYTE
RANGE2	LDA	TMCC,X

        CMP     COLCRS
        BCC     RNGERR
        BEQ     RNGERR
RNGOK:  LDA     #SUCCES     ;SET STATUS OK
        STA     DSTAT
        LDA     #BRKABT     ;PREPARE BREAK ABORT STATUS
        LDX     BRKKEY      ;CHECK BREAK KEY FLAG
        STA     BRKKEY      ;'CLEAR' BREAK
        BEQ     RNGER2      ;IF BREAK, QUIT IMMEDIATELY AND RETURN TO CIO
        RTS
RNGERR: JSR     HOME        ;ON RANGE ERROR, BRING CURSOR BACK
        LDA     #CRSROR     ;SHOW CURSOR OVERRANGE ERROR
RNGER2: STA     DSTAT
RNGER1: PLA                 ;RESTORE STACK (THIS ROUTINE IS ALWAYS 1 LEVEL
        PLA                 ;AWAY FROM RETURN TO CIO)
        LDA     SWPFLG      ;IF SWAPPED, SWAP BACK
        BPL     RETUR3
        JSR     SWAPA       ;AND DONT DO RETUR1
RETUR3: JMP     RETUR1      ;RETURN TO CIO
;
;
;
; OFFCRS: RESTORE OLD DATA UNDER CURSOR SO IT CAN BE MOVED
;
OFFCRS: LDY     #0
        LDA     OLDCHR
        STA     (OLDADR),Y
        RTS
;;
;
;
; BITMAP ROUTINES:
;
; BITCON: PUT MASK IN BITMSK AND INDEX IN X
; BITPUT: PUT CARRY INTO BITMAP
; BITROL: ROL CARRY INTO BOTTOM OF BITMAP (SCROLL)
; BITSET: SET PROPER BIT
; BITCLR: CLEAR PROPER BIT
; BITGET: RETURN CARRY SET IF BIT IS THERE
; LOGGET: DO BITGET FOR LOGMAP INSTEAD OF TABMAP
;
BITCON: PHA
        AND     #7
        TAX                 ;GET MASK
        LDA     MASKTB,X
        STA     BITMSK
        PLA                 ;PROCESS INDEX
        LSR     A
        LSR     A
        LSR     A
        TAX
        RTS
;
;
BITROL: ROL     LOGMAP+2
        ROL     LOGMAP+1
        ROL     LOGMAP
        RTS
;
;
BITPUT: BCC     BITCLR      ;AND RETURN
; OTHERWISE FALL THROUGH TO BITSET AND RETURN
BITSET: JSR     BITCON
        LDA     TABMAP,X
        ORA     BITMSK
        STA     TABMAP,X
        RTS
;
BITCLR: JSR     BITCON
        LDA     BITMSK
        EOR     #$FF
        AND     TABMAP,X
        STA     TABMAP,X
        RTS
;
LOGGET: LDA     ROWCRS
LO1GET: CLC
LO2GET: ADC     #120
BITGET: JSR     BITCON
        CLC
        LDA     TABMAP,X
        AND     BITMSK
        BEQ     BITGE1
        SEC
BITGE1: RTS
;
;
;
;
; INATAC: INTERNAL(CHAR) TO ATASCII(ATACHR) CONVERSION
;
INATAC: LDA     CHAR
        LDY     DINDEX      ;IF GRAPHICS MODES
        CPY     #3
        BCS     INATA1      ;THEN DON'T CHANGE CHAR
        ROL     A
        ROL     A
        ROL     A
        ROL     A
        AND     #3
        TAX
        LDA     CHAR
        AND     #$9F
        ORA     INTATA,X
INATA1: STA     ATACHR
        RTS
;
;
;
; MOVLIN: MOVE 40 BYTES AT FRMADR TO TOADR SAVING OLD TOADR
;       DATA IN THE LINBUF. THEN MAKE NEXT FRMADR
;       BE AT LINBUF FOR NEXT TRANSFER & TOADR=TOADR+40
;
MOVLIN: LDA     #HIGH LINBUF;SET UP ADRESS=LINBUF=$247
        STA     ADRESS+1
        LDA     #LOW LINBUF
        STA     ADRESS
        LDY     #39
MOVLI1: LDA     (TOADR),Y   ;SAVE TO DATA
        STA     TMPCHR
        LDA     (FRMADR),Y  ;STORE DATA
        STA     (TOADR),Y
        LDA     TMPCHR
        STA     (ADRESS),Y
        DEY
        BPL     MOVLI1
        LDA     ADRESS+1    ;SET UP FRMADR=LAST LINE
        STA     FRMADR+1
        LDA     ADRESS
        STA     FRMADR
        CLC                 ;ADD 40 TO TOADR
        LDA     TOADR
        ADC     #40
        STA     TOADR
        BCC     MOVLI2
        INC     TOADR+1
MOVLI2: RTS
;
;
;
; EXTEND: EXTEND BIT MAP FROM ROWCRS (EXTEND LOGICAL LINE
;
EXTEND: PHP                 ;SAVE CARRY
        LDY     #23
EXTEN1: TYA
        JSR     LO1GET
        PHP
        TYA
        CLC
        ADC     #121
        PLP
        JSR     BITPUT
EXTEN3: DEY
        BMI     EXTEN4
        CPY     ROWCRS
        BCS     EXTEN1
EXTEN4: LDA     ROWCRS
        CLC
        ADC     #120
        PLP
        JMP     BITPUT      ;STORE NEW LINE'S BIT AND RETURN
;
;
;
; CLRLIN: CLEAR LINE CURSOR IS ON
;
CLRLIN: LDA     LMARGN
        STA     COLCRS
        JSR     CONVRT
        LDY     #39
        LDA     #0
CLRLI1: STA     (ADRESS),Y
        DEY
        BPL     CLRLI1
        RTS
;
;
;
;
; SCROLL: SCROLL SCREEN
;
SCROLL: JSR     BITROL      ;ROLL IN CARRY
        LDA     SAVMSC      ;SET UP WORKING REGISTERS
        STA     ADRESS
        LDA     SAVMSC+1
        STA     ADRESS+1
SCROL1: LDY     #40         ;LOOP
        LDA     (ADRESS),Y
        LDX     RAMTOP      ;TEST FOR LAST LINE
        DEX
        CPX     ADRESS+1
        BNE     SCROL2
        LDX     #$D7
        CPX     ADRESS
        BCS     SCROL2
        LDA     #0          ;YES SO STORE ZERO DATA FOR THIS ENTIRE LINE
SCROL2: LDY     #0
        STA     (ADRESS),Y
        INC     ADRESS
        BNE     SCROL1
        INC     ADRESS+1
        LDA     ADRESS+1
        CMP     RAMTOP
        BNE     SCROL1
        JMP     DOLCOL      ;AND RETURN
;
;
; DOLCOL: DO LOGICAL COLUMN FROM BITMAP AND COLCRS
;
DOLCOL: LDA     #0          ;START WITH ZERO
        STA     LOGCOL
        LDA     ROWCRS
        STA     HOLD1
DOLCO1: LDA     HOLD1       ;ADD IN ROW COMPONENT
        JSR     LO1GET
        BCS     DOLCO2      ;FOUND BEGINNING OF LINE
        LDA     LOGCOL      ;ADD 40 AND LOOK BACK ONE
        CLC
        ADC     #40
        STA     LOGCOL
        DEC     HOLD1       ;UP ONE LINE
        JMP     DOLCO1
DOLCO2: CLC                 ;ADD IN COLCRS
        LDA     LOGCOL
        ADC     COLCRS
        STA     LOGCOL
        RTS
;
;
;
; DOBUFC: COMPUTE BUFFER COUNT AS THE NUMBER OF BYTES FROM
;         BUFSTR TO END OF LOGICAL LINE WITH TRAILING SPACES REMOVED
;
DOBUFC: JSR     PHACRS
        LDA     LOGCOL
        PHA
        LDA     BUFSTR      ;START
        STA     ROWCRS
        LDA     BUFSTR+1
        STA     COLCRS
        LDA     #1
        STA     BUFCNT
DOBUF1: LDX     #23         ;NORMAL
        LDA     SWPFLG      ;IF SWAPPED, ROW 3 IS THE LAST LINE ON SCREEN
        BPL     DOB1
        LDX     #3
DOB1:   CPX     ROWCRS      ;TEST IF CRSR IS AT LAST SCREEN POSITION
        BNE     DOBU1A
        LDA     COLCRS
        CMP     RMARGN
        BNE     DOBU1A
        INC     BUFCNT      ;YES, SO FAKE INCRSR TO AVOID SCROLLING
        JMP     DOBUF2
DOBU1A: JSR     INCRSB
        INC     BUFCNT
        LDA     LOGCOL
        CMP     LMARGN
        BNE     DOBUF1      ;NOT YET EOL
        DEC     ROWCRS      ;BACK UP ONE INCRSR
        JSR     CRSRLF
DOBUF2: JSR     GETPLT      ;TEST CURRENT COLUMN FOR NON-ZERO DATA
        BNE     DOBUF4      ;QUIT IF NON-ZERO
        DEC     BUFCNT      ;DECREMENT COUNTER
        LDA     LOGCOL      ;BEGINNING OF LOGICAL LINE YET?
        CMP     LMARGN
        BEQ     DOBUF4      ;YES, SO QUIT
        JSR     CRSRLF      ;BACK UP CURSOR
        LDA     COLCRS      ;IF LOGCOL=RMARGN, GO UP 1 ROW
        CMP     RMARGN
        BNE     DOBUF3
        DEC     ROWCRS
DOBUF3: LDA     BUFCNT
        BNE     DOBUF2      ;LOOP UNLESS BUFCNT JUST WENT TO ZERO
DOBUF4: PLA
        STA     LOGCOL
        JSR     PLACRS
        RTS
;
;
;
;
; STRBEG: MOVE BUFSTR TO BEGINNING OF LOGICAL LINE.
;
STRBEG: JSR     DOLCOL      ;USE DOLCOL TO POINT HOLD1 AT BOL
        LDA     HOLD1
        STA     BUFSTR
        LDA     LMARGN
        STA     BUFSTR+1
        RTS
;
;
;
;
;
; DELTIM: TIME TO DELETE A LINE IF IT IS EMPTY AND AN EXTENSION
;
DELTIA: LDA     LOGCOL      ;IF LOGCOL<>LMARGN
        CMP     LMARGN      ;THEN DONT MOVE UP ONE
        BNE     DELTIB      ;LINE BEFORE TESTING DELTIM
        DEC     ROWCRS
DELTIB: JSR     DOLCOL
DELTIM: LDA     LOGCOL      ;TEST FOR EXTENSION
        CMP     LMARGN
        BEQ     DELTI3      ;NO
        JSR     CONVRT
        LDA     RMARGN      ;SET UP COUNT
        SEC
        SBC     LMARGN
        TAY
DELTI1: LDA     (ADRESS),Y
        BNE     DELTI3      ;FOUND A NON-0 SO QUIT AND RETURN
        DEY
        BPL     DELTI1
DELTI2: JMP     DELLIB      ;DELETE A LINE AND RETURN
DELTI3: RTS
;
;
;
; TSTCTL: SEARCH CNTRLS TABLE TO SEE IF ATACHR IS A CNTL CHAR
;
TSTCTL: LDX     #45         ;PREPARE TO SEARCH TABLE
TSTCT1: LDA     CNTRLS,X
        CMP     ATACHR
        BEQ     TSTCT2
        DEX
        DEX
        DEX
        BPL     TSTCT1
TSTCT2: RTS
;
;
;
; PUSH ROWCRS,COLCRS AND COLCRS+1
;
PHACRS: LDX     #2
PHACR1: LDA     ROWCRS,X
        STA     TMPROW,X
        DEX
        BPL     PHACR1
        RTS
;
;
; PULL COLCRS+1,COLCRS AND ROWCRS
;
PLACRS: LDX     #2
PLACR1: LDA     TMPROW,X
        STA     ROWCRS,X
        DEX
        BPL     PLACR1
        RTS
;
;
;
; SWAP: IF MIXED MODE, SWAP TEXT CURSORS WITH REGULAR CURSORS
;
SWAP:   JSR     SWAPA       ;THIS ENTRY POINT DOES RETUR1
        JMP     RETUR1
SWAPA:  LDA     BOTSCR
        CMP     #24
        BEQ     SWAP3
        LDX     #11
SWAP1:  LDA     ROWCRS,X
        PHA
        LDA     TXTROW,X
        STA     ROWCRS,X
        PLA
        STA     TXTROW,X
        DEX
        BPL     SWAP1
        LDA     SWPFLG
        EOR     #$FF
        STA     SWPFLG
SWAP3:  RTS
;
;
; CLICK: MAKE CLICK THROUGH KEYBOARD SPEAKER
;
CLICK:
;	LDX     #$7F
	NOP
	NOP
CLICK1:
;	STX     CONSOL
	JMP	PCLICK
        STX     WSYNC
        DEX
        BPL     CLICK1
        RTS
;
;
; COLCR: PUTS EITHER 0 OR LMARGN INTO COLCRS BASED ON MODE AND SWPFLG
;
COLCR:  LDA     #0
        LDX     SWPFLG
        BNE     COLCR1
        LDX     DINDEX
        BNE     COLCR2
COLCR1: LDA     LMARGN
COLCR2: STA     COLCRS
        RTS
;
;
; PUTMSC: PUT SAVMSC INTO ADRESS
;
PUTMSC: LDA     SAVMSC      ;SET UP ADDRESS
        STA     ADRESS
        LDA     SAVMSC+1
        STA     ADRESS+1
        RTS
;
        EJECT
;
;
; DRAW -- DRAW A LINE FROM OLDROW,OLDCOL TO NEWROW,NEWCOL
; (THE AL MILLER METHOD FROM BASKETBALL)
DRAW:   LDX     #0
        LDA     ICCOMZ      ;TEST COMMAND: $11=DRAW $12=FILL
        CMP     #$11
        BEQ     DRAWA
        CMP     #$12        ;TEST FILL
        BEQ     DRAWB       ;YES
        LDY     #NVALID     ;NO, SO RETURN INVALID COMMAND
        RTS
DRAWB:  INX
DRAWA:  STX     FILFLG
        LDA     ROWCRS      ;PUT CURSOR INTO NEWROW,NEWCOL
        STA     NEWROW
        LDA     COLCRS
        STA     NEWCOL
        LDA     COLCRS+1
        STA     NEWCOL+1
        LDA     #1
        STA     ROWINC      ;SET UP INITIAL DIRECTIONS
        STA     COLINC
        SEC
        LDA     NEWROW      ;DETERMINE DELTA ROW
        SBC     OLDROW
        STA     DELTAR
        BCS     DRAW1       ;DO DIRECTION AND ABSOLUTE VALUE
        LDA     #$FF        ;BORROW WAS ATTEMPTED
        STA     ROWINC      ;SET DIRECTION=DOWN
        LDA     DELTAR
        EOR     #$FF        ;DELTAR = |DELTAR|
        CLC
        ADC     #1
        STA     DELTAR
DRAW1:  SEC
        LDA     NEWCOL      ;NOW DELTA COLUMN
        SBC     OLDCOL
        STA     DELTAC
        LDA     NEWCOL+1    ;TWO-BYTE QUANTITY
        SBC     OLDCOL+1
        STA     DELTAC+1
        BCS     DRAW2       ;DIRECTION AND ABSOLUTE VALUE
        LDA     #$FF        ;BORROW WAS ATTEMPTED
        STA     COLINC      ;SET DIRECTION = LEFT
        LDA     DELTAC
        EOR     #$FF        ;DELTAC = |DELTAC|
        STA     DELTAC
        LDA     DELTAC+1
        EOR     #$FF
        STA     DELTAC+1
        INC     DELTAC      ;ADD ONE FOR TWOS COMPLEMENT
        BNE     DRAW2
        INC     DELTAC+1
DRAW2:  LDX     #2          ;ZERO RAM FOR DRAW LOOP
        LDY     #0
        STY     COLAC+1
DRAW3A: TYA
        STA     ROWAC,X
        LDA     OLDROW,X
        STA     ROWCRS,X
        DEX
        BPL     DRAW3A
        LDA     DELTAC      ;FIND LARGER ONE (ROW OR COL)
;       STA     COUNTR      (PREPARE COUNTR AND ENDPT)
;       STA     ENDPT
        INX                 ;MAKE X 0
        TAY
        LDA     DELTAC+1
        STA     COUNTR+1
        STA     ENDPT+1
        BNE     DRAW3       ;AUTOMATICALLY LARGER IF MSD>0
        LDA     DELTAC
        CMP     DELTAR      ;LOW COL >LOW ROW?
        BCS     DRAW3       ;YES
        LDA     DELTAR
        LDX     #2
        TAY
DRAW3:  TYA                 ;PUT IN INITIAL CONDITIONS
        STA     COUNTR
        STA     ENDPT
        PHA                 ;SAVE AC
        LDA     ENDPT+1     ;PUT LSB OF HIGH BYTE
        LSR     A           ;INTO CARRY
        PLA                 ;RESTORE AC
        ROR     A           ;ROR THE 9 BIT ACUMULATOR
        STA     ROWAC,X
DRAW4A: LDA     COUNTR      ;TEST ZERO
        ORA     COUNTR+1
        BNE     DRAW11      ;IF COUNTER IS ZERO, LEAVE DRAW
        JMP     DRAW10
DRAW11: CLC                 ;ADD ROW TO ROWAC (PLOT LOOP)
        LDA     ROWAC
        ADC     DELTAR
        STA     ROWAC
        BCC     DRAW5
        INC     ROWAC+1
DRAW5:  LDA     ROWAC+1     ;COMPARE ROW TO ENDPOINT
        CMP     ENDPT+1     ;IF HIGH BYTE OF ROW IS .LT. HIGH
        BCC     DRAW6       ;BYTE OF ENDPT, BLT TO COLUMN
        BNE     DRAW5A
        LDA     ROWAC
        CMP     ENDPT       ;LOW BYTE
        BCC     DRAW6       ;ALSO BLT
DRAW5A: CLC                 ;GE SO MOVE POINT
        LDA     ROWCRS
        ADC     ROWINC
        STA     ROWCRS
        LDX     #0          ;AND SUBTRACT ENDPT FROM ROWAC
        JSR     SUBEND
DRAW6:  CLC                 ;DO SAME FOR COLUMN (DOUBLE BYTE ADD)
        LDA     COLAC       ;ADD
        ADC     DELTAC
        STA     COLAC
        LDA     COLAC+1
        ADC     DELTAC+1
        STA     COLAC+1
        CMP     ENDPT+1     ;COMPARE HIGH BYTE
        BCC     DRAW8
        BNE     DRAW6A
        LDA     COLAC       ;COMPARE LOW BYTE
        CMP     ENDPT
        BCC     DRAW8
DRAW6A: BIT     COLINC      ;+ OR - ?
        BPL     DRAW6B
        DEC     COLCRS      ;DO DOUBLE BYTE DECREMENT
        LDA     COLCRS
        CMP     #$FF
        BNE     DRAW7
        LDA     COLCRS+1
        BEQ     DRAW7       ;DON'T DEC IF ZERO
        DEC     COLCRS+1
        BPL     DRAW7       ;(UNCONDITIONAL)
DRAW6B: INC     COLCRS      ;DO DOUBLE BYTE INCREMENT
        BNE     DRAW7
        INC     COLCRS+1
DRAW7:  LDX     #2          ;AND SUBTRACT ENDPT FROM COLAC
        JSR     SUBEND
DRAW8:  JSR     RANGE
        JSR     OUTPLT      ;PLOT POINT
        LDA     FILFLG      ;TEST RIGHT FILL
        BEQ     DRAW9
        JSR     PHACRS
        LDA     ATACHR
        STA     HOLD4
DRAW8A: LDA     ROWCRS      ;SAVE ROW IN CASE OF CR
        PHA
        JSR     INCRSA      ;POSITION CURSOR ONE PAST DOT
        PLA                 ;RESTORE ROWCRS
        STA     ROWCRS
DRAW8C: JSR     RANGE
        JSR     GETPLT      ;GET DATA
        BNE     DRAW8B      ;STOP IF NON-ZERO DATA IS ENCOUNTERED
        LDA     FILDAT      ;FILL DATA
        STA     ATACHR
        JSR     OUTPLT      ;DRAW IT
        JMP     DRAW8A      ;LOOP
DRAW8B: LDA     HOLD4
        STA     ATACHR
        JSR     PLACRS
DRAW9:  SEC                 ;DO DOUBLE BYTE SUBTRACT
        LDA     COUNTR
        SBC     #1
        STA     COUNTR
        LDA     COUNTR+1
        SBC     #0
        STA     COUNTR+1
        BMI     DRAW10
        JMP     DRAW4A
DRAW10: JMP     RETUR1
        EJECT
;
;
; TABLES
;
;
; MEMORY ALLOCATION
;
ALOCAT: DB      24,16,10,10,16,28,52,100,196,196,196,196
;
;
; NUMBER OF DISPLAY LIST ENTRIES
;
NUMDLE: DB      23,23,11,23,47,47,95,95,97,97,97,97
MXDMDE: DB      19,19,9,19,39,39,79,79,65,65,65,65 ;(EXT OF NUMDLE)
;
;
; ANTIC CODE FROM INTERNAL MODE CONVERSION TABLE
;
;   INTERNAL         ANTIC CODE             DESCRIPTION
;       0               2               40X2X8  CHARACTERS
;       1               6               20X5X8      ""
;       2               7               20X5X16     ""
;       3               8               40X4X8  GRAPHICS
;       4               9               80X2X4     ""
;       5               A               80X4X4     ""
;       6               B               160X2X2    ""
;       7               D               160X4X2    ""
;       8               F               320X2X1    ""
;       9               SAME AS 8 BUT GTIA 'LUM' MODE
;       10              SAME AS 8 BUT GTIA 'COL/LUM REGISTER' MODE
;       11              SAME AS 8 BUT GTIA 'COLOR' MODE
;
ANCONV: DB      2,6,7,8,9,$A,$B,$D,$F,$F,$F,$F ;ZEROS FOR RANGE TEST IN PAGETB
;
;
; PAGE TABLE TELLS WHICH DISPLAY LISTS ARE IN DANGER OF
; CROSSING A 256 BYTE PAGE BOUNDARY
;
PAGETB: DB      0,0,0,0,0,0,0,1,1,1,1,1
;
;
; THIS IS THE NUMBER OF LEFT SHIFTS NEEDED TO MULTIPLY
; COLCRS BY 10,20, OR 40.  (ROWCRS*10)/(2**DHLINE)
;
DHLINE: DB      2,1,1,0,0,1,1,2,2,2,2,2
;
;
; COLUMN: NUMBER OF COLUMNS
;
COLUMN: DB      40,20,20,40,80,80,160,160,64,80,80,80 ;MODE 8 IS SPECIAL CASE
;
;
;
; NOROWS: NUMBER OF ROWS
;
NOROWS: DB      24,24,12,24,48,48,96,96,192,192,192,192
;
;
;
;
; DIV2TB: HOW MANY RIGHT SHIFTS FOR HCRSR FOR PARTIAL BYTE MODES
;
DIV2TB: DB      0,0,0,2,3,2,3,2,3,1,1,1
;
;
; DMASKT: DISPLAY MASK TABLE
;
DMASKT: DB      $00,$FF,$F0,$0F
        DB      $C0,$30,$0C,$03
;
; MASKTB: BIT MASK.   (ALSO PART OF DMASKTB! DO NOT SEPARATE)
;
MASKTB: DB      $80,$40,$20,$10,$08,$04,$02,$01
;
;
;
;
COLRTB: DB      $28,$CA,$94,$46,$00
;
;
;
;
; CNTRLS: CONTROL CODES AND THEIR DISPLACEMENTS INTO THE
;         CONTROL CHARACTER PROCESSORS
;
CNTRLS: DB      $1B
        DW      ESCAPE
        DB      $1C
        DW      CRSRUP
        DB      $1D
        DW      CRSRDN
        DB      $1E
        DW      CRSRLF
        DB      $1F
        DW      CRSRRT
        DB      $7D
        DW      CLRSCR
        DB      $7E
        DW      BS
        DB      $7F
        DW      TAB
        DB      $9B
        DW      DOCRWS
        DB      $9C
        DW      DELLIN
        DB      $9D
        DW      INSLIN
        DB      $9E
        DW      CLRTAB
        DB      $9F
        DW      SETTAB
        DB      $FD
        DW      BELL
        DB      $FE
        DW      DELCHR
        DB      $FF
        DW      INSCHR
;
;
;
;
;
; ATAINT: ATASCI TO INTERNAL TABLE
;
ATAINT: DB      $40,$00,$20,$60
;
;
; INTATA: INTERNAL TO ATASCI TABLE
;
INTATA: DB      $20,$40,$00,$60
;
;
; ATASCI: ATASCII CONVERSION TABLE
;
ATASCI: DB      $6C,$6A,$3B,$80,$80,$6B,$2B,$2A ;LOWER CASE
        DB      $6F,$80,$70,$75,$9B,$69,$2D,$3D

        DB      $76,$80,$63,$80,$80,$62,$78,$7A
        DB      $34,$80,$33,$36,$1B,$35,$32,$31

        DB      $2C,$20,$2E,$6E,$80,$6D,$2F,$81
        DB      $72,$80,$65,$79,$7F,$74,$77,$71

        DB      $39,$80,$30,$37,$7E,$38,$3C,$3E
        DB      $66,$68,$64,$80,$82,$67,$73,$61


        DB      $4C,$4A,$3A,$80,$80,$4B,$5C,$5E ;UPPER CASE
        DB      $4F,$80,$50,$55,$9B,$49,$5F,$7C

        DB      $56,$80,$43,$80,$80,$42,$58,$5A
        DB      $24,$80,$23,$26,$1B,$25,$22,$21

        DB      $5B,$20,$5D,$4E,$80,$4D,$3F,$81
        DB      $52,$80,$45,$59,$9F,$54,$57,$51

        DB      $28,$80,$29,$27,$9C,$40,$7D,$9D
        DB      $46,$48,$44,$80,$83,$47,$53,$41


        DB      $0C,$0A,$7B,$80,$80,$0B,$1E,$1F ;CONTROL
        DB      $0F,$80,$10,$15,$9B,$09,$1C,$1D

        DB      $16,$80,$03,$80,$80,$02,$18,$1A
        DB      $80,$80,$85,$80,$1B,$80,$FD,$80

        DB      $00,$20,$60,$0E,$80,$0D,$80,$81
        DB      $12,$80,$05,$19,$9E,$14,$17,$11

        DB      $80,$80,$80,$80,$FE,$80,$7D,$FF
        DB      $06,$08,$04,$80,$84,$07,$13,$01
;
	JMP	PIRQ		;vector to keyboard IRQ routine


;**	Check for correct module length

	ASSERT	EGETCH=$F63E
	ASSERT	BITCON=$FAEB
	ASSERT	*=$FFC1
;	SUBTTL	'Second 8K ROM Identification and Checksum'
;	SPACE	4,10
	FIX	$FFEE
;	SPACE	4,10
;**	Second 8K ROM Identification and Checksum


	DB	IDDAY,IDMON,IDYEAR		;date (day, month, year)
	DB	IDCPU				;CPU series
	DB	IDPN1,IDPN2,IDPN3,IDPN4,IDPN5	;part number
	DB	IDREV				;revision number
	DW	$0000				;reserved for checksum
;	SUBTTL	'6502 Machine Vectors'
;	SPACE	4,10
	FIX	$FFFA
;	SPACE	4,10
;**	6502 Machine Vectors


	DW	NMI	;vector to process NMI
	DW	RES	;vector to process RESET
	DW	IRQ	;vector to process IRQ
;	SPACE	4,10
	.END
